/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.media;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.App;
import tim.prune.DataSubscriber;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.Photo;
import tim.prune.gui.PhotoThumbnail;

public class PhotoPopupFunction
extends GenericFunction
implements DataSubscriber {
    private JFrame _frame = null;
    private JLabel _label = null;
    private PhotoThumbnail _photoThumb = null;

    public PhotoPopupFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.photopopup";
    }

    @Override
    public void begin() {
        if (this._frame == null) {
            this._frame = new JFrame(this.getName());
            this._frame.setIconImage(this._parentFrame.getIconImage());
            this._frame.getContentPane().add(this.makeContents());
            this._frame.pack();
            this._frame.setLocationRelativeTo(this._parentFrame);
            this._frame.setDefaultCloseOperation(2);
            this._frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    UpdateMessageBroker.removeSubscriber(PhotoPopupFunction.this);
                    super.windowClosed(windowEvent);
                }
            });
        }
        this.initFrame();
        Photo photo = this._app.getTrackInfo().getCurrentPhoto();
        if (photo.getWidth() <= 0 || photo.getHeight() <= 0) {
            this._frame.setVisible(false);
            this._app.showErrorMessageNoLookup(this.getNameKey(), String.valueOf(I18nManager.getText("error.showphoto.failed")) + " : " + photo.getName());
        } else {
            this._frame.setVisible(true);
            UpdateMessageBroker.addSubscriber(this);
        }
    }

    private void initFrame() {
        Photo photo = this._app.getTrackInfo().getCurrentPhoto();
        if (photo == null) {
            this._frame.setTitle("GpsPrune - " + I18nManager.getText("details.nophoto"));
            this._label.setText(I18nManager.getText("details.nophoto"));
        } else {
            this._frame.setTitle(photo.getName());
            this._label.setText("'" + photo.getName() + "' (" + photo.getWidth() + " x " + photo.getHeight() + ")");
        }
        this._photoThumb.setPhoto(photo);
    }

    private Component makeContents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._label = new JLabel("Photo popup");
        jPanel.add((Component)this._label, "North");
        this._photoThumb = new PhotoThumbnail(false);
        this._photoThumb.setPreferredSize(new Dimension(300, 300));
        jPanel.add((Component)this._photoThumb, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.ok"));
        jButton.addActionListener(actionEvent -> this._frame.dispose());
        jButton.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    PhotoPopupFunction.this._frame.dispose();
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    @Override
    public void dataUpdated(int n) {
        if ((n & 4) > 0) {
            this.initFrame();
        }
    }

    @Override
    public void actionCompleted(String string) {
    }
}

