/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Implements the BinaryNot logical operator pixel-wise between two
images.


This class is parameterized over the types of the two input images and
the type of the output image. Numeric conversions (castings) are done
by the C++ defaults.

The total operation over one pixel will be

output_pixel = static_cast&lt;PixelType&gt;( input1_pixel !=
input2_pixel )

Where "!=" is the equality operator in C++.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4
See:
 itk::simple::BinaryNot for the procedural interface

 itk::BinaryNotImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryNotImageFilter.h
*/
public class BinaryNotImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BinaryNotImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BinaryNotImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BinaryNotImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BinaryNotImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BinaryNotImageFilter::~BinaryNotImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BinaryNotImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BinaryNotImageFilter::BinaryNotImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BinaryNotImageFilter() {
    this(SimpleITKJNI.new_BinaryNotImageFilter(), true);
  }

  /**
Self&amp; itk::simple::BinaryNotImageFilter::SetForegroundValue(double ForegroundValue)

Set/Get the value in the image considered as "foreground". Defaults
to maximum value of PixelType.

*/
public  void setForegroundValue(double ForegroundValue) {
    SimpleITKJNI.BinaryNotImageFilter_setForegroundValue(swigCPtr, this, ForegroundValue);
  }

  /**
double itk::simple::BinaryNotImageFilter::GetForegroundValue() const

Set/Get the value in the image considered as "foreground". Defaults
to maximum value of PixelType.

*/
public  double getForegroundValue() {
    return SimpleITKJNI.BinaryNotImageFilter_getForegroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryNotImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the value used as "background". Defaults to NumericTraits&lt;PixelType&gt;::NonpositiveMin() .

*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.BinaryNotImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::BinaryNotImageFilter::GetBackgroundValue() const

Set/Get the value used as "background". Defaults to NumericTraits&lt;PixelType&gt;::NonpositiveMin() .

*/
public  double getBackgroundValue() {
    return SimpleITKJNI.BinaryNotImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryNotImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BinaryNotImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryNotImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BinaryNotImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BinaryNotImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.BinaryNotImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
