/* This file is part of the libopencm3 project.
 *
 * It was generated by the irq2nvic_h script from ./include/libopencm3/msp432/e4/irq.json
 */

#ifndef LIBOPENCM3_MSP432_E4_NVIC_H
#define LIBOPENCM3_MSP432_E4_NVIC_H

#include <libopencm3/cm3/nvic.h>

/** @defgroup CM3_nvic_defines_irqs User interrupts for MSP432 E4 series
    @ingroup CM3_nvic_defines

    @{*/

#define NVIC_GPIOA_IRQ 0
#define NVIC_GPIOB_IRQ 1
#define NVIC_GPIOC_IRQ 2
#define NVIC_GPIOD_IRQ 3
#define NVIC_GPIOE_IRQ 4
#define NVIC_UART0_IRQ 5
#define NVIC_UART1_IRQ 6
#define NVIC_SSI0_IRQ 7
#define NVIC_I2C0_IRQ 8
#define NVIC_PWM0_FAULT_IRQ 9
#define NVIC_PWM0_0_IRQ 10
#define NVIC_PWM0_1_IRQ 11
#define NVIC_PWM0_2_IRQ 12
#define NVIC_QEI0_IRQ 13
#define NVIC_ADC0SS0_IRQ 14
#define NVIC_ADC0SS1_IRQ 15
#define NVIC_ADC0SS2_IRQ 16
#define NVIC_ADC0SS3_IRQ 17
#define NVIC_WATCHDOG0_IRQ 18
#define NVIC_TIMER0A_IRQ 19
#define NVIC_TIMER0B_IRQ 20
#define NVIC_TIMER1A_IRQ 21
#define NVIC_TIMER1B_IRQ 22
#define NVIC_TIMER2A_IRQ 23
#define NVIC_TIMER2B_IRQ 24
#define NVIC_COMP0_IRQ 25
#define NVIC_COMP1_IRQ 26
#define NVIC_COMP2_IRQ 27
#define NVIC_SYSCTL_IRQ 28
#define NVIC_FLASH_CTRL_IRQ 29
#define NVIC_GPIOF_IRQ 30
#define NVIC_GPIOG_IRQ 31
#define NVIC_GPIOH_IRQ 32
#define NVIC_UART2_IRQ 33
#define NVIC_SSI1_IRQ 34
#define NVIC_TIMER3A_IRQ 35
#define NVIC_TIMER3B_IRQ 36
#define NVIC_I2C1_IRQ 37
#define NVIC_CAN0_IRQ 38
#define NVIC_CAN1_IRQ 39
#define NVIC_EMAC0_IRQ 40
#define NVIC_HIB_IRQ 41
#define NVIC_USB0_IRQ 42
#define NVIC_PWM0_3_IRQ 43
#define NVIC_UDMA_IRQ 44
#define NVIC_UDMAERR_IRQ 45
#define NVIC_ADC1SS0_IRQ 46
#define NVIC_ADC1SS1_IRQ 47
#define NVIC_ADC1SS2_IRQ 48
#define NVIC_ADC1SS3_IRQ 49
#define NVIC_EPI0_IRQ 50
#define NVIC_GPIOJ_IRQ 51
#define NVIC_GPIOK_IRQ 52
#define NVIC_GPIOL_IRQ 53
#define NVIC_SSI2_IRQ 54
#define NVIC_SSI3_IRQ 55
#define NVIC_UART3_IRQ 56
#define NVIC_UART4_IRQ 57
#define NVIC_UART5_IRQ 58
#define NVIC_UART6_IRQ 59
#define NVIC_UART7_IRQ 60
#define NVIC_I2C2_IRQ 61
#define NVIC_I2C3_IRQ 62
#define NVIC_TIMER4A_IRQ 63
#define NVIC_TIMER4B_IRQ 64
#define NVIC_TIMER5A_IRQ 65
#define NVIC_TIMER5B_IRQ 66
#define NVIC_SYSEXC_IRQ 67
#define NVIC_I2C4_IRQ 68
#define NVIC_I2C5_IRQ 69
#define NVIC_GPIOM_IRQ 70
#define NVIC_GPION_IRQ 71
#define NVIC_GPIOP0_IRQ 72
#define NVIC_GPIOP1_IRQ 73
#define NVIC_GPIOP3_IRQ 74
#define NVIC_GPIOP4_IRQ 75
#define NVIC_GPIOP5_IRQ 76
#define NVIC_GPIOP6_IRQ 77
#define NVIC_GPIOP7_IRQ 78
#define NVIC_GPIOQ0_IRQ 79
#define NVIC_GPIOQ1_IRQ 80
#define NVIC_GPIOQ2_IRQ 81
#define NVIC_GPIOQ3_IRQ 82
#define NVIC_GPIOQ4_IRQ 83
#define NVIC_GPIOQ5_IRQ 84
#define NVIC_GPIOQ6_IRQ 85
#define NVIC_GPIOQ7_IRQ 86
#define NVIC_TIMER6A_IRQ 87
#define NVIC_TIMER6B_IRQ 88
#define NVIC_TIMER7A_IRQ 89
#define NVIC_TIMER7B_IRQ 90
#define NVIC_I2C6_IRQ 91
#define NVIC_I2C7_IRQ 92
#define NVIC_I2C8_IRQ 93
#define NVIC_I2C9_IRQ 94

#define NVIC_IRQ_COUNT 95

/**@}*/

/** @defgroup CM3_nvic_isrprototypes_MSP432E4 User interrupt service routines (ISR) prototypes for MSP432 E4 series
    @ingroup CM3_nvic_isrprototypes

    @{*/

BEGIN_DECLS

void gpioa_isr(void);
void gpiob_isr(void);
void gpioc_isr(void);
void gpiod_isr(void);
void gpioe_isr(void);
void uart0_isr(void);
void uart1_isr(void);
void ssi0_isr(void);
void i2c0_isr(void);
void pwm0_fault_isr(void);
void pwm0_0_isr(void);
void pwm0_1_isr(void);
void pwm0_2_isr(void);
void qei0_isr(void);
void adc0ss0_isr(void);
void adc0ss1_isr(void);
void adc0ss2_isr(void);
void adc0ss3_isr(void);
void watchdog0_isr(void);
void timer0a_isr(void);
void timer0b_isr(void);
void timer1a_isr(void);
void timer1b_isr(void);
void timer2a_isr(void);
void timer2b_isr(void);
void comp0_isr(void);
void comp1_isr(void);
void comp2_isr(void);
void sysctl_isr(void);
void flash_ctrl_isr(void);
void gpiof_isr(void);
void gpiog_isr(void);
void gpioh_isr(void);
void uart2_isr(void);
void ssi1_isr(void);
void timer3a_isr(void);
void timer3b_isr(void);
void i2c1_isr(void);
void can0_isr(void);
void can1_isr(void);
void emac0_isr(void);
void hib_isr(void);
void usb0_isr(void);
void pwm0_3_isr(void);
void udma_isr(void);
void udmaerr_isr(void);
void adc1ss0_isr(void);
void adc1ss1_isr(void);
void adc1ss2_isr(void);
void adc1ss3_isr(void);
void epi0_isr(void);
void gpioj_isr(void);
void gpiok_isr(void);
void gpiol_isr(void);
void ssi2_isr(void);
void ssi3_isr(void);
void uart3_isr(void);
void uart4_isr(void);
void uart5_isr(void);
void uart6_isr(void);
void uart7_isr(void);
void i2c2_isr(void);
void i2c3_isr(void);
void timer4a_isr(void);
void timer4b_isr(void);
void timer5a_isr(void);
void timer5b_isr(void);
void sysexc_isr(void);
void i2c4_isr(void);
void i2c5_isr(void);
void gpiom_isr(void);
void gpion_isr(void);
void gpiop0_isr(void);
void gpiop1_isr(void);
void gpiop3_isr(void);
void gpiop4_isr(void);
void gpiop5_isr(void);
void gpiop6_isr(void);
void gpiop7_isr(void);
void gpioq0_isr(void);
void gpioq1_isr(void);
void gpioq2_isr(void);
void gpioq3_isr(void);
void gpioq4_isr(void);
void gpioq5_isr(void);
void gpioq6_isr(void);
void gpioq7_isr(void);
void timer6a_isr(void);
void timer6b_isr(void);
void timer7a_isr(void);
void timer7b_isr(void);
void i2c6_isr(void);
void i2c7_isr(void);
void i2c8_isr(void);
void i2c9_isr(void);

END_DECLS

/**@}*/

#endif /* LIBOPENCM3_MSP432_E4_NVIC_H */
