package Lire::Config::OptionSpec;

=head1 Lire::Config::OptionSpec

Type that represents a specific choice

=cut

use base qw/Lire::Config::TypeSpec/;

use Carp;

=pod

=head2 is_option( $value )

Returns true if $value is equals to this option name.

=cut

sub is_option {
    my ( $self, $value ) = @_;

    return lc $self->{'name'} eq lc $value;
}

1;
__END__

=pod

=head1 VERSION

$Id: OptionSpec.pm,v 1.2 2006/07/23 13:16:30 vanbaal Exp $

=head1 AUTHORS

Francis J. Lacoste <flacoste@logreport.org>
Wessel Dankers <wsl@logreport.org>
Wolfgang Sourdeau <wolfgang@logreport.org>

=head1 COPYRIGHT

Copyright (C) 2002-2004  Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html.

=cut
