/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.text;

import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.runtime.beans.actions.files.AbstractModifySingleFileAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;

public class WriteTextFileAction
extends AbstractModifySingleFileAction
implements PropertyLoggingInterceptor {
    private String text = "";
    private String encoding = "";
    private boolean escaped = true;
    private boolean append = false;
    private boolean logText = true;

    public boolean isLogText() {
        return this.replaceWithTextOverride("logText", this.logText);
    }

    public void setLogText(boolean logText) {
        this.logText = logText;
    }

    public boolean isEscaped() {
        return this.replaceWithTextOverride("escaped", this.escaped);
    }

    public void setEscaped(boolean escaped) {
        this.escaped = escaped;
    }

    public String getText() {
        return WriteTextFileAction.replaceVariables(WriteTextFileAction.replaceVariables(this.text, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE));
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getEncoding() {
        return WriteTextFileAction.replaceVariables(WriteTextFileAction.replaceVariables(this.encoding));
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isAppend() {
        return this.replaceWithTextOverride("append", this.append);
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    @Override
    protected boolean fileWillBeCreated() {
        return true;
    }

    @Override
    protected boolean modifyFile(File file, Context context) throws IOException {
        String encoding = this.getEncoding();
        String usedText = this.getText();
        if (this.isEscaped()) {
            try {
                usedText = WriteTextFileAction.loadConvert(usedText);
            }
            catch (Exception e) {
                Logger.getInstance().log(e);
                return false;
            }
        }
        InstallerUtil.writeTextFile(usedText, file, encoding, this.isAppend());
        return true;
    }

    private static String loadConvert(String theString) {
        int len = theString.length();
        StringBuilder outBuffer = new StringBuilder(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    @Override
    public Object getLogValueForProperty(String propertyName, Object propertyValue) {
        return this.maybeFilterLogReplacement(propertyName, "text", propertyValue, this.isLogText());
    }
}

