/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.nut;

import com.github.kokorin.jaffree.JaffreeException;
import com.github.kokorin.jaffree.Rational;
import com.github.kokorin.jaffree.nut.DataItem;
import com.github.kokorin.jaffree.nut.FrameCode;
import com.github.kokorin.jaffree.nut.Info;
import com.github.kokorin.jaffree.nut.MainHeader;
import com.github.kokorin.jaffree.nut.NutConst;
import com.github.kokorin.jaffree.nut.NutFrame;
import com.github.kokorin.jaffree.nut.NutInputStream;
import com.github.kokorin.jaffree.nut.StreamHeader;
import com.github.kokorin.jaffree.nut.SyncPoint;
import com.github.kokorin.jaffree.nut.Timestamp;
import com.github.kokorin.jaffree.nut.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public class NutReader {
    private final NutInputStream input;
    private MainHeader mainHeader;
    private StreamHeader[] streamHeaders;
    private Info[] infos;
    private long[] lastPts;

    public NutReader(NutInputStream input) {
        this.input = input;
    }

    public MainHeader getMainHeader() throws IOException {
        this.readToFrame();
        return this.mainHeader;
    }

    public StreamHeader[] getStreamHeaders() throws IOException {
        this.readToFrame();
        return Arrays.copyOf(this.streamHeaders, this.streamHeaders.length);
    }

    public Info[] getInfos() throws IOException {
        this.readToFrame();
        return Arrays.copyOf(this.infos, this.infos.length);
    }

    private void readToFrame() throws IOException {
        String fileId;
        if (this.input.getPosition() == 0L && !Objects.equals(fileId = this.input.readCString(), "nut/multimedia container")) {
            throw new JaffreeException("Wrong file ID: " + fileId);
        }
        while (this.input.checkNextByte() == 78) {
            PacketHeader packetHeader = this.readPacketHeader();
            long nextPacketPosition = this.input.getPosition() + packetHeader.forwardPtr;
            if (packetHeader.startcode == NutConst.MAIN_STARTCODE) {
                this.mainHeader = this.readMainHeader();
                if (this.streamHeaders == null) {
                    this.streamHeaders = new StreamHeader[this.mainHeader.streamCount];
                }
                if (this.infos == null) {
                    this.infos = new Info[this.mainHeader.streamCount];
                }
                if (this.lastPts == null) {
                    this.lastPts = new long[this.mainHeader.streamCount];
                }
            } else if (packetHeader.startcode == NutConst.STREAM_STARTCODE) {
                StreamHeader streamHeader;
                this.streamHeaders[streamHeader.streamId] = streamHeader = this.readStreamHeader();
            } else if (packetHeader.startcode == NutConst.INFO_STARTCODE) {
                Info info = this.readInfo();
                if (info.streamId >= 0) {
                    this.infos[info.streamId] = info;
                } else {
                    for (int i = 0; i < this.mainHeader.streamCount; ++i) {
                        this.infos[i] = info;
                    }
                }
            } else if (packetHeader.startcode == NutConst.SYNCPOINT_STARTCODE) {
                SyncPoint syncPoint = this.readSyncPoint();
                long pts = syncPoint.globalKeyPts.pts;
                Rational ptsTimebase = this.mainHeader.timeBases[syncPoint.globalKeyPts.timebaseId];
                for (int i = 0; i < this.mainHeader.streamCount; ++i) {
                    Rational streamTimeBase = this.mainHeader.timeBases[this.streamHeaders[i].timeBaseId];
                    this.lastPts[i] = Util.convertTimestamp(pts, ptsTimebase, streamTimeBase);
                }
            }
            this.input.skipBytes(nextPacketPosition - this.input.getPosition() - 4L);
            this.readPacketFooter();
        }
    }

    private PacketHeader readPacketHeader() throws IOException {
        long startcode = this.input.readLong();
        long forwardPtr = this.input.readValue();
        long headerChecksum = 0L;
        if (forwardPtr > 4096L) {
            headerChecksum = this.input.readInt();
        }
        return new PacketHeader(startcode, forwardPtr, headerChecksum);
    }

    private MainHeader readMainHeader() throws IOException {
        long majorVersion = this.input.readValue();
        long minorVersion = 0L;
        if (majorVersion > 3L) {
            minorVersion = this.input.readValue();
        }
        int streamCount = (int)this.input.readValue();
        long maxDistance = this.input.readValue();
        int timeBaseCount = (int)this.input.readValue();
        Rational[] timeBases = new Rational[timeBaseCount];
        for (int i = 0; i < timeBaseCount; ++i) {
            long numerator = this.input.readValue();
            long denominator = this.input.readValue();
            timeBases[i] = new Rational(numerator, denominator);
        }
        int streamId = 0;
        int dataSizeMul = 1;
        long ptsDelta = 0L;
        long matchTimeDelta = -4611686018427387903L;
        long elisionHeaderIdx = 0L;
        FrameCode[] frameCodes = new FrameCode[256];
        int i = 0;
        while (i < 256) {
            Set<FrameCode.Flag> flags = FrameCode.Flag.fromBitCode(this.input.readValue());
            long fields = this.input.readValue();
            if (fields > 0L) {
                ptsDelta = this.input.readSignedValue();
            }
            if (fields > 1L) {
                dataSizeMul = (int)this.input.readValue();
            }
            if (fields > 2L) {
                streamId = (int)this.input.readValue();
            }
            int size = fields > 3L ? (int)this.input.readValue() : 0;
            long reserved = fields > 4L ? this.input.readValue() : 0L;
            int count = fields > 5L ? (int)this.input.readValue() : dataSizeMul - size;
            if (fields > 6L) {
                matchTimeDelta = this.input.readSignedValue();
            }
            if (fields > 7L) {
                elisionHeaderIdx = this.input.readValue();
            }
            int j = 8;
            while ((long)j < fields) {
                this.input.readValue();
                ++j;
            }
            for (j = 0; j < count && i < 256; ++j, ++i) {
                FrameCode ft;
                if (i == 78) {
                    ft = FrameCode.INVALID;
                    --j;
                } else {
                    ft = new FrameCode(flags, streamId, dataSizeMul, size + j, ptsDelta, reserved, matchTimeDelta, elisionHeaderIdx);
                }
                frameCodes[i] = ft;
            }
        }
        long[] elisionHeaderSize = new long[255];
        Set<MainHeader.Flag> mainFlags = Collections.emptySet();
        return new MainHeader(majorVersion, minorVersion, streamCount, maxDistance, timeBases, frameCodes, elisionHeaderSize, mainFlags);
    }

    private StreamHeader readStreamHeader() throws IOException {
        int streamId = (int)this.input.readValue();
        StreamHeader.Type streamType = StreamHeader.Type.fromCode(this.input.readValue());
        byte[] fourcc = this.input.readVariableBytes();
        int timeBaseId = (int)this.input.readValue();
        int msbPtsShift = (int)this.input.readValue();
        long maxPtsDistance = this.input.readValue();
        long decodeDelay = this.input.readValue();
        Set<StreamHeader.Flag> flags = StreamHeader.Flag.fromBitCode(this.input.readValue());
        byte[] codecSpcificData = this.input.readVariableBytes();
        StreamHeader.Video video = null;
        StreamHeader.Audio audio = null;
        if (streamType == StreamHeader.Type.VIDEO) {
            int width = (int)this.input.readValue();
            int height = (int)this.input.readValue();
            int sampleWidth = (int)this.input.readValue();
            int sampleHeight = (int)this.input.readValue();
            StreamHeader.ColourspaceType colourspaceType = StreamHeader.ColourspaceType.fromCode(this.input.readValue());
            video = new StreamHeader.Video(width, height, sampleWidth, sampleHeight, colourspaceType);
        } else if (streamType == StreamHeader.Type.AUDIO) {
            long samplerateNumerator = this.input.readValue();
            long samplerateDenominator = this.input.readValue();
            int channelCount = (int)this.input.readValue();
            Rational sampleRate = new Rational(samplerateNumerator, samplerateDenominator);
            audio = new StreamHeader.Audio(sampleRate, channelCount);
        }
        return new StreamHeader(streamId, streamType, fourcc, timeBaseId, msbPtsShift, maxPtsDistance, decodeDelay, flags, codecSpcificData, video, audio);
    }

    private SyncPoint readSyncPoint() throws IOException {
        Timestamp pts = this.input.readTimestamp(this.mainHeader.timeBases.length);
        long backPtrDiv16 = this.input.readValue();
        Timestamp transmitTs = pts;
        if (this.mainHeader.flags.contains((Object)MainHeader.Flag.BROADCAST_MODE)) {
            transmitTs = this.input.readTimestamp(this.mainHeader.timeBases.length);
        }
        return new SyncPoint(pts, backPtrDiv16, transmitTs);
    }

    public NutFrame readFrame() throws IOException {
        long pts;
        this.readToFrame();
        if (!this.input.hasMoreData()) {
            return null;
        }
        int frameCode = this.input.readByte();
        FrameCode frameTable = this.mainHeader.frameCodes[frameCode];
        Set<FrameCode.Flag> flags = frameTable.flags;
        int streamId = frameTable.streamId;
        long dataSizeMsb = 0L;
        long dataSizeMul = frameTable.dataSizeMul;
        long dataSizeLsb = frameTable.dataSizeLsb;
        long reservedValues = frameTable.reservedCount;
        long matchTimeDelta = frameTable.matchTimeDelta;
        long elisionHeaderSize = 0L;
        DataItem[] sideData = null;
        DataItem[] metaData = null;
        if (flags.contains((Object)FrameCode.Flag.CODED_FLAGS)) {
            flags = EnumSet.copyOf(flags);
            Set<FrameCode.Flag> codedFlags = FrameCode.Flag.fromBitCode(this.input.readValue());
            flags = FrameCode.Flag.xor(flags, codedFlags);
        }
        if (flags.contains((Object)FrameCode.Flag.STREAM_ID)) {
            streamId = (int)this.input.readValue();
        }
        StreamHeader streamHeader = this.streamHeaders[streamId];
        if (flags.contains((Object)FrameCode.Flag.CODED_PTS)) {
            int shift;
            long codedPts = this.input.readValue();
            if (Util.compareUnsigned(codedPts, 1L << (shift = streamHeader.msbPtsShift)) >= 0) {
                pts = codedPts - (1L << shift);
            } else {
                long mask = (1L << shift) - 1L;
                long delta = this.lastPts[streamId] - mask / 2L;
                pts = (codedPts - delta & mask) + delta;
            }
        } else {
            pts = this.lastPts[streamId] + frameTable.ptsDelta;
        }
        if (flags.contains((Object)FrameCode.Flag.SIZE_MSB)) {
            dataSizeMsb = this.input.readValue();
        }
        if (flags.contains((Object)FrameCode.Flag.MATCH_TIME)) {
            matchTimeDelta = this.input.readSignedValue();
        }
        if (flags.contains((Object)FrameCode.Flag.HEADER_IDX)) {
            int elisionHeaderIdx = (int)this.input.readValue();
            elisionHeaderSize = this.mainHeader.elisionHeaderSize[elisionHeaderIdx];
        }
        if (flags.contains((Object)FrameCode.Flag.RESERVED)) {
            reservedValues = this.input.readValue();
        }
        int i2 = 0;
        while ((long)i2 < reservedValues) {
            this.input.readValue();
            ++i2;
        }
        if (flags.contains((Object)FrameCode.Flag.CHECKSUM)) {
            long i2 = this.input.readInt();
        }
        if (flags.contains((Object)FrameCode.Flag.SM_DATA)) {
            sideData = this.readDataItems();
            metaData = this.readDataItems();
        }
        long dataSizeWithElision = dataSizeLsb + dataSizeMsb * dataSizeMul;
        long dataSize = dataSizeWithElision - elisionHeaderSize;
        byte[] data = this.input.readBytes(dataSize);
        this.input.skipBytes(elisionHeaderSize);
        boolean keyframe = flags.contains((Object)FrameCode.Flag.KEYFRAME);
        boolean eor = flags.contains((Object)FrameCode.Flag.EOR) || dataSize == 0L;
        this.lastPts[streamId] = pts;
        return new NutFrame(streamId, pts, data, sideData, metaData, keyframe, eor);
    }

    private Info readInfo() throws IOException {
        int streamId = (int)(this.input.readValue() - 1L);
        int chapterId = (int)this.input.readSignedValue();
        Timestamp timestamp = this.input.readTimestamp(this.mainHeader.timeBases.length);
        long chapterStartPts = timestamp.pts;
        long chapterLengthPts = this.input.readValue();
        DataItem[] meta = this.readDataItems();
        return new Info(streamId, chapterId, chapterStartPts, chapterLengthPts, timestamp.timebaseId, meta);
    }

    private DataItem[] readDataItems() throws IOException {
        int count = (int)this.input.readValue();
        DataItem[] result = new DataItem[count];
        for (int i = 0; i < count; ++i) {
            Object value;
            String type;
            String name = this.input.readVariableString();
            long valueCode = this.input.readSignedValue();
            if (valueCode == -1L) {
                type = "UTF-8";
                value = this.input.readVariableString();
            } else if (valueCode == -2L) {
                type = this.input.readVariableString();
                value = this.input.readVariableBytes();
            } else if (valueCode == -3L) {
                type = "s";
                value = this.input.readSignedValue();
            } else if (valueCode == -4L) {
                type = "t";
                value = this.input.readTimestamp(this.mainHeader.timeBases.length);
            } else if (valueCode < -4L) {
                type = "r";
                long denominator = -valueCode - 4L;
                long numerator = this.input.readSignedValue();
                value = new Rational(numerator, denominator);
            } else {
                type = "v";
                value = valueCode;
            }
            result[i] = new DataItem(name, value, type);
        }
        return result;
    }

    private PacketFooter readPacketFooter() throws IOException {
        long checksum = this.input.readInt();
        return new PacketFooter(checksum);
    }

    private static class PacketHeader {
        private final long startcode;
        private final long forwardPtr;
        private final long headerChecksum;

        PacketHeader(long startcode, long forwardPtr, long headerChecksum) {
            this.startcode = startcode;
            this.forwardPtr = forwardPtr;
            this.headerChecksum = headerChecksum;
        }
    }

    private static class PacketFooter {
        private final long checksum;

        PacketFooter(long checksum) {
            this.checksum = checksum;
        }
    }
}

