/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.engine;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.Term;
import org.opensearch.common.lease.Releasable;
import org.opensearch.index.engine.DocumentIndexWriter;
import org.opensearch.index.mapper.ParseContext;

public class LuceneIndexWriter
implements DocumentIndexWriter {
    private final IndexWriter indexWriter;

    public LuceneIndexWriter(IndexWriter indexWriter) {
        this.indexWriter = indexWriter;
    }

    @Override
    public long getFlushingBytes() {
        return this.indexWriter.getFlushingBytes();
    }

    @Override
    public long getPendingNumDocs() {
        return this.indexWriter.getPendingNumDocs();
    }

    @Override
    public LiveIndexWriterConfig getConfig() {
        return this.indexWriter.getConfig();
    }

    @Override
    public boolean hasPendingMerges() {
        return this.indexWriter.hasPendingMerges();
    }

    @Override
    public boolean hasUncommittedChanges() {
        return this.indexWriter.hasUncommittedChanges();
    }

    @Override
    public Throwable getTragicException() {
        return this.indexWriter.getTragicException();
    }

    @Override
    public long ramBytesUsed() {
        return this.indexWriter.ramBytesUsed();
    }

    @Override
    public void setLiveCommitData(Iterable<Map.Entry<String, String>> commitUserData) {
        this.indexWriter.setLiveCommitData(commitUserData);
    }

    @Override
    public long commit() throws IOException {
        return this.indexWriter.commit();
    }

    @Override
    public Iterable<Map.Entry<String, String>> getLiveCommitData() {
        return this.indexWriter.getLiveCommitData();
    }

    @Override
    public void rollback() throws IOException {
        this.indexWriter.rollback();
    }

    @Override
    public void close() throws IOException {
        this.indexWriter.close();
    }

    @Override
    public void deleteUnusedFiles() throws IOException {
        this.indexWriter.deleteUnusedFiles();
    }

    @Override
    public long addDocuments(Iterable<ParseContext.Document> docs, Term uid) throws IOException {
        return this.indexWriter.addDocuments(docs);
    }

    @Override
    public long addDocument(ParseContext.Document doc, Term uid) throws IOException {
        return this.indexWriter.addDocument((Iterable)doc);
    }

    @Override
    public void softUpdateDocuments(Term uid, Iterable<ParseContext.Document> docs, long version, long seqNo, long primaryTerm, Field ... softDeletesField) throws IOException {
        this.indexWriter.softUpdateDocuments(uid, docs, softDeletesField);
    }

    @Override
    public void softUpdateDocument(Term uid, ParseContext.Document doc, long version, long seqNo, long primaryTerm, Field ... softDeletesField) throws IOException {
        this.indexWriter.softUpdateDocument(uid, (Iterable)doc, softDeletesField);
    }

    @Override
    public void deleteDocument(Term uid, boolean isStaleOperation, ParseContext.Document doc, long version, long seqNo, long primaryTerm, Field ... softDeletesField) throws IOException {
        if (isStaleOperation) {
            this.indexWriter.addDocument((Iterable)doc);
        } else {
            this.indexWriter.softUpdateDocument(uid, (Iterable)doc, softDeletesField);
        }
    }

    @Override
    public void forceMergeDeletes(boolean doWait) throws IOException {
        this.indexWriter.forceMergeDeletes(doWait);
    }

    @Override
    public void maybeMerge() throws IOException {
        this.indexWriter.maybeMerge();
    }

    @Override
    public void forceMerge(int maxNumSegments, boolean doWait) throws IOException {
        this.indexWriter.forceMerge(maxNumSegments, doWait);
    }

    @Override
    public IndexWriter getAccumulatingIndexWriter() {
        return this.indexWriter;
    }

    @Override
    public boolean hasNewIndexingOrUpdates() {
        return false;
    }

    @Override
    public boolean isWriteLockedByCurrentThread() {
        return true;
    }

    public void beforeRefresh() throws IOException {
    }

    public void afterRefresh(boolean b) throws IOException {
    }

    @Override
    public Releasable obtainWriteLockOnAllMap() {
        return () -> {};
    }
}

