/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.jobscheduler;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.geospatial.annotation.VisibleForTesting;
import org.opensearch.geospatial.ip2geo.common.DatasourceState;
import org.opensearch.geospatial.ip2geo.common.Ip2GeoExecutor;
import org.opensearch.geospatial.ip2geo.common.Ip2GeoLockService;
import org.opensearch.geospatial.ip2geo.dao.DatasourceDao;
import org.opensearch.geospatial.ip2geo.jobscheduler.Datasource;
import org.opensearch.geospatial.ip2geo.jobscheduler.DatasourceTask;
import org.opensearch.geospatial.ip2geo.jobscheduler.DatasourceUpdateService;
import org.opensearch.jobscheduler.spi.JobExecutionContext;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.ScheduledJobRunner;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;

public class DatasourceRunner
implements ScheduledJobRunner {
    @Generated
    private static final Logger log = LogManager.getLogger(DatasourceRunner.class);
    private static final int DELETE_INDEX_RETRY_IN_MIN = 15;
    private static final int DELETE_INDEX_DELAY_IN_MILLIS = 10000;
    private static DatasourceRunner INSTANCE;
    private ClusterService clusterService;
    private DatasourceUpdateService datasourceUpdateService;
    private Ip2GeoExecutor ip2GeoExecutor;
    private DatasourceDao datasourceDao;
    private Ip2GeoLockService ip2GeoLockService;
    private boolean initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasourceRunner getJobRunnerInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<DatasourceRunner> clazz = DatasourceRunner.class;
        synchronized (DatasourceRunner.class) {
            if (INSTANCE != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
            INSTANCE = new DatasourceRunner();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private DatasourceRunner() {
    }

    public void initialize(ClusterService clusterService, DatasourceUpdateService datasourceUpdateService, Ip2GeoExecutor ip2GeoExecutor, DatasourceDao datasourceDao, Ip2GeoLockService ip2GeoLockService) {
        this.clusterService = clusterService;
        this.datasourceUpdateService = datasourceUpdateService;
        this.ip2GeoExecutor = ip2GeoExecutor;
        this.datasourceDao = datasourceDao;
        this.ip2GeoLockService = ip2GeoLockService;
        this.initialized = true;
    }

    public void runJob(ScheduledJobParameter jobParameter, JobExecutionContext context) {
        if (!this.initialized) {
            throw new AssertionError((Object)"this instance is not initialized");
        }
        log.info("Update job started for a datasource[{}]", (Object)jobParameter.getName());
        if (!(jobParameter instanceof Datasource)) {
            throw new IllegalStateException("job parameter is not instance of Datasource, type: " + jobParameter.getClass().getCanonicalName());
        }
        this.ip2GeoExecutor.forDatasourceUpdate().submit(this.updateDatasourceRunner(jobParameter));
    }

    @VisibleForTesting
    protected Runnable updateDatasourceRunner(ScheduledJobParameter jobParameter) {
        return () -> {
            Optional<LockModel> lockModel = this.ip2GeoLockService.acquireLock(jobParameter.getName(), 300L);
            if (lockModel.isEmpty()) {
                log.error("Failed to update. Another processor is holding a lock for datasource[{}]", (Object)jobParameter.getName());
                return;
            }
            LockModel lock = lockModel.get();
            try {
                this.updateDatasource(jobParameter, this.ip2GeoLockService.getRenewLockRunnable(new AtomicReference<LockModel>(lock)));
            }
            catch (Exception e) {
                log.error("Failed to update datasource[{}]", (Object)jobParameter.getName(), (Object)e);
            }
            finally {
                this.ip2GeoLockService.releaseLock(lock);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void updateDatasource(ScheduledJobParameter jobParameter, Runnable renewLock) throws IOException {
        Datasource datasource = this.datasourceDao.getDatasource(jobParameter.getName());
        if (datasource == null) {
            log.info("Datasource[{}] does not exist", (Object)jobParameter.getName());
            return;
        }
        if (!DatasourceState.AVAILABLE.equals((Object)datasource.getState())) {
            log.error("Invalid datasource state. Expecting {} but received {}", (Object)DatasourceState.AVAILABLE, (Object)datasource.getState());
            datasource.disable();
            datasource.getUpdateStats().setLastFailedAt(Instant.now());
            this.datasourceDao.updateDatasource(datasource);
            return;
        }
        try {
            this.datasourceUpdateService.deleteUnusedIndices(datasource);
            if (!DatasourceTask.DELETE_UNUSED_INDICES.equals((Object)datasource.getTask())) {
                this.datasourceUpdateService.updateOrCreateGeoIpData(datasource, renewLock);
            }
            this.datasourceUpdateService.deleteUnusedIndices(datasource);
        }
        catch (Exception e) {
            log.error("Failed to update datasource for {}", (Object)datasource.getName(), (Object)e);
            datasource.getUpdateStats().setLastFailedAt(Instant.now());
            this.datasourceDao.updateDatasource(datasource);
        }
        finally {
            this.postProcessing(datasource);
        }
    }

    private void postProcessing(Datasource datasource) {
        if (datasource.isExpired()) {
            this.datasourceUpdateService.deleteUnusedIndices(datasource);
            this.datasourceUpdateService.updateDatasource(datasource, datasource.getUserSchedule(), DatasourceTask.ALL);
            return;
        }
        if (datasource.willExpire(datasource.getUserSchedule().getNextExecutionTime(Instant.now()))) {
            IntervalSchedule intervalSchedule = new IntervalSchedule(datasource.expirationDay(), 15, ChronoUnit.MINUTES, 10000L);
            this.datasourceUpdateService.updateDatasource(datasource, intervalSchedule, DatasourceTask.DELETE_UNUSED_INDICES);
        } else {
            this.datasourceUpdateService.updateDatasource(datasource, datasource.getUserSchedule(), DatasourceTask.ALL);
        }
    }
}

