/* pantheon-files-core.h generated by valac 0.56.18, the Vala compiler, do not modify */

#ifndef __LIBCORE_PANTHEON_FILES_CORE_H__
#define __LIBCORE_PANTHEON_FILES_CORE_H__

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <granite.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <sys/types.h>
#include <cairo-gobject.h>

G_BEGIN_DECLS

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif
#define FILES_FILE_GIO_DEFAULT_ATTRIBUTES "standard::is-hidden,standard::is-backup,standard::is-symlink,standard:" \
":type,standard::name," "standard::display-name,standard::content-type,standard::fast-content-t" \
"ype,standard::size," "standard::symlink-target,standard::target-uri,access::*,time::*,owner:" \
":*,trash::*,unix::*,id::filesystem," "thumbnail::*,mountable::*,metadata::marlin-sort-column-id,metadata::ma" \
"rlin-sort-reversed"
#define FILES_FILE_UTILS_COPY_TAG N_ ("copy")
#define FILES_FILE_UTILS_LINK_TAG N_ ("link")
#define FILES_FILE_UTILS_OPENING_COPY_LINK_TAG N_ ("(")
#define FILES_FILE_UTILS_CLOSING_COPY_LINK_TAG N_ (")")
#define FILES_ROOT_FS_URI "file://"
#define FILES_ADMIN_URI "admin://"
#define FILES_TRASH_URI "trash://"
#define FILES_NETWORK_URI "network://"
#define FILES_RECENT_URI "recent://"
#define FILES_AFP_URI "afp://"
#define FILES_AFC_URI "afc://"
#define FILES_DAV_URI "dav://"
#define FILES_DAVS_URI "davs://"
#define FILES_SFTP_URI "sftp://"
#define FILES_FTP_URI "ftp://"
#define FILES_SMB_URI "smb://"
#define FILES_MTP_URI "mtp://"
#define FILES_PTP_URI "gphoto2://"
#define FILES_APP_ID "io.elementary.files"
#define FILES_APP_DESKTOP FILES_APP_ID ".desktop"
#define FILES_APP_TITLE N_ ("Files")
#define FILES_HELP_URL "https://elementaryos.stackexchange.com/questions/tagged/pantheon-files"
#define FILES_BUG_URL "https://github.com/elementary/files/issues/new"
#define FILES_INVALID_TAB_NAME "----"
#define FILES_ICON_APP_LOGO "system-file-manager"
#define FILES_ICON_FILESYSTEM "drive-harddisk-system"
#define FILES_ICON_FILESYSTEM_SYMBOLIC "drive-harddisk-symbolic"
#define FILES_ICON_FOLDER "folder"
#define FILES_ICON_FOLDER_DOCUMENTS_SYMBOLIC "folder-documents-symbolic"
#define FILES_ICON_FOLDER_DOWNLOADS_SYMBOLIC "folder-download-symbolic"
#define FILES_ICON_FOLDER_MUSIC_SYMBOLIC "folder-music-symbolic"
#define FILES_ICON_FOLDER_PICTURES_SYMBOLIC "folder-pictures-symbolic"
#define FILES_ICON_FOLDER_PUBLICSHARE_SYMBOLIC "folder-publicshare-symbolic"
#define FILES_ICON_FOLDER_REMOTE "folder-remote"
#define FILES_ICON_FOLDER_REMOTE_SYMBOLIC "folder-remote-symbolic"
#define FILES_ICON_FOLDER_TEMPLATES_SYMBOLIC "folder-templates-symbolic"
#define FILES_ICON_FOLDER_VIDEOS_SYMBOLIC "folder-videos-symbolic"
#define FILES_ICON_GO_HOME_SYMBOLIC "go-home-symbolic"
#define FILES_ICON_HOME "user-home"
#define FILES_ICON_DEVICE_PHONE_SYMBOLIC "phone-symbolic"
#define FILES_ICON_DEVICE_CAMERA_SYMBOLIC "camera-photo-symbolic"
#define FILES_ICON_DEVICE_REMOVABLE_MEDIA_SYMBOLIC "media-removable-symbolic"
#define FILES_ICON_NETWORK_SYMBOLIC "network-workgroup-symbolic"
#define FILES_ICON_NETWORK "network-workgroup"
#define FILES_ICON_NETWORK_SERVER_SYMBOLIC "network-server-symbolic"
#define FILES_ICON_NETWORK_SERVER "network-server"
#define FILES_ICON_TRASH "user-trash"
#define FILES_ICON_TRASH_FULL "user-trash-full"
#define FILES_ICON_TRASH_SYMBOLIC "user-trash-symbolic"
#define FILES_ICON_RECENT "document-open-recent"
#define FILES_ICON_RECENT_SYMBOLIC "document-open-recent-symbolic"
#define FILES_ICON_PATHBAR_PRIMARY_FIND_SYMBOLIC "edit-find-symbolic"
#define FILES_ICON_PATHBAR_SECONDARY_NAVIGATE_SYMBOLIC "go-jump-symbolic"
#define FILES_ICON_PATHBAR_SECONDARY_REFRESH_SYMBOLIC "view-refresh-symbolic"
#define FILES_ICON_PATHBAR_SECONDARY_WORKING_SYMBOLIC "process-working-symbolic"
#define FILES_OPEN_IN_TERMINAL_DESKTOP_ID "open-pantheon-terminal-here.desktop"
#define FILES_PROTOCOL_NAME_AFP N_ ("AFP")
#define FILES_PROTOCOL_NAME_AFC N_ ("AFC")
#define FILES_PROTOCOL_NAME_DAV N_ ("DAV")
#define FILES_PROTOCOL_NAME_DAVS N_ ("DAVS")
#define FILES_PROTOCOL_NAME_FTP N_ ("FTP")
#define FILES_PROTOCOL_NAME_NETWORK N_ ("Network")
#define FILES_PROTOCOL_NAME_SFTP N_ ("SFTP")
#define FILES_PROTOCOL_NAME_SMB N_ ("SMB")
#define FILES_PROTOCOL_NAME_TRASH N_ ("Trash")
#define FILES_PROTOCOL_NAME_RECENT N_ ("Recent")
#define FILES_PROTOCOL_NAME_MTP N_ ("MTP")
#define FILES_PROTOCOL_NAME_GPHOTO2 N_ ("GPHOTO2")
#define FILES_PROTOCOL_NAME_FILE N_ ("File System")
#define FILES_MINIMUM_LOCATION_BAR_ENTRY_WIDTH ((gdouble) 36)
#define FILES_LOCATION_BAR_ANIMATION_TIME_USEC ((guint64) 200000)
#define FILES_BUTTON_LONG_PRESS ((guint) 300)
#define FILES_DEFAULT_POPUP_MENU_DISPLACEMENT ((gint16) 2)
#define FILES_SIDEBAR_PLUGIN_ITEM_PLACE_TYPE FILES_PLACE_TYPE_PLUGIN_ITEM
#define PF_SOUND_THEME "elementary"
#define PF_SOUND_DELETE "trash-empty"
#define PF_SOUND_EMPTY_TRASH "trash-empty"
#define CANCEL _ ("_Cancel")
#define DELETE _ ("Delete")
#define SKIP _ ("_Skip")
#define SKIP_ALL _ ("S_kip All")
#define RETRY _ ("_Retry")
#define DELETE_ALL _ ("Delete _All")
#define REPLACE _ ("_Replace")
#define REPLACE_ALL _ ("Replace _All")
#define MERGE _ ("_Merge")
#define MERGE_ALL _ ("Merge _All")
#define COPY_FORCE _ ("Copy _Anyway")
#define EMPTY_TRASH _ ("Empty _Trash")
#define FILES_TRASH_MONITOR_URI "trash://"
#define MARLIN_FILE_OPERATIONS_COMMON_JOB_NSEC_PER_MSEC 1000000
#define MARLIN_FILE_OPERATIONS_COMMON_JOB_SECONDS_NEEDED_FOR_RELIABLE_TRANSFER_RATE 15
#define FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_MINIMUM_LOCATION_BAR_ENTRY_WIDTH ((gdouble) 16)
#define FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_MINIMUM_BREADCRUMB_WIDTH ((gdouble) 12)
#define FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_ICON_WIDTH 32
#define FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_BREAD_SPACING 12
#define FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_YPAD ((gdouble) 0)

#define FILES_TYPE_ABSTRACT_SLOT (files_abstract_slot_get_type ())
#define FILES_ABSTRACT_SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_ABSTRACT_SLOT, FilesAbstractSlot))
#define FILES_ABSTRACT_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_ABSTRACT_SLOT, FilesAbstractSlotClass))
#define FILES_IS_ABSTRACT_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_ABSTRACT_SLOT))
#define FILES_IS_ABSTRACT_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_ABSTRACT_SLOT))
#define FILES_ABSTRACT_SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_ABSTRACT_SLOT, FilesAbstractSlotClass))

typedef struct _FilesAbstractSlot FilesAbstractSlot;
typedef struct _FilesAbstractSlotClass FilesAbstractSlotClass;
typedef struct _FilesAbstractSlotPrivate FilesAbstractSlotPrivate;

#define FILES_TYPE_FILE (files_file_get_type ())
#define FILES_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_FILE, FilesFile))
#define FILES_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_FILE, FilesFileClass))
#define FILES_IS_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_FILE))
#define FILES_IS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_FILE))
#define FILES_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_FILE, FilesFileClass))

typedef struct _FilesFile FilesFile;
typedef struct _FilesFileClass FilesFileClass;

#define FILES_TYPE_DIRECTORY (files_directory_get_type ())
#define FILES_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_DIRECTORY, FilesDirectory))
#define FILES_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_DIRECTORY, FilesDirectoryClass))
#define FILES_IS_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_DIRECTORY))
#define FILES_IS_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_DIRECTORY))
#define FILES_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_DIRECTORY, FilesDirectoryClass))

typedef struct _FilesDirectory FilesDirectory;
typedef struct _FilesDirectoryClass FilesDirectoryClass;

#define FILES_TYPE_BOOKMARK (files_bookmark_get_type ())
#define FILES_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_BOOKMARK, FilesBookmark))
#define FILES_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_BOOKMARK, FilesBookmarkClass))
#define FILES_IS_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_BOOKMARK))
#define FILES_IS_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_BOOKMARK))
#define FILES_BOOKMARK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_BOOKMARK, FilesBookmarkClass))

typedef struct _FilesBookmark FilesBookmark;
typedef struct _FilesBookmarkClass FilesBookmarkClass;
typedef struct _FilesBookmarkPrivate FilesBookmarkPrivate;

#define FILES_TYPE_BOOKMARK_LIST (files_bookmark_list_get_type ())
#define FILES_BOOKMARK_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_BOOKMARK_LIST, FilesBookmarkList))
#define FILES_BOOKMARK_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_BOOKMARK_LIST, FilesBookmarkListClass))
#define FILES_IS_BOOKMARK_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_BOOKMARK_LIST))
#define FILES_IS_BOOKMARK_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_BOOKMARK_LIST))
#define FILES_BOOKMARK_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_BOOKMARK_LIST, FilesBookmarkListClass))

typedef struct _FilesBookmarkList FilesBookmarkList;
typedef struct _FilesBookmarkListClass FilesBookmarkListClass;
typedef struct _FilesBookmarkListPrivate FilesBookmarkListPrivate;

#define FILES_TYPE_CALL_WHEN_READY (files_call_when_ready_get_type ())
#define FILES_CALL_WHEN_READY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_CALL_WHEN_READY, FilesCallWhenReady))
#define FILES_CALL_WHEN_READY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_CALL_WHEN_READY, FilesCallWhenReadyClass))
#define FILES_IS_CALL_WHEN_READY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_CALL_WHEN_READY))
#define FILES_IS_CALL_WHEN_READY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_CALL_WHEN_READY))
#define FILES_CALL_WHEN_READY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_CALL_WHEN_READY, FilesCallWhenReadyClass))

typedef struct _FilesCallWhenReady FilesCallWhenReady;
typedef struct _FilesCallWhenReadyClass FilesCallWhenReadyClass;
typedef struct _FilesCallWhenReadyPrivate FilesCallWhenReadyPrivate;
typedef void (*FilesCallWhenReadycall_when_ready_func) (GList* files, gpointer user_data);

#define FILES_CONNECT_SERVER_TYPE_OPERATION (files_connect_server_operation_get_type ())
#define FILES_CONNECT_SERVER_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_CONNECT_SERVER_TYPE_OPERATION, FilesConnectServerOperation))
#define FILES_CONNECT_SERVER_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_CONNECT_SERVER_TYPE_OPERATION, FilesConnectServerOperationClass))
#define FILES_CONNECT_SERVER_IS_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_CONNECT_SERVER_TYPE_OPERATION))
#define FILES_CONNECT_SERVER_IS_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_CONNECT_SERVER_TYPE_OPERATION))
#define FILES_CONNECT_SERVER_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_CONNECT_SERVER_TYPE_OPERATION, FilesConnectServerOperationClass))

typedef struct _FilesConnectServerOperation FilesConnectServerOperation;
typedef struct _FilesConnectServerOperationClass FilesConnectServerOperationClass;
typedef struct _FilesConnectServerOperationPrivate FilesConnectServerOperationPrivate;

#define PF_TYPE_CONNECT_SERVER_DIALOG (pf_connect_server_dialog_get_type ())
#define PF_CONNECT_SERVER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PF_TYPE_CONNECT_SERVER_DIALOG, PFConnectServerDialog))
#define PF_CONNECT_SERVER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PF_TYPE_CONNECT_SERVER_DIALOG, PFConnectServerDialogClass))
#define PF_IS_CONNECT_SERVER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PF_TYPE_CONNECT_SERVER_DIALOG))
#define PF_IS_CONNECT_SERVER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PF_TYPE_CONNECT_SERVER_DIALOG))
#define PF_CONNECT_SERVER_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PF_TYPE_CONNECT_SERVER_DIALOG, PFConnectServerDialogClass))

typedef struct _PFConnectServerDialog PFConnectServerDialog;
typedef struct _PFConnectServerDialogClass PFConnectServerDialogClass;
typedef struct _PFConnectServerDialogPrivate PFConnectServerDialogPrivate;
typedef struct _FilesDirectoryPrivate FilesDirectoryPrivate;
typedef enum  {
	FILES_DIRECTORY_STATE_NOT_LOADED,
	FILES_DIRECTORY_STATE_LOADING,
	FILES_DIRECTORY_STATE_LOADED,
	FILES_DIRECTORY_STATE_TIMED_OUT
} FilesDirectoryState;

#define FILES_DIRECTORY_TYPE_STATE (files_directory_state_get_type ())
typedef void (*FilesDirectoryFileLoadedFunc) (FilesFile* file, gpointer user_data);
typedef void (*FilesDirectoryDoneLoadingFunc) (gpointer user_data);
typedef struct _FilesFileChangesChange FilesFileChangesChange;

#define FILES_TYPE_DND_HANDLER (files_dnd_handler_get_type ())
#define FILES_DND_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_DND_HANDLER, FilesDndHandler))
#define FILES_DND_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_DND_HANDLER, FilesDndHandlerClass))
#define FILES_IS_DND_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_DND_HANDLER))
#define FILES_IS_DND_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_DND_HANDLER))
#define FILES_DND_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_DND_HANDLER, FilesDndHandlerClass))

typedef struct _FilesDndHandler FilesDndHandler;
typedef struct _FilesDndHandlerClass FilesDndHandlerClass;
typedef struct _FilesDndHandlerPrivate FilesDndHandlerPrivate;
typedef enum  {
	FILES_WINDOW_STATE_NORMAL,
	FILES_WINDOW_STATE_MAXIMIZED,
	FILES_WINDOW_STATE_INVALID
} FilesWindowState;

#define FILES_TYPE_WINDOW_STATE (files_window_state_get_type ())
typedef enum  {
	FILES_VIEW_MODE_ICON = 0,
	FILES_VIEW_MODE_LIST = 1,
	FILES_VIEW_MODE_MILLER_COLUMNS = 2,
	FILES_VIEW_MODE_CURRENT,
	FILES_VIEW_MODE_PREFERRED,
	FILES_VIEW_MODE_INVALID
} FilesViewMode;

#define FILES_TYPE_VIEW_MODE (files_view_mode_get_type ())
typedef enum  {
	FILES_OPEN_FLAG_DEFAULT,
	FILES_OPEN_FLAG_NEW_ROOT,
	FILES_OPEN_FLAG_NEW_TAB,
	FILES_OPEN_FLAG_NEW_WINDOW,
	FILES_OPEN_FLAG_APP
} FilesOpenFlag;

#define FILES_TYPE_OPEN_FLAG (files_open_flag_get_type ())
typedef enum  {
	FILES_ZOOM_LEVEL_SMALLEST,
	FILES_ZOOM_LEVEL_SMALLER,
	FILES_ZOOM_LEVEL_SMALL,
	FILES_ZOOM_LEVEL_NORMAL,
	FILES_ZOOM_LEVEL_LARGE,
	FILES_ZOOM_LEVEL_LARGER,
	FILES_ZOOM_LEVEL_HUGE,
	FILES_ZOOM_LEVEL_HUGER,
	FILES_ZOOM_LEVEL_LARGEST,
	FILES_ZOOM_LEVEL_N_LEVELS,
	FILES_ZOOM_LEVEL_INVALID
} FilesZoomLevel;

#define FILES_TYPE_ZOOM_LEVEL (files_zoom_level_get_type ())
typedef enum  {
	FILES_ICON_SIZE_EMBLEM = 16,
	FILES_ICON_SIZE_SMALLEST = 16,
	FILES_ICON_SIZE_LARGE_EMBLEM = 24,
	FILES_ICON_SIZE_SMALLER = 24,
	FILES_ICON_SIZE_SMALL = 32,
	FILES_ICON_SIZE_NORMAL = 48,
	FILES_ICON_SIZE_LARGE = 64,
	FILES_ICON_SIZE_LARGER = 96,
	FILES_ICON_SIZE_HUGE = 128,
	FILES_ICON_SIZE_HUGER = 192,
	FILES_ICON_SIZE_LARGEST = 256
} FilesIconSize;

#define FILES_TYPE_ICON_SIZE (files_icon_size_get_type ())
typedef enum  {
	FILES_TARGET_TYPE_STRING,
	FILES_TARGET_TYPE_TEXT_URI_LIST,
	FILES_TARGET_TYPE_XDND_DIRECT_SAVE0,
	FILES_TARGET_TYPE_NETSCAPE_URL,
	FILES_TARGET_TYPE_BOOKMARK_ROW
} FilesTargetType;

#define FILES_TYPE_TARGET_TYPE (files_target_type_get_type ())
typedef enum  {
	FILES_SORT_BY_NAME,
	FILES_SORT_BY_CREATED,
	FILES_SORT_BY_MODIFIED,
	FILES_SORT_BY_SIZE
} FilesSortBy;

#define FILES_TYPE_SORT_BY (files_sort_by_get_type ())
typedef enum  {
	FILES_RENAME_STATUS_VALID,
	FILES_RENAME_STATUS_IGNORED,
	FILES_RENAME_STATUS_INVALID
} FilesRenameStatus;

#define FILES_TYPE_RENAME_STATUS (files_rename_status_get_type ())
typedef enum  {
	FILES_RENAME_MODE_TEXT,
	FILES_RENAME_MODE_NUMBER_SEQUENCE,
	FILES_RENAME_MODE_DATETIME,
	FILES_RENAME_MODE_INVALID
} FilesRenameMode;

#define FILES_TYPE_RENAME_MODE (files_rename_mode_get_type ())
typedef enum  {
	FILES_RENAME_POSITION_SUFFIX,
	FILES_RENAME_POSITION_PREFIX,
	FILES_RENAME_POSITION_INVALID
} FilesRenamePosition;

#define FILES_TYPE_RENAME_POSITION (files_rename_position_get_type ())
typedef enum  {
	FILES_RENAME_DATE_FORMAT_DEFAULT,
	FILES_RENAME_DATE_FORMAT_DEFAULT_DATETIME,
	FILES_RENAME_DATE_FORMAT_LOCALE,
	FILES_RENAME_DATE_FORMAT_ISO_DATE,
	FILES_RENAME_DATE_FORMAT_ISO_DATETIME,
	FILES_RENAME_DATE_FORMAT_INVALID
} FilesRenameDateFormat;

#define FILES_TYPE_RENAME_DATE_FORMAT (files_rename_date_format_get_type ())
typedef enum  {
	FILES_RENAME_DATE_SOURCE_CREATED,
	FILES_RENAME_DATE_SOURCE_MODIFIED,
	FILES_RENAME_DATE_SOURCE_NOW,
	FILES_RENAME_DATE_SOURCE_INVALID
} FilesRenameDateSource;

#define FILES_TYPE_RENAME_DATE_SOURCE (files_rename_date_source_get_type ())
typedef struct _FilesFilePrivate FilesFilePrivate;
typedef enum  {
	FILES_FILE_ICON_FLAGS_NONE,
	FILES_FILE_ICON_FLAGS_USE_THUMBNAILS
} FilesFileIconFlags;

#define FILES_FILE_TYPE_ICON_FLAGS (files_file_icon_flags_get_type ())
typedef enum  {
	FILES_FILE_THUMB_STATE_UNKNOWN,
	FILES_FILE_THUMB_STATE_NONE,
	FILES_FILE_THUMB_STATE_READY,
	FILES_FILE_THUMB_STATE_LOADING
} FilesFileThumbState;

#define FILES_FILE_TYPE_THUMB_STATE (files_file_thumb_state_get_type ())
typedef enum  {
	FILES_FILE_CHANGES_KIND_INITIAL,
	FILES_FILE_CHANGES_KIND_ADDED,
	FILES_FILE_CHANGES_KIND_CHANGED,
	FILES_FILE_CHANGES_KIND_REMOVED,
	FILES_FILE_CHANGES_KIND_MOVED
} FilesFileChangesKind;

#define FILES_FILE_CHANGES_TYPE_KIND (files_file_changes_kind_get_type ())

#define FILES_TYPE_FILE_CONFLICT_DIALOG (files_file_conflict_dialog_get_type ())
#define FILES_FILE_CONFLICT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_FILE_CONFLICT_DIALOG, FilesFileConflictDialog))
#define FILES_FILE_CONFLICT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_FILE_CONFLICT_DIALOG, FilesFileConflictDialogClass))
#define FILES_IS_FILE_CONFLICT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_FILE_CONFLICT_DIALOG))
#define FILES_IS_FILE_CONFLICT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_FILE_CONFLICT_DIALOG))
#define FILES_FILE_CONFLICT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_FILE_CONFLICT_DIALOG, FilesFileConflictDialogClass))

typedef struct _FilesFileConflictDialog FilesFileConflictDialog;
typedef struct _FilesFileConflictDialogClass FilesFileConflictDialogClass;
typedef struct _FilesFileConflictDialogPrivate FilesFileConflictDialogPrivate;
typedef enum  {
	FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_SKIP,
	FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_RENAME,
	FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_REPLACE,
	FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_NEWEST
} FilesFileConflictDialogResponseType;

#define FILES_FILE_CONFLICT_DIALOG_TYPE_RESPONSE_TYPE (files_file_conflict_dialog_response_type_get_type ())

#define FILES_TYPE_ICON_INFO (files_icon_info_get_type ())
#define FILES_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_ICON_INFO, FilesIconInfo))
#define FILES_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_ICON_INFO, FilesIconInfoClass))
#define FILES_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_ICON_INFO))
#define FILES_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_ICON_INFO))
#define FILES_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_ICON_INFO, FilesIconInfoClass))

typedef struct _FilesIconInfo FilesIconInfo;
typedef struct _FilesIconInfoClass FilesIconInfoClass;
typedef struct _FilesIconInfoPrivate FilesIconInfoPrivate;

#define FILES_TYPE_LIST_MODEL (files_list_model_get_type ())
#define FILES_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_LIST_MODEL, FilesListModel))
#define FILES_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_LIST_MODEL, FilesListModelClass))
#define FILES_IS_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_LIST_MODEL))
#define FILES_IS_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_LIST_MODEL))
#define FILES_LIST_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_LIST_MODEL, FilesListModelClass))

typedef struct _FilesListModel FilesListModel;
typedef struct _FilesListModelClass FilesListModelClass;
typedef struct _FilesListModelPrivate FilesListModelPrivate;
typedef enum  {
	FILES_LIST_MODEL_COLUMN_ID_FILE_COLUMN,
	FILES_LIST_MODEL_COLUMN_ID_COLOR,
	FILES_LIST_MODEL_COLUMN_ID_PIXBUF,
	FILES_LIST_MODEL_COLUMN_ID_FILENAME,
	FILES_LIST_MODEL_COLUMN_ID_SIZE,
	FILES_LIST_MODEL_COLUMN_ID_TYPE,
	FILES_LIST_MODEL_COLUMN_ID_MODIFIED,
	FILES_LIST_MODEL_COLUMN_ID_NUM_COLUMNS
} FilesListModelColumnID;

#define FILES_LIST_MODEL_TYPE_COLUMN_ID (files_list_model_column_id_get_type ())

#define FILES_TYPE_PREFERENCES (files_preferences_get_type ())
#define FILES_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_PREFERENCES, FilesPreferences))
#define FILES_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_PREFERENCES, FilesPreferencesClass))
#define FILES_IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_PREFERENCES))
#define FILES_IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_PREFERENCES))
#define FILES_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_PREFERENCES, FilesPreferencesClass))

typedef struct _FilesPreferences FilesPreferences;
typedef struct _FilesPreferencesClass FilesPreferencesClass;
typedef struct _FilesPreferencesPrivate FilesPreferencesPrivate;

#define FILES_TYPE_PLUGIN_MANAGER (files_plugin_manager_get_type ())
#define FILES_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_PLUGIN_MANAGER, FilesPluginManager))
#define FILES_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_PLUGIN_MANAGER, FilesPluginManagerClass))
#define FILES_IS_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_PLUGIN_MANAGER))
#define FILES_IS_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_PLUGIN_MANAGER))
#define FILES_PLUGIN_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_PLUGIN_MANAGER, FilesPluginManagerClass))

typedef struct _FilesPluginManager FilesPluginManager;
typedef struct _FilesPluginManagerClass FilesPluginManagerClass;
typedef struct _FilesPluginManagerPrivate FilesPluginManagerPrivate;

#define FILES_PLUGINS_TYPE_BASE (files_plugins_base_get_type ())
#define FILES_PLUGINS_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_PLUGINS_TYPE_BASE, FilesPluginsBase))
#define FILES_PLUGINS_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_PLUGINS_TYPE_BASE, FilesPluginsBaseClass))
#define FILES_PLUGINS_IS_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_PLUGINS_TYPE_BASE))
#define FILES_PLUGINS_IS_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_PLUGINS_TYPE_BASE))
#define FILES_PLUGINS_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_PLUGINS_TYPE_BASE, FilesPluginsBaseClass))

typedef struct _FilesPluginsBase FilesPluginsBase;
typedef struct _FilesPluginsBaseClass FilesPluginsBaseClass;
typedef struct _FilesPluginsBasePrivate FilesPluginsBasePrivate;

#define PF_PROGRESS_TYPE_INFO (pf_progress_info_get_type ())
#define PF_PROGRESS_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PF_PROGRESS_TYPE_INFO, PFProgressInfo))
#define PF_PROGRESS_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PF_PROGRESS_TYPE_INFO, PFProgressInfoClass))
#define PF_PROGRESS_IS_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PF_PROGRESS_TYPE_INFO))
#define PF_PROGRESS_IS_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PF_PROGRESS_TYPE_INFO))
#define PF_PROGRESS_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PF_PROGRESS_TYPE_INFO, PFProgressInfoClass))

typedef struct _PFProgressInfo PFProgressInfo;
typedef struct _PFProgressInfoClass PFProgressInfoClass;
typedef struct _PFProgressInfoPrivate PFProgressInfoPrivate;

#define PF_PROGRESS_TYPE_INFO_MANAGER (pf_progress_info_manager_get_type ())
#define PF_PROGRESS_INFO_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PF_PROGRESS_TYPE_INFO_MANAGER, PFProgressInfoManager))
#define PF_PROGRESS_INFO_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PF_PROGRESS_TYPE_INFO_MANAGER, PFProgressInfoManagerClass))
#define PF_PROGRESS_IS_INFO_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PF_PROGRESS_TYPE_INFO_MANAGER))
#define PF_PROGRESS_IS_INFO_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PF_PROGRESS_TYPE_INFO_MANAGER))
#define PF_PROGRESS_INFO_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PF_PROGRESS_TYPE_INFO_MANAGER, PFProgressInfoManagerClass))

typedef struct _PFProgressInfoManager PFProgressInfoManager;
typedef struct _PFProgressInfoManagerClass PFProgressInfoManagerClass;
typedef struct _PFProgressInfoManagerPrivate PFProgressInfoManagerPrivate;

#define FILES_TYPE_SIDEBAR_PLUGIN_ITEM (files_sidebar_plugin_item_get_type ())
#define FILES_SIDEBAR_PLUGIN_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_SIDEBAR_PLUGIN_ITEM, FilesSidebarPluginItem))
#define FILES_SIDEBAR_PLUGIN_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_SIDEBAR_PLUGIN_ITEM, FilesSidebarPluginItemClass))
#define FILES_IS_SIDEBAR_PLUGIN_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_SIDEBAR_PLUGIN_ITEM))
#define FILES_IS_SIDEBAR_PLUGIN_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_SIDEBAR_PLUGIN_ITEM))
#define FILES_SIDEBAR_PLUGIN_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_SIDEBAR_PLUGIN_ITEM, FilesSidebarPluginItemClass))

typedef struct _FilesSidebarPluginItem FilesSidebarPluginItem;
typedef struct _FilesSidebarPluginItemClass FilesSidebarPluginItemClass;
typedef struct _FilesSidebarPluginItemPrivate FilesSidebarPluginItemPrivate;
typedef enum  {
	FILES_PLACE_TYPE_BUILT_IN,
	FILES_PLACE_TYPE_MOUNTED_VOLUME,
	FILES_PLACE_TYPE_BOOKMARK,
	FILES_PLACE_TYPE_BOOKMARKS_CATEGORY,
	FILES_PLACE_TYPE_PERSONAL_CATEGORY,
	FILES_PLACE_TYPE_STORAGE_CATEGORY,
	FILES_PLACE_TYPE_NETWORK_CATEGORY,
	FILES_PLACE_TYPE_PLUGIN_ITEM
} FilesPlaceType;

#define FILES_TYPE_PLACE_TYPE (files_place_type_get_type ())
typedef void (*FilesSidebarCallbackFunc) (GtkWidget* widget);

#define PF_TYPE_SOUND_MANAGER (pf_sound_manager_get_type ())
#define PF_SOUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PF_TYPE_SOUND_MANAGER, PFSoundManager))
#define PF_SOUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PF_TYPE_SOUND_MANAGER, PFSoundManagerClass))
#define PF_IS_SOUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PF_TYPE_SOUND_MANAGER))
#define PF_IS_SOUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PF_TYPE_SOUND_MANAGER))
#define PF_SOUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PF_TYPE_SOUND_MANAGER, PFSoundManagerClass))

typedef struct _PFSoundManager PFSoundManager;
typedef struct _PFSoundManagerClass PFSoundManagerClass;
typedef struct _PFSoundManagerPrivate PFSoundManagerPrivate;

#define FILES_TYPE_THUMBNAILER_DAEMON (files_thumbnailer_daemon_get_type ())
#define FILES_THUMBNAILER_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_THUMBNAILER_DAEMON, FilesThumbnailerDaemon))
#define FILES_IS_THUMBNAILER_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_THUMBNAILER_DAEMON))
#define FILES_THUMBNAILER_DAEMON_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FILES_TYPE_THUMBNAILER_DAEMON, FilesThumbnailerDaemonIface))

typedef struct _FilesThumbnailerDaemon FilesThumbnailerDaemon;
typedef struct _FilesThumbnailerDaemonIface FilesThumbnailerDaemonIface;

#define FILES_TYPE_THUMBNAILER_DAEMON_PROXY (files_thumbnailer_daemon_proxy_get_type ())

#define FILES_TYPE_THUMBNAILER (files_thumbnailer_get_type ())
#define FILES_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_THUMBNAILER, FilesThumbnailer))
#define FILES_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_THUMBNAILER, FilesThumbnailerClass))
#define FILES_IS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_THUMBNAILER))
#define FILES_IS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_THUMBNAILER))
#define FILES_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_THUMBNAILER, FilesThumbnailerClass))

typedef struct _FilesThumbnailer FilesThumbnailer;
typedef struct _FilesThumbnailerClass FilesThumbnailerClass;
typedef struct _FilesThumbnailerPrivate FilesThumbnailerPrivate;

#define FILES_TYPE_TRASH_MONITOR (files_trash_monitor_get_type ())
#define FILES_TRASH_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_TRASH_MONITOR, FilesTrashMonitor))
#define FILES_TRASH_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_TRASH_MONITOR, FilesTrashMonitorClass))
#define FILES_IS_TRASH_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_TRASH_MONITOR))
#define FILES_IS_TRASH_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_TRASH_MONITOR))
#define FILES_TRASH_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_TRASH_MONITOR, FilesTrashMonitorClass))

typedef struct _FilesTrashMonitor FilesTrashMonitor;
typedef struct _FilesTrashMonitorClass FilesTrashMonitorClass;
typedef struct _FilesTrashMonitorPrivate FilesTrashMonitorPrivate;
typedef enum  {
	MARLIN_UNDO_COPY,
	MARLIN_UNDO_DUPLICATE,
	MARLIN_UNDO_MOVE,
	MARLIN_UNDO_RENAME,
	MARLIN_UNDO_CREATEEMPTYFILE,
	MARLIN_UNDO_CREATEFILEFROMTEMPLATE,
	MARLIN_UNDO_CREATEFOLDER,
	MARLIN_UNDO_MOVETOTRASH,
	MARLIN_UNDO_CREATELINK,
	MARLIN_UNDO_RESTOREFROMTRASH,
	MARLIN_UNDO_SETPERMISSIONS,
	MARLIN_UNDO_RECURSIVESETPERMISSIONS,
	MARLIN_UNDO_CHANGEOWNER,
	MARLIN_UNDO_CHANGEGROUP
} FilesUndoActionType;

#define FILES_TYPE_UNDO_ACTION_TYPE (files_undo_action_type_get_type ())

#define FILES_TYPE_UNDO_ACTION_DATA (files_undo_action_data_get_type ())
#define FILES_UNDO_ACTION_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_UNDO_ACTION_DATA, FilesUndoActionData))
#define FILES_UNDO_ACTION_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_UNDO_ACTION_DATA, FilesUndoActionDataClass))
#define FILES_IS_UNDO_ACTION_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_UNDO_ACTION_DATA))
#define FILES_IS_UNDO_ACTION_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_UNDO_ACTION_DATA))
#define FILES_UNDO_ACTION_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_UNDO_ACTION_DATA, FilesUndoActionDataClass))

typedef struct _FilesUndoActionData FilesUndoActionData;
typedef struct _FilesUndoActionDataClass FilesUndoActionDataClass;
typedef struct _FilesUndoActionDataPrivate FilesUndoActionDataPrivate;

#define FILES_TYPE_UNDO_MANAGER (files_undo_manager_get_type ())
#define FILES_UNDO_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_UNDO_MANAGER, FilesUndoManager))
#define FILES_UNDO_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_UNDO_MANAGER, FilesUndoManagerClass))
#define FILES_IS_UNDO_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_UNDO_MANAGER))
#define FILES_IS_UNDO_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_UNDO_MANAGER))
#define FILES_UNDO_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_UNDO_MANAGER, FilesUndoManagerClass))

typedef struct _FilesUndoManager FilesUndoManager;
typedef struct _FilesUndoManagerClass FilesUndoManagerClass;
typedef struct _FilesUndoManagerPrivate FilesUndoManagerPrivate;

#define MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB (marlin_file_operations_common_job_get_type ())
#define MARLIN_FILE_OPERATIONS_COMMON_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB, FilesFileOperationsCommonJob))
#define MARLIN_FILE_OPERATIONS_COMMON_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB, FilesFileOperationsCommonJobClass))
#define MARLIN_FILE_OPERATIONS_IS_COMMON_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB))
#define MARLIN_FILE_OPERATIONS_IS_COMMON_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB))
#define MARLIN_FILE_OPERATIONS_COMMON_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB, FilesFileOperationsCommonJobClass))

typedef struct _FilesFileOperationsCommonJob FilesFileOperationsCommonJob;
typedef struct _FilesFileOperationsCommonJobClass FilesFileOperationsCommonJobClass;
typedef struct _FilesFileOperationsCommonJobPrivate FilesFileOperationsCommonJobPrivate;
typedef struct _SourceInfo SourceInfo;
typedef struct _TransferInfo TransferInfo;

#define MARLIN_FILE_OPERATIONS_TYPE_COPY_MOVE_JOB (marlin_file_operations_copy_move_job_get_type ())
#define MARLIN_FILE_OPERATIONS_COPY_MOVE_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MARLIN_FILE_OPERATIONS_TYPE_COPY_MOVE_JOB, FilesFileOperationsCopyMoveJob))
#define MARLIN_FILE_OPERATIONS_COPY_MOVE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MARLIN_FILE_OPERATIONS_TYPE_COPY_MOVE_JOB, FilesFileOperationsCopyMoveJobClass))
#define MARLIN_FILE_OPERATIONS_IS_COPY_MOVE_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MARLIN_FILE_OPERATIONS_TYPE_COPY_MOVE_JOB))
#define MARLIN_FILE_OPERATIONS_IS_COPY_MOVE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MARLIN_FILE_OPERATIONS_TYPE_COPY_MOVE_JOB))
#define MARLIN_FILE_OPERATIONS_COPY_MOVE_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MARLIN_FILE_OPERATIONS_TYPE_COPY_MOVE_JOB, FilesFileOperationsCopyMoveJobClass))

typedef struct _FilesFileOperationsCopyMoveJob FilesFileOperationsCopyMoveJob;
typedef struct _FilesFileOperationsCopyMoveJobClass FilesFileOperationsCopyMoveJobClass;
typedef struct _FilesFileOperationsCopyMoveJobPrivate FilesFileOperationsCopyMoveJobPrivate;

#define MARLIN_FILE_OPERATIONS_TYPE_CREATE_JOB (marlin_file_operations_create_job_get_type ())
#define MARLIN_FILE_OPERATIONS_CREATE_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MARLIN_FILE_OPERATIONS_TYPE_CREATE_JOB, FilesFileOperationsCreateJob))
#define MARLIN_FILE_OPERATIONS_CREATE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MARLIN_FILE_OPERATIONS_TYPE_CREATE_JOB, FilesFileOperationsCreateJobClass))
#define MARLIN_FILE_OPERATIONS_IS_CREATE_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MARLIN_FILE_OPERATIONS_TYPE_CREATE_JOB))
#define MARLIN_FILE_OPERATIONS_IS_CREATE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MARLIN_FILE_OPERATIONS_TYPE_CREATE_JOB))
#define MARLIN_FILE_OPERATIONS_CREATE_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MARLIN_FILE_OPERATIONS_TYPE_CREATE_JOB, FilesFileOperationsCreateJobClass))

typedef struct _FilesFileOperationsCreateJob FilesFileOperationsCreateJob;
typedef struct _FilesFileOperationsCreateJobClass FilesFileOperationsCreateJobClass;
typedef struct _FilesFileOperationsCreateJobPrivate FilesFileOperationsCreateJobPrivate;

#define MARLIN_FILE_OPERATIONS_TYPE_DELETE_JOB (marlin_file_operations_delete_job_get_type ())
#define MARLIN_FILE_OPERATIONS_DELETE_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MARLIN_FILE_OPERATIONS_TYPE_DELETE_JOB, FilesFileOperationsDeleteJob))
#define MARLIN_FILE_OPERATIONS_DELETE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MARLIN_FILE_OPERATIONS_TYPE_DELETE_JOB, FilesFileOperationsDeleteJobClass))
#define MARLIN_FILE_OPERATIONS_IS_DELETE_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MARLIN_FILE_OPERATIONS_TYPE_DELETE_JOB))
#define MARLIN_FILE_OPERATIONS_IS_DELETE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MARLIN_FILE_OPERATIONS_TYPE_DELETE_JOB))
#define MARLIN_FILE_OPERATIONS_DELETE_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MARLIN_FILE_OPERATIONS_TYPE_DELETE_JOB, FilesFileOperationsDeleteJobClass))

typedef struct _FilesFileOperationsDeleteJob FilesFileOperationsDeleteJob;
typedef struct _FilesFileOperationsDeleteJobClass FilesFileOperationsDeleteJobClass;
typedef struct _FilesFileOperationsDeleteJobPrivate FilesFileOperationsDeleteJobPrivate;

#define MARLIN_FILE_OPERATIONS_TYPE_EMPTY_TRASH_JOB (marlin_file_operations_empty_trash_job_get_type ())
#define MARLIN_FILE_OPERATIONS_EMPTY_TRASH_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MARLIN_FILE_OPERATIONS_TYPE_EMPTY_TRASH_JOB, FilesFileOperationsEmptyTrashJob))
#define MARLIN_FILE_OPERATIONS_EMPTY_TRASH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MARLIN_FILE_OPERATIONS_TYPE_EMPTY_TRASH_JOB, FilesFileOperationsEmptyTrashJobClass))
#define MARLIN_FILE_OPERATIONS_IS_EMPTY_TRASH_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MARLIN_FILE_OPERATIONS_TYPE_EMPTY_TRASH_JOB))
#define MARLIN_FILE_OPERATIONS_IS_EMPTY_TRASH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MARLIN_FILE_OPERATIONS_TYPE_EMPTY_TRASH_JOB))
#define MARLIN_FILE_OPERATIONS_EMPTY_TRASH_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MARLIN_FILE_OPERATIONS_TYPE_EMPTY_TRASH_JOB, FilesFileOperationsEmptyTrashJobClass))

typedef struct _FilesFileOperationsEmptyTrashJob FilesFileOperationsEmptyTrashJob;
typedef struct _FilesFileOperationsEmptyTrashJobClass FilesFileOperationsEmptyTrashJobClass;
typedef struct _FilesFileOperationsEmptyTrashJobPrivate FilesFileOperationsEmptyTrashJobPrivate;

#define FILES_TYPE_SIDEBAR_INTERFACE (files_sidebar_interface_get_type ())
#define FILES_SIDEBAR_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_SIDEBAR_INTERFACE, FilesSidebarInterface))
#define FILES_IS_SIDEBAR_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_SIDEBAR_INTERFACE))
#define FILES_SIDEBAR_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FILES_TYPE_SIDEBAR_INTERFACE, FilesSidebarInterfaceIface))

typedef struct _FilesSidebarInterface FilesSidebarInterface;
typedef struct _FilesSidebarInterfaceIface FilesSidebarInterfaceIface;

#define FILES_VIEW_CHROME_TYPE_LOCATABLE (files_view_chrome_locatable_get_type ())
#define FILES_VIEW_CHROME_LOCATABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_CHROME_TYPE_LOCATABLE, FilesViewChromeLocatable))
#define FILES_VIEW_CHROME_IS_LOCATABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_CHROME_TYPE_LOCATABLE))
#define FILES_VIEW_CHROME_LOCATABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FILES_VIEW_CHROME_TYPE_LOCATABLE, FilesViewChromeLocatableIface))

typedef struct _FilesViewChromeLocatable FilesViewChromeLocatable;
typedef struct _FilesViewChromeLocatableIface FilesViewChromeLocatableIface;

#define FILES_VIEW_CHROME_TYPE_NAVIGATABLE (files_view_chrome_navigatable_get_type ())
#define FILES_VIEW_CHROME_NAVIGATABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_CHROME_TYPE_NAVIGATABLE, FilesViewChromeNavigatable))
#define FILES_VIEW_CHROME_IS_NAVIGATABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_CHROME_TYPE_NAVIGATABLE))
#define FILES_VIEW_CHROME_NAVIGATABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FILES_VIEW_CHROME_TYPE_NAVIGATABLE, FilesViewChromeNavigatableIface))

typedef struct _FilesViewChromeNavigatable FilesViewChromeNavigatable;
typedef struct _FilesViewChromeNavigatableIface FilesViewChromeNavigatableIface;

#define FILES_VIEW_CHROME_TYPE_SEARCHABLE (files_view_chrome_searchable_get_type ())
#define FILES_VIEW_CHROME_SEARCHABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_CHROME_TYPE_SEARCHABLE, FilesViewChromeSearchable))
#define FILES_VIEW_CHROME_IS_SEARCHABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_CHROME_TYPE_SEARCHABLE))
#define FILES_VIEW_CHROME_SEARCHABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FILES_VIEW_CHROME_TYPE_SEARCHABLE, FilesViewChromeSearchableIface))

typedef struct _FilesViewChromeSearchable FilesViewChromeSearchable;
typedef struct _FilesViewChromeSearchableIface FilesViewChromeSearchableIface;

#define SIDEBAR_TYPE_SIDEBAR_LIST_INTERFACE (sidebar_sidebar_list_interface_get_type ())
#define SIDEBAR_SIDEBAR_LIST_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_SIDEBAR_LIST_INTERFACE, SidebarSidebarListInterface))
#define SIDEBAR_IS_SIDEBAR_LIST_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_SIDEBAR_LIST_INTERFACE))
#define SIDEBAR_SIDEBAR_LIST_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SIDEBAR_TYPE_SIDEBAR_LIST_INTERFACE, SidebarSidebarListInterfaceIface))

typedef struct _SidebarSidebarListInterface SidebarSidebarListInterface;
typedef struct _SidebarSidebarListInterfaceIface SidebarSidebarListInterfaceIface;

#define SIDEBAR_TYPE_SIDEBAR_ITEM_INTERFACE (sidebar_sidebar_item_interface_get_type ())
#define SIDEBAR_SIDEBAR_ITEM_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_SIDEBAR_ITEM_INTERFACE, SidebarSidebarItemInterface))
#define SIDEBAR_IS_SIDEBAR_ITEM_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_SIDEBAR_ITEM_INTERFACE))
#define SIDEBAR_SIDEBAR_ITEM_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SIDEBAR_TYPE_SIDEBAR_ITEM_INTERFACE, SidebarSidebarItemInterfaceIface))

typedef struct _SidebarSidebarItemInterface SidebarSidebarItemInterface;
typedef struct _SidebarSidebarItemInterfaceIface SidebarSidebarItemInterfaceIface;

#define FILES_VIEW_CHROME_TYPE_BASIC_BREADCRUMBS_ENTRY (files_view_chrome_basic_breadcrumbs_entry_get_type ())
#define FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_CHROME_TYPE_BASIC_BREADCRUMBS_ENTRY, FilesViewChromeBasicBreadcrumbsEntry))
#define FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_CHROME_TYPE_BASIC_BREADCRUMBS_ENTRY, FilesViewChromeBasicBreadcrumbsEntryClass))
#define FILES_VIEW_CHROME_IS_BASIC_BREADCRUMBS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_CHROME_TYPE_BASIC_BREADCRUMBS_ENTRY))
#define FILES_VIEW_CHROME_IS_BASIC_BREADCRUMBS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_CHROME_TYPE_BASIC_BREADCRUMBS_ENTRY))
#define FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_CHROME_TYPE_BASIC_BREADCRUMBS_ENTRY, FilesViewChromeBasicBreadcrumbsEntryClass))

typedef struct _FilesViewChromeBasicBreadcrumbsEntry FilesViewChromeBasicBreadcrumbsEntry;
typedef struct _FilesViewChromeBasicBreadcrumbsEntryClass FilesViewChromeBasicBreadcrumbsEntryClass;
typedef struct _FilesViewChromeBasicBreadcrumbsEntryPrivate FilesViewChromeBasicBreadcrumbsEntryPrivate;

#define FILES_VIEW_CHROME_TYPE_BREADCRUMB_ELEMENT (files_view_chrome_breadcrumb_element_get_type ())
#define FILES_VIEW_CHROME_BREADCRUMB_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_CHROME_TYPE_BREADCRUMB_ELEMENT, FilesViewChromeBreadcrumbElement))
#define FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_CHROME_TYPE_BREADCRUMB_ELEMENT, FilesViewChromeBreadcrumbElementClass))
#define FILES_VIEW_CHROME_IS_BREADCRUMB_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_CHROME_TYPE_BREADCRUMB_ELEMENT))
#define FILES_VIEW_CHROME_IS_BREADCRUMB_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_CHROME_TYPE_BREADCRUMB_ELEMENT))
#define FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_CHROME_TYPE_BREADCRUMB_ELEMENT, FilesViewChromeBreadcrumbElementClass))

typedef struct _FilesViewChromeBreadcrumbElement FilesViewChromeBreadcrumbElement;
typedef struct _FilesViewChromeBreadcrumbElementClass FilesViewChromeBreadcrumbElementClass;
typedef enum  {
	FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_TARGET_TYPE_TEXT_URI_LIST
} FilesViewChromeBasicBreadcrumbsEntryTargetType;

#define FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_TYPE_TARGET_TYPE (files_view_chrome_basic_breadcrumbs_entry_target_type_get_type ())

#define FILES_VIEW_CHROME_TYPE_BASIC_LOCATION_BAR (files_view_chrome_basic_location_bar_get_type ())
#define FILES_VIEW_CHROME_BASIC_LOCATION_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_CHROME_TYPE_BASIC_LOCATION_BAR, FilesViewChromeBasicLocationBar))
#define FILES_VIEW_CHROME_BASIC_LOCATION_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_CHROME_TYPE_BASIC_LOCATION_BAR, FilesViewChromeBasicLocationBarClass))
#define FILES_VIEW_CHROME_IS_BASIC_LOCATION_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_CHROME_TYPE_BASIC_LOCATION_BAR))
#define FILES_VIEW_CHROME_IS_BASIC_LOCATION_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_CHROME_TYPE_BASIC_LOCATION_BAR))
#define FILES_VIEW_CHROME_BASIC_LOCATION_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_CHROME_TYPE_BASIC_LOCATION_BAR, FilesViewChromeBasicLocationBarClass))

typedef struct _FilesViewChromeBasicLocationBar FilesViewChromeBasicLocationBar;
typedef struct _FilesViewChromeBasicLocationBarClass FilesViewChromeBasicLocationBarClass;
typedef struct _FilesViewChromeBasicLocationBarPrivate FilesViewChromeBasicLocationBarPrivate;
typedef struct _FilesViewChromeBreadcrumbElementPrivate FilesViewChromeBreadcrumbElementPrivate;

#define FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_INFO (files_view_chrome_breadcrumb_icon_info_get_type ())
#define FILES_VIEW_CHROME_BREADCRUMB_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_INFO, FilesViewChromeBreadcrumbIconInfo))
#define FILES_VIEW_CHROME_BREADCRUMB_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_INFO, FilesViewChromeBreadcrumbIconInfoClass))
#define FILES_VIEW_CHROME_IS_BREADCRUMB_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_INFO))
#define FILES_VIEW_CHROME_IS_BREADCRUMB_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_INFO))
#define FILES_VIEW_CHROME_BREADCRUMB_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_INFO, FilesViewChromeBreadcrumbIconInfoClass))

typedef struct _FilesViewChromeBreadcrumbIconInfo FilesViewChromeBreadcrumbIconInfo;
typedef struct _FilesViewChromeBreadcrumbIconInfoClass FilesViewChromeBreadcrumbIconInfoClass;
typedef struct _FilesViewChromeBreadcrumbIconInfoPrivate FilesViewChromeBreadcrumbIconInfoPrivate;

#define FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_LIST (files_view_chrome_breadcrumb_icon_list_get_type ())
#define FILES_VIEW_CHROME_BREADCRUMB_ICON_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_LIST, FilesViewChromeBreadcrumbIconList))
#define FILES_VIEW_CHROME_BREADCRUMB_ICON_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_LIST, FilesViewChromeBreadcrumbIconListClass))
#define FILES_VIEW_CHROME_IS_BREADCRUMB_ICON_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_LIST))
#define FILES_VIEW_CHROME_IS_BREADCRUMB_ICON_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_LIST))
#define FILES_VIEW_CHROME_BREADCRUMB_ICON_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_LIST, FilesViewChromeBreadcrumbIconListClass))

typedef struct _FilesViewChromeBreadcrumbIconList FilesViewChromeBreadcrumbIconList;
typedef struct _FilesViewChromeBreadcrumbIconListClass FilesViewChromeBreadcrumbIconListClass;
typedef struct _FilesViewChromeBreadcrumbIconListPrivate FilesViewChromeBreadcrumbIconListPrivate;

#define FILES_VIEW_CHROME_TYPE_BUTTON_WITH_MENU (files_view_chrome_button_with_menu_get_type ())
#define FILES_VIEW_CHROME_BUTTON_WITH_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_CHROME_TYPE_BUTTON_WITH_MENU, FilesViewChromeButtonWithMenu))
#define FILES_VIEW_CHROME_BUTTON_WITH_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_CHROME_TYPE_BUTTON_WITH_MENU, FilesViewChromeButtonWithMenuClass))
#define FILES_VIEW_CHROME_IS_BUTTON_WITH_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_CHROME_TYPE_BUTTON_WITH_MENU))
#define FILES_VIEW_CHROME_IS_BUTTON_WITH_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_CHROME_TYPE_BUTTON_WITH_MENU))
#define FILES_VIEW_CHROME_BUTTON_WITH_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_CHROME_TYPE_BUTTON_WITH_MENU, FilesViewChromeButtonWithMenuClass))

typedef struct _FilesViewChromeButtonWithMenu FilesViewChromeButtonWithMenu;
typedef struct _FilesViewChromeButtonWithMenuClass FilesViewChromeButtonWithMenuClass;
typedef struct _FilesViewChromeButtonWithMenuPrivate FilesViewChromeButtonWithMenuPrivate;

#define FILES_VIEW_CHROME_TYPE_VIEW_SWITCHER (files_view_chrome_view_switcher_get_type ())
#define FILES_VIEW_CHROME_VIEW_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_CHROME_TYPE_VIEW_SWITCHER, FilesViewChromeViewSwitcher))
#define FILES_VIEW_CHROME_VIEW_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_CHROME_TYPE_VIEW_SWITCHER, FilesViewChromeViewSwitcherClass))
#define FILES_VIEW_CHROME_IS_VIEW_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_CHROME_TYPE_VIEW_SWITCHER))
#define FILES_VIEW_CHROME_IS_VIEW_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_CHROME_TYPE_VIEW_SWITCHER))
#define FILES_VIEW_CHROME_VIEW_SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_CHROME_TYPE_VIEW_SWITCHER, FilesViewChromeViewSwitcherClass))

typedef struct _FilesViewChromeViewSwitcher FilesViewChromeViewSwitcher;
typedef struct _FilesViewChromeViewSwitcherClass FilesViewChromeViewSwitcherClass;
typedef struct _FilesViewChromeViewSwitcherPrivate FilesViewChromeViewSwitcherPrivate;

struct _FilesAbstractSlot {
	GObject parent_instance;
	FilesAbstractSlotPrivate * priv;
	GtkBox* extra_location_widgets;
	GtkBox* extra_action_widgets;
	GtkBox* content_box;
	gint width;
};

struct _FilesAbstractSlotClass {
	GObjectClass parent_class;
	void (*initialize_directory) (FilesAbstractSlot* self);
	GList* (*get_selected_files) (FilesAbstractSlot* self);
	void (*set_active_state) (FilesAbstractSlot* self, gboolean set_active, gboolean animate);
	FilesAbstractSlot* (*get_current_slot) (FilesAbstractSlot* self);
	void (*reload) (FilesAbstractSlot* self, gboolean non_local_only);
	void (*grab_focus) (FilesAbstractSlot* self);
	void (*user_path_change_request) (FilesAbstractSlot* self, GFile* loc, gboolean make_root);
	void (*focus_first_for_empty_selection) (FilesAbstractSlot* self, gboolean select);
	void (*select_glib_files) (FilesAbstractSlot* self, GList* locations, GFile* focus_location);
	void (*close) (FilesAbstractSlot* self);
	GFileInfo* (*lookup_file_info) (FilesAbstractSlot* self, GFile* loc);
	void (*zoom_out) (FilesAbstractSlot* self);
	void (*zoom_in) (FilesAbstractSlot* self);
	void (*zoom_normal) (FilesAbstractSlot* self);
	gboolean (*set_all_selected) (FilesAbstractSlot* self, gboolean all_selected);
	GtkWidget* (*get_content_box) (FilesAbstractSlot* self);
	gchar* (*get_root_uri) (FilesAbstractSlot* self);
	gchar* (*get_tip_uri) (FilesAbstractSlot* self);
	gboolean (*get_realized) (FilesAbstractSlot* self);
	gboolean (*get_locked_focus) (FilesAbstractSlot* self);
	gboolean (*get_is_frozen) (FilesAbstractSlot* self);
	void (*set_is_frozen) (FilesAbstractSlot* self, gboolean value);
};

struct _FilesBookmark {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FilesBookmarkPrivate * priv;
};

struct _FilesBookmarkClass {
	GTypeClass parent_class;
	void (*finalize) (FilesBookmark *self);
};

struct _FilesBookmarkList {
	GObject parent_instance;
	FilesBookmarkListPrivate * priv;
};

struct _FilesBookmarkListClass {
	GObjectClass parent_class;
};

struct _FilesCallWhenReady {
	GObject parent_instance;
	FilesCallWhenReadyPrivate * priv;
	GList* files;
};

struct _FilesCallWhenReadyClass {
	GObjectClass parent_class;
};

struct _FilesConnectServerOperation {
	GtkMountOperation parent_instance;
	FilesConnectServerOperationPrivate * priv;
};

struct _FilesConnectServerOperationClass {
	GtkMountOperationClass parent_class;
};

struct _PFConnectServerDialog {
	GraniteDialog parent_instance;
	PFConnectServerDialogPrivate * priv;
};

struct _PFConnectServerDialogClass {
	GraniteDialogClass parent_class;
};

struct _FilesDirectory {
	GObject parent_instance;
	FilesDirectoryPrivate * priv;
	gint icon_size;
	gboolean permission_denied;
	gboolean network_available;
};

struct _FilesDirectoryClass {
	GObjectClass parent_class;
};

struct _FilesDndHandler {
	GObject parent_instance;
	FilesDndHandlerPrivate * priv;
};

struct _FilesDndHandlerClass {
	GObjectClass parent_class;
};

struct _FilesFile {
	GObject parent_instance;
	FilesFilePrivate * priv;
	gboolean is_gone;
	GFile* target_location;
	FilesFile* target_gof;
	GIcon* icon;
	GList* emblems_list;
	guint n_emblems;
	GFileInfo* info;
	gchar* custom_display_name;
	guint64 size;
	gint count;
	gchar* format_size;
	guint64 modified;
	guint64 created;
	gchar* formated_modified;
	gchar* formated_type;
	gchar* tagstype;
	GdkPixbuf* pix;
	gchar* custom_icon_name;
	gint pix_size;
	gint pix_scale;
	gint width;
	gint height;
	gint sort_column_id;
	GtkSortType sort_order;
	GFileType file_type;
	gboolean is_remote;
	gboolean is_directory;
	gboolean is_desktop;
	gboolean is_expanded;
	gboolean can_unmount;
	guint thumbstate;
	gboolean thumbnail_loaded;
	gboolean is_mounted;
	guint32 uid;
	guint32 gid;
	gchar* owner;
	gchar* group;
	gboolean has_permissions;
	guint32 permissions;
	GMount* mount;
	gboolean is_connected;
	gchar* utf8_collation_key;
	gboolean link_known_target;
};

struct _FilesFileClass {
	GObjectClass parent_class;
};

struct _FilesFileChangesChange {
	FilesFileChangesKind kind;
	GFile* from;
	GFile* to;
	gboolean is_internal;
};

struct _FilesFileConflictDialog {
	GraniteMessageDialog parent_instance;
	FilesFileConflictDialogPrivate * priv;
};

struct _FilesFileConflictDialogClass {
	GraniteMessageDialogClass parent_class;
};

struct _FilesIconInfo {
	GObject parent_instance;
	FilesIconInfoPrivate * priv;
};

struct _FilesIconInfoClass {
	GObjectClass parent_class;
};

struct _FilesListModel {
	GtkTreeStore parent_instance;
	FilesListModelPrivate * priv;
};

struct _FilesListModelClass {
	GtkTreeStoreClass parent_class;
};

struct _FilesPreferences {
	GObject parent_instance;
	FilesPreferencesPrivate * priv;
};

struct _FilesPreferencesClass {
	GObjectClass parent_class;
};

struct _FilesPluginManager {
	GObject parent_instance;
	FilesPluginManagerPrivate * priv;
	GList* menus G_GNUC_DEPRECATED ;
};

struct _FilesPluginManagerClass {
	GObjectClass parent_class;
};

struct _FilesPluginsBase {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FilesPluginsBasePrivate * priv;
	GtkWidget* window;
};

struct _FilesPluginsBaseClass {
	GTypeClass parent_class;
	void (*finalize) (FilesPluginsBase *self);
	void (*directory_loaded) (FilesPluginsBase* self, GtkApplicationWindow* window, FilesAbstractSlot* view, FilesFile* directory);
	void (*context_menu) (FilesPluginsBase* self, GtkWidget* widget, GList* files);
	void (*sidebar_loaded) (FilesPluginsBase* self, GtkWidget* widget);
	void (*update_sidebar) (FilesPluginsBase* self, GtkWidget* widget);
	void (*update_file_info) (FilesPluginsBase* self, FilesFile* file);
};

struct _PFProgressInfo {
	GObject parent_instance;
	PFProgressInfoPrivate * priv;
};

struct _PFProgressInfoClass {
	GObjectClass parent_class;
};

struct _PFProgressInfoManager {
	GObject parent_instance;
	PFProgressInfoManagerPrivate * priv;
};

struct _PFProgressInfoManagerClass {
	GObjectClass parent_class;
};

struct _FilesSidebarPluginItem {
	GObject parent_instance;
	FilesSidebarPluginItemPrivate * priv;
};

struct _FilesSidebarPluginItemClass {
	GObjectClass parent_class;
};

struct _PFSoundManager {
	GObject parent_instance;
	PFSoundManagerPrivate * priv;
};

struct _PFSoundManagerClass {
	GObjectClass parent_class;
};

struct _FilesThumbnailerDaemonIface {
	GTypeInterface parent_iface;
	void (*queue) (FilesThumbnailerDaemon* self, gchar** uris, gint uris_length1, gchar** mime_types, gint mime_types_length1, const gchar* flavor, const gchar* scheduler, guint handle_to_unqueue, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint (*queue_finish) (FilesThumbnailerDaemon* self, GAsyncResult* _res_, GError** error);
	void (*dequeue) (FilesThumbnailerDaemon* self, guint handle, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*dequeue_finish) (FilesThumbnailerDaemon* self, GAsyncResult* _res_, GError** error);
	void (*get_supported) (FilesThumbnailerDaemon* self, gchar*** uri_schemes, gint* uri_schemes_length1, gchar*** mime_types, gint* mime_types_length1, GError** error);
};

struct _FilesThumbnailer {
	GObject parent_instance;
	FilesThumbnailerPrivate * priv;
};

struct _FilesThumbnailerClass {
	GObjectClass parent_class;
};

struct _FilesTrashMonitor {
	GObject parent_instance;
	FilesTrashMonitorPrivate * priv;
};

struct _FilesTrashMonitorClass {
	GObjectClass parent_class;
};

struct _FilesUndoActionData {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FilesUndoActionDataPrivate * priv;
	FilesUndoActionType action_type;
	gboolean is_valid;
	gboolean locked;
	gboolean freed;
	guint count;
	GFile* src_dir;
	GFile* dest_dir;
	GList* sources;
	GList* destinations;
	gchar* undo_label;
	gchar* undo_description;
	gchar* redo_label;
	gchar* redo_description;
	gchar* template;
	gchar* target_uri;
	gchar* old_uri;
	gchar* new_uri;
	GHashTable* trashed;
	GHashTable* original_permissions;
	guint32 dir_mask;
	guint32 dir_permissions;
	guint32 file_mask;
	guint32 file_permissions;
	guint32 current_permissions;
	guint32 new_permissions;
	gchar* original_group_name_or_id;
	gchar* new_group_name_or_id;
	gchar* original_user_name_or_id;
	gchar* new_user_name_or_id;
};

struct _FilesUndoActionDataClass {
	GTypeClass parent_class;
	void (*finalize) (FilesUndoActionData *self);
};

struct _FilesUndoManager {
	GObject parent_instance;
	FilesUndoManagerPrivate * priv;
};

struct _FilesUndoManagerClass {
	GObjectClass parent_class;
};

struct _FilesFileOperationsCommonJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FilesFileOperationsCommonJobPrivate * priv;
	GtkWindow* parent_window;
	guint inhibit_cookie;
	GCancellable* cancellable;
	PFProgressInfo* progress;
	FilesUndoActionData* undo_redo_data;
	GTimer* time;
	gboolean skip_all_error;
	GHashTable* skip_files;
};

struct _FilesFileOperationsCommonJobClass {
	GTypeClass parent_class;
	void (*finalize) (FilesFileOperationsCommonJob *self);
	const gchar* (*get_scan_primary) (FilesFileOperationsCommonJob* self);
	void (*report_count_progress) (FilesFileOperationsCommonJob* self, SourceInfo* source_info);
};

struct _SourceInfo {
	gint num_files;
	gint64 num_bytes;
	gint num_files_since_progress;
};

struct _TransferInfo {
	gint num_files;
	gint64 num_bytes;
	guint64 last_report_time;
	gint last_reported_files_left;
};

struct _FilesFileOperationsCopyMoveJob {
	FilesFileOperationsCommonJob parent_instance;
	FilesFileOperationsCopyMoveJobPrivate * priv;
	gboolean is_move;
	GList* files;
	GFile* destination;
	GHashTable* debuting_files;
	gboolean replace_all;
	gboolean merge_all;
	gboolean keep_all_newest;
	gboolean skip_all_conflict;
};

struct _FilesFileOperationsCopyMoveJobClass {
	FilesFileOperationsCommonJobClass parent_class;
};

struct _FilesFileOperationsCreateJob {
	FilesFileOperationsCommonJob parent_instance;
	FilesFileOperationsCreateJobPrivate * priv;
	GFile* dest_dir;
	gchar* filename;
	gboolean make_dir;
	GFile* src;
	guint8* src_data;
	gint length;
	GFile* created_file;
};

struct _FilesFileOperationsCreateJobClass {
	FilesFileOperationsCommonJobClass parent_class;
};

struct _FilesFileOperationsDeleteJob {
	FilesFileOperationsCommonJob parent_instance;
	FilesFileOperationsDeleteJobPrivate * priv;
	GList* files;
	gboolean try_trash;
	gboolean user_cancel;
	gboolean delete_all;
};

struct _FilesFileOperationsDeleteJobClass {
	FilesFileOperationsCommonJobClass parent_class;
};

struct _FilesFileOperationsEmptyTrashJob {
	FilesFileOperationsCommonJob parent_instance;
	FilesFileOperationsEmptyTrashJobPrivate * priv;
};

struct _FilesFileOperationsEmptyTrashJobClass {
	FilesFileOperationsCommonJobClass parent_class;
};

struct _FilesSidebarInterfaceIface {
	GTypeInterface parent_iface;
	guint32 (*add_plugin_item) (FilesSidebarInterface* self, FilesSidebarPluginItem* item, FilesPlaceType category);
	gboolean (*update_plugin_item) (FilesSidebarInterface* self, FilesSidebarPluginItem* item, guint32 item_id);
	void (*add_favorite_uri) (FilesSidebarInterface* self, const gchar* uri, const gchar* custom_name);
	gboolean (*has_favorite_uri) (FilesSidebarInterface* self, const gchar* uri);
	void (*sync_uri) (FilesSidebarInterface* self, const gchar* uri);
	void (*reload) (FilesSidebarInterface* self);
	void (*on_free_space_change) (FilesSidebarInterface* self);
	void (*focus) (FilesSidebarInterface* self);
};

struct _FilesViewChromeLocatableIface {
	GTypeInterface parent_iface;
	void (*set_display_path) (FilesViewChromeLocatable* self, const gchar* path);
	gchar* (*get_display_path) (FilesViewChromeLocatable* self);
	gboolean (*set_focussed) (FilesViewChromeLocatable* self);
};

struct _FilesViewChromeNavigatableIface {
	GTypeInterface parent_iface;
	void (*set_breadcrumbs_path) (FilesViewChromeNavigatable* self, const gchar* newpath);
	gchar* (*get_breadcrumbs_path) (FilesViewChromeNavigatable* self, gboolean include_file_protocol);
	void (*set_action_icon_tooltip) (FilesViewChromeNavigatable* self, const gchar* tip);
	void (*hide_action_icon) (FilesViewChromeNavigatable* self);
	void (*set_entry_text) (FilesViewChromeNavigatable* self, const gchar* txt);
	void (*reset) (FilesViewChromeNavigatable* self);
	void (*set_animation_visible) (FilesViewChromeNavigatable* self, gboolean visible);
	void (*set_placeholder) (FilesViewChromeNavigatable* self, const gchar* placeholder);
	void (*show_default_action_icon) (FilesViewChromeNavigatable* self);
	void (*set_default_action_icon_tooltip) (FilesViewChromeNavigatable* self);
	gchar* (*get_entry_text) (FilesViewChromeNavigatable* self);
	gint (*get_minimum_width) (FilesViewChromeNavigatable* self);
	void (*set_default_entry_tooltip) (FilesViewChromeNavigatable* self);
	const gchar* (*get_action_icon_name) (FilesViewChromeNavigatable* self);
	void (*set_action_icon_name) (FilesViewChromeNavigatable* self, const gchar* value);
	gboolean (*get_hide_breadcrumbs) (FilesViewChromeNavigatable* self);
	void (*set_hide_breadcrumbs) (FilesViewChromeNavigatable* self, gboolean value);
};

struct _FilesViewChromeSearchableIface {
	GTypeInterface parent_iface;
	void (*cancel) (FilesViewChromeSearchable* self);
	void (*search) (FilesViewChromeSearchable* self, const gchar* txt, GFile* search_location);
};

struct _SidebarSidebarItemInterfaceIface {
	GTypeInterface parent_iface;
	gint (*get_index) (SidebarSidebarItemInterface* self);
	void (*destroy_bookmark) (SidebarSidebarItemInterface* self);
	void (*update_icon) (SidebarSidebarItemInterface* self, GIcon* icon);
	void (*add_extra_menu_items) (SidebarSidebarItemInterface* self, GMenu* menu);
	void (*update_plugin_data) (SidebarSidebarItemInterface* self, FilesSidebarPluginItem* item);
	void (*activated) (SidebarSidebarItemInterface* self, FilesOpenFlag flag);
	SidebarSidebarListInterface* (*get_list) (SidebarSidebarItemInterface* self);
	void (*set_list) (SidebarSidebarItemInterface* self, SidebarSidebarListInterface* value);
	guint32 (*get_id) (SidebarSidebarItemInterface* self);
	void (*set_id) (SidebarSidebarItemInterface* self, guint32 value);
	const gchar* (*get_uri) (SidebarSidebarItemInterface* self);
	void (*set_uri) (SidebarSidebarItemInterface* self, const gchar* value);
	const gchar* (*get_custom_name) (SidebarSidebarItemInterface* self);
	void (*set_custom_name) (SidebarSidebarItemInterface* self, const gchar* value);
	GIcon* (*get_gicon) (SidebarSidebarItemInterface* self);
	void (*set_gicon) (SidebarSidebarItemInterface* self, GIcon* value);
	gboolean (*get_pinned) (SidebarSidebarItemInterface* self);
	void (*set_pinned) (SidebarSidebarItemInterface* self, gboolean value);
	gboolean (*get_permanent) (SidebarSidebarItemInterface* self);
	void (*set_permanent) (SidebarSidebarItemInterface* self, gboolean value);
	gboolean (*get_can_insert_before) (SidebarSidebarItemInterface* self);
	void (*set_can_insert_before) (SidebarSidebarItemInterface* self, gboolean value);
	gboolean (*get_can_insert_after) (SidebarSidebarItemInterface* self);
	void (*set_can_insert_after) (SidebarSidebarItemInterface* self, gboolean value);
	GMenuModel* (*get_menu_model) (SidebarSidebarItemInterface* self);
	void (*set_menu_model) (SidebarSidebarItemInterface* self, GMenuModel* value);
	GActionGroup* (*get_action_group) (SidebarSidebarItemInterface* self);
	void (*set_action_group) (SidebarSidebarItemInterface* self, GActionGroup* value);
	const gchar* (*get_action_group_namespace) (SidebarSidebarItemInterface* self);
	void (*set_action_group_namespace) (SidebarSidebarItemInterface* self, const gchar* value);
};

struct _SidebarSidebarListInterfaceIface {
	GTypeInterface parent_iface;
	void (*select_item) (SidebarSidebarListInterface* self, GtkListBoxRow* item);
	void (*unselect_all_items) (SidebarSidebarListInterface* self);
	void (*refresh) (SidebarSidebarListInterface* self);
	void (*refresh_info) (SidebarSidebarListInterface* self);
	void (*rename_bookmark_by_uri) (SidebarSidebarListInterface* self, const gchar* uri, const gchar* new_name);
	void (*open_item) (SidebarSidebarListInterface* self, SidebarSidebarItemInterface* item, FilesOpenFlag flag);
	guint32 (*add_plugin_item) (SidebarSidebarListInterface* self, FilesSidebarPluginItem* plugin_item);
	void (*clear) (SidebarSidebarListInterface* self);
	gboolean (*has_uri) (SidebarSidebarListInterface* self, const gchar* uri, GtkListBoxRow** row);
	gboolean (*select_uri) (SidebarSidebarListInterface* self, const gchar* uri);
	gboolean (*remove_item_by_id) (SidebarSidebarListInterface* self, guint32 id);
	gboolean (*add_favorite) (SidebarSidebarListInterface* self, const gchar* uri, const gchar* label, gint index);
	SidebarSidebarItemInterface* (*get_item_at_index) (SidebarSidebarListInterface* self, gint index);
	gboolean (*move_item_after) (SidebarSidebarListInterface* self, SidebarSidebarItemInterface* item, gint target_index);
	gboolean (*is_drop_target) (SidebarSidebarListInterface* self);
	FilesSidebarInterface* (*get_sidebar) (SidebarSidebarListInterface* self);
	void (*set_sidebar) (SidebarSidebarListInterface* self, FilesSidebarInterface* value);
	GtkListBox* (*get_list_box) (SidebarSidebarListInterface* self);
	void (*set_list_box) (SidebarSidebarListInterface* self, GtkListBox* value);
};

struct _FilesViewChromeBasicBreadcrumbsEntry {
	GtkEntry parent_instance;
	FilesViewChromeBasicBreadcrumbsEntryPrivate * priv;
	gchar* placeholder;
	FilesViewChromeBreadcrumbElement* clicked_element;
	gchar* current_dir_path;
	GeeArrayList* elements;
	gboolean animation_visible;
	GeeCollection* old_elements;
	GtkStyleContext* button_context;
	GtkStyleContext* button_context_active;
	GtkGestureMultiPress* button_controller;
	gboolean context_menu_showing;
};

struct _FilesViewChromeBasicBreadcrumbsEntryClass {
	GtkEntryClass parent_class;
	void (*reset) (FilesViewChromeBasicBreadcrumbsEntry* self);
	gboolean (*on_key_press_event) (FilesViewChromeBasicBreadcrumbsEntry* self, guint keyval, guint keycode, GdkModifierType state);
	void (*on_button_pressed_event) (FilesViewChromeBasicBreadcrumbsEntry* self, gint n_press, gdouble x, gdouble y);
	void (*on_button_released_event) (FilesViewChromeBasicBreadcrumbsEntry* self, gint n_press, gdouble x, gdouble y);
	gboolean (*on_focus_out) (FilesViewChromeBasicBreadcrumbsEntry* self, GdkEventFocus* event);
	gboolean (*on_focus_in) (FilesViewChromeBasicBreadcrumbsEntry* self, GdkEventFocus* event);
	void (*on_activate) (FilesViewChromeBasicBreadcrumbsEntry* self);
	void (*on_entry_text_changed) (FilesViewChromeBasicBreadcrumbsEntry* self);
	void (*go_up) (FilesViewChromeBasicBreadcrumbsEntry* self);
	void (*set_default_entry_tooltip) (FilesViewChromeBasicBreadcrumbsEntry* self);
};

struct _FilesViewChromeBasicLocationBar {
	GtkBox parent_instance;
	FilesViewChromeBasicLocationBarPrivate * priv;
	GtkWidget* widget;
};

struct _FilesViewChromeBasicLocationBarClass {
	GtkBoxClass parent_class;
	void (*connect_signals) (FilesViewChromeBasicLocationBar* self);
	void (*after_bread_text_changed) (FilesViewChromeBasicLocationBar* self, const gchar* txt);
	gboolean (*after_bread_focus_in_event) (FilesViewChromeBasicLocationBar* self, GdkEventFocus* event);
	gboolean (*after_bread_focus_out_event) (FilesViewChromeBasicLocationBar* self, GdkEventFocus* event);
	void (*on_bread_action_icon_press) (FilesViewChromeBasicLocationBar* self);
	void (*on_bread_activate_path) (FilesViewChromeBasicLocationBar* self, const gchar* path, FilesOpenFlag flag);
	void (*show_navigate_icon) (FilesViewChromeBasicLocationBar* self);
	void (*hide_navigate_icon) (FilesViewChromeBasicLocationBar* self);
	void (*set_display_path) (FilesViewChromeBasicLocationBar* self, const gchar* path);
};

struct _FilesViewChromeBreadcrumbElement {
	GObject parent_instance;
	FilesViewChromeBreadcrumbElementPrivate * priv;
	gdouble offset;
	gdouble x;
	gdouble display_width;
	gboolean hidden;
	gboolean display;
	gboolean can_shrink;
	gboolean pressed;
	gboolean text_is_displayed;
};

struct _FilesViewChromeBreadcrumbElementClass {
	GObjectClass parent_class;
};

struct _FilesViewChromeBreadcrumbIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FilesViewChromeBreadcrumbIconInfoPrivate * priv;
	gchar* path;
	gboolean protocol;
	GIcon* gicon;
	gchar** exploded;
	gint exploded_length1;
	gboolean break_loop;
	gchar* text_displayed;
	gint icon_width;
	gint icon_height;
};

struct _FilesViewChromeBreadcrumbIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (FilesViewChromeBreadcrumbIconInfo *self);
};

struct _FilesViewChromeBreadcrumbIconList {
	GObject parent_instance;
	FilesViewChromeBreadcrumbIconListPrivate * priv;
};

struct _FilesViewChromeBreadcrumbIconListClass {
	GObjectClass parent_class;
};

struct _FilesViewChromeButtonWithMenu {
	GtkToggleButton parent_instance;
	FilesViewChromeButtonWithMenuPrivate * priv;
};

struct _FilesViewChromeButtonWithMenuClass {
	GtkToggleButtonClass parent_class;
};

struct _FilesViewChromeViewSwitcher {
	GtkBox parent_instance;
	FilesViewChromeViewSwitcherPrivate * priv;
};

struct _FilesViewChromeViewSwitcherClass {
	GtkBoxClass parent_class;
};

VALA_EXTERN GType files_abstract_slot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesAbstractSlot, g_object_unref)
VALA_EXTERN GType files_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesFile, g_object_unref)
VALA_EXTERN void files_abstract_slot_add_extra_widget (FilesAbstractSlot* self,
                                           GtkWidget* widget);
VALA_EXTERN void files_abstract_slot_add_extra_action_widget (FilesAbstractSlot* self,
                                                  GtkWidget* widget);
VALA_EXTERN void files_abstract_slot_add_overlay (FilesAbstractSlot* self,
                                      GtkWidget* widget);
VALA_EXTERN void files_abstract_slot_initialize_directory (FilesAbstractSlot* self);
VALA_EXTERN GList* files_abstract_slot_get_selected_files (FilesAbstractSlot* self);
VALA_EXTERN void files_abstract_slot_set_active_state (FilesAbstractSlot* self,
                                           gboolean set_active,
                                           gboolean animate);
VALA_EXTERN FilesAbstractSlot* files_abstract_slot_get_current_slot (FilesAbstractSlot* self);
VALA_EXTERN void files_abstract_slot_reload (FilesAbstractSlot* self,
                                 gboolean non_local_only);
VALA_EXTERN void files_abstract_slot_grab_focus (FilesAbstractSlot* self);
VALA_EXTERN void files_abstract_slot_user_path_change_request (FilesAbstractSlot* self,
                                                   GFile* loc,
                                                   gboolean make_root);
VALA_EXTERN void files_abstract_slot_focus_first_for_empty_selection (FilesAbstractSlot* self,
                                                          gboolean select);
VALA_EXTERN void files_abstract_slot_select_glib_files (FilesAbstractSlot* self,
                                            GList* locations,
                                            GFile* focus_location);
VALA_EXTERN void files_abstract_slot_close (FilesAbstractSlot* self);
VALA_EXTERN GFileInfo* files_abstract_slot_lookup_file_info (FilesAbstractSlot* self,
                                                 GFile* loc);
VALA_EXTERN void files_abstract_slot_zoom_out (FilesAbstractSlot* self);
VALA_EXTERN void files_abstract_slot_zoom_in (FilesAbstractSlot* self);
VALA_EXTERN void files_abstract_slot_zoom_normal (FilesAbstractSlot* self);
VALA_EXTERN gboolean files_abstract_slot_set_all_selected (FilesAbstractSlot* self,
                                               gboolean all_selected);
VALA_EXTERN GtkWidget* files_abstract_slot_get_content_box (FilesAbstractSlot* self);
VALA_EXTERN gchar* files_abstract_slot_get_root_uri (FilesAbstractSlot* self);
VALA_EXTERN gchar* files_abstract_slot_get_tip_uri (FilesAbstractSlot* self);
VALA_EXTERN gboolean files_abstract_slot_get_realized (FilesAbstractSlot* self);
VALA_EXTERN FilesAbstractSlot* files_abstract_slot_construct (GType object_type);
VALA_EXTERN GType files_directory_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesDirectory, g_object_unref)
VALA_EXTERN FilesDirectory* files_abstract_slot_get_directory (FilesAbstractSlot* self);
VALA_EXTERN void files_abstract_slot_set_directory (FilesAbstractSlot* self,
                                        FilesDirectory* value);
VALA_EXTERN FilesFile* files_abstract_slot_get_file (FilesAbstractSlot* self);
VALA_EXTERN GFile* files_abstract_slot_get_location (FilesAbstractSlot* self);
VALA_EXTERN void files_abstract_slot_set_location (FilesAbstractSlot* self,
                                       GFile* value);
VALA_EXTERN const gchar* files_abstract_slot_get_uri (FilesAbstractSlot* self);
VALA_EXTERN gboolean files_abstract_slot_get_locked_focus (FilesAbstractSlot* self);
VALA_EXTERN gboolean files_abstract_slot_get_is_frozen (FilesAbstractSlot* self);
VALA_EXTERN void files_abstract_slot_set_is_frozen (FilesAbstractSlot* self,
                                        gboolean value);
VALA_EXTERN GtkOverlay* files_abstract_slot_get_overlay (FilesAbstractSlot* self);
VALA_EXTERN void files_abstract_slot_set_overlay (FilesAbstractSlot* self,
                                      GtkOverlay* value);
VALA_EXTERN gint files_abstract_slot_get_slot_number (FilesAbstractSlot* self);
VALA_EXTERN void files_abstract_slot_set_slot_number (FilesAbstractSlot* self,
                                          gint value);
VALA_EXTERN gpointer files_bookmark_ref (gpointer instance);
VALA_EXTERN void files_bookmark_unref (gpointer instance);
VALA_EXTERN GParamSpec* files_param_spec_bookmark (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void files_value_set_bookmark (GValue* value,
                               gpointer v_object);
VALA_EXTERN void files_value_take_bookmark (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer files_value_get_bookmark (const GValue* value);
VALA_EXTERN GType files_bookmark_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesBookmark, files_bookmark_unref)
VALA_EXTERN GCompareFunc files_bookmark_compare_with;
VALA_EXTERN FilesBookmark* files_bookmark_new (FilesFile* gof_file,
                                   const gchar* label);
VALA_EXTERN FilesBookmark* files_bookmark_construct (GType object_type,
                                         FilesFile* gof_file,
                                         const gchar* label);
VALA_EXTERN FilesBookmark* files_bookmark_new_from_uri (const gchar* uri,
                                            const gchar* label);
VALA_EXTERN FilesBookmark* files_bookmark_construct_from_uri (GType object_type,
                                                  const gchar* uri,
                                                  const gchar* label);
VALA_EXTERN FilesBookmark* files_bookmark_copy (FilesBookmark* self);
VALA_EXTERN GFile* files_bookmark_get_location (FilesBookmark* self);
VALA_EXTERN gchar* files_bookmark_get_parse_name (FilesBookmark* self);
VALA_EXTERN GIcon* files_bookmark_get_icon (FilesBookmark* self);
VALA_EXTERN gboolean files_bookmark_uri_known_not_to_exist (FilesBookmark* self);
VALA_EXTERN const gchar* files_bookmark_get_custom_name (FilesBookmark* self);
VALA_EXTERN void files_bookmark_set_custom_name (FilesBookmark* self,
                                     const gchar* value);
VALA_EXTERN FilesFile* files_bookmark_get_gof_file (FilesBookmark* self);
VALA_EXTERN const gchar* files_bookmark_get_basename (FilesBookmark* self);
VALA_EXTERN const gchar* files_bookmark_get_uri (FilesBookmark* self);
VALA_EXTERN GType files_bookmark_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesBookmarkList, g_object_unref)
VALA_EXTERN FilesBookmarkList* files_bookmark_list_get_instance (void);
VALA_EXTERN FilesBookmark* files_bookmark_list_insert_uri (FilesBookmarkList* self,
                                               const gchar* uri,
                                               guint index,
                                               const gchar* custom_name);
VALA_EXTERN FilesBookmark* files_bookmark_list_insert_uri_at_end (FilesBookmarkList* self,
                                                      const gchar* uri,
                                                      const gchar* custom_name);
VALA_EXTERN void files_bookmark_list_insert_uris (FilesBookmarkList* self,
                                      GList* uris,
                                      guint index);
VALA_EXTERN gboolean files_bookmark_list_contains (FilesBookmarkList* self,
                                       FilesBookmark* bm);
VALA_EXTERN void files_bookmark_list_delete_item_at (FilesBookmarkList* self,
                                         guint index);
VALA_EXTERN void files_bookmark_list_rename_item_with_uri (FilesBookmarkList* self,
                                               const gchar* uri,
                                               const gchar* new_name);
VALA_EXTERN void files_bookmark_list_delete_items_with_uri (FilesBookmarkList* self,
                                                const gchar* uri);
VALA_EXTERN guint files_bookmark_list_length (FilesBookmarkList* self);
VALA_EXTERN FilesBookmark* files_bookmark_list_item_at (FilesBookmarkList* self,
                                            guint index);
VALA_EXTERN void files_bookmark_list_move_item_uri (FilesBookmarkList* self,
                                        const gchar* uri,
                                        gint step);
VALA_EXTERN GList* files_bookmark_list_get_list (FilesBookmarkList* self);
VALA_EXTERN GType files_call_when_ready_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesCallWhenReady, g_object_unref)
VALA_EXTERN FilesCallWhenReady* files_call_when_ready_new (GList* _files,
                                               FilesCallWhenReadycall_when_ready_func _f,
                                               gpointer _f_target);
VALA_EXTERN FilesCallWhenReady* files_call_when_ready_construct (GType object_type,
                                                     GList* _files,
                                                     FilesCallWhenReadycall_when_ready_func _f,
                                                     gpointer _f_target);
VALA_EXTERN GType files_connect_server_operation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesConnectServerOperation, g_object_unref)
VALA_EXTERN GType pf_connect_server_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PFConnectServerDialog, g_object_unref)
VALA_EXTERN FilesConnectServerOperation* files_connect_server_operation_new (PFConnectServerDialog* dialog);
VALA_EXTERN FilesConnectServerOperation* files_connect_server_operation_construct (GType object_type,
                                                                       PFConnectServerDialog* dialog);
VALA_EXTERN PFConnectServerDialog* pf_connect_server_dialog_new (GtkWindow* window);
VALA_EXTERN PFConnectServerDialog* pf_connect_server_dialog_construct (GType object_type,
                                                           GtkWindow* window);
VALA_EXTERN void pf_connect_server_dialog_fill_details_async (PFConnectServerDialog* self,
                                                  GMountOperation* mount_operation,
                                                  const gchar* default_user,
                                                  const gchar* default_domain,
                                                  GAskPasswordFlags askpassword_flags,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
VALA_EXTERN gboolean pf_connect_server_dialog_fill_details_finish (PFConnectServerDialog* self,
                                                       GAsyncResult* _res_);
VALA_EXTERN const gchar* pf_connect_server_dialog_get_server_uri (PFConnectServerDialog* self);
VALA_EXTERN GType files_directory_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FilesDirectory* files_directory_from_gfile (GFile* file);
VALA_EXTERN FilesDirectory* files_directory_from_file (FilesFile* gof);
VALA_EXTERN void files_directory_init (FilesDirectory* self,
                           FilesDirectoryFileLoadedFunc file_loaded_func,
                           gpointer file_loaded_func_target,
                           FilesDirectoryDoneLoadingFunc done_loading_func,
                           gpointer done_loading_func_target);
VALA_EXTERN void files_directory_check_network (FilesDirectory* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN gboolean files_directory_check_network_finish (FilesDirectory* self,
                                               GAsyncResult* _res_);
VALA_EXTERN void files_directory_cancel (FilesDirectory* self);
VALA_EXTERN void files_directory_reload (FilesDirectory* self);
VALA_EXTERN void files_directory_block_monitor (FilesDirectory* self);
VALA_EXTERN void files_directory_unblock_monitor (FilesDirectory* self);
VALA_EXTERN GList* files_directory_get_files (FilesDirectory* self);
VALA_EXTERN void files_directory_load_hiddens (FilesDirectory* self);
VALA_EXTERN void files_directory_update_files (FilesDirectory* self);
VALA_EXTERN void files_directory_update_desktop_files (FilesDirectory* self);
VALA_EXTERN FilesFile* files_directory_file_hash_lookup_location (FilesDirectory* self,
                                                      GFile* location);
VALA_EXTERN void files_directory_file_hash_add_file (FilesDirectory* self,
                                         FilesFile* gof);
VALA_EXTERN void files_directory_notify_files_changed (GList* files);
VALA_EXTERN void files_file_changes_change_free (FilesFileChangesChange * self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesFileChangesChange, files_file_changes_change_free)
VALA_EXTERN void files_directory_notify_changes_added (GList* changes);
VALA_EXTERN void files_directory_notify_files_added_internally (GList* files);
VALA_EXTERN void files_directory_notify_files_removed (GList* files);
VALA_EXTERN void files_directory_notify_files_moved (GList* files);
VALA_EXTERN FilesDirectory* files_directory_cache_lookup (GFile* file);
VALA_EXTERN FilesDirectory* files_directory_cache_lookup_parent (GFile* file);
VALA_EXTERN gboolean files_directory_remove_dir_from_cache (FilesDirectory* dir);
VALA_EXTERN gboolean files_directory_purge_dir_from_cache (FilesDirectory* dir);
VALA_EXTERN void files_directory_empty_dir_cache (void);
VALA_EXTERN gboolean files_directory_has_parent (FilesDirectory* self);
VALA_EXTERN GFile* files_directory_get_parent (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_is_loading (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_is_loaded (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_has_timed_out (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_is_empty (FilesDirectory* self);
VALA_EXTERN GList* files_directory_get_sorted_dirs (FilesDirectory* self);
VALA_EXTERN GFile* files_directory_get_creation_key (FilesDirectory* self);
VALA_EXTERN GFile* files_directory_get_location (FilesDirectory* self);
VALA_EXTERN GFile* files_directory_get_selected_file (FilesDirectory* self);
VALA_EXTERN FilesFile* files_directory_get_file (FilesDirectory* self);
VALA_EXTERN FilesDirectoryState files_directory_get_state (FilesDirectory* self);
VALA_EXTERN guint files_directory_get_displayed_files_count (FilesDirectory* self);
VALA_EXTERN const gchar* files_directory_get_scheme (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_is_local (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_is_trash (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_is_network (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_is_recent (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_is_admin (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_is_no_info (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_has_mounts (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_has_trash_dirs (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_can_load (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_can_open_files (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_can_stream_files (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_allow_user_interaction (FilesDirectory* self);
VALA_EXTERN void files_directory_set_allow_user_interaction (FilesDirectory* self,
                                                 gboolean value);
VALA_EXTERN gboolean files_directory_get_is_cancelled (FilesDirectory* self);
VALA_EXTERN const gchar* files_directory_get_last_error_message (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_loaded_from_cache (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_freeze_update (FilesDirectory* self);
VALA_EXTERN void files_directory_set_freeze_update (FilesDirectory* self,
                                        gboolean value);
VALA_EXTERN GType files_dnd_handler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesDndHandler, g_object_unref)
VALA_EXTERN FilesDndHandler* files_dnd_handler_new (void);
VALA_EXTERN FilesDndHandler* files_dnd_handler_construct (GType object_type);
VALA_EXTERN gboolean files_dnd_handler_dnd_perform (FilesDndHandler* self,
                                        GtkWidget* widget,
                                        FilesFile* drop_target,
                                        GList* drop_file_list,
                                        GdkDragAction action);
VALA_EXTERN GdkDragAction* files_dnd_handler_drag_drop_action_ask (FilesDndHandler* self,
                                                       GtkWidget* dest_widget,
                                                       GtkApplicationWindow* win,
                                                       GdkDragAction possible_actions);
VALA_EXTERN void files_dnd_handler_on_choice (FilesDndHandler* self,
                                  GVariant* param);
VALA_EXTERN gchar* files_dnd_handler_get_source_filename (FilesDndHandler* self,
                                              GdkWindow* source_window);
VALA_EXTERN void files_dnd_handler_set_source_uri (FilesDndHandler* self,
                                       GdkWindow* source_window,
                                       const gchar* uri);
VALA_EXTERN gboolean files_dnd_handler_handle_xdnddirectsave (FilesDndHandler* self,
                                                  GdkWindow* source_window,
                                                  FilesFile* drop_target,
                                                  GtkSelectionData* selection);
VALA_EXTERN gboolean files_dnd_handler_handle_netscape_url (FilesDndHandler* self,
                                                GdkWindow* source_window,
                                                FilesFile* drop_target,
                                                GtkSelectionData* selection);
VALA_EXTERN gboolean files_dnd_handler_handle_file_drag_actions (FilesDndHandler* self,
                                                     GtkWidget* dest_widget,
                                                     FilesFile* drop_target,
                                                     GList* drop_file_list,
                                                     GdkDragAction possible_actions,
                                                     GdkDragAction suggested_action,
                                                     GtkApplicationWindow* win,
                                                     guint32 timestamp);
VALA_EXTERN gboolean files_dnd_handler_selection_data_is_uri_list (GtkSelectionData* selection_data,
                                                       guint info,
                                                       gchar** text);
VALA_EXTERN gchar* files_dnd_handler_data_to_string (guchar* cdata,
                                         gint cdata_length1);
VALA_EXTERN void files_dnd_handler_set_selection_data_from_file_list (GtkSelectionData* selection_data,
                                                          GList* file_list,
                                                          const gchar* prefix);
VALA_EXTERN void files_dnd_handler_set_selection_text_from_file_list (GtkSelectionData* selection_data,
                                                          GList* file_list,
                                                          const gchar* prefix);
VALA_EXTERN GdkDragAction files_dnd_handler_file_accepts_drop (FilesFile* dest,
                                                   GList* drop_file_list,
                                                   GdkDragAction selected_action,
                                                   GdkDragAction possible_actions,
                                                   GdkDragAction* suggested_action_return);
VALA_EXTERN GType files_window_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* files_window_state_to_string (FilesWindowState self);
VALA_EXTERN GType files_view_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType files_open_flag_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType files_zoom_level_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType files_icon_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FilesIconSize files_zoom_level_to_icon_size (FilesZoomLevel self);
VALA_EXTERN GType files_target_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType files_sort_by_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* files_sort_by_to_string (FilesSortBy self);
VALA_EXTERN GType files_rename_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType files_rename_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* files_rename_mode_to_string (FilesRenameMode self);
VALA_EXTERN GType files_rename_position_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* files_rename_position_to_string (FilesRenamePosition self);
VALA_EXTERN gchar* files_rename_position_to_placeholder (FilesRenamePosition self);
VALA_EXTERN GType files_rename_date_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* files_rename_date_format_to_string (FilesRenameDateFormat self);
VALA_EXTERN GType files_rename_date_source_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* files_rename_date_source_to_string (FilesRenameDateSource self);
VALA_EXTERN GType files_file_icon_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType files_file_thumb_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FilesFile* files_file_get (GFile* location);
VALA_EXTERN FilesFile* files_file_get_by_uri (const gchar* uri);
VALA_EXTERN FilesFile* files_file_get_by_commandline_arg (const gchar* arg);
VALA_EXTERN FilesFile* files_file_cache_lookup (GFile* file);
VALA_EXTERN GMount* files_file_get_mount_at (GFile* location);
VALA_EXTERN FilesFile* files_file_new (GFile* location,
                           GFile* dir);
VALA_EXTERN FilesFile* files_file_construct (GType object_type,
                                 GFile* location,
                                 GFile* dir);
VALA_EXTERN void files_file_remove_from_caches (FilesFile* self);
VALA_EXTERN void files_file_set_expanded (FilesFile* self,
                              gboolean expanded);
VALA_EXTERN gboolean files_file_is_folder (FilesFile* self);
VALA_EXTERN gboolean files_file_is_symlink (FilesFile* self);
VALA_EXTERN gboolean files_file_is_desktop_file (FilesFile* self);
VALA_EXTERN gboolean files_file_is_image (FilesFile* self);
VALA_EXTERN gboolean files_file_is_trashed (FilesFile* self);
VALA_EXTERN gboolean files_file_is_readable (FilesFile* self);
VALA_EXTERN gboolean files_file_is_writable (FilesFile* self);
VALA_EXTERN gboolean files_file_is_executable (FilesFile* self);
VALA_EXTERN gboolean files_file_is_mountable (FilesFile* self);
VALA_EXTERN gboolean files_file_is_smb_share (FilesFile* self);
VALA_EXTERN gboolean files_file_is_smb_server (FilesFile* self);
VALA_EXTERN const gchar* files_file_get_display_name (FilesFile* self);
VALA_EXTERN GFile* files_file_get_target_location (FilesFile* self);
VALA_EXTERN const gchar* files_file_get_symlink_target (FilesFile* self);
VALA_EXTERN const gchar* files_file_get_ftype (FilesFile* self);
VALA_EXTERN gchar* files_file_get_formated_time (FilesFile* self,
                                     const gchar* attr);
VALA_EXTERN GdkPixbuf* files_file_get_icon_pixbuf (FilesFile* self,
                                       gint _size,
                                       gint scale,
                                       FilesFileIconFlags flags);
VALA_EXTERN void files_file_get_folder_icon_from_uri_or_path (FilesFile* self);
VALA_EXTERN void files_file_update (FilesFile* self);
VALA_EXTERN void files_file_update_type (FilesFile* self);
VALA_EXTERN void files_file_update_icon (FilesFile* self,
                             gint _size,
                             gint _scale);
VALA_EXTERN void files_file_update_desktop_file (FilesFile* self);
VALA_EXTERN void files_file_query_update (FilesFile* self);
VALA_EXTERN gboolean files_file_ensure_query_info (FilesFile* self);
VALA_EXTERN gboolean files_file_can_set_owner (FilesFile* self);
VALA_EXTERN gboolean files_file_can_set_group (FilesFile* self);
VALA_EXTERN gboolean files_file_can_set_permissions (FilesFile* self);
VALA_EXTERN gboolean files_file_can_unmount (FilesFile* self);
VALA_EXTERN gchar* files_file_get_permissions_as_string (FilesFile* self);
VALA_EXTERN GList* files_file_get_settable_group_names (FilesFile* self);
VALA_EXTERN gboolean files_file_is_remote_uri_scheme (FilesFile* self);
VALA_EXTERN gboolean files_file_is_root_network_folder (FilesFile* self);
VALA_EXTERN gboolean files_file_is_network_uri_scheme (FilesFile* self);
VALA_EXTERN gboolean files_file_is_smb_uri_scheme (FilesFile* self);
VALA_EXTERN gboolean files_file_is_recent_uri_scheme (FilesFile* self);
VALA_EXTERN gboolean files_file_is_other_uri_scheme (FilesFile* self);
VALA_EXTERN gchar* files_file_get_display_target_uri (FilesFile* self);
VALA_EXTERN GAppInfo* files_file_get_default_handler (FilesFile* self);
VALA_EXTERN gboolean files_file_execute (FilesFile* self,
                             GList* files,
                             GError** error);
VALA_EXTERN gint files_file_compare_for_sort (FilesFile* self,
                                  FilesFile* other,
                                  gint sort_type,
                                  gboolean directories_first,
                                  gboolean reversed);
VALA_EXTERN gint files_file_compare_by_display_name (FilesFile* self,
                                         FilesFile* other);
VALA_EXTERN void files_file_update_emblem (FilesFile* self);
VALA_EXTERN void files_file_add_emblem (FilesFile* self,
                            const gchar* emblem);
VALA_EXTERN void files_file_ensure_size (FilesFile* self);
VALA_EXTERN GIcon* files_file_get_icon_user_special_dirs (FilesFile* self,
                                              const gchar* path);
VALA_EXTERN gint files_file_compare_files_by_time (FilesFile* self,
                                       FilesFile* other);
VALA_EXTERN gint files_file_compare_files_by_created (FilesFile* self,
                                          FilesFile* other);
VALA_EXTERN gint files_file_compare_by_type (FilesFile* self,
                                 FilesFile* other);
VALA_EXTERN gint files_file_compare_files_by_size (FilesFile* self,
                                       FilesFile* other);
VALA_EXTERN gint files_file_compare_by_size (FilesFile* self,
                                 FilesFile* other);
VALA_EXTERN GFile* files_file_get_location (FilesFile* self);
VALA_EXTERN GFile* files_file_get_directory (FilesFile* self);
VALA_EXTERN const gchar* files_file_get_basename (FilesFile* self);
VALA_EXTERN const gchar* files_file_get_uri (FilesFile* self);
VALA_EXTERN gint files_file_get_color (FilesFile* self);
VALA_EXTERN void files_file_set_color (FilesFile* self,
                           gint value);
VALA_EXTERN gboolean files_file_get_is_hidden (FilesFile* self);
VALA_EXTERN const gchar* files_file_get_thumbnail_path (FilesFile* self);
VALA_EXTERN void files_file_set_thumbnail_path (FilesFile* self,
                                    const gchar* value);
VALA_EXTERN gboolean files_file_get_exists (FilesFile* self);
VALA_EXTERN void files_file_set_exists (FilesFile* self,
                            gboolean value);
VALA_EXTERN GType files_file_changes_kind_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FilesFileChangesChange* files_file_changes_change_new (void);
VALA_EXTERN void files_file_changes_queue_file_added (GFile* location,
                                          gboolean internal_origin);
VALA_EXTERN void files_file_changes_queue_file_changed (GFile* location);
VALA_EXTERN void files_file_changes_queue_file_removed (GFile* location);
VALA_EXTERN void files_file_changes_queue_file_moved (GFile* from,
                                          GFile* to);
VALA_EXTERN void files_file_changes_consume_changes (gboolean consume_all);
VALA_EXTERN GType files_file_conflict_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesFileConflictDialog, g_object_unref)
VALA_EXTERN GType files_file_conflict_dialog_response_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FilesFileConflictDialog* files_file_conflict_dialog_new (GtkWindow* parent,
                                                         GFile* _source,
                                                         GFile* _destination,
                                                         GFile* _dest_dir);
VALA_EXTERN FilesFileConflictDialog* files_file_conflict_dialog_construct (GType object_type,
                                                               GtkWindow* parent,
                                                               GFile* _source,
                                                               GFile* _destination,
                                                               GFile* _dest_dir);
VALA_EXTERN gchar* files_file_conflict_dialog_get_new_name (FilesFileConflictDialog* self);
VALA_EXTERN gboolean files_file_conflict_dialog_get_apply_to_all (FilesFileConflictDialog* self);
VALA_EXTERN GList* files_file_utils_files_from_uris (const gchar* uris);
VALA_EXTERN GKeyFile* files_file_utils_key_file_from_file (GFile* file,
                                               GCancellable* cancellable,
                                               GError** error);
VALA_EXTERN GFile* files_file_utils_get_file_for_path (const gchar* path);
VALA_EXTERN gchar* files_file_utils_get_parent_path_from_path (const gchar* path,
                                                   gboolean include_file_protocol);
VALA_EXTERN void files_file_utils_restore_files_from_trash (GList* files,
                                                GtkWidget* widget);
VALA_EXTERN gchar* files_file_utils_get_path_for_symlink (GFile* file);
VALA_EXTERN gboolean files_file_utils_path_has_parent (const gchar* new_path);
VALA_EXTERN gchar* files_file_utils_escape_uri (const gchar* uri,
                                    gboolean allow_utf8,
                                    gboolean allow_single_quote);
VALA_EXTERN gchar* files_file_utils_sanitize_path (const gchar* input_uri,
                                       const gchar* input_current_uri,
                                       gboolean include_file_protocol);
VALA_EXTERN void files_file_utils_split_protocol_from_path (const gchar* path,
                                                gchar** protocol,
                                                gchar** new_path);
VALA_EXTERN gchar* files_file_utils_get_smb_share_from_uri (const gchar* uri);
VALA_EXTERN void files_file_utils_get_rename_region (const gchar* filename,
                                         gint* start_offset,
                                         gint* end_offset,
                                         gboolean select_all);
VALA_EXTERN gchar* files_file_utils_custom_basename_from_file (GFile* location);
VALA_EXTERN void files_file_utils_set_file_display_name (GFile* old_location,
                                             const gchar* new_name,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN GFile* files_file_utils_set_file_display_name_finish (GAsyncResult* _res_,
                                                      GError** error);
VALA_EXTERN gchar* files_file_utils_get_formatted_time_attribute_from_info (GFileInfo* info,
                                                                const gchar* attr);
VALA_EXTERN gchar* files_file_utils_get_formatted_date_time (GDateTime* dt);
VALA_EXTERN guint16 files_file_utils_get_default_port_for_protocol (const gchar* protocol);
VALA_EXTERN gboolean files_file_utils_get_is_tls_for_protocol (const gchar* protocol);
VALA_EXTERN gboolean files_file_utils_location_is_in_trash (GFile* location);
VALA_EXTERN gint files_file_utils_compare_modification_dates (GFile* a,
                                                  GFile* b);
VALA_EXTERN void files_file_utils_remove_thumbnail_paths_for_uri (const gchar* uri);
VALA_EXTERN gboolean files_file_utils_same_location (const gchar* uri_a,
                                         const gchar* uri_b);
VALA_EXTERN guint64 files_file_utils_get_file_modification_time (GFile* file);
VALA_EXTERN gchar* files_file_utils_get_afp_target_uri (const gchar* standard_target_uri,
                                            const gchar* uri);
VALA_EXTERN gboolean files_file_utils_make_file_name_valid_for_dest_fs (gchar** filename,
                                                            const gchar* dest_fs_type);
VALA_EXTERN gchar* files_file_utils_format_time (gint seconds,
                                     gint* time_unit);
VALA_EXTERN gchar* files_file_utils_get_duplicate_name (const gchar* name,
                                            gint count_increment,
                                            gint max_length,
                                            gboolean is_link);
VALA_EXTERN gchar* files_file_utils_shorten_utf8_string (const gchar* base_string,
                                             gint reduce_by_num_bytes);
VALA_EXTERN gchar* files_file_utils_get_link_name (const gchar* target_name,
                                       gint count,
                                       gint max_length);
VALA_EXTERN gchar* files_file_utils_get_copy_name (const gchar* base_name,
                                       const gchar* suffix,
                                       gint count,
                                       gint max_length);
VALA_EXTERN gint files_file_utils_get_max_name_length (GFile* file_dir);
VALA_EXTERN gboolean files_file_utils_protocol_is_supported (const gchar* protocol);
VALA_EXTERN gboolean files_file_utils_file_is_dir (GFile* file);
VALA_EXTERN gchar* files_file_utils_disambiguate_uri (const gchar* uri,
                                          const gchar* conflict_uri);
VALA_EXTERN GType files_icon_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesIconInfo, g_object_unref)
VALA_EXTERN FilesIconInfo* files_icon_info_new_for_pixbuf (GdkPixbuf* pixbuf);
VALA_EXTERN FilesIconInfo* files_icon_info_construct_for_pixbuf (GType object_type,
                                                     GdkPixbuf* pixbuf);
VALA_EXTERN FilesIconInfo* files_icon_info_new_for_icon_info (GtkIconInfo* icon_info);
VALA_EXTERN FilesIconInfo* files_icon_info_construct_for_icon_info (GType object_type,
                                                        GtkIconInfo* icon_info);
VALA_EXTERN FilesIconInfo* files_icon_info_lookup (GIcon* icon,
                                       gint size,
                                       gint scale,
                                       gboolean cache_loadable);
VALA_EXTERN FilesIconInfo* files_icon_info_get_generic_icon (gint size,
                                                 gint scale);
VALA_EXTERN FilesIconInfo* files_icon_info_lookup_from_name (const gchar* icon_name,
                                                 gint size,
                                                 gint scale);
VALA_EXTERN FilesIconInfo* files_icon_info_lookup_from_path (const gchar* path,
                                                 gint size,
                                                 gint scale,
                                                 gboolean is_remote);
VALA_EXTERN gboolean files_icon_info_is_fallback (FilesIconInfo* self);
VALA_EXTERN GdkPixbuf* files_icon_info_get_pixbuf_nodefault (FilesIconInfo* self);
VALA_EXTERN GtkIconTheme* files_icon_info_get_icon_theme (void);
VALA_EXTERN guint files_icon_info_loadable_icon_cache_info (void);
VALA_EXTERN guint files_icon_info_themed_icon_cache_info (void);
VALA_EXTERN void files_icon_info_remove_cache (const gchar* path,
                                   gint size,
                                   gint scale);
VALA_EXTERN void files_icon_info_set_reap_time (guint milliseconds);
VALA_EXTERN void files_icon_info_clear_caches (void);
VALA_EXTERN FilesIconInfo* files_icon_info_new (void);
VALA_EXTERN FilesIconInfo* files_icon_info_construct (GType object_type);
VALA_EXTERN GdkPixbuf* files_icon_info_get_pixbuf (FilesIconInfo* self);
VALA_EXTERN void files_icon_info_set_pixbuf (FilesIconInfo* self,
                                 GdkPixbuf* value);
VALA_EXTERN GType files_list_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesListModel, g_object_unref)
VALA_EXTERN GType files_list_model_column_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FilesListModelColumnID files_list_model_column_id_from_string (const gchar* column_id);
VALA_EXTERN const gchar* files_list_model_column_id_to_string (FilesListModelColumnID self);
VALA_EXTERN void files_list_model_set_sorting_off (FilesListModel* self);
VALA_EXTERN void files_list_model_set_sorting_on (FilesListModel* self);
VALA_EXTERN FilesFile* files_list_model_file_for_path (FilesListModel* self,
                                           GtkTreePath* path);
VALA_EXTERN FilesFile* files_list_model_file_for_iter (FilesListModel* self,
                                           GtkTreeIter* iter);
VALA_EXTERN guint files_list_model_get_length (FilesListModel* self);
VALA_EXTERN GtkTreePath* files_list_model_get_path_for_first_file (FilesListModel* self,
                                                       FilesFile* file);
VALA_EXTERN void files_list_model_file_changed (FilesListModel* self,
                                    FilesFile* file,
                                    FilesDirectory* dir);
VALA_EXTERN void files_list_model_set_should_sort_directories_first (FilesListModel* self,
                                                         gboolean sort_directories_first);
VALA_EXTERN gboolean files_list_model_get_subdirectory (FilesListModel* self,
                                            GtkTreePath* path,
                                            FilesDirectory** dir);
VALA_EXTERN void files_list_model_load_subdirectory (FilesListModel* self,
                                         FilesDirectory* dir);
VALA_EXTERN gboolean files_list_model_unload_subdirectory (FilesListModel* self,
                                               GtkTreeIter* parent_iter);
VALA_EXTERN gboolean files_list_model_insert_sorted (FilesListModel* self,
                                         FilesFile* file,
                                         FilesDirectory* dir);
VALA_EXTERN gboolean files_list_model_add_file (FilesListModel* self,
                                    FilesFile* file,
                                    FilesDirectory* dir);
VALA_EXTERN gboolean files_list_model_remove_file (FilesListModel* self,
                                       FilesFile* file,
                                       FilesDirectory* dir);
VALA_EXTERN void files_list_model_clear (FilesListModel* self);
VALA_EXTERN FilesListModel* files_list_model_new (void);
VALA_EXTERN FilesListModel* files_list_model_construct (GType object_type);
VALA_EXTERN gboolean files_list_model_get_show_hidden_files (FilesListModel* self);
VALA_EXTERN void files_list_model_set_show_hidden_files (FilesListModel* self,
                                             gboolean value);
VALA_EXTERN gint files_list_model_get_icon_size (FilesListModel* self);
VALA_EXTERN void files_list_model_set_icon_size (FilesListModel* self,
                                     gint value);
VALA_EXTERN gboolean files_list_model_get_has_child (FilesListModel* self);
VALA_EXTERN void files_list_model_set_has_child (FilesListModel* self,
                                     gboolean value);
VALA_EXTERN gboolean files_list_model_get_sort_pending (FilesListModel* self);
VALA_EXTERN GdkPixbuf* pf_pixbuf_utils_lighten (GdkPixbuf* src);
VALA_EXTERN GdkPixbuf* pf_pixbuf_utils_darken (GdkPixbuf* src,
                                   guint8 saturation,
                                   guint8 darken);
VALA_EXTERN GdkPixbuf* pf_pixbuf_utils_lucent (GdkPixbuf* src,
                                   guint percent);
VALA_EXTERN GType files_preferences_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesPreferences, g_object_unref)
VALA_EXTERN FilesPreferences* files_preferences;
VALA_EXTERN FilesPreferences* files_preferences_get_default (void);
VALA_EXTERN FilesPreferences* files_preferences_new (void);
VALA_EXTERN FilesPreferences* files_preferences_construct (GType object_type);
VALA_EXTERN gboolean files_preferences_get_show_hidden_files (FilesPreferences* self);
VALA_EXTERN void files_preferences_set_show_hidden_files (FilesPreferences* self,
                                              gboolean value);
VALA_EXTERN gboolean files_preferences_get_show_remote_thumbnails (FilesPreferences* self);
VALA_EXTERN void files_preferences_set_show_remote_thumbnails (FilesPreferences* self,
                                                   gboolean value);
VALA_EXTERN gboolean files_preferences_get_show_local_thumbnails (FilesPreferences* self);
VALA_EXTERN void files_preferences_set_show_local_thumbnails (FilesPreferences* self,
                                                  gboolean value);
VALA_EXTERN gboolean files_preferences_get_singleclick_select (FilesPreferences* self);
VALA_EXTERN void files_preferences_set_singleclick_select (FilesPreferences* self,
                                               gboolean value);
VALA_EXTERN gboolean files_preferences_get_confirm_trash (FilesPreferences* self);
VALA_EXTERN void files_preferences_set_confirm_trash (FilesPreferences* self,
                                          gboolean value);
VALA_EXTERN gboolean files_preferences_get_force_icon_size (FilesPreferences* self);
VALA_EXTERN void files_preferences_set_force_icon_size (FilesPreferences* self,
                                            gboolean value);
VALA_EXTERN gboolean files_preferences_get_sort_directories_first (FilesPreferences* self);
VALA_EXTERN void files_preferences_set_sort_directories_first (FilesPreferences* self,
                                                   gboolean value);
VALA_EXTERN gboolean files_preferences_get_remember_history (FilesPreferences* self);
VALA_EXTERN void files_preferences_set_remember_history (FilesPreferences* self,
                                             gboolean value);
VALA_EXTERN const gchar* files_preferences_get_date_format (FilesPreferences* self);
VALA_EXTERN void files_preferences_set_date_format (FilesPreferences* self,
                                        const gchar* value);
VALA_EXTERN const gchar* files_preferences_get_clock_format (FilesPreferences* self);
VALA_EXTERN void files_preferences_set_clock_format (FilesPreferences* self,
                                         const gchar* value);
VALA_EXTERN GType files_plugin_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesPluginManager, g_object_unref)
VALA_EXTERN FilesPluginManager* plugins;
VALA_EXTERN FilesPluginManager* files_plugin_manager_new (const gchar* plugin_dir,
                                              guint user_id);
VALA_EXTERN FilesPluginManager* files_plugin_manager_construct (GType object_type,
                                                    const gchar* plugin_dir,
                                                    guint user_id);
VALA_EXTERN void files_plugin_manager_hook_context_menu (FilesPluginManager* self,
                                             GtkWidget* menu,
                                             GList* files);
VALA_EXTERN void files_plugin_manager_directory_loaded (FilesPluginManager* self,
                                            GtkApplicationWindow* window,
                                            FilesAbstractSlot* view,
                                            FilesFile* directory);
VALA_EXTERN void files_plugin_manager_interface_loaded (FilesPluginManager* self,
                                            GtkWidget* win);
VALA_EXTERN void files_plugin_manager_sidebar_loaded (FilesPluginManager* self,
                                          GtkWidget* widget);
VALA_EXTERN void files_plugin_manager_update_sidebar (FilesPluginManager* self,
                                          GtkWidget* widget);
VALA_EXTERN void files_plugin_manager_update_file_info (FilesPluginManager* self,
                                            FilesFile* file);
VALA_EXTERN GeeList* files_plugin_manager_get_available_plugins (FilesPluginManager* self);
VALA_EXTERN GeeList* files_plugin_manager_get_menuitem_references (FilesPluginManager* self);
VALA_EXTERN gpointer files_plugins_base_ref (gpointer instance);
VALA_EXTERN void files_plugins_base_unref (gpointer instance);
VALA_EXTERN GParamSpec* files_plugins_param_spec_base (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void files_plugins_value_set_base (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void files_plugins_value_take_base (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer files_plugins_value_get_base (const GValue* value);
VALA_EXTERN GType files_plugins_base_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesPluginsBase, files_plugins_base_unref)
VALA_EXTERN void files_plugins_base_directory_loaded (FilesPluginsBase* self,
                                          GtkApplicationWindow* window,
                                          FilesAbstractSlot* view,
                                          FilesFile* directory);
VALA_EXTERN void files_plugins_base_context_menu (FilesPluginsBase* self,
                                      GtkWidget* widget,
                                      GList* files);
VALA_EXTERN void files_plugins_base_sidebar_loaded (FilesPluginsBase* self,
                                        GtkWidget* widget);
VALA_EXTERN void files_plugins_base_update_sidebar (FilesPluginsBase* self,
                                        GtkWidget* widget);
VALA_EXTERN void files_plugins_base_update_file_info (FilesPluginsBase* self,
                                          FilesFile* file);
VALA_EXTERN void files_plugins_base_interface_loaded (FilesPluginsBase* self,
                                          GtkWidget* widget);
VALA_EXTERN FilesPluginsBase* files_plugins_base_construct (GType object_type);
VALA_EXTERN GType pf_progress_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PFProgressInfo, g_object_unref)
VALA_EXTERN PFProgressInfo* pf_progress_info_new (void);
VALA_EXTERN PFProgressInfo* pf_progress_info_construct (GType object_type);
VALA_EXTERN void pf_progress_info_cancel (PFProgressInfo* self);
VALA_EXTERN void pf_progress_info_start (PFProgressInfo* self);
VALA_EXTERN void pf_progress_info_finish (PFProgressInfo* self);
VALA_EXTERN void pf_progress_info_pause (PFProgressInfo* self);
VALA_EXTERN void pf_progress_info_resume (PFProgressInfo* self);
VALA_EXTERN void pf_progress_info_take_status (PFProgressInfo* self,
                                   gchar* _status);
VALA_EXTERN void pf_progress_info_take_details (PFProgressInfo* self,
                                    gchar* _details);
VALA_EXTERN void pf_progress_info_update_progress (PFProgressInfo* self,
                                       gdouble current,
                                       gdouble total);
VALA_EXTERN void pf_progress_info_pulse_progress (PFProgressInfo* self);
VALA_EXTERN GCancellable* pf_progress_info_get_cancellable (PFProgressInfo* self);
VALA_EXTERN const gchar* pf_progress_info_get_title (PFProgressInfo* self);
VALA_EXTERN void pf_progress_info_set_title (PFProgressInfo* self,
                                 const gchar* value);
VALA_EXTERN const gchar* pf_progress_info_get_status (PFProgressInfo* self);
VALA_EXTERN const gchar* pf_progress_info_get_details (PFProgressInfo* self);
VALA_EXTERN void pf_progress_info_set_details (PFProgressInfo* self,
                                   const gchar* value);
VALA_EXTERN gdouble pf_progress_info_get_progress (PFProgressInfo* self);
VALA_EXTERN gdouble pf_progress_info_get_current (PFProgressInfo* self);
VALA_EXTERN gdouble pf_progress_info_get_total (PFProgressInfo* self);
VALA_EXTERN gboolean pf_progress_info_get_activity_mode (PFProgressInfo* self);
VALA_EXTERN gboolean pf_progress_info_get_is_started (PFProgressInfo* self);
VALA_EXTERN gboolean pf_progress_info_get_is_finished (PFProgressInfo* self);
VALA_EXTERN gboolean pf_progress_info_get_is_paused (PFProgressInfo* self);
VALA_EXTERN gboolean pf_progress_info_get_is_cancelled (PFProgressInfo* self);
VALA_EXTERN GType pf_progress_info_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PFProgressInfoManager, g_object_unref)
VALA_EXTERN PFProgressInfoManager* pf_progress_info_manager_get_instance (void);
VALA_EXTERN void pf_progress_info_manager_add_new_info (PFProgressInfoManager* self,
                                            PFProgressInfo* info);
VALA_EXTERN void pf_progress_info_manager_remove_finished_info (PFProgressInfoManager* self,
                                                    PFProgressInfo* info);
VALA_EXTERN GeeLinkedList* pf_progress_info_manager_get_all_infos (PFProgressInfoManager* self);
VALA_EXTERN PFProgressInfoManager* pf_progress_info_manager_new (void);
VALA_EXTERN PFProgressInfoManager* pf_progress_info_manager_construct (GType object_type);
VALA_EXTERN gchar* files_protocol_to_name (const gchar* protocol);
VALA_EXTERN GType files_sidebar_plugin_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesSidebarPluginItem, g_object_unref)
VALA_EXTERN GType files_place_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FilesSidebarPluginItem* files_sidebar_plugin_item_new (void);
VALA_EXTERN FilesSidebarPluginItem* files_sidebar_plugin_item_construct (GType object_type);
VALA_EXTERN const gchar* files_sidebar_plugin_item_get_name (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_name (FilesSidebarPluginItem* self,
                                         const gchar* value);
VALA_EXTERN const gchar* files_sidebar_plugin_item_get_uri (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_uri (FilesSidebarPluginItem* self,
                                        const gchar* value);
VALA_EXTERN GDrive* files_sidebar_plugin_item_get_drive (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_drive (FilesSidebarPluginItem* self,
                                          GDrive* value);
VALA_EXTERN GVolume* files_sidebar_plugin_item_get_volume (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_volume (FilesSidebarPluginItem* self,
                                           GVolume* value);
VALA_EXTERN GMount* files_sidebar_plugin_item_get_mount (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_mount (FilesSidebarPluginItem* self,
                                          GMount* value);
VALA_EXTERN GIcon* files_sidebar_plugin_item_get_icon (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_icon (FilesSidebarPluginItem* self,
                                         GIcon* value);
VALA_EXTERN guint files_sidebar_plugin_item_get_index (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_index (FilesSidebarPluginItem* self,
                                          guint value);
VALA_EXTERN gboolean files_sidebar_plugin_item_get_can_eject (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_can_eject (FilesSidebarPluginItem* self,
                                              gboolean value);
VALA_EXTERN const gchar* files_sidebar_plugin_item_get_tooltip (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_tooltip (FilesSidebarPluginItem* self,
                                            const gchar* value);
VALA_EXTERN GIcon* files_sidebar_plugin_item_get_action_icon (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_action_icon (FilesSidebarPluginItem* self,
                                                GIcon* value);
VALA_EXTERN gboolean files_sidebar_plugin_item_get_show_spinner (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_show_spinner (FilesSidebarPluginItem* self,
                                                 gboolean value);
VALA_EXTERN guint64 files_sidebar_plugin_item_get_free_space (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_free_space (FilesSidebarPluginItem* self,
                                               guint64 value);
VALA_EXTERN guint64 files_sidebar_plugin_item_get_disk_size (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_disk_size (FilesSidebarPluginItem* self,
                                              guint64 value);
VALA_EXTERN GActionGroup* files_sidebar_plugin_item_get_action_group (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_action_group (FilesSidebarPluginItem* self,
                                                 GActionGroup* value);
VALA_EXTERN const gchar* files_sidebar_plugin_item_get_action_group_namespace (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_action_group_namespace (FilesSidebarPluginItem* self,
                                                           const gchar* value);
VALA_EXTERN GMenuModel* files_sidebar_plugin_item_get_menu_model (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_menu_model (FilesSidebarPluginItem* self,
                                               GMenuModel* value);
VALA_EXTERN FilesSidebarCallbackFunc files_sidebar_plugin_item_get_cb (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_cb (FilesSidebarPluginItem* self,
                                       FilesSidebarCallbackFunc value);
VALA_EXTERN GType pf_sound_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PFSoundManager, g_object_unref)
VALA_EXTERN PFSoundManager* pf_sound_manager_get_instance (void);
VALA_EXTERN void pf_sound_manager_play_delete_sound (PFSoundManager* self);
VALA_EXTERN void pf_sound_manager_play_empty_trash_sound (PFSoundManager* self);
VALA_EXTERN void pf_sound_manager_play_sound (PFSoundManager* self,
                                  const gchar* pf_sound_id);
VALA_EXTERN GraniteMessageDialog* pf_dialogs_show_error_dialog (const gchar* primary_text,
                                                    const gchar* secondary_text,
                                                    GtkWindow* parent);
VALA_EXTERN GraniteMessageDialog* pf_dialogs_show_warning_dialog (const gchar* primary_text,
                                                      const gchar* secondary_text,
                                                      GtkWindow* parent);
VALA_EXTERN GType files_thumbnailer_daemon_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint files_thumbnailer_daemon_register_object (void* object,
                                                GDBusConnection* connection,
                                                const gchar* path,
                                                GError** error);
VALA_EXTERN GType files_thumbnailer_daemon_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesThumbnailerDaemon, g_object_unref)
VALA_EXTERN void files_thumbnailer_daemon_queue (FilesThumbnailerDaemon* self,
                                     gchar** uris,
                                     gint uris_length1,
                                     gchar** mime_types,
                                     gint mime_types_length1,
                                     const gchar* flavor,
                                     const gchar* scheduler,
                                     guint handle_to_unqueue,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN guint files_thumbnailer_daemon_queue_finish (FilesThumbnailerDaemon* self,
                                             GAsyncResult* _res_,
                                             GError** error);
VALA_EXTERN void files_thumbnailer_daemon_dequeue (FilesThumbnailerDaemon* self,
                                       guint handle,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN void files_thumbnailer_daemon_dequeue_finish (FilesThumbnailerDaemon* self,
                                              GAsyncResult* _res_,
                                              GError** error);
VALA_EXTERN void files_thumbnailer_daemon_get_supported (FilesThumbnailerDaemon* self,
                                             gchar*** uri_schemes,
                                             gint* uri_schemes_length1,
                                             gchar*** mime_types,
                                             gint* mime_types_length1,
                                             GError** error);
VALA_EXTERN GType files_thumbnailer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesThumbnailer, g_object_unref)
VALA_EXTERN FilesThumbnailer* files_thumbnailer_get (void);
VALA_EXTERN gboolean files_thumbnailer_queue_file (FilesThumbnailer* self,
                                       FilesFile* file,
                                       gint* request);
VALA_EXTERN gboolean files_thumbnailer_queue_files (FilesThumbnailer* self,
                                        GList* files,
                                        gint* request);
VALA_EXTERN void files_thumbnailer_dequeue (FilesThumbnailer* self,
                                gint request);
VALA_EXTERN GType files_trash_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesTrashMonitor, g_object_unref)
VALA_EXTERN FilesTrashMonitor* files_trash_monitor_get_default (void);
VALA_EXTERN GIcon* files_trash_monitor_get_icon (FilesTrashMonitor* self);
VALA_EXTERN FilesTrashMonitor* files_trash_monitor_new (void);
VALA_EXTERN FilesTrashMonitor* files_trash_monitor_construct (GType object_type);
VALA_EXTERN gboolean files_trash_monitor_get_is_empty (FilesTrashMonitor* self);
VALA_EXTERN GList* pf_user_utils_get_user_names (void);
VALA_EXTERN GList* pf_user_utils_get_group_names_for_user (void);
VALA_EXTERN GList* pf_user_utils_get_all_group_names (void);
VALA_EXTERN gboolean pf_user_utils_user_in_group (const gchar* group_name);
VALA_EXTERN uid_t* pf_user_utils_get_group_id_from_group_name (const gchar* group_name);
VALA_EXTERN uid_t* pf_user_utils_get_user_id_from_user_name (const gchar* user_name);
VALA_EXTERN const gchar* pf_user_utils_get_user_home_from_user_uid (uid_t uid);
VALA_EXTERN uid_t* pf_user_utils_get_id_from_digit_string (const gchar* digit_string);
VALA_EXTERN gchar* pf_user_utils_get_real_user_home (void);
VALA_EXTERN GType files_undo_action_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN const gchar* files_undo_action_type_to_undo_string (FilesUndoActionType self);
VALA_EXTERN const gchar* files_undo_action_type_to_redo_string (FilesUndoActionType self);
VALA_EXTERN gpointer files_undo_action_data_ref (gpointer instance);
VALA_EXTERN void files_undo_action_data_unref (gpointer instance);
VALA_EXTERN GParamSpec* files_param_spec_undo_action_data (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void files_value_set_undo_action_data (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void files_value_take_undo_action_data (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer files_value_get_undo_action_data (const GValue* value);
VALA_EXTERN GType files_undo_action_data_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesUndoActionData, files_undo_action_data_unref)
VALA_EXTERN FilesUndoActionData* files_undo_action_data_new (FilesUndoActionType action_type,
                                                 gint items_count);
VALA_EXTERN FilesUndoActionData* files_undo_action_data_construct (GType object_type,
                                                       FilesUndoActionType action_type,
                                                       gint items_count);
VALA_EXTERN void files_undo_action_data_set_src_dir (FilesUndoActionData* self,
                                         GFile* src);
VALA_EXTERN void files_undo_action_data_set_dest_dir (FilesUndoActionData* self,
                                          GFile* dest);
VALA_EXTERN void files_undo_action_data_add_origin_target_pair (FilesUndoActionData* self,
                                                    GFile* origin,
                                                    GFile* target);
VALA_EXTERN void files_undo_action_data_set_create_data (FilesUndoActionData* self,
                                             const gchar* target_uri,
                                             const gchar* template);
VALA_EXTERN void files_undo_action_data_set_rename_information (FilesUndoActionData* self,
                                                    GFile* old_file,
                                                    GFile* new_file);
VALA_EXTERN void files_undo_action_data_add_trashed_file (FilesUndoActionData* self,
                                              GFile* file,
                                              guint64 mtime);
VALA_EXTERN void files_undo_action_data_add_file_permissions (FilesUndoActionData* self,
                                                  GFile* file,
                                                  guint32 permission);
VALA_EXTERN void files_undo_action_data_set_recursive_permissions (FilesUndoActionData* self,
                                                       guint32 file_permissions,
                                                       guint32 file_mask,
                                                       guint32 dir_permissions,
                                                       guint32 dir_mask);
VALA_EXTERN void files_undo_action_data_set_file_permissions (FilesUndoActionData* self,
                                                  const gchar* uri,
                                                  guint32 current_permissions,
                                                  guint32 new_permissions);
VALA_EXTERN void files_undo_action_data_set_owner_change_information (FilesUndoActionData* self,
                                                          const gchar* uri,
                                                          const gchar* current_user,
                                                          const gchar* new_user);
VALA_EXTERN void files_undo_action_data_set_group_change_information (FilesUndoActionData* self,
                                                          const gchar* uri,
                                                          const gchar* current_group,
                                                          const gchar* new_group);
VALA_EXTERN GType files_undo_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesUndoManager, g_object_unref)
VALA_EXTERN FilesUndoManager* files_undo_manager_instance (void);
VALA_EXTERN void files_undo_manager_undo (FilesUndoManager* self,
                              GtkWidget* widget,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_);
VALA_EXTERN gboolean files_undo_manager_undo_finish (FilesUndoManager* self,
                                         GAsyncResult* _res_,
                                         GError** error);
VALA_EXTERN void files_undo_manager_redo (FilesUndoManager* self,
                              GtkWidget* widget,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_);
VALA_EXTERN gboolean files_undo_manager_redo_finish (FilesUndoManager* self,
                                         GAsyncResult* _res_,
                                         GError** error);
VALA_EXTERN void files_undo_manager_add_action (FilesUndoManager* self,
                                    FilesUndoActionData* action);
VALA_EXTERN void files_undo_manager_add_rename_action (FilesUndoManager* self,
                                           GFile* renamed_file,
                                           const gchar* original_name);
VALA_EXTERN void files_undo_manager_trash_has_emptied (FilesUndoManager* self);
VALA_EXTERN const gchar* files_undo_manager_get_next_undo_description (FilesUndoManager* self);
VALA_EXTERN const gchar* files_undo_manager_get_next_redo_description (FilesUndoManager* self);
VALA_EXTERN gboolean files_undo_manager_can_undo (FilesUndoManager* self);
VALA_EXTERN gboolean files_undo_manager_can_redo (FilesUndoManager* self);
VALA_EXTERN FilesUndoManager* files_undo_manager_new (void);
VALA_EXTERN FilesUndoManager* files_undo_manager_construct (GType object_type);
VALA_EXTERN guint files_undo_manager_get_undo_levels (FilesUndoManager* self);
VALA_EXTERN void files_undo_manager_set_undo_levels (FilesUndoManager* self,
                                         guint value);
VALA_EXTERN gboolean files_undo_manager_get_confirm_delete (FilesUndoManager* self);
VALA_EXTERN void files_undo_manager_set_confirm_delete (FilesUndoManager* self,
                                            gboolean value);
VALA_EXTERN gboolean files_undo_manager_get_undo_redo_flag (FilesUndoManager* self);
VALA_EXTERN gpointer marlin_file_operations_common_job_ref (gpointer instance);
VALA_EXTERN void marlin_file_operations_common_job_unref (gpointer instance);
VALA_EXTERN GParamSpec* marlin_file_operations_param_spec_common_job (const gchar* name,
                                                          const gchar* nick,
                                                          const gchar* blurb,
                                                          GType object_type,
                                                          GParamFlags flags);
VALA_EXTERN void marlin_file_operations_value_set_common_job (GValue* value,
                                                  gpointer v_object);
VALA_EXTERN void marlin_file_operations_value_take_common_job (GValue* value,
                                                   gpointer v_object);
VALA_EXTERN gpointer marlin_file_operations_value_get_common_job (const GValue* value);
VALA_EXTERN GType marlin_file_operations_common_job_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesFileOperationsCommonJob, marlin_file_operations_common_job_unref)
VALA_EXTERN void marlin_file_operations_common_job_source_info_free (SourceInfo * self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceInfo, marlin_file_operations_common_job_source_info_free)
VALA_EXTERN FilesFileOperationsCommonJob* marlin_file_operations_common_job_new (GtkWindow* parent_window);
VALA_EXTERN FilesFileOperationsCommonJob* marlin_file_operations_common_job_construct (GType object_type,
                                                                           GtkWindow* parent_window);
VALA_EXTERN const gchar* marlin_file_operations_common_job_get_scan_primary (FilesFileOperationsCommonJob* self);
VALA_EXTERN void marlin_file_operations_common_job_report_count_progress (FilesFileOperationsCommonJob* self,
                                                              SourceInfo* source_info);
VALA_EXTERN void marlin_file_operations_common_job_inhibit_power_manager (FilesFileOperationsCommonJob* self,
                                                              const gchar* message);
VALA_EXTERN gboolean marlin_file_operations_common_job_aborted (FilesFileOperationsCommonJob* self);
VALA_EXTERN void marlin_file_operations_common_job_abort_job (FilesFileOperationsCommonJob* self);
VALA_EXTERN void marlin_file_operations_common_job_skip_file (FilesFileOperationsCommonJob* self,
                                                  GFile* file);
VALA_EXTERN void marlin_file_operations_common_job_skip_readdir_error (FilesFileOperationsCommonJob* self,
                                                           GFile* dir);
VALA_EXTERN gboolean marlin_file_operations_common_job_should_skip_file (FilesFileOperationsCommonJob* self,
                                                             GFile* file);
VALA_EXTERN gboolean marlin_file_operations_common_job_should_skip_readdir_error (FilesFileOperationsCommonJob* self,
                                                                      GFile* dir);
VALA_EXTERN void marlin_file_operations_common_job_verify_destination (FilesFileOperationsCommonJob* self,
                                                           GFile* dest,
                                                           gchar** dest_fs_id,
                                                           gint64 required_size);
VALA_EXTERN SourceInfo* marlin_file_operations_common_job_scan_sources (FilesFileOperationsCommonJob* self,
                                                            GList* files);
VALA_EXTERN gint marlin_file_operations_common_job_run_error (FilesFileOperationsCommonJob* self,
                                                  gchar* primary_text,
                                                  gchar* secondary_text,
                                                  const gchar* details_text,
                                                  gboolean show_all,
                                                  ...);
VALA_EXTERN gint marlin_file_operations_common_job_run_warning (FilesFileOperationsCommonJob* self,
                                                    gchar* primary_text,
                                                    gchar* secondary_text,
                                                    const gchar* details_text,
                                                    gboolean show_all,
                                                    ...);
VALA_EXTERN gint marlin_file_operations_common_job_run_question (FilesFileOperationsCommonJob* self,
                                                     gchar* primary_text,
                                                     gchar* secondary_text,
                                                     const gchar* details_text,
                                                     gboolean show_all,
                                                     ...);
VALA_EXTERN gint marlin_file_operations_common_job_run_conflict_dialog (FilesFileOperationsCommonJob* self,
                                                            GFile* src,
                                                            GFile* dest,
                                                            GFile* dest_dir,
                                                            gchar** new_name,
                                                            gboolean* apply_to_all);
VALA_EXTERN SourceInfo* marlin_file_operations_common_job_source_info_copy (SourceInfo* self);
VALA_EXTERN SourceInfo* marlin_file_operations_common_job_source_info_new (void);
VALA_EXTERN void marlin_file_operations_common_job_transfer_info_free (TransferInfo * self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TransferInfo, marlin_file_operations_common_job_transfer_info_free)
VALA_EXTERN TransferInfo* marlin_file_operations_common_job_transfer_info_new (void);
VALA_EXTERN GType marlin_file_operations_copy_move_job_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesFileOperationsCopyMoveJob, marlin_file_operations_common_job_unref)
VALA_EXTERN FilesFileOperationsCopyMoveJob* marlin_file_operations_copy_move_job_new (GtkWindow* parent_window,
                                                                          GList* files,
                                                                          GFile* destination);
VALA_EXTERN FilesFileOperationsCopyMoveJob* marlin_file_operations_copy_move_job_construct (GType object_type,
                                                                                GtkWindow* parent_window,
                                                                                GList* files,
                                                                                GFile* destination);
VALA_EXTERN FilesFileOperationsCopyMoveJob* marlin_file_operations_copy_move_job_new_move (GtkWindow* parent_window,
                                                                               GList* files,
                                                                               GFile* destination);
VALA_EXTERN FilesFileOperationsCopyMoveJob* marlin_file_operations_copy_move_job_construct_move (GType object_type,
                                                                                     GtkWindow* parent_window,
                                                                                     GList* files,
                                                                                     GFile* destination);
VALA_EXTERN void marlin_file_operations_copy_move_job_report_link_progress (FilesFileOperationsCopyMoveJob* self,
                                                                gint total,
                                                                gint left);
VALA_EXTERN void marlin_file_operations_copy_move_job_report_copy_progress (FilesFileOperationsCopyMoveJob* self,
                                                                SourceInfo* source_info,
                                                                TransferInfo* transfer_info);
VALA_EXTERN void marlin_file_operations_copy_move_job_report_move_progress (FilesFileOperationsCopyMoveJob* self,
                                                                gint total,
                                                                gint left);
VALA_EXTERN GType marlin_file_operations_create_job_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesFileOperationsCreateJob, marlin_file_operations_common_job_unref)
VALA_EXTERN FilesFileOperationsCreateJob* marlin_file_operations_create_job_new_folder (GtkWindow* parent_window,
                                                                            GFile* dest_dir);
VALA_EXTERN FilesFileOperationsCreateJob* marlin_file_operations_create_job_construct_folder (GType object_type,
                                                                                  GtkWindow* parent_window,
                                                                                  GFile* dest_dir);
VALA_EXTERN FilesFileOperationsCreateJob* marlin_file_operations_create_job_new_file_from_template (GtkWindow* parent_window,
                                                                                        GFile* dest_dir,
                                                                                        const gchar* target_filename,
                                                                                        GFile* src);
VALA_EXTERN FilesFileOperationsCreateJob* marlin_file_operations_create_job_construct_file_from_template (GType object_type,
                                                                                              GtkWindow* parent_window,
                                                                                              GFile* dest_dir,
                                                                                              const gchar* target_filename,
                                                                                              GFile* src);
VALA_EXTERN FilesFileOperationsCreateJob* marlin_file_operations_create_job_new_file (GtkWindow* parent_window,
                                                                          GFile* dest_dir,
                                                                          const gchar* target_filename,
                                                                          guint8* src_data,
                                                                          gint length);
VALA_EXTERN FilesFileOperationsCreateJob* marlin_file_operations_create_job_construct_file (GType object_type,
                                                                                GtkWindow* parent_window,
                                                                                GFile* dest_dir,
                                                                                const gchar* target_filename,
                                                                                guint8* src_data,
                                                                                gint length);
VALA_EXTERN FilesFileOperationsCreateJob* marlin_file_operations_create_job_new (void);
VALA_EXTERN FilesFileOperationsCreateJob* marlin_file_operations_create_job_construct (GType object_type);
VALA_EXTERN GType marlin_file_operations_delete_job_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesFileOperationsDeleteJob, marlin_file_operations_common_job_unref)
VALA_EXTERN gboolean marlin_file_operations_delete_job_can_delete_without_confirm (GFile* file);
VALA_EXTERN FilesFileOperationsDeleteJob* marlin_file_operations_delete_job_new (GtkWindow* parent_window,
                                                                     GList* files,
                                                                     gboolean try_trash);
VALA_EXTERN FilesFileOperationsDeleteJob* marlin_file_operations_delete_job_construct (GType object_type,
                                                                           GtkWindow* parent_window,
                                                                           GList* files,
                                                                           gboolean try_trash);
VALA_EXTERN gboolean marlin_file_operations_delete_job_confirm_delete_from_trash (FilesFileOperationsDeleteJob* self,
                                                                      GList* to_delete_files);
VALA_EXTERN gboolean marlin_file_operations_delete_job_confirm_delete_directly (FilesFileOperationsDeleteJob* self,
                                                                    GList* to_delete_files);
VALA_EXTERN void marlin_file_operations_delete_job_report_delete_progress (FilesFileOperationsDeleteJob* self,
                                                               SourceInfo* source_info,
                                                               TransferInfo* transfer_info);
VALA_EXTERN void marlin_file_operations_delete_job_report_trash_progress (FilesFileOperationsDeleteJob* self,
                                                              gint files_trashed,
                                                              gint total_files);
VALA_EXTERN GType marlin_file_operations_empty_trash_job_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesFileOperationsEmptyTrashJob, marlin_file_operations_common_job_unref)
VALA_EXTERN FilesFileOperationsEmptyTrashJob* marlin_file_operations_empty_trash_job_new (GtkWindow* parent_window,
                                                                              GList* trash_dirs);
VALA_EXTERN FilesFileOperationsEmptyTrashJob* marlin_file_operations_empty_trash_job_construct (GType object_type,
                                                                                    GtkWindow* parent_window,
                                                                                    GList* trash_dirs);
VALA_EXTERN void marlin_file_operations_empty_trash_job_empty_trash (FilesFileOperationsEmptyTrashJob* self,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
VALA_EXTERN void marlin_file_operations_empty_trash_job_empty_trash_finish (FilesFileOperationsEmptyTrashJob* self,
                                                                GAsyncResult* _res_);
VALA_EXTERN void marlin_file_operations_unmount_mount (GMount* mount,
                                           GtkWindow* parent,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN gboolean marlin_file_operations_unmount_mount_finish (GAsyncResult* _res_);
VALA_EXTERN void marlin_file_operations_eject_mount (GMount* mount,
                                         GtkWindow* parent,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN gboolean marlin_file_operations_eject_mount_finish (GAsyncResult* _res_);
VALA_EXTERN void marlin_file_operations_eject_drive (GDrive* drive,
                                         GtkWindow* parent,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN void marlin_file_operations_eject_drive_finish (GAsyncResult* _res_);
VALA_EXTERN void marlin_file_operations_safely_remove_drive (GDrive* drive,
                                                 GtkWindow* parent,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN void marlin_file_operations_safely_remove_drive_finish (GAsyncResult* _res_);
VALA_EXTERN void marlin_file_operations_mount_volume_full (GVolume* volume,
                                               GtkWindow* parent_window,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN gboolean marlin_file_operations_mount_volume_full_finish (GAsyncResult* _res_);
VALA_EXTERN void marlin_file_operations_mount_volume (GVolume* volume,
                                          GtkWindow* parent_window);
VALA_EXTERN gboolean marlin_file_operations_has_trash_files (GMount* mount);
VALA_EXTERN gboolean marlin_file_operations_mount_has_trash (GMount* mount);
VALA_EXTERN GList* marlin_file_operations_get_trash_dirs_for_mount (GMount* mount);
VALA_EXTERN void marlin_file_operations_empty_trash_for_mount (GtkWidget* parent_view,
                                                   GMount* mount);
VALA_EXTERN GType files_sidebar_interface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesSidebarInterface, g_object_unref)
VALA_EXTERN guint32 files_sidebar_interface_add_plugin_item (FilesSidebarInterface* self,
                                                 FilesSidebarPluginItem* item,
                                                 FilesPlaceType category);
VALA_EXTERN gboolean files_sidebar_interface_update_plugin_item (FilesSidebarInterface* self,
                                                     FilesSidebarPluginItem* item,
                                                     guint32 item_id);
VALA_EXTERN void files_sidebar_interface_add_favorite_uri (FilesSidebarInterface* self,
                                               const gchar* uri,
                                               const gchar* custom_name);
VALA_EXTERN gboolean files_sidebar_interface_has_favorite_uri (FilesSidebarInterface* self,
                                                   const gchar* uri);
VALA_EXTERN void files_sidebar_interface_sync_uri (FilesSidebarInterface* self,
                                       const gchar* uri);
VALA_EXTERN void files_sidebar_interface_reload (FilesSidebarInterface* self);
VALA_EXTERN void files_sidebar_interface_on_free_space_change (FilesSidebarInterface* self);
VALA_EXTERN void files_sidebar_interface_focus (FilesSidebarInterface* self);
VALA_EXTERN GType files_view_chrome_locatable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewChromeLocatable, g_object_unref)
VALA_EXTERN void files_view_chrome_locatable_set_display_path (FilesViewChromeLocatable* self,
                                                   const gchar* path);
VALA_EXTERN gchar* files_view_chrome_locatable_get_display_path (FilesViewChromeLocatable* self);
VALA_EXTERN gboolean files_view_chrome_locatable_set_focussed (FilesViewChromeLocatable* self);
VALA_EXTERN GType files_view_chrome_navigatable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewChromeNavigatable, g_object_unref)
VALA_EXTERN void files_view_chrome_navigatable_set_breadcrumbs_path (FilesViewChromeNavigatable* self,
                                                         const gchar* newpath);
VALA_EXTERN gchar* files_view_chrome_navigatable_get_breadcrumbs_path (FilesViewChromeNavigatable* self,
                                                           gboolean include_file_protocol);
VALA_EXTERN void files_view_chrome_navigatable_set_action_icon_tooltip (FilesViewChromeNavigatable* self,
                                                            const gchar* tip);
VALA_EXTERN void files_view_chrome_navigatable_hide_action_icon (FilesViewChromeNavigatable* self);
VALA_EXTERN void files_view_chrome_navigatable_set_entry_text (FilesViewChromeNavigatable* self,
                                                   const gchar* txt);
VALA_EXTERN void files_view_chrome_navigatable_reset (FilesViewChromeNavigatable* self);
VALA_EXTERN void files_view_chrome_navigatable_set_animation_visible (FilesViewChromeNavigatable* self,
                                                          gboolean visible);
VALA_EXTERN void files_view_chrome_navigatable_set_placeholder (FilesViewChromeNavigatable* self,
                                                    const gchar* placeholder);
VALA_EXTERN void files_view_chrome_navigatable_show_default_action_icon (FilesViewChromeNavigatable* self);
VALA_EXTERN void files_view_chrome_navigatable_set_default_action_icon_tooltip (FilesViewChromeNavigatable* self);
VALA_EXTERN gchar* files_view_chrome_navigatable_get_entry_text (FilesViewChromeNavigatable* self);
VALA_EXTERN gint files_view_chrome_navigatable_get_minimum_width (FilesViewChromeNavigatable* self);
VALA_EXTERN void files_view_chrome_navigatable_set_default_entry_tooltip (FilesViewChromeNavigatable* self);
VALA_EXTERN const gchar* files_view_chrome_navigatable_get_action_icon_name (FilesViewChromeNavigatable* self);
VALA_EXTERN void files_view_chrome_navigatable_set_action_icon_name (FilesViewChromeNavigatable* self,
                                                         const gchar* value);
VALA_EXTERN gboolean files_view_chrome_navigatable_get_hide_breadcrumbs (FilesViewChromeNavigatable* self);
VALA_EXTERN void files_view_chrome_navigatable_set_hide_breadcrumbs (FilesViewChromeNavigatable* self,
                                                         gboolean value);
VALA_EXTERN GType files_view_chrome_searchable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewChromeSearchable, g_object_unref)
VALA_EXTERN void files_view_chrome_searchable_cancel (FilesViewChromeSearchable* self);
VALA_EXTERN void files_view_chrome_searchable_search (FilesViewChromeSearchable* self,
                                          const gchar* txt,
                                          GFile* search_location);
VALA_EXTERN GType sidebar_sidebar_item_interface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarSidebarItemInterface, g_object_unref)
VALA_EXTERN GType sidebar_sidebar_list_interface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarSidebarListInterface, g_object_unref)
VALA_EXTERN void sidebar_sidebar_list_interface_select_item (SidebarSidebarListInterface* self,
                                                 GtkListBoxRow* item);
VALA_EXTERN void sidebar_sidebar_list_interface_unselect_all_items (SidebarSidebarListInterface* self);
VALA_EXTERN void sidebar_sidebar_list_interface_refresh (SidebarSidebarListInterface* self);
VALA_EXTERN void sidebar_sidebar_list_interface_refresh_info (SidebarSidebarListInterface* self);
VALA_EXTERN void sidebar_sidebar_list_interface_rename_bookmark_by_uri (SidebarSidebarListInterface* self,
                                                            const gchar* uri,
                                                            const gchar* new_name);
VALA_EXTERN void sidebar_sidebar_list_interface_open_item (SidebarSidebarListInterface* self,
                                               SidebarSidebarItemInterface* item,
                                               FilesOpenFlag flag);
VALA_EXTERN guint32 sidebar_sidebar_list_interface_add_plugin_item (SidebarSidebarListInterface* self,
                                                        FilesSidebarPluginItem* plugin_item);
VALA_EXTERN void sidebar_sidebar_list_interface_clear (SidebarSidebarListInterface* self);
VALA_EXTERN gboolean sidebar_sidebar_list_interface_has_uri (SidebarSidebarListInterface* self,
                                                 const gchar* uri,
                                                 GtkListBoxRow** row);
VALA_EXTERN gboolean sidebar_sidebar_list_interface_select_uri (SidebarSidebarListInterface* self,
                                                    const gchar* uri);
VALA_EXTERN gboolean sidebar_sidebar_list_interface_remove_item_by_id (SidebarSidebarListInterface* self,
                                                           guint32 id);
VALA_EXTERN gboolean sidebar_sidebar_list_interface_add_favorite (SidebarSidebarListInterface* self,
                                                      const gchar* uri,
                                                      const gchar* label,
                                                      gint index);
VALA_EXTERN SidebarSidebarItemInterface* sidebar_sidebar_list_interface_get_item_at_index (SidebarSidebarListInterface* self,
                                                                               gint index);
VALA_EXTERN gboolean sidebar_sidebar_list_interface_move_item_after (SidebarSidebarListInterface* self,
                                                         SidebarSidebarItemInterface* item,
                                                         gint target_index);
VALA_EXTERN gboolean sidebar_sidebar_list_interface_is_drop_target (SidebarSidebarListInterface* self);
VALA_EXTERN void sidebar_sidebar_list_interface_focus (SidebarSidebarListInterface* self);
VALA_EXTERN FilesSidebarInterface* sidebar_sidebar_list_interface_get_sidebar (SidebarSidebarListInterface* self);
VALA_EXTERN void sidebar_sidebar_list_interface_set_sidebar (SidebarSidebarListInterface* self,
                                                 FilesSidebarInterface* value);
VALA_EXTERN GtkListBox* sidebar_sidebar_list_interface_get_list_box (SidebarSidebarListInterface* self);
VALA_EXTERN void sidebar_sidebar_list_interface_set_list_box (SidebarSidebarListInterface* self,
                                                  GtkListBox* value);
VALA_EXTERN guint32 sidebar_sidebar_item_interface_row_id;
VALA_EXTERN GeeHashMap* sidebar_sidebar_item_interface_item_id_map;
VALA_EXTERN GMutex sidebar_sidebar_item_interface_item_map_lock;
VALA_EXTERN guint32 sidebar_sidebar_item_interface_get_next_item_id (void);
VALA_EXTERN SidebarSidebarItemInterface* sidebar_sidebar_item_interface_get_item (guint32 id);
VALA_EXTERN gint sidebar_sidebar_item_interface_get_index (SidebarSidebarItemInterface* self);
VALA_EXTERN void sidebar_sidebar_item_interface_destroy_bookmark (SidebarSidebarItemInterface* self);
VALA_EXTERN void sidebar_sidebar_item_interface_update_icon (SidebarSidebarItemInterface* self,
                                                 GIcon* icon);
VALA_EXTERN void sidebar_sidebar_item_interface_add_extra_menu_items (SidebarSidebarItemInterface* self,
                                                          GMenu* menu);
VALA_EXTERN void sidebar_sidebar_item_interface_update_plugin_data (SidebarSidebarItemInterface* self,
                                                        FilesSidebarPluginItem* item);
VALA_EXTERN void sidebar_sidebar_item_interface_activated (SidebarSidebarItemInterface* self,
                                               FilesOpenFlag flag);
VALA_EXTERN SidebarSidebarListInterface* sidebar_sidebar_item_interface_get_list (SidebarSidebarItemInterface* self);
VALA_EXTERN void sidebar_sidebar_item_interface_set_list (SidebarSidebarItemInterface* self,
                                              SidebarSidebarListInterface* value);
VALA_EXTERN guint32 sidebar_sidebar_item_interface_get_id (SidebarSidebarItemInterface* self);
VALA_EXTERN void sidebar_sidebar_item_interface_set_id (SidebarSidebarItemInterface* self,
                                            guint32 value);
VALA_EXTERN const gchar* sidebar_sidebar_item_interface_get_uri (SidebarSidebarItemInterface* self);
VALA_EXTERN void sidebar_sidebar_item_interface_set_uri (SidebarSidebarItemInterface* self,
                                             const gchar* value);
VALA_EXTERN const gchar* sidebar_sidebar_item_interface_get_custom_name (SidebarSidebarItemInterface* self);
VALA_EXTERN void sidebar_sidebar_item_interface_set_custom_name (SidebarSidebarItemInterface* self,
                                                     const gchar* value);
VALA_EXTERN GIcon* sidebar_sidebar_item_interface_get_gicon (SidebarSidebarItemInterface* self);
VALA_EXTERN void sidebar_sidebar_item_interface_set_gicon (SidebarSidebarItemInterface* self,
                                               GIcon* value);
VALA_EXTERN gboolean sidebar_sidebar_item_interface_get_pinned (SidebarSidebarItemInterface* self);
VALA_EXTERN void sidebar_sidebar_item_interface_set_pinned (SidebarSidebarItemInterface* self,
                                                gboolean value);
VALA_EXTERN gboolean sidebar_sidebar_item_interface_get_permanent (SidebarSidebarItemInterface* self);
VALA_EXTERN void sidebar_sidebar_item_interface_set_permanent (SidebarSidebarItemInterface* self,
                                                   gboolean value);
VALA_EXTERN gboolean sidebar_sidebar_item_interface_get_can_insert_before (SidebarSidebarItemInterface* self);
VALA_EXTERN void sidebar_sidebar_item_interface_set_can_insert_before (SidebarSidebarItemInterface* self,
                                                           gboolean value);
VALA_EXTERN gboolean sidebar_sidebar_item_interface_get_can_insert_after (SidebarSidebarItemInterface* self);
VALA_EXTERN void sidebar_sidebar_item_interface_set_can_insert_after (SidebarSidebarItemInterface* self,
                                                          gboolean value);
VALA_EXTERN GMenuModel* sidebar_sidebar_item_interface_get_menu_model (SidebarSidebarItemInterface* self);
VALA_EXTERN void sidebar_sidebar_item_interface_set_menu_model (SidebarSidebarItemInterface* self,
                                                    GMenuModel* value);
VALA_EXTERN GActionGroup* sidebar_sidebar_item_interface_get_action_group (SidebarSidebarItemInterface* self);
VALA_EXTERN void sidebar_sidebar_item_interface_set_action_group (SidebarSidebarItemInterface* self,
                                                      GActionGroup* value);
VALA_EXTERN const gchar* sidebar_sidebar_item_interface_get_action_group_namespace (SidebarSidebarItemInterface* self);
VALA_EXTERN void sidebar_sidebar_item_interface_set_action_group_namespace (SidebarSidebarItemInterface* self,
                                                                const gchar* value);
VALA_EXTERN GType files_view_chrome_basic_breadcrumbs_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewChromeBasicBreadcrumbsEntry, g_object_unref)
VALA_EXTERN GType files_view_chrome_breadcrumb_element_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewChromeBreadcrumbElement, g_object_unref)
VALA_EXTERN GType files_view_chrome_basic_breadcrumbs_entry_target_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* files_view_chrome_basic_breadcrumbs_entry_get_action_icon_tooltip (FilesViewChromeBasicBreadcrumbsEntry* self);
VALA_EXTERN void files_view_chrome_basic_breadcrumbs_entry_reset (FilesViewChromeBasicBreadcrumbsEntry* self);
VALA_EXTERN void files_view_chrome_basic_breadcrumbs_entry_hide_default_action_icon (FilesViewChromeBasicBreadcrumbsEntry* self);
VALA_EXTERN gboolean files_view_chrome_basic_breadcrumbs_entry_on_key_press_event (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                       guint keyval,
                                                                       guint keycode,
                                                                       GdkModifierType state);
VALA_EXTERN void files_view_chrome_basic_breadcrumbs_entry_on_button_pressed_event (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                        gint n_press,
                                                                        gdouble x,
                                                                        gdouble y);
VALA_EXTERN void files_view_chrome_basic_breadcrumbs_entry_on_button_released_event (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                         gint n_press,
                                                                         gdouble x,
                                                                         gdouble y);
VALA_EXTERN gboolean files_view_chrome_basic_breadcrumbs_entry_is_icon_event (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                  gdouble x);
VALA_EXTERN gboolean files_view_chrome_basic_breadcrumbs_entry_on_focus_out (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                 GdkEventFocus* event);
VALA_EXTERN gboolean files_view_chrome_basic_breadcrumbs_entry_on_focus_in (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                GdkEventFocus* event);
VALA_EXTERN void files_view_chrome_basic_breadcrumbs_entry_on_activate (FilesViewChromeBasicBreadcrumbsEntry* self);
VALA_EXTERN void files_view_chrome_basic_breadcrumbs_entry_on_entry_text_changed (FilesViewChromeBasicBreadcrumbsEntry* self);
VALA_EXTERN void files_view_chrome_basic_breadcrumbs_entry_go_up (FilesViewChromeBasicBreadcrumbsEntry* self);
VALA_EXTERN void files_view_chrome_basic_breadcrumbs_entry_set_entry_cursor (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                 const gchar* cursor_name);
VALA_EXTERN void files_view_chrome_basic_breadcrumbs_entry_set_default_entry_tooltip (FilesViewChromeBasicBreadcrumbsEntry* self);
VALA_EXTERN void files_view_chrome_basic_breadcrumbs_entry_reset_elements_states (FilesViewChromeBasicBreadcrumbsEntry* self);
VALA_EXTERN gdouble files_view_chrome_basic_breadcrumbs_entry_get_displayed_breadcrumbs_natural_width (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                                           GList** displayed_breadcrumbs);
VALA_EXTERN FilesViewChromeBreadcrumbElement* files_view_chrome_basic_breadcrumbs_entry_get_element_from_coordinates (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                                                          gdouble x);
VALA_EXTERN gchar* files_view_chrome_basic_breadcrumbs_entry_get_path_from_element (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                        FilesViewChromeBreadcrumbElement* el,
                                                                        gboolean include_file_protocol);
VALA_EXTERN gchar* files_view_chrome_basic_breadcrumbs_entry_get_first_element_icon_name (FilesViewChromeBasicBreadcrumbsEntry* self);
VALA_EXTERN FilesViewChromeBasicBreadcrumbsEntry* files_view_chrome_basic_breadcrumbs_entry_new (void);
VALA_EXTERN FilesViewChromeBasicBreadcrumbsEntry* files_view_chrome_basic_breadcrumbs_entry_construct (GType object_type);
VALA_EXTERN GType files_view_chrome_basic_location_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewChromeBasicLocationBar, g_object_unref)
VALA_EXTERN FilesViewChromeBasicLocationBar* files_view_chrome_basic_location_bar_new (FilesViewChromeNavigatable* _bread);
VALA_EXTERN FilesViewChromeBasicLocationBar* files_view_chrome_basic_location_bar_construct (GType object_type,
                                                                                 FilesViewChromeNavigatable* _bread);
VALA_EXTERN void files_view_chrome_basic_location_bar_connect_signals (FilesViewChromeBasicLocationBar* self);
VALA_EXTERN void files_view_chrome_basic_location_bar_after_bread_text_changed (FilesViewChromeBasicLocationBar* self,
                                                                    const gchar* txt);
VALA_EXTERN gboolean files_view_chrome_basic_location_bar_after_bread_focus_in_event (FilesViewChromeBasicLocationBar* self,
                                                                          GdkEventFocus* event);
VALA_EXTERN gboolean files_view_chrome_basic_location_bar_after_bread_focus_out_event (FilesViewChromeBasicLocationBar* self,
                                                                           GdkEventFocus* event);
VALA_EXTERN void files_view_chrome_basic_location_bar_on_bread_action_icon_press (FilesViewChromeBasicLocationBar* self);
VALA_EXTERN void files_view_chrome_basic_location_bar_on_bread_activate_path (FilesViewChromeBasicLocationBar* self,
                                                                  const gchar* path,
                                                                  FilesOpenFlag flag);
VALA_EXTERN void files_view_chrome_basic_location_bar_show_navigate_icon (FilesViewChromeBasicLocationBar* self);
VALA_EXTERN void files_view_chrome_basic_location_bar_hide_navigate_icon (FilesViewChromeBasicLocationBar* self);
VALA_EXTERN void files_view_chrome_basic_location_bar_show_breadcrumbs (FilesViewChromeBasicLocationBar* self);
VALA_EXTERN void files_view_chrome_basic_location_bar_set_display_path (FilesViewChromeBasicLocationBar* self,
                                                            const gchar* path);
VALA_EXTERN const gchar* files_view_chrome_basic_location_bar_get_displayed_path (FilesViewChromeBasicLocationBar* self);
VALA_EXTERN void files_view_chrome_basic_location_bar_set_displayed_path (FilesViewChromeBasicLocationBar* self,
                                                              const gchar* value);
VALA_EXTERN void files_view_chrome_basic_location_bar_set_with_animation (FilesViewChromeBasicLocationBar* self,
                                                              gboolean value);
VALA_EXTERN gboolean files_view_chrome_basic_location_bar_get_has_focus (FilesViewChromeBasicLocationBar* self);
VALA_EXTERN FilesViewChromeBreadcrumbElement* files_view_chrome_breadcrumb_element_new (const gchar* text_,
                                                                            GtkWidget* widget_,
                                                                            GtkStyleContext* button_context);
VALA_EXTERN FilesViewChromeBreadcrumbElement* files_view_chrome_breadcrumb_element_construct (GType object_type,
                                                                                  const gchar* text_,
                                                                                  GtkWidget* widget_,
                                                                                  GtkStyleContext* button_context);
VALA_EXTERN gpointer files_view_chrome_breadcrumb_icon_info_ref (gpointer instance);
VALA_EXTERN void files_view_chrome_breadcrumb_icon_info_unref (gpointer instance);
VALA_EXTERN GParamSpec* files_view_chrome_param_spec_breadcrumb_icon_info (const gchar* name,
                                                               const gchar* nick,
                                                               const gchar* blurb,
                                                               GType object_type,
                                                               GParamFlags flags);
VALA_EXTERN void files_view_chrome_value_set_breadcrumb_icon_info (GValue* value,
                                                       gpointer v_object);
VALA_EXTERN void files_view_chrome_value_take_breadcrumb_icon_info (GValue* value,
                                                        gpointer v_object);
VALA_EXTERN gpointer files_view_chrome_value_get_breadcrumb_icon_info (const GValue* value);
VALA_EXTERN GType files_view_chrome_breadcrumb_icon_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewChromeBreadcrumbIconInfo, files_view_chrome_breadcrumb_icon_info_unref)
VALA_EXTERN void files_view_chrome_breadcrumb_element_set_icon (FilesViewChromeBreadcrumbElement* self,
                                                    FilesViewChromeBreadcrumbIconInfo* icon_info);
VALA_EXTERN gdouble files_view_chrome_breadcrumb_element_draw (FilesViewChromeBreadcrumbElement* self,
                                                   cairo_t* cr,
                                                   gdouble x,
                                                   gdouble y,
                                                   gdouble height,
                                                   GtkWidget* widget);
VALA_EXTERN gchar* files_view_chrome_breadcrumb_element_get_icon_name (FilesViewChromeBreadcrumbElement* self);
VALA_EXTERN const gchar* files_view_chrome_breadcrumb_element_get_text (FilesViewChromeBreadcrumbElement* self);
VALA_EXTERN gdouble files_view_chrome_breadcrumb_element_get_natural_width (FilesViewChromeBreadcrumbElement* self);
VALA_EXTERN gdouble files_view_chrome_breadcrumb_element_get_real_width (FilesViewChromeBreadcrumbElement* self);
VALA_EXTERN const gchar* files_view_chrome_breadcrumb_element_get_text_for_display (FilesViewChromeBreadcrumbElement* self);
VALA_EXTERN void files_view_chrome_breadcrumb_element_set_text_for_display (FilesViewChromeBreadcrumbElement* self,
                                                                const gchar* value);
VALA_EXTERN FilesViewChromeBreadcrumbIconInfo* files_view_chrome_breadcrumb_icon_info_new_special_directory (const gchar* path,
                                                                                                 const gchar* icon_name);
VALA_EXTERN FilesViewChromeBreadcrumbIconInfo* files_view_chrome_breadcrumb_icon_info_construct_special_directory (GType object_type,
                                                                                                       const gchar* path,
                                                                                                       const gchar* icon_name);
VALA_EXTERN FilesViewChromeBreadcrumbIconInfo* files_view_chrome_breadcrumb_icon_info_new_protocol_directory (const gchar* scheme,
                                                                                                  const gchar* icon_name,
                                                                                                  const gchar* display_name);
VALA_EXTERN FilesViewChromeBreadcrumbIconInfo* files_view_chrome_breadcrumb_icon_info_construct_protocol_directory (GType object_type,
                                                                                                        const gchar* scheme,
                                                                                                        const gchar* icon_name,
                                                                                                        const gchar* display_name);
VALA_EXTERN FilesViewChromeBreadcrumbIconInfo* files_view_chrome_breadcrumb_icon_info_new_from_mount (GMount* mount);
VALA_EXTERN FilesViewChromeBreadcrumbIconInfo* files_view_chrome_breadcrumb_icon_info_construct_from_mount (GType object_type,
                                                                                                GMount* mount);
VALA_EXTERN GdkPixbuf* files_view_chrome_breadcrumb_icon_info_render_icon (FilesViewChromeBreadcrumbIconInfo* self,
                                                               GtkStyleContext* context);
VALA_EXTERN void files_view_chrome_breadcrumb_icon_info_set_path (FilesViewChromeBreadcrumbIconInfo* self,
                                                      const gchar* path);
VALA_EXTERN FilesViewChromeBreadcrumbIconInfo* files_view_chrome_breadcrumb_icon_info_new (void);
VALA_EXTERN FilesViewChromeBreadcrumbIconInfo* files_view_chrome_breadcrumb_icon_info_construct (GType object_type);
VALA_EXTERN GType files_view_chrome_breadcrumb_icon_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewChromeBreadcrumbIconList, g_object_unref)
VALA_EXTERN FilesViewChromeBreadcrumbIconList* files_view_chrome_breadcrumb_icon_list_new (GtkStyleContext* context);
VALA_EXTERN FilesViewChromeBreadcrumbIconList* files_view_chrome_breadcrumb_icon_list_construct (GType object_type,
                                                                                     GtkStyleContext* context);
VALA_EXTERN void files_view_chrome_breadcrumb_icon_list_add_mounted_volumes (FilesViewChromeBreadcrumbIconList* self);
VALA_EXTERN void files_view_chrome_breadcrumb_icon_list_truncate_to_length (FilesViewChromeBreadcrumbIconList* self,
                                                                gint new_length);
VALA_EXTERN gint files_view_chrome_breadcrumb_icon_list_length (FilesViewChromeBreadcrumbIconList* self);
VALA_EXTERN GeeArrayList* files_view_chrome_breadcrumb_icon_list_get_list (FilesViewChromeBreadcrumbIconList* self);
VALA_EXTERN GtkStyleContext* files_view_chrome_breadcrumb_icon_list_get_context (FilesViewChromeBreadcrumbIconList* self);
VALA_EXTERN gint files_view_chrome_breadcrumb_icon_list_get_scale (FilesViewChromeBreadcrumbIconList* self);
VALA_EXTERN void files_view_chrome_breadcrumb_icon_list_set_scale (FilesViewChromeBreadcrumbIconList* self,
                                                       gint value);
VALA_EXTERN GType files_view_chrome_button_with_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewChromeButtonWithMenu, g_object_unref)
VALA_EXTERN FilesViewChromeButtonWithMenu* files_view_chrome_button_with_menu_new (const gchar* icon_name);
VALA_EXTERN FilesViewChromeButtonWithMenu* files_view_chrome_button_with_menu_construct (GType object_type,
                                                                             const gchar* icon_name);
VALA_EXTERN void files_view_chrome_button_with_menu_popup_menu (FilesViewChromeButtonWithMenu* self);
VALA_EXTERN void files_view_chrome_button_with_menu_set_menu (FilesViewChromeButtonWithMenu* self,
                                                  GMenu* value);
VALA_EXTERN GType files_view_chrome_view_switcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewChromeViewSwitcher, g_object_unref)
VALA_EXTERN FilesViewChromeViewSwitcher* files_view_chrome_view_switcher_new (GSimpleAction* view_mode_action);
VALA_EXTERN FilesViewChromeViewSwitcher* files_view_chrome_view_switcher_construct (GType object_type,
                                                                        GSimpleAction* view_mode_action);
VALA_EXTERN void files_view_chrome_view_switcher_set_mode (FilesViewChromeViewSwitcher* self,
                                               guint32 mode);
VALA_EXTERN GSimpleAction* files_view_chrome_view_switcher_get_action (FilesViewChromeViewSwitcher* self);

VALA_EXTERN const gchar* FILES_PREFERENCES_TAGS_COLORS[12];
VALA_EXTERN const gchar* FILES_SKIP_IMAGES[3];

G_END_DECLS

#endif
