/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXFloatingPoint;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.latex.datatool.CurrencyContentCommand;
import com.dickimawbooks.texparserlib.latex.datatool.DataRealElement;
import com.dickimawbooks.texparserlib.latex.datatool.DatumType;
import java.io.IOException;

public class DataCurrencyElement
extends DataRealElement {
    private TeXObject symbol;

    public DataCurrencyElement(TeXObject teXObject) {
        this(teXObject, 0.0);
    }

    public DataCurrencyElement(TeXObject teXObject, TeXNumber teXNumber) {
        this(teXObject, teXNumber.doubleValue());
    }

    public DataCurrencyElement(TeXObject teXObject, Number number) {
        this(teXObject, number.doubleValue());
    }

    public DataCurrencyElement(TeXObject teXObject, double d) {
        super(d);
        this.symbol = teXObject;
    }

    public DataCurrencyElement(TeXObject teXObject, double d, TeXObject teXObject2) {
        super(d, teXObject2);
        this.symbol = teXObject;
    }

    @Override
    public Object clone() {
        return new DataCurrencyElement((TeXObject)this.symbol.clone(), this.doubleValue(), this.original == null ? null : (TeXObject)this.original.clone());
    }

    @Override
    public byte getDataType() {
        return 3;
    }

    @Override
    public DatumType getDatumType() {
        return DatumType.CURRENCY;
    }

    @Override
    public ControlSequence createControlSequence(String string) {
        return new CurrencyContentCommand(string, (TeXObject)this.symbol.clone(), this.doubleValue());
    }

    @Override
    public TeXObject getContent(TeXParser teXParser) {
        if (this.original == null) {
            TeXObjectList teXObjectList = teXParser.getListener().createString(String.format("%.2f", this.doubleValue()));
            teXObjectList.push((TeXObject)this.symbol.clone());
            return teXObjectList;
        }
        return this.original;
    }

    @Override
    public TeXObject getCurrencySymbol() {
        return this.getSymbol();
    }

    public TeXObject getSymbol() {
        return this.symbol;
    }

    @Override
    public String toString(TeXParser teXParser) {
        if (this.original == null) {
            return String.format("%s%.2f", this.symbol.toString(teXParser), this.doubleValue());
        }
        return this.original.toString(teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.original != null) {
            return super.expandonce(teXParser, teXObjectList);
        }
        TeXParserListener teXParserListener = teXParser.getListener();
        TeXObjectList teXObjectList2 = teXParserListener.createStack();
        teXObjectList2.add(teXParserListener.getControlSequence("DTLfmtcurrency"));
        Group group = teXParserListener.createGroup();
        group.add(this.symbol, true);
        teXObjectList2.add(group);
        group = teXParserListener.createGroup();
        teXObjectList2.add(group);
        group.add(teXParserListener.getControlSequence("__texparser_fmt_currency_value:n"));
        group.add(new TeXFloatingPoint(this.doubleValue()));
        return teXObjectList2;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.expandonce(teXParser).process(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.expandonce(teXParser, teXObjectList).process(teXParser, teXObjectList);
    }

    @Override
    public String toString() {
        return String.format("%s[symbol=%s,value=%f,original=%s]", this.getClass().getSimpleName(), this.symbol, this.value, this.original);
    }
}

