/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.openide.explorer.ExplorerActionsImpl;
import org.openide.explorer.Bundle;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.io.SafeException;

public final class ExplorerManager
implements Serializable,
Cloneable {
    static final long serialVersionUID = -4330330689803575792L;
    public static final String PROP_ROOT_CONTEXT = "rootContext";
    public static final String PROP_EXPLORED_CONTEXT = "exploredContext";
    public static final String PROP_SELECTED_NODES = "selectedNodes";
    public static final String PROP_NODE_CHANGE = "nodeChange";
    static RequestProcessor selectionProcessor;
    private static final int SELECTION_SYNC_DELAY = 200;
    private static final ObjectStreamField[] serialPersistentFields;
    private transient VetoableChangeSupport vetoableSupport;
    private transient PropertyChangeSupport propertySupport;
    private Node rootContext;
    private Node exploredContext;
    private Node[] selectedNodes;
    private transient Listener listener;
    private transient NodeListener weakListener;
    private RequestProcessor.Task selectionSyncTask;
    private ExplorerActionsImpl actions;
    private transient Object LOCK;
    static boolean SCHEDULE_REMOVE_ASYNCH;

    public ExplorerManager() {
        this.init();
    }

    private void init() {
        this.exploredContext = this.rootContext = Node.EMPTY;
        this.selectedNodes = new Node[0];
        this.listener = new Listener();
        this.weakListener = NodeOp.weakNodeListener((NodeListener)this.listener, null);
        this.LOCK = new Object();
    }

    public ExplorerManager clone() {
        ExplorerManager explorerManager = new ExplorerManager();
        explorerManager.rootContext = this.rootContext;
        explorerManager.exploredContext = this.exploredContext;
        explorerManager.selectedNodes = this.selectedNodes;
        return explorerManager;
    }

    public Node[] getSelectedNodes() {
        return this.selectedNodes;
    }

    private boolean equalNodes(Node[] nodeArray, Node[] nodeArray2) {
        int n;
        if (!Arrays.equals(nodeArray, nodeArray2)) {
            return false;
        }
        if (nodeArray == null || nodeArray.length == 0) {
            return true;
        }
        for (n = 0; n < nodeArray.length && Arrays.equals(NodeOp.createPath((Node)nodeArray[n], null), NodeOp.createPath((Node)nodeArray2[n], null)); ++n) {
        }
        return n == nodeArray.length;
    }

    public final void setSelectedNodes(final Node[] nodeArray) throws PropertyVetoException {
        class AtomicSetSelectedNodes
        implements Runnable {
            public PropertyVetoException veto;
            private boolean doFire;
            private Node[] oldValue;
            private Node[] newValue;

            AtomicSetSelectedNodes() {
            }

            private void checkAndSet() {
                if (nodeArray == null) {
                    throw new IllegalArgumentException(Bundle.EXC_NodeCannotBeNull());
                }
                if (ExplorerManager.this.equalNodes(nodeArray, ExplorerManager.this.selectedNodes)) {
                    return;
                }
                ArrayList<Node> arrayList = null;
                for (int i = 0; i < nodeArray.length; ++i) {
                    if (nodeArray[i] == null) {
                        throw new IllegalArgumentException(Bundle.EXC_NoElementOfNodeSelectionMayBeNull());
                    }
                    if (!ExplorerManager.this.isUnderRoot(nodeArray[i])) {
                        if (arrayList != null) continue;
                        arrayList = new ArrayList<Node>(nodeArray.length);
                        for (int j = 0; j < i; ++j) {
                            arrayList.add(nodeArray[j]);
                        }
                        continue;
                    }
                    if (arrayList == null) continue;
                    arrayList.add(nodeArray[i]);
                }
                if (arrayList != null) {
                    this.newValue = arrayList.toArray(new Node[0]);
                    if (ExplorerManager.this.equalNodes(this.newValue, ExplorerManager.this.selectedNodes)) {
                        return;
                    }
                } else {
                    this.newValue = nodeArray;
                }
                if (this.newValue.length != 0 && ExplorerManager.this.vetoableSupport != null) {
                    try {
                        ExplorerManager.this.vetoableSupport.fireVetoableChange(ExplorerManager.PROP_SELECTED_NODES, ExplorerManager.this.selectedNodes, this.newValue);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        this.veto = propertyVetoException;
                        return;
                    }
                }
                this.updateSelection();
            }

            private void updateSelection() {
                this.oldValue = ExplorerManager.this.selectedNodes;
                ExplorerManager.this.addRemoveListeners(false);
                ExplorerManager.access$002(ExplorerManager.this, this.newValue);
                ExplorerManager.this.addRemoveListeners(true);
                this.doFire = true;
            }

            public void fire() {
                if (this.doFire) {
                    ExplorerManager.this.fireInAWT(ExplorerManager.PROP_SELECTED_NODES, this.oldValue, ExplorerManager.this.selectedNodes);
                }
            }

            @Override
            public void run() {
                this.checkAndSet();
            }
        }
        AtomicSetSelectedNodes atomicSetSelectedNodes = new AtomicSetSelectedNodes();
        Children.MUTEX.readAccess((Runnable)atomicSetSelectedNodes);
        atomicSetSelectedNodes.fire();
        if (atomicSetSelectedNodes.veto != null) {
            throw atomicSetSelectedNodes.veto;
        }
    }

    public final Node getExploredContext() {
        return this.exploredContext;
    }

    public final void setExploredContext(Node node) {
        this.setExploredContext(node, new Node[0]);
    }

    public final void setExploredContext(final Node node, final Node[] nodeArray) {
        class SetExploredContext
        implements Runnable {
            boolean doFire;
            Node oldValue;

            SetExploredContext() {
            }

            @Override
            public void run() {
                if (Utilities.compareObjects((Object)node, (Object)ExplorerManager.this.exploredContext)) {
                    ExplorerManager.this.setSelectedNodes0(nodeArray);
                    return;
                }
                ExplorerManager.this.checkUnderRoot(node);
                ExplorerManager.this.setSelectedNodes0(nodeArray);
                this.oldValue = ExplorerManager.this.exploredContext;
                ExplorerManager.this.addRemoveListeners(false);
                ExplorerManager.this.exploredContext = node;
                ExplorerManager.this.addRemoveListeners(true);
                this.doFire = true;
            }

            public void fire() {
                if (this.doFire) {
                    ExplorerManager.this.fireInAWT(ExplorerManager.PROP_EXPLORED_CONTEXT, this.oldValue, node);
                }
            }
        }
        SetExploredContext setExploredContext = new SetExploredContext();
        Children.MUTEX.readAccess((Runnable)setExploredContext);
        setExploredContext.fire();
    }

    public final void setExploredContextAndSelection(final Node node, final Node[] nodeArray) throws PropertyVetoException {
        class SetExploredContextAndSelection
        implements Runnable {
            public PropertyVetoException veto;
            private boolean doFire;
            private Object oldValue;

            SetExploredContextAndSelection() {
            }

            @Override
            public void run() {
                try {
                    if (Utilities.compareObjects((Object)node, (Object)ExplorerManager.this.exploredContext)) {
                        ExplorerManager.this.setSelectedNodes(nodeArray);
                        return;
                    }
                    ExplorerManager.this.checkUnderRoot(node);
                    ExplorerManager.this.setSelectedNodes(nodeArray);
                    this.oldValue = ExplorerManager.this.exploredContext;
                    ExplorerManager.this.addRemoveListeners(false);
                    ExplorerManager.this.exploredContext = node;
                    ExplorerManager.this.addRemoveListeners(true);
                    this.doFire = true;
                }
                catch (PropertyVetoException propertyVetoException) {
                    this.veto = propertyVetoException;
                }
            }

            public void fire() {
                if (this.doFire) {
                    ExplorerManager.this.fireInAWT(ExplorerManager.PROP_EXPLORED_CONTEXT, this.oldValue, ExplorerManager.this.exploredContext);
                }
            }
        }
        SetExploredContextAndSelection setExploredContextAndSelection = new SetExploredContextAndSelection();
        Children.MUTEX.readAccess((Runnable)setExploredContextAndSelection);
        setExploredContextAndSelection.fire();
        if (setExploredContextAndSelection.veto != null) {
            throw setExploredContextAndSelection.veto;
        }
    }

    final void addRemoveListeners(boolean bl) {
        IdentityHashMap identityHashMap = new IdentityHashMap(333);
        this.collectNodes(this.exploredContext, identityHashMap);
        for (Node node : this.selectedNodes) {
            this.collectNodes(node, identityHashMap);
        }
        for (Node node : identityHashMap.keySet()) {
            if (bl) {
                node.addNodeListener(this.weakListener);
                continue;
            }
            node.removeNodeListener(this.weakListener);
        }
    }

    private final void collectNodes(Node node, Map<Node, ?> map) {
        assert (Children.MUTEX.isReadAccess());
        while (node != null && node != this.rootContext) {
            map.put(node, null);
            node = node.getParentNode();
        }
    }

    final void setSelectedNodes0(Node[] nodeArray) {
        try {
            this.setSelectedNodes(nodeArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public final Node getRootContext() {
        return this.rootContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRootContext(final Node node) {
        if (node == null) {
            throw new IllegalArgumentException(Bundle.EXC_CannotHaveNullRootContext());
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.rootContext.equals((Object)node)) {
                return;
            }
        }
        class SetRootContext
        implements Runnable {
            SetRootContext() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ExplorerManager.this.LOCK;
                synchronized (object) {
                    if (ExplorerManager.this.rootContext.equals((Object)node)) {
                        return;
                    }
                    ExplorerManager.this.addRemoveListeners(false);
                    Node node2 = ExplorerManager.this.rootContext;
                    ExplorerManager.this.rootContext = node;
                    node2.removeNodeListener(ExplorerManager.this.weakListener);
                    ExplorerManager.this.rootContext.addNodeListener(ExplorerManager.this.weakListener);
                    ExplorerManager.this.fireInAWT(ExplorerManager.PROP_ROOT_CONTEXT, node2, ExplorerManager.this.rootContext);
                    Node[] nodeArray = ExplorerManager.this.getSelectedNodes();
                    if (!ExplorerManager.this.areUnderTarget(nodeArray, ExplorerManager.this.rootContext)) {
                        nodeArray = new Node[]{};
                    }
                    ExplorerManager.this.setExploredContext(ExplorerManager.this.rootContext, nodeArray);
                }
            }
        }
        object = new SetRootContext();
        Children.MUTEX.readAccess((Runnable)object);
    }

    private boolean areUnderTarget(Node[] nodeArray, Node node) {
        block0: for (int i = 0; i < nodeArray.length; ++i) {
            for (Node node2 = nodeArray[i]; node2 != null; node2 = node2.getParentNode()) {
                if (node2.equals((Object)node)) continue block0;
            }
            return false;
        }
        return true;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertySupport == null) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertySupport != null) {
            this.propertySupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableSupport == null) {
            this.vetoableSupport = new VetoableChangeSupport(this);
        }
        this.vetoableSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableSupport != null) {
            this.vetoableSupport.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    private boolean isUnderRoot(Node node) {
        while (node != null) {
            if (node.equals((Object)this.rootContext)) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }

    private void checkUnderRoot(Node node) {
        if (node != null && !this.isUnderRoot(node)) {
            Logger.getLogger(ExplorerManager.class.getName()).log(Level.WARNING, "Explored context not under root: {0}---{1}; ROOT: {2}---{3}", new Object[]{node.getDisplayName(), node, this.rootContext.getDisplayName(), this.rootContext});
            throw new IllegalArgumentException(Bundle.EXC_ContextMustBeWithinRootContext(node.getDisplayName(), this.rootContext.getDisplayName()));
        }
    }

    final void waitFinished() {
        if (this.selectionSyncTask != null) {
            this.selectionSyncTask.waitFinished();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this);
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        Node.Handle handle = this.rootContext.getHandle();
        putField.put("root", handle);
        putField.put("rootName", this.rootContext.getDisplayName());
        if (handle != null) {
            String[] stringArray = this.exploredContext == null ? null : (this.isUnderRoot(this.exploredContext) ? NodeOp.createPath((Node)this.exploredContext, (Node)this.rootContext) : null);
            putField.put("explored", stringArray);
            LinkedList<String[]> linkedList = new LinkedList<String[]>();
            for (int i = 0; i < this.selectedNodes.length; ++i) {
                if (!this.isUnderRoot(this.selectedNodes[i])) continue;
                linkedList.add(NodeOp.createPath((Node)this.selectedNodes[i], (Node)this.rootContext));
            }
            putField.put("selected", linkedList.toArray());
        }
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.init();
        Object object = objectInputStream.readObject();
        if (object != this) {
            this.readObjectOld((Node.Handle)object, objectInputStream);
            return;
        }
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Node.Handle handle = (Node.Handle)getField.get("root", null);
        String string = (String)getField.get("rootName", null);
        if (handle == null) {
            throw new SafeException((Exception)new IOException("Could not restore Explorer window; the root node \"" + string + "\" is not persistent; override Node.getHandle to fix"));
        }
        String[] stringArray = (String[])getField.get("explored", null);
        Object[] objectArray = (Object[])getField.get("selected", null);
        try {
            Node node = handle.getNode();
            if (node == null) {
                throw new IOException("Node.Handle.getNode (for " + string + ") should not return null");
            }
            this.restoreSelection(node, stringArray, Arrays.asList(objectArray));
        }
        catch (IOException iOException) {
            SafeException safeException = new SafeException((Exception)iOException);
            if (!Utilities.compareObjects((Object)iOException.getMessage(), (Object)iOException.getLocalizedMessage())) {
                Exceptions.attachLocalizedMessage((Throwable)safeException, (String)Bundle.EXC_handle_failed(string));
            }
            throw safeException;
        }
    }

    private void readObjectOld(Node.Handle handle, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Node node;
        if (handle == null) {
            return;
        }
        String[] stringArray = (String[])objectInputStream.readObject();
        String[] stringArray2 = (String[])objectInputStream.readObject();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        while ((node = (Node)objectInputStream.readObject()) != null) {
            linkedList.add(node);
        }
        node = ExplorerManager.findPath(handle.getNode(), stringArray);
        this.restoreSelection(node, stringArray2, linkedList);
    }

    private void restoreSelection(final Node node, final String[] stringArray, final List<?> list) {
        this.setRootContext(node);
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                ArrayList<Node> arrayList = new ArrayList<Node>(list.size());
                for (Object e : list) {
                    arrayList.add(ExplorerManager.findPath(node, (String[])e));
                }
                Node[] nodeArray = arrayList.toArray(new Node[0]);
                if (stringArray != null) {
                    ExplorerManager.this.setExploredContext(ExplorerManager.findPath(node, stringArray), nodeArray);
                } else {
                    ExplorerManager.this.setSelectedNodes0(nodeArray);
                }
            }
        });
    }

    public static ExplorerManager find(Component component) {
        do {
            if ((component = component.getParent()) != null) continue;
            return new ExplorerManager();
        } while (!(component instanceof Provider));
        return ((Provider)((Object)component)).getExplorerManager();
    }

    static Node findPath(Node node, String[] stringArray) {
        try {
            return NodeOp.findPath((Node)node, (String[])stringArray);
        }
        catch (NodeNotFoundException nodeNotFoundException) {
            return nodeNotFoundException.getClosestNode();
        }
    }

    static synchronized RequestProcessor getSelectionProcessor() {
        if (selectionProcessor == null) {
            selectionProcessor = new RequestProcessor("ExplorerManager-selection");
        }
        return selectionProcessor;
    }

    static synchronized ExplorerActionsImpl findExplorerActionsImpl(ExplorerManager explorerManager) {
        assert (explorerManager != null);
        if (explorerManager.actions == null) {
            explorerManager.actions = new ExplorerActionsImpl();
            explorerManager.actions.attach(explorerManager);
        }
        return explorerManager.actions;
    }

    final void fireInAWT(final String string, final Object object, final Object object2) {
        if (this.propertySupport != null) {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    ExplorerManager.this.propertySupport.firePropertyChange(string, object, object2);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void waitActionsFinished() {
        Class<ExplorerManager> clazz = ExplorerManager.class;
        synchronized (ExplorerManager.class) {
            ExplorerActionsImpl explorerActionsImpl = this.actions;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (explorerActionsImpl != null) {
                explorerActionsImpl.waitFinished();
            }
            return;
        }
    }

    static /* synthetic */ Node[] access$002(ExplorerManager explorerManager, Node[] nodeArray) {
        explorerManager.selectedNodes = nodeArray;
        return nodeArray;
    }

    static {
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("root", Node.Handle.class), new ObjectStreamField("rootName", String.class), new ObjectStreamField("explored", String[].class), new ObjectStreamField("selected", Object[].class)};
        SCHEDULE_REMOVE_ASYNCH = true;
    }

    private class Listener
    extends NodeAdapter
    implements Runnable {
        Collection<Node> removeList = new HashSet<Node>();

        Listener() {
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
            if (nodeEvent.getNode().equals((Object)ExplorerManager.this.getRootContext())) {
                ExplorerManager.this.setRootContext(Node.EMPTY);
            } else {
                final Node node = nodeEvent.getNode();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Listener.this.scheduleRemove(node);
                    }
                };
                if (SCHEDULE_REMOVE_ASYNCH) {
                    SwingUtilities.invokeLater(runnable);
                } else {
                    runnable.run();
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ExplorerManager.this.fireInAWT(ExplorerManager.PROP_NODE_CHANGE, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleRemove(Node node) {
            Object object = ExplorerManager.this;
            synchronized (object) {
                if (ExplorerManager.this.selectionSyncTask == null) {
                    ExplorerManager.this.selectionSyncTask = ExplorerManager.getSelectionProcessor().create((Runnable)this);
                } else {
                    ExplorerManager.this.selectionSyncTask.cancel();
                }
            }
            object = this;
            synchronized (object) {
                this.removeList.add(node);
            }
            ExplorerManager.this.selectionSyncTask.schedule(200);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Node node;
            Object object;
            Collection<Node> collection;
            if (!Children.MUTEX.isReadAccess()) {
                Children.MUTEX.readAccess((Runnable)this);
                return;
            }
            Object object2 = this;
            synchronized (object2) {
                collection = this.removeList;
                this.removeList = new HashSet<Node>();
            }
            if (!ExplorerManager.this.isUnderRoot(ExplorerManager.this.exploredContext)) {
                ExplorerManager.this.setExploredContext(ExplorerManager.this.rootContext);
                return;
            }
            object2 = new LinkedList<Node>(Arrays.asList(ExplorerManager.this.getSelectedNodes()));
            Iterator<Node> iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!((LinkedList)object2).contains(object)) continue;
                node = (Node)((LinkedList)object2).get(((LinkedList)object2).indexOf(object));
                if (Arrays.equals(NodeOp.createPath((Node)object, null), NodeOp.createPath((Node)node, null)) && !this.isInParentChildren((Node)object)) continue;
                iterator.remove();
            }
            ((AbstractCollection)object2).removeAll(collection);
            object = ((AbstractSequentialList)object2).iterator();
            while (object.hasNext()) {
                node = (Node)object.next();
                if (ExplorerManager.this.isUnderRoot(node)) continue;
                object.remove();
            }
            object = ((LinkedList)object2).toArray(new Node[0]);
            ExplorerManager.this.setSelectedNodes0((Node[])object);
        }

        private boolean isInParentChildren(Node node) {
            Node node2 = node.getParentNode();
            return node2 != null && Arrays.asList(node2.getChildren().getNodes()).contains(node);
        }
    }

    public static interface Provider {
        public ExplorerManager getExplorerManager();
    }
}

