# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_wpaperctl_global_optspecs
	string join \n h/help V/version
end

function __fish_wpaperctl_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_wpaperctl_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_wpaperctl_using_subcommand
	set -l cmd (__fish_wpaperctl_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -s h -l help -d 'Print help'
complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -s V -l version -d 'Print version'
complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -f -a "get-wallpaper"
complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -f -a "get"
complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -f -a "all-wallpapers"
complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -f -a "get-all"
complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -f -a "next-wallpaper"
complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -f -a "next"
complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -f -a "previous-wallpaper"
complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -f -a "previous"
complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -f -a "reload-wallpaper"
complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -f -a "reload"
complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -f -a "pause-wallpaper"
complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -f -a "pause"
complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -f -a "resume-wallpaper"
complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -f -a "resume"
complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -f -a "toggle-pause-wallpaper"
complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -f -a "toggle-pause"
complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -f -a "get-status"
complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -f -a "status"
complete -c wpaperctl -n "__fish_wpaperctl_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand get-wallpaper" -s h -l help -d 'Print help'
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand get" -s h -l help -d 'Print help'
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand all-wallpapers" -s j -l json
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand all-wallpapers" -s h -l help -d 'Print help'
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand get-all" -s j -l json
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand get-all" -s h -l help -d 'Print help'
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand next-wallpaper" -s h -l help -d 'Print help'
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand next" -s h -l help -d 'Print help'
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand previous-wallpaper" -s h -l help -d 'Print help'
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand previous" -s h -l help -d 'Print help'
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand reload-wallpaper" -s h -l help -d 'Print help'
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand reload" -s h -l help -d 'Print help'
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand pause-wallpaper" -s h -l help -d 'Print help'
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand pause" -s h -l help -d 'Print help'
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand resume-wallpaper" -s h -l help -d 'Print help'
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand resume" -s h -l help -d 'Print help'
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand toggle-pause-wallpaper" -s h -l help -d 'Print help'
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand toggle-pause" -s h -l help -d 'Print help'
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand get-status" -s j -l json
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand get-status" -s h -l help -d 'Print help'
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand status" -s j -l json
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand status" -s h -l help -d 'Print help'
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand help; and not __fish_seen_subcommand_from get-wallpaper all-wallpapers next-wallpaper previous-wallpaper reload-wallpaper pause-wallpaper resume-wallpaper toggle-pause-wallpaper get-status help" -f -a "get-wallpaper"
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand help; and not __fish_seen_subcommand_from get-wallpaper all-wallpapers next-wallpaper previous-wallpaper reload-wallpaper pause-wallpaper resume-wallpaper toggle-pause-wallpaper get-status help" -f -a "all-wallpapers"
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand help; and not __fish_seen_subcommand_from get-wallpaper all-wallpapers next-wallpaper previous-wallpaper reload-wallpaper pause-wallpaper resume-wallpaper toggle-pause-wallpaper get-status help" -f -a "next-wallpaper"
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand help; and not __fish_seen_subcommand_from get-wallpaper all-wallpapers next-wallpaper previous-wallpaper reload-wallpaper pause-wallpaper resume-wallpaper toggle-pause-wallpaper get-status help" -f -a "previous-wallpaper"
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand help; and not __fish_seen_subcommand_from get-wallpaper all-wallpapers next-wallpaper previous-wallpaper reload-wallpaper pause-wallpaper resume-wallpaper toggle-pause-wallpaper get-status help" -f -a "reload-wallpaper"
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand help; and not __fish_seen_subcommand_from get-wallpaper all-wallpapers next-wallpaper previous-wallpaper reload-wallpaper pause-wallpaper resume-wallpaper toggle-pause-wallpaper get-status help" -f -a "pause-wallpaper"
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand help; and not __fish_seen_subcommand_from get-wallpaper all-wallpapers next-wallpaper previous-wallpaper reload-wallpaper pause-wallpaper resume-wallpaper toggle-pause-wallpaper get-status help" -f -a "resume-wallpaper"
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand help; and not __fish_seen_subcommand_from get-wallpaper all-wallpapers next-wallpaper previous-wallpaper reload-wallpaper pause-wallpaper resume-wallpaper toggle-pause-wallpaper get-status help" -f -a "toggle-pause-wallpaper"
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand help; and not __fish_seen_subcommand_from get-wallpaper all-wallpapers next-wallpaper previous-wallpaper reload-wallpaper pause-wallpaper resume-wallpaper toggle-pause-wallpaper get-status help" -f -a "get-status"
complete -c wpaperctl -n "__fish_wpaperctl_using_subcommand help; and not __fish_seen_subcommand_from get-wallpaper all-wallpapers next-wallpaper previous-wallpaper reload-wallpaper pause-wallpaper resume-wallpaper toggle-pause-wallpaper get-status help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
