﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lexv2-models/LexModelsV2Request.h>
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>

#include <utility>

namespace Aws {
namespace LexModelsV2 {
namespace Model {

/**
 */
class DescribeTestSetRequest : public LexModelsV2Request {
 public:
  AWS_LEXMODELSV2_API DescribeTestSetRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeTestSet"; }

  AWS_LEXMODELSV2_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The test set Id for the test set request.</p>
   */
  inline const Aws::String& GetTestSetId() const { return m_testSetId; }
  inline bool TestSetIdHasBeenSet() const { return m_testSetIdHasBeenSet; }
  template <typename TestSetIdT = Aws::String>
  void SetTestSetId(TestSetIdT&& value) {
    m_testSetIdHasBeenSet = true;
    m_testSetId = std::forward<TestSetIdT>(value);
  }
  template <typename TestSetIdT = Aws::String>
  DescribeTestSetRequest& WithTestSetId(TestSetIdT&& value) {
    SetTestSetId(std::forward<TestSetIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_testSetId;
  bool m_testSetIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
