#!/bin/bash
# vim: set tabstop=8 shiftwidth=4 softtabstop=4 expandtab smarttab colorcolumn=80:
#
# Copyright (c) 2016 Red Hat, Inc.
# Author: Nathaniel McCallum <npmccallum@redhat.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

depends() {
    echo clevis network
    return 0
}

have_tang_bindings() {
    . clevis-luks-common-functions
    local dev
    for dev in $(clevis_devices_to_unlock "list-open-devices"); do
        if clevis luks list -d "${dev}" | grep -q tang; then
            return 0
        fi
    done
    return 1
}

install() {
    if [ "${hostonly_cmdline}" = "yes" ] && have_tang_bindings; then
        echo "rd.neednet=1" > "${initdir}/etc/cmdline.d/99clevis-pin-tang.conf"
    fi

    inst_multiple \
	clevis-decrypt-tang \
	curl
}
