/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.data.hints;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractValueBindingDescriptor<TYPE, CONTEXT>
extends AbstractDescriptor {
    private static final Log log = Log.getLog(AbstractValueBindingDescriptor.class);
    public static final String TAG_SUPPORTS = "supports";
    private static final String ATTR_KIND = "kind";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_TYPE_NAME = "typeName";
    private static final String ATTR_DATA_SOURCE = "dataSource";
    private static final String ATTR_EXTENSION = "extension";
    private final String id;
    private final String description;
    protected AbstractDescriptor.ObjectType implType;
    protected final List<SupportInfo> supportInfos = new ArrayList<SupportInfo>();
    private TYPE instance;

    public AbstractValueBindingDescriptor(IConfigurationElement config) {
        super(config);
        IConfigurationElement[] typeElements;
        this.id = config.getAttribute("id");
        this.description = config.getAttribute("description");
        this.implType = (AbstractDescriptor)this.new AbstractDescriptor.ObjectType(config.getAttribute("class"));
        IConfigurationElement[] iConfigurationElementArray = typeElements = config.getChildren(TAG_SUPPORTS);
        int n = typeElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement typeElement = iConfigurationElementArray[n2];
            this.supportInfos.add(new SupportInfo(typeElement));
            ++n2;
        }
    }

    protected abstract Class<TYPE> getImplClass();

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    @NotNull
    public TYPE getInstance() {
        if (this.instance == null) {
            try {
                this.instance = this.implType.createInstance(this.getImplClass());
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't instantiate value manager '" + this.getId() + "'", e);
            }
        }
        return this.instance;
    }

    public boolean isEnabled(DBSTypedObject typedObject, CONTEXT context, boolean checkConfigDisable) {
        return true;
    }

    public boolean supportsType(@NotNull CONTEXT context, @Nullable DBPDataSource dataSource, DBSTypedObject typedObject, Class<?> valueType, boolean checkDataSource, boolean checkType) {
        if (!this.isEnabled(typedObject, context, true)) {
            return false;
        }
        DBPDataKind dataKind = typedObject.getDataKind();
        for (SupportInfo info : this.supportInfos) {
            DBSDataType dataType;
            if (dataSource == null || info.dataSource == null ? checkDataSource : !this.supportsAnyProvider(dataSource, info)) continue;
            if (info.typeName != null) {
                String actualTypeName;
                String typeName = info.typeName.toLowerCase(Locale.ROOT);
                if (typeName.equalsIgnoreCase(actualTypeName = typedObject.getTypeName().toLowerCase(Locale.ROOT))) {
                    return true;
                }
                if (typeName.endsWith("*") && actualTypeName.startsWith(typeName.substring(0, typeName.length() - 1))) {
                    return true;
                }
            }
            if (info.valueType != null && valueType != null) {
                if (info.valueType.matchesType(valueType) && info.dataKind == null || info.dataKind == dataKind) {
                    return true;
                }
            } else if (checkType) continue;
            if (info.dataKind != null && info.dataKind == dataKind) {
                return true;
            }
            if (info.extension != null && (dataType = DBUtils.getDataType(typedObject)) != null && CommonUtils.equalObjects((Object)info.extension, (Object)CommonUtils.toString((Object)dataType.geTypeExtension()))) {
                return true;
            }
            if (checkType || info.valueType != null || info.dataKind != null || info.typeName != null || info.extension != null) continue;
            return true;
        }
        return false;
    }

    private boolean supportsAnyProvider(@NotNull DBPDataSource dataSource, SupportInfo info) {
        DBPDataSourceProviderDescriptor provider = dataSource.getContainer().getDriver().getProviderDescriptor();
        while (provider != null) {
            if (info.dataSource.equals(provider.getId()) || info.dataSource.equals(dataSource.getClass().getName())) {
                return true;
            }
            provider = provider.getParentProvider();
        }
        return false;
    }

    public boolean supportsAnyType(@NotNull CONTEXT context, @Nullable DBPDataSource dataSource, DBSTypedObject typedObject, Class<?> valueType) {
        if (!this.isEnabled(typedObject, context, false)) {
            return false;
        }
        if (this.supportInfos.isEmpty()) {
            return true;
        }
        DBPDataKind dataKind = typedObject.getDataKind();
        for (SupportInfo info : this.supportInfos) {
            DBSDataType dataType;
            if (dataSource != null && info.dataSource != null && !this.supportsAnyProvider(dataSource, info)) {
                return false;
            }
            if (info.typeName != null && info.typeName.equalsIgnoreCase(typedObject.getTypeName())) {
                return true;
            }
            if (info.valueType != null && valueType != null && info.valueType.matchesType(valueType) && (info.dataKind == null || info.dataKind == dataKind)) {
                return true;
            }
            if (info.dataKind != null && info.dataKind == dataKind) {
                return true;
            }
            if (info.extension != null && (dataType = DBUtils.getDataType(typedObject)) != null && CommonUtils.equalObjects((Object)info.extension, (Object)CommonUtils.toString((Object)dataType.geTypeExtension()))) {
                return true;
            }
            if (info.valueType != null || info.dataKind != null || info.typeName != null || info.extension != null) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.id;
    }

    protected class SupportInfo {
        String typeName;
        DBPDataKind dataKind;
        AbstractDescriptor.ObjectType valueType;
        String extension;
        String dataSource;

        public SupportInfo(IConfigurationElement cfg) {
            String kindName = cfg.getAttribute(AbstractValueBindingDescriptor.ATTR_KIND);
            String typeName = cfg.getAttribute(AbstractValueBindingDescriptor.ATTR_TYPE_NAME);
            String className = cfg.getAttribute(AbstractValueBindingDescriptor.ATTR_TYPE);
            String ext = cfg.getAttribute(AbstractValueBindingDescriptor.ATTR_EXTENSION);
            String dspId = cfg.getAttribute(AbstractValueBindingDescriptor.ATTR_DATA_SOURCE);
            if (!(CommonUtils.isEmpty((String)kindName) && CommonUtils.isEmpty((String)typeName) && CommonUtils.isEmpty((String)className) && CommonUtils.isEmpty((String)dspId) && CommonUtils.isEmpty((String)ext))) {
                if (!CommonUtils.isEmpty((String)kindName)) {
                    try {
                        this.dataKind = DBPDataKind.valueOf(kindName);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        log.warn("Bad data kind: " + kindName);
                    }
                }
                if (!CommonUtils.isEmpty((String)typeName)) {
                    this.typeName = typeName;
                }
                if (!CommonUtils.isEmpty((String)className)) {
                    this.valueType = new AbstractDescriptor.ObjectType(cfg, AbstractValueBindingDescriptor.ATTR_TYPE);
                }
                if (!CommonUtils.isEmpty((String)ext)) {
                    this.extension = ext;
                }
                if (!CommonUtils.isEmpty((String)dspId)) {
                    this.dataSource = dspId;
                }
            }
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            if (this.valueType != null) {
                str.append("valueType=").append(this.valueType.getImplName()).append("; ");
            }
            if (this.typeName != null) {
                str.append("typeName=").append(this.typeName).append(";");
            }
            if (this.dataKind != null) {
                str.append("dataKind=").append((Object)this.dataKind).append(";");
            }
            if (this.extension != null) {
                str.append("extension=").append(this.extension).append(";");
            }
            if (this.dataSource != null) {
                str.append("dataSource=").append(this.dataSource).append(";");
            }
            return str.toString();
        }
    }
}

