/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;

public class ObjectContext<T>
implements JexlContext,
JexlContext.NamespaceResolver {
    private final JexlEngine jexl;
    private final T object;

    public ObjectContext(JexlEngine engine, T wrapped) {
        this.jexl = engine;
        this.object = wrapped;
    }

    @Override
    public Object get(String name) {
        return this.jexl.getProperty(this.object, name);
    }

    @Override
    public void set(String name, Object value) {
        this.jexl.setProperty(this.object, name, value);
    }

    @Override
    public boolean has(String name) {
        return this.jexl.getUberspect().getPropertyGet(this.object, name) != null;
    }

    @Override
    public Object resolveNamespace(String name) {
        if (name == null || name.isEmpty()) {
            return this.object;
        }
        return null;
    }
}

