/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file.spreadsheet.process;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.EdgeDirection;
import org.gephi.io.importer.api.EdgeDirectionDefault;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.plugin.file.spreadsheet.process.AbstractImportProcess;
import org.gephi.io.importer.plugin.file.spreadsheet.process.SpreadsheetGeneralConfiguration;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetParser;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetRow;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;

public class ImportEdgesProcess
extends AbstractImportProcess {
    public static final String EDGE_SOURCE = "source";
    public static final String EDGE_TARGET = "target";
    public static final String EDGE_TYPE = "type";
    public static final String EDGE_KIND = "kind";
    public static final String EDGE_ID = "id";
    public static final String EDGE_LABEL = "label";

    public ImportEdgesProcess(SpreadsheetGeneralConfiguration generalConfig, SheetParser parser, ContainerLoader container, ProgressTicket progressTicket) throws IOException {
        super(generalConfig, container, progressTicket, parser);
        this.init();
    }

    private void init() {
        this.container.setAllowAutoNode(true);
        this.container.setAllowParallelEdge(true);
        this.container.setAllowSelfLoop(true);
        this.container.setEdgeDefault(EdgeDirectionDefault.MIXED);
    }

    @Override
    public boolean execute() {
        this.setupColumnsIndexesAndFindSpecialColumns(Arrays.asList(EDGE_SOURCE, EDGE_TARGET, EDGE_TYPE, EDGE_KIND, EDGE_ID, EDGE_LABEL), this.generalConfig.getColumnsClasses());
        Integer sourceColumnIndex = (Integer)this.specialColumnsIndexMap.get(EDGE_SOURCE);
        Integer targetColumnIndex = (Integer)this.specialColumnsIndexMap.get(EDGE_TARGET);
        Integer typeColumnIndex = (Integer)this.specialColumnsIndexMap.get(EDGE_TYPE);
        Integer kindColumnIndex = (Integer)this.specialColumnsIndexMap.get(EDGE_KIND);
        Integer idColumnIndex = (Integer)this.specialColumnsIndexMap.get(EDGE_ID);
        Integer labelColumnIndex = (Integer)this.specialColumnsIndexMap.get(EDGE_LABEL);
        Progress.start((ProgressTicket)this.progressTicket);
        for (SheetRow row : this.parser) {
            EdgeDraft edge;
            String type;
            if (this.cancel) break;
            if (!this.checkRow(row)) continue;
            String source = null;
            String target = null;
            String id = null;
            String label = null;
            EdgeDirection direction = EdgeDirection.DIRECTED;
            String kind = null;
            if (sourceColumnIndex != null) {
                source = row.get(sourceColumnIndex);
            }
            if (targetColumnIndex != null) {
                target = row.get(targetColumnIndex);
            }
            if (typeColumnIndex != null && "undirected".equalsIgnoreCase(type = row.get(typeColumnIndex))) {
                direction = EdgeDirection.UNDIRECTED;
            }
            if (kindColumnIndex != null) {
                kind = row.get(kindColumnIndex);
            }
            if (idColumnIndex != null) {
                id = row.get(idColumnIndex);
            }
            if (labelColumnIndex != null) {
                label = row.get(labelColumnIndex);
            }
            EdgeDraft edgeDraft = edge = id != null ? this.container.factory().newEdgeDraft(id) : this.container.factory().newEdgeDraft();
            if (label != null) {
                edge.setLabel(label);
            }
            if (source == null || target == null) {
                this.logError(this.getMessage("ImportEdgesProcess.error.noSourceOrTargetData"));
                continue;
            }
            if (!this.container.nodeExists(source)) {
                this.container.addNode(this.container.factory().newNodeDraft(source));
            }
            if (!this.container.nodeExists(target)) {
                this.container.addNode(this.container.factory().newNodeDraft(target));
            }
            edge.setSource(this.container.getNode(source));
            edge.setTarget(this.container.getNode(target));
            edge.setDirection(direction);
            if (kind != null) {
                edge.setType((Object)kind);
            }
            for (Map.Entry columnEntry : this.headersIndexMap.entrySet()) {
                Object value;
                String column = (String)columnEntry.getKey();
                Integer index = (Integer)columnEntry.getValue();
                Class type2 = (Class)this.headersClassMap.get(column);
                if (type2 == null || (value = row.get(index)) == null || (value = this.parseValue((String)value, type2, column)) == null) continue;
                if (column.equalsIgnoreCase("weight") && value instanceof Number) {
                    edge.setWeight(((Number)value).doubleValue());
                    continue;
                }
                edge.setValue(column, value);
            }
            this.container.addEdge(edge);
        }
        Progress.finish((ProgressTicket)this.progressTicket);
        return !this.cancel;
    }

    @Override
    protected void addColumn(String name, Class type) {
        this.container.addEdgeColumn(name, type);
    }
}

