/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.IOException;
import java.net.MalformedURLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import joptsimple.OptionParser;
import joptsimple.OptionSpec;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.TerseException;

public class JmxTool {
    public static void main(String[] args) {
        try {
            JmxToolOptions options = new JmxToolOptions(args);
            if (CommandLineUtils.isPrintHelpNeeded((CommandDefaultOptions)options)) {
                CommandLineUtils.printUsageAndExit((OptionParser)options.parser, (String)"Dump JMX values to standard output.");
                return;
            }
            if (CommandLineUtils.isPrintVersionNeeded((CommandDefaultOptions)options)) {
                CommandLineUtils.printVersionAndExit();
                return;
            }
            Optional<String[]> attributesInclude = options.attributesInclude();
            Optional<DateFormat> dateFormat = options.dateFormat();
            String reportFormat = options.parseFormat();
            boolean keepGoing = true;
            MBeanServerConnection conn = JmxTool.connectToBeanServer(options);
            List<ObjectName> queries = options.queries();
            boolean hasPatternQueries = queries.stream().filter(Objects::nonNull).anyMatch(ObjectName::isPattern);
            Set<ObjectName> found = JmxTool.findObjects(options, conn, queries, hasPatternQueries);
            Map<ObjectName, Integer> numExpectedAttributes = JmxTool.findNumExpectedAttributes(conn, attributesInclude, hasPatternQueries, queries, found);
            ArrayList<String> keys = new ArrayList<String>();
            keys.add("time");
            keys.addAll(new TreeSet<String>(JmxTool.queryAttributes(conn, found, attributesInclude).keySet()));
            JmxTool.maybePrintCsvHeader(reportFormat, keys, numExpectedAttributes);
            while (keepGoing) {
                long start = System.currentTimeMillis();
                Map<String, Object> attributes = JmxTool.queryAttributes(conn, found, attributesInclude);
                attributes.put("time", dateFormat.isPresent() ? dateFormat.get().format(new Date()) : String.valueOf(System.currentTimeMillis()));
                JmxTool.maybePrintDataRows(reportFormat, numExpectedAttributes, keys, attributes);
                if (options.isOneTime()) {
                    keepGoing = false;
                    continue;
                }
                TimeUnit.MILLISECONDS.sleep(Math.max(0L, (long)options.interval() - (System.currentTimeMillis() - start)));
            }
            Exit.exit((int)0);
        }
        catch (TerseException e) {
            System.err.println(e.getMessage());
            Exit.exit((int)1);
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.err.println(Utils.stackTrace((Throwable)e));
            Exit.exit((int)1);
        }
    }

    private static String mkString(Stream<Object> stream, String delimiter) {
        return stream.filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(delimiter));
    }

    private static int sumValues(Map<ObjectName, Integer> numExpectedAttributes) {
        return numExpectedAttributes.values().stream().mapToInt(Integer::intValue).sum();
    }

    private static String[] attributesNames(MBeanInfo mBeanInfo) {
        return (String[])Arrays.stream(mBeanInfo.getAttributes()).map(MBeanFeatureInfo::getName).toArray(String[]::new);
    }

    private static MBeanServerConnection connectToBeanServer(JmxToolOptions options) throws Exception {
        MBeanServerConnection serverConn = null;
        boolean connected = false;
        long connectTimeoutMs = 10000L;
        long connectTestStarted = System.currentTimeMillis();
        do {
            try {
                System.err.printf("Trying to connect to JMX url: %s%n", options.jmxServiceURL());
                HashMap<String, Object> env = new HashMap<String, Object>();
                if (options.hasJmxSslEnableOpt()) {
                    env.put("com.sun.jndi.rmi.factory.socket", new SslRMIClientSocketFactory());
                }
                if (options.hasJmxAuthPropOpt()) {
                    env.put("jmx.remote.credentials", options.credentials());
                }
                JMXConnector connector = JMXConnectorFactory.connect(options.jmxServiceURL(), env);
                serverConn = connector.getMBeanServerConnection();
                connected = true;
            }
            catch (Exception e) {
                System.err.printf("Could not connect to JMX url: %s. Exception: %s.%n", options.jmxServiceURL(), e.getMessage());
                e.printStackTrace();
                TimeUnit.MILLISECONDS.sleep(100L);
            }
        } while (System.currentTimeMillis() - connectTestStarted < connectTimeoutMs && !connected);
        if (!connected) {
            throw new TerseException(String.format("Could not connect to JMX url %s after %d ms.", options.jmxServiceURL(), connectTimeoutMs));
        }
        return serverConn;
    }

    private static Set<ObjectName> findObjects(JmxToolOptions options, MBeanServerConnection conn, List<ObjectName> queries, boolean hasPatternQueries) throws Exception {
        long waitTimeoutMs = 10000L;
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        HashSet<ObjectName> querySet = new HashSet<ObjectName>(queries);
        BiPredicate<Set, Set> foundAllObjects = Set::equals;
        long start = System.currentTimeMillis();
        do {
            if (!result.isEmpty()) {
                System.err.println("Could not find all object names, retrying");
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            result.addAll(JmxTool.queryObjects(conn, queries));
        } while (!hasPatternQueries && options.hasWait() && System.currentTimeMillis() - start < waitTimeoutMs && !foundAllObjects.test(querySet, result));
        if (!hasPatternQueries && options.hasWait() && !foundAllObjects.test(querySet, result)) {
            querySet.removeAll(result);
            String missing = JmxTool.mkString(querySet.stream().map(Object::toString), ",");
            throw new TerseException(String.format("Could not find all requested object names after %d ms. Missing %s", waitTimeoutMs, missing));
        }
        return result;
    }

    private static Set<ObjectName> queryObjects(MBeanServerConnection conn, List<ObjectName> queries) {
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        queries.forEach(name -> {
            try {
                result.addAll(conn.queryNames((ObjectName)name, null));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return result;
    }

    private static Map<ObjectName, Integer> findNumExpectedAttributes(MBeanServerConnection conn, Optional<String[]> attributesInclude, boolean hasPatternQueries, List<ObjectName> queries, Set<ObjectName> found) throws Exception {
        HashMap<ObjectName, Integer> result = new HashMap<ObjectName, Integer>();
        if (attributesInclude.isEmpty()) {
            found.forEach(objectName -> {
                try {
                    MBeanInfo mBeanInfo = conn.getMBeanInfo((ObjectName)objectName);
                    result.put((ObjectName)objectName, conn.getAttributes((ObjectName)objectName, JmxTool.attributesNames(mBeanInfo)).size());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        } else if (hasPatternQueries) {
            found.forEach(objectName -> {
                try {
                    MBeanInfo mBeanInfo = conn.getMBeanInfo((ObjectName)objectName);
                    AttributeList attributes = conn.getAttributes((ObjectName)objectName, JmxTool.attributesNames(mBeanInfo));
                    ArrayList expectedAttributes = new ArrayList();
                    attributes.asList().forEach(attribute -> {
                        if (Arrays.asList((String[])attributesInclude.get()).contains(attribute.getName())) {
                            expectedAttributes.add(objectName);
                        }
                    });
                    if (expectedAttributes.size() > 0) {
                        result.put((ObjectName)objectName, expectedAttributes.size());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        } else {
            found.forEach(objectName -> result.put((ObjectName)objectName, ((String[])attributesInclude.get()).length));
        }
        if (result.isEmpty()) {
            throw new TerseException(String.format("No matched attributes for the queried objects %s.", queries));
        }
        return result;
    }

    private static Map<String, Object> queryAttributes(MBeanServerConnection conn, Set<ObjectName> objectNames, Optional<String[]> attributesInclude) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (ObjectName objectName : objectNames) {
            MBeanInfo beanInfo = conn.getMBeanInfo(objectName);
            AttributeList attributes = conn.getAttributes(objectName, (String[])Arrays.stream(beanInfo.getAttributes()).map(a -> a.getName()).toArray(String[]::new));
            for (Attribute attribute : attributes.asList()) {
                if (attributesInclude.isPresent()) {
                    if (!Arrays.asList(attributesInclude.get()).contains(attribute.getName())) continue;
                    result.put(String.format("%s:%s", objectName.toString(), attribute.getName()), attribute.getValue());
                    continue;
                }
                result.put(String.format("%s:%s", objectName.toString(), attribute.getName()), attribute.getValue());
            }
        }
        return result;
    }

    private static void maybePrintCsvHeader(String reportFormat, List<String> keys, Map<ObjectName, Integer> numExpectedAttributes) {
        if (reportFormat.equals("original") && keys.size() == JmxTool.sumValues(numExpectedAttributes) + 1) {
            System.out.println(JmxTool.mkString(keys.stream().map(key -> String.format("\"%s\"", key)), ","));
        }
    }

    private static void maybePrintDataRows(String reportFormat, Map<ObjectName, Integer> numExpectedAttributes, List<String> keys, Map<String, Object> attributes) {
        if (attributes.size() == JmxTool.sumValues(numExpectedAttributes) + 1) {
            switch (reportFormat) {
                case "properties": {
                    keys.forEach(key -> System.out.printf("%s=%s%n", key, attributes.get(key)));
                    break;
                }
                case "csv": {
                    keys.forEach(key -> System.out.printf("%s,\"%s\"%n", key, attributes.get(key)));
                    break;
                }
                case "tsv": {
                    keys.forEach(key -> System.out.printf("%s\t%s%n", key, attributes.get(key)));
                    break;
                }
                default: {
                    System.out.println(JmxTool.mkString(keys.stream().map(attributes::get), ","));
                }
            }
        }
    }

    private static class JmxToolOptions
    extends CommandDefaultOptions {
        private final OptionSpec<String> objectNameOpt;
        private final OptionSpec<String> attributesOpt;
        private final OptionSpec<Integer> reportingIntervalOpt;
        private final OptionSpec<Boolean> oneTimeOpt;
        private final OptionSpec<String> dateFormatOpt;
        private final OptionSpec<String> jmxServiceUrlOpt;
        private final OptionSpec<String> reportFormatOpt;
        private final OptionSpec<String> jmxAuthPropOpt;
        private final OptionSpec<Boolean> jmxSslEnableOpt;
        private final OptionSpec<Void> waitOpt;

        public JmxToolOptions(String[] args) {
            super(args);
            this.objectNameOpt = this.parser.accepts("object-name", "A JMX object name to use as a query. This can contain wild cards, and this option can be given multiple times to specify more than one query. If no objects are specified all objects will be queried.").withRequiredArg().describedAs("name").ofType(String.class);
            this.attributesOpt = this.parser.accepts("attributes", "The list of attributes to include in the query. This is a comma-separated list. If no attributes are specified all objects will be queried.").withRequiredArg().describedAs("name").ofType(String.class);
            this.reportingIntervalOpt = this.parser.accepts("reporting-interval", "Interval in MS with which to poll jmx stats; default value is 2 seconds. Value of -1 equivalent to setting one-time to true").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)2000, (Object[])new Integer[0]);
            this.oneTimeOpt = this.parser.accepts("one-time", "Flag to indicate run once only.").withOptionalArg().describedAs("one-time").ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]);
            this.dateFormatOpt = this.parser.accepts("date-format", "The date format to use for formatting the time field. See java.text.SimpleDateFormat for options.").withRequiredArg().describedAs("format").ofType(String.class);
            this.jmxServiceUrlOpt = this.parser.accepts("jmx-url", "The url to connect to poll JMX data. See Oracle javadoc for JMXServiceURL for details.").withRequiredArg().describedAs("service-url").ofType(String.class).defaultsTo((Object)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (Object[])new String[0]);
            this.reportFormatOpt = this.parser.accepts("report-format", "output format name: either 'original', 'properties', 'csv', 'tsv' ").withRequiredArg().describedAs("report-format").ofType(String.class).defaultsTo((Object)"original", (Object[])new String[0]);
            this.jmxAuthPropOpt = this.parser.accepts("jmx-auth-prop", "A mechanism to pass property in the form 'username=password' when enabling remote JMX with password authentication.").withRequiredArg().describedAs("jmx-auth-prop").ofType(String.class);
            this.jmxSslEnableOpt = this.parser.accepts("jmx-ssl-enable", "Flag to enable remote JMX with SSL.").withRequiredArg().describedAs("ssl-enable").ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]);
            this.waitOpt = this.parser.accepts("wait", "Wait for requested JMX objects to become available before starting output. Only supported when the list of objects is non-empty and contains no object name patterns.");
            this.options = this.parser.parse(args);
        }

        public JMXServiceURL jmxServiceURL() throws MalformedURLException {
            return new JMXServiceURL((String)this.options.valueOf(this.jmxServiceUrlOpt));
        }

        public int interval() {
            return (Integer)this.options.valueOf(this.reportingIntervalOpt);
        }

        public boolean isOneTime() {
            return this.interval() < 0 || this.options.has(this.oneTimeOpt);
        }

        public Optional<String[]> attributesInclude() {
            if (this.options.has(this.attributesOpt)) {
                String[] attributes = (String[])((Stream)Arrays.stream(((String)this.options.valueOf(this.attributesOpt)).split(",")).sequential()).filter(s -> !s.isEmpty()).toArray(String[]::new);
                return Optional.of(attributes);
            }
            return Optional.empty();
        }

        public Optional<DateFormat> dateFormat() {
            return this.options.has(this.dateFormatOpt) ? Optional.of(new SimpleDateFormat((String)this.options.valueOf(this.dateFormatOpt))) : Optional.empty();
        }

        public boolean hasWait() {
            return this.options.has(this.waitOpt);
        }

        private String parseFormat() {
            String reportFormat = ((String)this.options.valueOf(this.reportFormatOpt)).toLowerCase(Locale.ROOT);
            return Arrays.asList("properties", "csv", "tsv").contains(reportFormat) ? reportFormat : "original";
        }

        public boolean hasJmxAuthPropOpt() {
            return this.options.has(this.jmxAuthPropOpt);
        }

        public boolean hasJmxSslEnableOpt() {
            return this.options.has(this.jmxSslEnableOpt);
        }

        public String[] credentials() {
            return ((String)this.options.valueOf(this.jmxAuthPropOpt)).split("=", 2);
        }

        public List<ObjectName> queries() {
            if (this.options.has(this.objectNameOpt)) {
                return this.options.valuesOf(this.objectNameOpt).stream().map(s -> {
                    try {
                        return new ObjectName((String)s);
                    }
                    catch (MalformedObjectNameException e) {
                        throw new RuntimeException(e);
                    }
                }).collect(Collectors.toList());
            }
            ArrayList<ObjectName> listWithNull = new ArrayList<ObjectName>();
            listWithNull.add(null);
            return listWithNull;
        }
    }
}

