/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.key;

import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.util.Objects;
import org.wildfly.security.key.RawPrivateKey;

class RawECPrivateKey
extends RawPrivateKey
implements ECPrivateKey,
PrivateKey {
    private static final long serialVersionUID = -7911268659221164137L;
    private final BigInteger s;
    private final ECParameterSpec params;

    RawECPrivateKey(ECPrivateKey original) {
        super(original);
        this.s = original.getS();
        this.params = original.getParams();
    }

    RawECPrivateKey(Key original) {
        this((ECPrivateKey)original);
    }

    @Override
    public BigInteger getS() {
        return this.s;
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    @Override
    boolean isEqual(Key key) {
        return key instanceof ECPrivateKey && this.isEqual((ECPrivateKey)key);
    }

    boolean isEqual(ECPrivateKey key) {
        return super.isEqual(key) && Objects.equals(this.s, key.getS()) && Objects.equals(this.params, key.getParams());
    }
}

