/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import org.junit.Assert;
import org.junit.Test;
import org.languagetool.AnalyzedToken;

public class AnalyzedTokenTest {
    @Test
    public void testToString() {
        AnalyzedToken testToken = new AnalyzedToken("word", "POS", "lemma");
        Assert.assertEquals((Object)"lemma/POS", (Object)testToken.toString());
        Assert.assertEquals((Object)"lemma", (Object)testToken.getLemma());
        AnalyzedToken testToken2 = new AnalyzedToken("word", "POS", null);
        Assert.assertEquals((Object)"word/POS", (Object)testToken2.toString());
        Assert.assertEquals(null, (Object)testToken2.getLemma());
        Assert.assertEquals((Object)"word", (Object)testToken2.getToken());
    }

    @Test
    public void testMatches() {
        AnalyzedToken testToken1 = new AnalyzedToken("word", "POS", "lemma");
        Assert.assertFalse((boolean)testToken1.matches(new AnalyzedToken("", null, null)));
        Assert.assertTrue((boolean)testToken1.matches(new AnalyzedToken("word", null, null)));
        Assert.assertTrue((boolean)testToken1.matches(new AnalyzedToken("word", "POS", null)));
        Assert.assertTrue((boolean)testToken1.matches(new AnalyzedToken("word", "POS", "lemma")));
        Assert.assertFalse((boolean)testToken1.matches(new AnalyzedToken("word", "POS1", "lemma")));
        Assert.assertFalse((boolean)testToken1.matches(new AnalyzedToken("word1", "POS", "lemma")));
        Assert.assertFalse((boolean)testToken1.matches(new AnalyzedToken("word", "POS", "lemma1")));
        Assert.assertTrue((boolean)testToken1.matches(new AnalyzedToken("", "POS", "lemma")));
        Assert.assertTrue((boolean)testToken1.matches(new AnalyzedToken("", null, "lemma")));
    }
}

