/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.ModelUtil;

public class SentenceModel
extends BaseModel {
    private static final String COMPONENT_NAME = "SentenceDetectorME";
    private static final String MAXENT_MODEL_ENTRY_NAME = "sent.model";

    public SentenceModel(String languageCode, MaxentModel sentModel, Map<String, String> manifestInfoEntries, SentenceDetectorFactory sdFactory) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries, sdFactory);
        this.artifactMap.put(MAXENT_MODEL_ENTRY_NAME, sentModel);
        this.checkArtifactMap();
    }

    public SentenceModel(String languageCode, MaxentModel sentModel, boolean useTokenEnd, Dictionary abbreviations, char[] eosCharacters, Map<String, String> manifestInfoEntries) {
        this(languageCode, sentModel, manifestInfoEntries, new SentenceDetectorFactory(languageCode, useTokenEnd, abbreviations, eosCharacters));
    }

    public SentenceModel(String languageCode, MaxentModel sentModel, boolean useTokenEnd, Dictionary abbreviations, char[] eosCharacters) {
        this(languageCode, sentModel, useTokenEnd, abbreviations, eosCharacters, null);
    }

    public SentenceModel(String languageCode, MaxentModel sentModel, boolean useTokenEnd, Dictionary abbreviations, Map<String, String> manifestInfoEntries) {
        this(languageCode, sentModel, useTokenEnd, abbreviations, null, manifestInfoEntries);
    }

    public SentenceModel(String languageCode, MaxentModel sentModel, boolean useTokenEnd, Dictionary abbreviations) {
        this(languageCode, sentModel, useTokenEnd, abbreviations, null, null);
    }

    public SentenceModel(InputStream in) throws IOException {
        super(COMPONENT_NAME, in);
    }

    public SentenceModel(File modelFile) throws IOException {
        super(COMPONENT_NAME, modelFile);
    }

    public SentenceModel(Path modelPath) throws IOException {
        this(modelPath.toFile());
    }

    public SentenceModel(URL modelURL) throws IOException {
        super(COMPONENT_NAME, modelURL);
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME) instanceof MaxentModel)) {
            throw new InvalidFormatException("Unable to find sent.model maxent model!");
        }
        if (!ModelUtil.validateOutcomes(this.getMaxentModel(), "s", "n")) {
            throw new InvalidFormatException("The maxent model is not compatible with the sentence detector!");
        }
    }

    public SentenceDetectorFactory getFactory() {
        return (SentenceDetectorFactory)this.toolFactory;
    }

    @Override
    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return SentenceDetectorFactory.class;
    }

    public MaxentModel getMaxentModel() {
        return (MaxentModel)this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME);
    }

    public Dictionary getAbbreviations() {
        if (this.getFactory() != null) {
            return this.getFactory().getAbbreviationDictionary();
        }
        return null;
    }

    public boolean useTokenEnd() {
        return this.getFactory() == null || this.getFactory().isUseTokenEnd();
    }

    public char[] getEosCharacters() {
        if (this.getFactory() != null) {
            return this.getFactory().getEOSCharacters();
        }
        return null;
    }
}

