/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.file;

final class PathUtils {
    private PathUtils() {
    }

    public static String protocol(String url) {
        int pos = url.indexOf(":");
        if (pos == -1) {
            return "";
        }
        return url.substring(0, pos).trim();
    }

    public static String basedir(String url) {
        String protocol = PathUtils.protocol(url);
        String retValue = null;
        retValue = protocol.length() > 0 ? url.substring(protocol.length() + 1) : url;
        if ((retValue = PathUtils.decode(retValue)).startsWith("//")) {
            if ((retValue = retValue.substring(2)).length() >= 2 && (retValue.charAt(1) == '|' || retValue.charAt(1) == ':')) {
                retValue = retValue.charAt(0) + ":" + retValue.substring(2);
            } else {
                int index = retValue.indexOf("/");
                if (index >= 0) {
                    retValue = retValue.substring(index + 1);
                }
                if (retValue.length() >= 2 && (retValue.charAt(1) == '|' || retValue.charAt(1) == ':')) {
                    retValue = retValue.charAt(0) + ":" + retValue.substring(2);
                } else if (index >= 0) {
                    retValue = "/" + retValue;
                }
            }
        }
        if (retValue.length() >= 2 && retValue.charAt(1) == '|') {
            retValue = retValue.charAt(0) + ":" + retValue.substring(2);
        }
        return retValue.trim();
    }

    static String decode(String url) {
        String decoded = url;
        if (url != null) {
            int pos = -1;
            while ((pos = decoded.indexOf(37, pos + 1)) >= 0) {
                if (pos + 2 >= decoded.length()) continue;
                String hexStr = decoded.substring(pos + 1, pos + 3);
                char ch = (char)Integer.parseInt(hexStr, 16);
                decoded = decoded.substring(0, pos) + ch + decoded.substring(pos + 3);
            }
        }
        return decoded;
    }
}

