/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import oracle.ons.ONS;
import oracle.ons.ONSException;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.FailoverEvent;
import oracle.ucp.common.FailoverEventHandlerTask;
import oracle.ucp.common.Failoverable;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.oracle.DataBasedConnectionAffinityCallback;
import oracle.ucp.jdbc.oracle.FailoverActionResult;
import oracle.ucp.jdbc.oracle.FailoverStatisticsAccumulator;
import oracle.ucp.jdbc.oracle.FailoverStatisticsCounters;
import oracle.ucp.jdbc.oracle.FailoverStatisticsItem;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask;
import oracle.ucp.jdbc.oracle.ONSRuntimeLBEventHandlerTask;
import oracle.ucp.jdbc.oracle.OracleConnectionAffinityContext;
import oracle.ucp.jdbc.oracle.OracleFailoverEvent;
import oracle.ucp.jdbc.oracle.OracleGravitateConnectionPoolTask;
import oracle.ucp.jdbc.oracle.OracleLoadBalancingEvent;
import oracle.ucp.jdbc.oracle.RACAffinityContext;
import oracle.ucp.jdbc.oracle.RACCallback;
import oracle.ucp.jdbc.oracle.RACCallbackGuard;
import oracle.ucp.jdbc.oracle.RACInstance;
import oracle.ucp.jdbc.oracle.RACInstanceImpl;
import oracle.ucp.jdbc.oracle.RACManager;
import oracle.ucp.jdbc.oracle.rlb.MetricsAccumulator;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfo;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfoList;
import oracle.ucp.routing.oracle.ShardManager;
import oracle.ucp.routing.oracle.ShardManagerImpl;
import oracle.ucp.util.ProlongedTask;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TimerManager;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

public class RACManagerImpl
implements RACManager,
Failoverable,
Diagnosable {
    static final String CLASS_NAME = RACManagerImpl.class.getName();
    private boolean m_isEntireServiceDownProcessed = false;
    private int m_cardinality = 0;
    private RACCallbackGuard m_cbk = null;
    private final ReentrantLock poolLock = new ReentrantLock();
    private final ReentrantLock failoverEventHandlerTaskLock = new ReentrantLock();
    private final ReentrantLock fcfProcessingInfoLock = new ReentrantLock();
    private final ReentrantLock fcfProcessingInfoProcessedOnlyLock = new ReentrantLock();
    private final ReentrantLock rlbEventHandlerTaskLock = new ReentrantLock();
    private final ReentrantLock gravitatePoolTaskLock = new ReentrantLock();
    private final FailoverStatisticsAccumulator eventAccumulator = new FailoverStatisticsAccumulator();
    private FailoverStatisticsItem currentEvent;
    public final MetricsAccumulator rlbMetricsAccumulator = new MetricsAccumulator();
    private int m_targetTearDownConnCount = 0;
    int m_tornDownConnCount = 0;
    int m_markedToCloseConnCount = 0;
    private int m_targetUpEventNewConnCount = 0;
    private int m_upEventNewConnCount = 0;
    final StringBuilder m_errorInfo = new StringBuilder(512);
    private ONSDatabaseEventHandlerTask m_failoverEventHandlerTask = null;
    private final OracleDatabaseInstanceInfoList m_dbInstanceInfoList;
    final AtomicReference<String> m_serviceName = new AtomicReference();
    private final AtomicReference<String> m_onsConfigurationString = new AtomicReference<String>("");
    private final int STARTED = 1;
    private final int STOPPED = 2;
    private int m_state = 2;
    private String m_fcfProcessingInfo = "";
    private String m_fcfProcessingInfoProcessedOnly = "";
    private final int ACTION_MARKDOWN = 100;
    private final int ACTION_CLEANUP = 200;
    private final BlockingQueue<OracleDatabaseInstanceInfo> m_instancesToGravitateQueue = new LinkedBlockingQueue<OracleDatabaseInstanceInfo>();
    private final Random m_rand = new Random(0L);
    private final AtomicReference<OracleGravitateConnectionPoolTask> m_gravitatePoolTask = new AtomicReference();
    private final AtomicBoolean m_gravitateTaskBusy = new AtomicBoolean();
    int[] m_mixTable;
    static final int MIX_TABLE_SIZE = 4096;
    static final int IRREDUCIBLE_POLYNOMIAL = 4105;
    static final int MIX_TABLE_GENERATOR = 3;
    private ONSRuntimeLBEventHandlerTask m_rlbEventHandlerTask = null;
    private final AtomicBoolean m_runtimeLoadBalancingEnabled = new AtomicBoolean();
    protected ConnectionAffinityCallback m_connectionAffinityCallback = null;
    private final Map<String, Boolean> m_affinityMap = Collections.synchronizedMap(new HashMap());
    protected final AtomicLong m_successfulAffinityBasedBorrowCount = new AtomicLong(0L);
    protected final AtomicLong m_failedAffinityBasedBorrowCount = new AtomicLong(0L);
    protected final AtomicLong m_successfulRCLBBasedBorrowCount = new AtomicLong(0L);
    protected final AtomicLong m_failedRCLBBasedBorrowCount = new AtomicLong(0L);
    private final AtomicBoolean m_rclbMetricsPolicyEnabled = new AtomicBoolean(false);
    private final AtomicInteger m_dbVersion = new AtomicInteger(0);
    private final TaskManager m_taskManager;
    private final TimerManager m_timerManager;
    private boolean olderWLSCompatible;
    private final boolean isStrictWSAffinity;
    private final boolean isStrictXAAffinity;
    protected ONS currentONS = null;
    protected boolean calledStartONS = false;
    private volatile Diagnosable diagnosticsCollector = DiagnosticsCollectorImpl.getCommon();

    RACManagerImpl(TaskManager taskMngr, TimerManager timerMngr, boolean isStrictWSAffinity, boolean isStrictXAAffinity, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        this.m_dbInstanceInfoList = new OracleDatabaseInstanceInfoList(this);
        this.m_taskManager = taskMngr;
        this.m_timerManager = timerMngr;
        this.isStrictWSAffinity = isStrictWSAffinity;
        this.isStrictXAAffinity = isStrictXAAffinity;
        this.diagnosticsCollector = Objects.requireNonNull(diagnosticsCollector);
        Util.disableDriverHA();
        Util.disableImplicitBeginRequest();
    }

    private boolean validateServiceEvent(OracleFailoverEvent failoverEvent) {
        String _svcName = failoverEvent.getServiceName();
        String _dbName = failoverEvent.getDbUniqueName();
        return _svcName != null && !_svcName.equals("") && _dbName != null && !_dbName.equals("");
    }

    private boolean validateHostDownEvent(OracleFailoverEvent failoverEvent) {
        String _hostName = failoverEvent.getHostName();
        return _hostName != null && !_hostName.equals("");
    }

    @Override
    public void handleFailoverEvent(FailoverEvent event) throws UniversalConnectionPoolException {
        if (event == null || !(event instanceof OracleFailoverEvent)) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(306);
        }
        OracleFailoverEvent failoverEvent = (OracleFailoverEvent)event;
        String status = failoverEvent.getStatus();
        String eventType = failoverEvent.getEventType();
        String serviceName = failoverEvent.getServiceName();
        String instanceName = failoverEvent.getInstanceName();
        String dbUniqueName = failoverEvent.getDbUniqueName();
        String hostName = failoverEvent.getHostName();
        String reason = failoverEvent.getReason();
        this.trace(Level.FINEST, CLASS_NAME, "handleFailoverEvent", "eventType: {0}, status = {1}", null, null, eventType, status);
        if (eventType.equals("database/event/service")) {
            if (status.equalsIgnoreCase("down") || status.equalsIgnoreCase("not_restarting") || status.equalsIgnoreCase("restart_failed")) {
                if (null == serviceName || !serviceName.equals(this.m_serviceName.get())) {
                    this.eventAccumulator.addItem(new FailoverStatisticsItem(FailoverStatisticsItem.Type.NOT_PROCESSED, serviceName, instanceName, dbUniqueName, hostName));
                    this.trace(Level.FINEST, CLASS_NAME, "handleFailoverEvent", String.format("The service event has service name: %s, not applicable to this pool and not processed.", serviceName), null, null, new Object[0]);
                } else if (this.validateServiceEvent(failoverEvent)) {
                    this.currentEvent = new FailoverStatisticsItem(FailoverStatisticsItem.Type.SERVICE_DOWN, serviceName, instanceName, dbUniqueName, hostName);
                    this.eventAccumulator.addItem(this.currentEvent);
                    this.getRACCallback().initiateDownEventProcessing(failoverEvent);
                } else {
                    this.eventAccumulator.addItem(new FailoverStatisticsItem(FailoverStatisticsItem.Type.NOT_PROCESSED, serviceName, instanceName, dbUniqueName, hostName));
                    this.trace(Level.FINEST, CLASS_NAME, "handleFailoverEvent", "The service down event is invalid and not processed.", null, null, new Object[0]);
                }
            } else if (status.equalsIgnoreCase("up")) {
                if (null == serviceName || !serviceName.equals(this.m_serviceName.get())) {
                    this.eventAccumulator.addItem(new FailoverStatisticsItem(FailoverStatisticsItem.Type.NOT_PROCESSED, serviceName, instanceName, dbUniqueName, hostName));
                    this.trace(Level.FINEST, CLASS_NAME, "handleFailoverEvent", String.format("The service event has service name: %s, not applicable to this pool and not processed.", serviceName), null, null, new Object[0]);
                } else if (this.validateServiceEvent(failoverEvent)) {
                    this.currentEvent = new FailoverStatisticsItem(FailoverStatisticsItem.Type.SERVICE_UP, serviceName, instanceName, dbUniqueName, hostName);
                    this.eventAccumulator.addItem(this.currentEvent);
                    int numToCreate = this.getRACCallback().initiateUpEventProcessing(failoverEvent);
                    this.processUpEvent2ndPhase(numToCreate);
                    this.m_isEntireServiceDownProcessed = false;
                } else {
                    this.eventAccumulator.addItem(new FailoverStatisticsItem(FailoverStatisticsItem.Type.NOT_PROCESSED, serviceName, instanceName, dbUniqueName, hostName));
                    this.trace(Level.FINEST, CLASS_NAME, "handleFailoverEvent", "The service up event is invalid and not processed.", null, null, new Object[0]);
                }
            }
        } else if (eventType.equals("database/event/host") && status.equalsIgnoreCase("nodedown")) {
            if (this.validateHostDownEvent(failoverEvent)) {
                this.currentEvent = new FailoverStatisticsItem(FailoverStatisticsItem.Type.HOST_DOWN, serviceName, instanceName, dbUniqueName, hostName);
                this.eventAccumulator.addItem(this.currentEvent);
                this.getRACCallback().initiateDownEventProcessing(failoverEvent);
            } else {
                this.eventAccumulator.addItem(new FailoverStatisticsItem(FailoverStatisticsItem.Type.NOT_PROCESSED, serviceName, instanceName, dbUniqueName, hostName));
                this.trace(Level.FINEST, CLASS_NAME, "handleFailoverEvent", "The host down event is invalid and not processed.", null, null, new Object[0]);
            }
        } else {
            this.eventAccumulator.addItem(new FailoverStatisticsItem(FailoverStatisticsItem.Type.NOT_PROCESSED, serviceName, instanceName, dbUniqueName, hostName));
            this.trace(Level.FINEST, CLASS_NAME, "handleFailoverEvent", "Invalid Event received {0}", null, null, eventType);
        }
        this.setFCFProcessingInfo(this.eventAccumulator.toString());
        this.setFCFProcessingInfoProcessedOnly(this.eventAccumulator.toStringProcessedOnly());
        this.resetFCFInternalMetrics();
    }

    @Override
    public int processUpEvent(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, int initialPoolSize, int maxPoolSize, OracleFailoverEvent failoverEvent) throws UniversalConnectionPoolException {
        String status = failoverEvent.getStatus();
        String eventType = failoverEvent.getEventType();
        this.trace(Level.FINEST, CLASS_NAME, "processUpEvent", String.format("status=%s, eventType=%s", status, eventType), null, null, new Object[0]);
        int numConnsToCreate = -1;
        if (eventType.equals("database/event/service")) {
            if (status.equalsIgnoreCase("up")) {
                numConnsToCreate = this.processServiceUpEvent(aconns, bconns, initialPoolSize, maxPoolSize, failoverEvent.getInstanceName(), failoverEvent.getHostName(), failoverEvent.getDbUniqueName());
            } else {
                this.trace(Level.FINEST, CLASS_NAME, "processUpEvent", "The service up event is invalid and not processed.", null, null, new Object[0]);
            }
        } else {
            this.trace(Level.FINEST, CLASS_NAME, "processUpEvent", "Invalid Event received {0}", null, null, eventType);
        }
        return numConnsToCreate;
    }

    private FailoverStatisticsCounters processConnectionsForServiceDown(FailoverablePooledConnection[] conns, boolean isProcessingAvailableConnections, String instanceName, String dbUniqueName, boolean isPlannedDownEvent, long evtTimestamp, int actionFlag) {
        FailoverStatisticsCounters cs = new FailoverStatisticsCounters();
        cs.conns = conns.length;
        for (int i = 0; i < cs.conns; ++i) {
            if (!this.failoverServiceEventMatch(conns[i], instanceName, dbUniqueName, evtTimestamp)) continue;
            ++cs.affected;
            FailoverActionResult result = this.processFailoverAction(conns[i], isProcessingAvailableConnections, isPlannedDownEvent, actionFlag);
            cs.update(result);
        }
        return cs;
    }

    FailoverActionResult processFailoverAction(FailoverablePooledConnection pc, boolean isAvailableConnection, boolean isPlannedDownEvent, int actionFlag) {
        FailoverActionResult result = FailoverActionResult.NOOP;
        switch (actionFlag) {
            case 0: {
                try {
                    if (!isAvailableConnection && isPlannedDownEvent) {
                        pc.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN);
                        result = FailoverActionResult.MARKED_CLOSE_ON_RETURN;
                        break;
                    }
                    pc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                    result = FailoverActionResult.MARKED_BAD;
                }
                catch (UniversalConnectionPoolException ucpe) {
                    this.trace(Level.FINEST, CLASS_NAME, "processFailoverAction", "setting status failed: {0}", null, null, this.getStackTraceString(ucpe));
                    this.m_errorInfo.append(", ").append(ucpe.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                break;
            }
            case 1: {
                try {
                    pc.abort();
                }
                catch (Exception exc) {
                    this.trace(Level.FINEST, CLASS_NAME, "processFailoverAction", "aborting connection failed: {0}", null, null, this.getStackTraceString(exc));
                    this.m_errorInfo.append(", ").append(exc.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                try {
                    pc.close(!isAvailableConnection);
                    result = FailoverActionResult.ABORTED_AND_CLOSED;
                }
                catch (UniversalConnectionPoolException ucpe) {
                    this.trace(Level.FINEST, CLASS_NAME, "processFailoverAction", "closing connection failed: {0}", null, null, this.getStackTraceString(ucpe));
                    this.m_errorInfo.append(", ").append(ucpe.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                break;
            }
        }
        return result;
    }

    private FailoverStatisticsCounters processConnectionsForHostDown(FailoverablePooledConnection[] pooledConnections, boolean isProcessingAvailableConnections, String hostName, long evtTimestamp, int actionFlag) {
        FailoverStatisticsCounters cs = new FailoverStatisticsCounters();
        cs.conns = pooledConnections.length;
        for (int i = 0; i < cs.conns; ++i) {
            if (!this.failoverHostEventMatch(pooledConnections[i], hostName, evtTimestamp)) continue;
            ++cs.affected;
            FailoverActionResult result = this.processFailoverAction(pooledConnections[i], isProcessingAvailableConnections, false, actionFlag);
            cs.update(result);
        }
        return cs;
    }

    private int processServiceUpEvent(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, int initialPoolSize, int maxPoolSize, String instanceName, String hostName, String dbUniqueName) {
        int createCount;
        this.currentEvent.availConns = aconns == null ? 0 : aconns.length;
        int n = this.currentEvent.borrowedConns = bconns == null ? 0 : bconns.length;
        assert (this.m_dbInstanceInfoList != null);
        if (instanceName != null && !"".equals(instanceName)) {
            this.m_dbInstanceInfoList.markUpInstanceForUpEvent(this.m_serviceName.get(), instanceName, hostName, dbUniqueName);
        }
        this.m_cardinality = this.m_dbInstanceInfoList.getUpInstancesCount();
        int totalConnsCount = this.currentEvent.availConns + this.currentEvent.borrowedConns;
        if (this.m_cardinality == 0) {
            this.trace(Level.FINEST, CLASS_NAME, "processServiceUpEvent", "cardinality == 0, incorrect instance status", null, null, new Object[0]);
            createCount = 0;
        } else if (this.m_cardinality == 1) {
            createCount = initialPoolSize - totalConnsCount;
            if (createCount > 0) {
                this.trace(Level.FINEST, CLASS_NAME, "processServiceUpEvent", "first up instance, to obtain {0} connections", null, null, createCount);
            } else {
                createCount = 0;
                this.trace(Level.FINEST, CLASS_NAME, "processServiceUpEvent", "first up instance, no new connections to obtain", null, null, new Object[0]);
            }
        } else {
            createCount = this.getUpEventConnectionsToCreateCount(aconns, bconns, maxPoolSize, totalConnsCount);
            this.trace(Level.FINEST, CLASS_NAME, "processServiceUpEvent", "cardinality is {0}, to get {1} connections", null, null, this.m_cardinality, createCount);
        }
        this.m_targetUpEventNewConnCount = createCount;
        return createCount;
    }

    private void processUpEvent2ndPhase(int createCount) {
        boolean isFCFSuccessful;
        for (int i = 0; i < createCount; ++i) {
            try {
                this.getRACCallback().openNewConnection(null, null);
                ++this.m_upEventNewConnCount;
                continue;
            }
            catch (Exception e) {
                this.trace(Level.FINEST, CLASS_NAME, "processServiceUpEvent", "UP-event processing failed when adding new connections {0}", null, null, this.getStackTraceString(e));
                this.m_errorInfo.append(", ").append(e.getStackTrace()[0].toString());
            }
        }
        this.currentEvent.cardinality = this.m_cardinality;
        this.currentEvent.targetedToTearConns = this.m_targetTearDownConnCount;
        this.currentEvent.tornDownConns = this.m_tornDownConnCount;
        this.currentEvent.markedToCloseConns = this.m_markedToCloseConnCount;
        this.currentEvent.targetUpEventNewConns = this.m_targetUpEventNewConnCount;
        this.currentEvent.upEventNewConnCount = this.m_upEventNewConnCount;
        this.currentEvent.successful = isFCFSuccessful = this.m_upEventNewConnCount == this.m_targetUpEventNewConnCount && this.m_targetTearDownConnCount == this.m_tornDownConnCount + this.m_markedToCloseConnCount && 0 == this.m_errorInfo.length();
        this.trace(Level.FINEST, CLASS_NAME, "processServiceUpEvent", "Fast Connection Failover ststus={0}", null, null, isFCFSuccessful);
    }

    private int getUpEventConnectionsToCreateCount(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, int maxPoolSize, int totalConnsCount) {
        int connectionsToCreate = 0;
        int averageConnections = totalConnsCount / (this.m_cardinality - 1);
        int poolSizeHeadRoom = maxPoolSize - totalConnsCount;
        connectionsToCreate = averageConnections <= poolSizeHeadRoom ? averageConnections : poolSizeHeadRoom;
        if (connectionsToCreate < averageConnections) {
            int connectionsTornDown;
            int targetAverageConnections = totalConnsCount / this.m_cardinality;
            this.m_targetTearDownConnCount = connectionsTornDown = this.tearDownConnections(aconns, bconns, targetAverageConnections);
            if (connectionsTornDown > 0) {
                connectionsToCreate = connectionsTornDown;
            }
        }
        return connectionsToCreate;
    }

    private int tearDownConnections(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, int targetAverageConnections) {
        OracleDatabaseInstanceInfo dbInstance;
        boolean _sucProcessingOneConn;
        int i;
        assert (aconns != null);
        assert (bconns != null);
        int _tornDownAvailConnCount = 0;
        int _markedToCloseCount = 0;
        for (i = 0; i < aconns.length; ++i) {
            _sucProcessingOneConn = true;
            dbInstance = this.m_dbInstanceInfoList.getOracleDatabaseInstanceInfo(aconns[i].getInstance(), aconns[i].getDatabase());
            if (dbInstance.getNumToTearDown() == -1) {
                dbInstance.setNumToTearDown(dbInstance.getNumberOfConnectionsCount() - targetAverageConnections);
            }
            if (dbInstance.getNumToTearDown() <= 0) continue;
            _sucProcessingOneConn = FailoverActionResult.FAILED != this.processFailoverAction(aconns[i], true, false, 0);
            boolean bl = _sucProcessingOneConn = _sucProcessingOneConn && FailoverActionResult.FAILED != this.processFailoverAction(aconns[i], true, false, 1);
            if (!_sucProcessingOneConn) continue;
            dbInstance.decrementNumToTearDown();
            ++_tornDownAvailConnCount;
        }
        this.m_tornDownConnCount += _tornDownAvailConnCount;
        for (i = 0; i < bconns.length; ++i) {
            _sucProcessingOneConn = true;
            dbInstance = this.m_dbInstanceInfoList.getOracleDatabaseInstanceInfo(bconns[i].getInstance(), bconns[i].getDatabase());
            if (dbInstance.getNumToTearDown() == -1) {
                dbInstance.setNumToTearDown(dbInstance.getNumberOfConnectionsCount() - targetAverageConnections);
            }
            if (dbInstance.getNumToTearDown() <= 0) continue;
            try {
                bconns[i].setStatus(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN);
            }
            catch (UniversalConnectionPoolException ucpe) {
                this.trace(Level.FINEST, CLASS_NAME, "tearDownConnections", "Borrowed connection tearing failed when setting status {0}", null, null, this.getStackTraceString(ucpe));
                this.m_errorInfo.append(", ").append(ucpe.getStackTrace()[0].toString());
                _sucProcessingOneConn = false;
            }
            if (!_sucProcessingOneConn) continue;
            dbInstance.decrementNumToTearDown();
            ++_markedToCloseCount;
        }
        this.m_markedToCloseConnCount += _markedToCloseCount;
        this.trace(Level.FINEST, CLASS_NAME, "tearDownConnections", "available torn: {0}, borrowed marked to close: {1}", null, null, _tornDownAvailConnCount, _markedToCloseCount);
        return _tornDownAvailConnCount + _markedToCloseCount;
    }

    boolean failoverServiceEventMatch(FailoverablePooledConnection pooledConnection, String instanceName, String dbUniqueName, long evtTimestamp) {
        if (!this.olderWLSCompatible) {
            Date connTS = pooledConnection.getInstanceStartTime();
            this.trace(Level.FINEST, CLASS_NAME, "failoverServiceEventMatch", "INSTANCE START TIME: {0}", null, null, null != connTS ? connTS.toString() : "null");
            if (connTS != null && connTS.getTime() > evtTimestamp) {
                this.trace(Level.FINEST, CLASS_NAME, "failoverServiceEventMatch", "instance started after FAN event", null, null, new Object[0]);
                return false;
            }
        }
        String pcDbUniqueName = pooledConnection.getDatabase();
        if (instanceName == null) {
            return pcDbUniqueName == null || dbUniqueName == null || dbUniqueName.equals(pcDbUniqueName);
        }
        String pcDataSourceInstanceName = pooledConnection.getInstance();
        if (pcDataSourceInstanceName == null || pcDbUniqueName == null) {
            return false;
        }
        return instanceName.equals(pcDataSourceInstanceName) && dbUniqueName.equals(pcDbUniqueName);
    }

    private boolean failoverHostEventMatch(FailoverablePooledConnection pooledConnection, String hostName, long evtTimestamp) {
        if (!this.olderWLSCompatible) {
            Date connTS = pooledConnection.getInstanceStartTime();
            this.trace(Level.FINEST, CLASS_NAME, "failoverHostEventMatch", "INSTANCE START TIME: %t", null, null, connTS);
            if (connTS != null && connTS.getTime() > evtTimestamp) {
                this.trace(Level.FINEST, CLASS_NAME, "failoverHostEventMatch", "instance started after FAN event", null, null, new Object[0]);
                return false;
            }
        }
        String pooledConnectionHostName = pooledConnection.getHost();
        return hostName != null && pooledConnectionHostName != null && hostName.equals(pooledConnectionHostName);
    }

    private void resetFCFInternalMetrics() {
        this.m_targetTearDownConnCount = 0;
        this.m_tornDownConnCount = 0;
        this.m_markedToCloseConnCount = 0;
        this.m_targetUpEventNewConnCount = 0;
        this.m_upEventNewConnCount = 0;
        int _len = this.m_errorInfo.length();
        this.m_errorInfo.delete(0, _len);
    }

    String getStackTraceString(Throwable exc) {
        StringWriter stackTraceWriter = new StringWriter(1024);
        PrintWriter pw = new PrintWriter(stackTraceWriter);
        exc.printStackTrace(pw);
        return ((Object)stackTraceWriter).toString();
    }

    private void startONS(final String onsConfigStr) throws UniversalConnectionPoolException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws UniversalConnectionPoolException {
                    try {
                        RACManagerImpl.this.currentONS = new ONS(onsConfigStr);
                        RACManagerImpl.this.trace(Level.FINEST, CLASS_NAME, "startONS", "ONS({0}) succeeded", null, null, Util.maskONSConfigurationString(onsConfigStr));
                    }
                    catch (ONSException e) {
                        RACManagerImpl.this.currentONS = null;
                        throw UCPErrorHandler.newUniversalConnectionPoolException(308, e);
                    }
                    finally {
                        RACManagerImpl.this.calledStartONS = true;
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException onsexc) {
            this.currentONS = null;
            throw UCPErrorHandler.newUniversalConnectionPoolException(308, onsexc);
        }
    }

    @Override
    public void start() throws UniversalConnectionPoolException {
        if (this.m_state != 2) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(60);
        }
        this.olderWLSCompatible = Util.isPreWLS1212Compatible();
        String onsConfigurationString = this.m_onsConfigurationString.get();
        if ((onsConfigurationString == null || "".equals(onsConfigurationString)) && !this.olderWLSCompatible) {
            this.getAutoONSConfigurationFromServer();
        }
        if ((onsConfigurationString = this.m_onsConfigurationString.get()) != null && !"".equals(onsConfigurationString)) {
            this.startONS(onsConfigurationString);
        }
        if (this.getFailoverEventHandlerTask() != null) {
            this.stop();
        } else {
            this.setFailoverEventHandlerTask(new ONSDatabaseEventHandlerTask(this.m_serviceName.get(), this, this.m_taskManager));
        }
        ONSDatabaseEventHandlerTask fcfTask = (ONSDatabaseEventHandlerTask)this.getFailoverEventHandlerTask();
        if (fcfTask != null) {
            fcfTask.setTerminate(false);
            try {
                fcfTask.start();
            }
            catch (RejectedExecutionException e) {
                throw new UniversalConnectionPoolException(e);
            }
        }
        this.m_state = 1;
        this.trace(Level.FINE, CLASS_NAME, "start", "started", null, null, new Object[0]);
    }

    private FailoverEventHandlerTask getFailoverEventHandlerTask() {
        this.failoverEventHandlerTaskLock.lock();
        try {
            ONSDatabaseEventHandlerTask oNSDatabaseEventHandlerTask = this.m_failoverEventHandlerTask;
            return oNSDatabaseEventHandlerTask;
        }
        finally {
            this.failoverEventHandlerTaskLock.unlock();
        }
    }

    @Override
    public void stop() throws UniversalConnectionPoolException {
        if (this.m_state == 2) {
            this.trace(Level.FINEST, CLASS_NAME, "stop", "failover already stopped", null, null, new Object[0]);
            return;
        }
        this.terminateRuntimeLoadBalancing();
        ONSDatabaseEventHandlerTask fcfTask = (ONSDatabaseEventHandlerTask)this.getFailoverEventHandlerTask();
        if (fcfTask != null) {
            fcfTask.setTerminate(true);
            fcfTask.waitTerminate();
        }
        this.setFailoverEventHandlerTask(null);
        this.resetRACStatistics();
        this.olderWLSCompatible = false;
        if (this.currentONS != null) {
            this.currentONS.shutdown();
            this.currentONS = null;
            this.calledStartONS = false;
        }
        this.m_state = 2;
        this.trace(Level.FINE, CLASS_NAME, "stop", "stopped", null, null, new Object[0]);
    }

    private void resetRACStatistics() {
        this.m_successfulAffinityBasedBorrowCount.set(0L);
        this.m_failedAffinityBasedBorrowCount.set(0L);
        this.m_successfulRCLBBasedBorrowCount.set(0L);
        this.m_failedRCLBBasedBorrowCount.set(0L);
        this.setFCFProcessingInfo("");
        this.setFCFProcessingInfoProcessedOnly("");
    }

    protected void setFailoverEventHandlerTask(ONSDatabaseEventHandlerTask failoverEventHandlerTask) {
        this.failoverEventHandlerTaskLock.lock();
        try {
            this.m_failoverEventHandlerTask = failoverEventHandlerTask;
        }
        finally {
            this.failoverEventHandlerTaskLock.unlock();
        }
    }

    @Override
    public void setFailoverInfo(Object info) throws UniversalConnectionPoolException {
        assert (false) : "internal error: this method must not be invoked";
    }

    void updateDatabaseInstanceInfo(Object info, boolean isForFailover, boolean isAddingConnection) throws UniversalConnectionPoolException {
        OracleDatabaseInstanceInfo dbi = (OracleDatabaseInstanceInfo)info;
        this.m_serviceName.compareAndSet(null, dbi.getServiceName());
        assert (this.m_dbInstanceInfoList != null);
        this.m_dbInstanceInfoList.updateDatabaseInstanceInfo(dbi, isForFailover, isAddingConnection);
    }

    @Override
    public Object getFailoverInfo() {
        return this.m_dbInstanceInfoList;
    }

    @Override
    public String getONSConfiguration() {
        return this.m_onsConfigurationString.get();
    }

    @Override
    public void setONSConfiguration(String onsConfigStr) throws UniversalConnectionPoolException {
        String oldOnsConfigStr;
        this.trace(Level.FINEST, CLASS_NAME, "setONSConfiguration", "onsConfigStr: {0}", null, null, Util.maskONSConfigurationString(onsConfigStr));
        if (onsConfigStr == null) {
            onsConfigStr = "";
        }
        if (onsConfigStr.equals(oldOnsConfigStr = this.m_onsConfigurationString.getAndSet(onsConfigStr))) {
            return;
        }
        if (this.m_state == 1) {
            this.stop();
            this.start();
        }
    }

    void setFCFProcessingInfo(String fcfInfo) {
        this.fcfProcessingInfoLock.lock();
        try {
            this.m_fcfProcessingInfo = fcfInfo;
        }
        finally {
            this.fcfProcessingInfoLock.unlock();
        }
    }

    void setFCFProcessingInfoProcessedOnly(String fcfInfo) {
        this.fcfProcessingInfoProcessedOnlyLock.lock();
        try {
            this.m_fcfProcessingInfoProcessedOnly = fcfInfo;
        }
        finally {
            this.fcfProcessingInfoProcessedOnlyLock.unlock();
        }
    }

    @Override
    public void markDownConnectionsForDownEvent(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, OracleFailoverEvent failoverEvent) {
        this.processConnectionsForDownEvent(aconns, bconns, failoverEvent, 100);
    }

    @Override
    public void cleanupConnectionsForDownEvent(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, OracleFailoverEvent failoverEvent) {
        this.processConnectionsForDownEvent(aconns, bconns, failoverEvent, 200);
    }

    private void processConnectionsForDownEvent(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, OracleFailoverEvent failoverEvent, int actionFlag) {
        String status = failoverEvent.getStatus();
        String eventType = failoverEvent.getEventType();
        long eventTimestamp = failoverEvent.getTimestamp();
        this.trace(Level.FINEST, CLASS_NAME, "processConnectionsForDownEvent", "status=%s, eventType=%s", null, null, status, eventType);
        if (eventType.equals("database/event/service")) {
            if (status.equalsIgnoreCase("down") || status.equalsIgnoreCase("not_restarting") || status.equalsIgnoreCase("restart_failed")) {
                boolean isPlannedDownEvent;
                String instanceName = failoverEvent.getInstanceName();
                String dbUniqueName = failoverEvent.getDbUniqueName();
                String reason = failoverEvent.getReason();
                boolean bl = isPlannedDownEvent = reason != null && reason.equals("user");
                if (actionFlag == 100) {
                    if (!this.m_isEntireServiceDownProcessed) {
                        this.currentEvent.availMarked = this.processConnectionsForServiceDown(aconns, true, instanceName, dbUniqueName, isPlannedDownEvent, eventTimestamp, 0);
                        this.currentEvent.borrowedMarked = this.processConnectionsForServiceDown(bconns, false, instanceName, dbUniqueName, isPlannedDownEvent, eventTimestamp, 0);
                        if (instanceName == null) {
                            this.m_isEntireServiceDownProcessed = false;
                        }
                    }
                } else if (actionFlag == 200) {
                    boolean isFCFSuccessful;
                    this.currentEvent.availConns = aconns == null ? 0 : aconns.length;
                    int n = this.currentEvent.borrowedConns = bconns == null ? 0 : bconns.length;
                    if (!isPlannedDownEvent) {
                        this.currentEvent.borrowedClosed = this.processConnectionsForServiceDown(bconns, false, instanceName, dbUniqueName, isPlannedDownEvent, eventTimestamp, 1);
                    }
                    this.currentEvent.availClosed = this.processConnectionsForServiceDown(aconns, true, instanceName, dbUniqueName, isPlannedDownEvent, eventTimestamp, 1);
                    assert (this.m_dbInstanceInfoList != null);
                    this.m_dbInstanceInfoList.markDownInstanceForServiceDownEvent(instanceName, dbUniqueName);
                    this.currentEvent.reason = reason;
                    this.currentEvent.successful = isFCFSuccessful = this.currentEvent.availClosed.failed == 0 && this.currentEvent.borrowedClosed.failed == 0 && this.m_errorInfo.length() == 0;
                    this.trace(Level.FINEST, CLASS_NAME, "processConnectionsForDownEvent", "Fast Connection Failover ststus={0}", null, null, isFCFSuccessful);
                }
            } else {
                this.trace(Level.FINEST, CLASS_NAME, "processConnectionsForDownEvent", "The down event is invalid and not processed.", null, null, new Object[0]);
            }
        } else if (eventType.equals("database/event/host") && status.equalsIgnoreCase("nodedown")) {
            String hostName = failoverEvent.getHostName();
            if (actionFlag == 100) {
                this.currentEvent.availMarked = this.processConnectionsForHostDown(aconns, true, hostName, eventTimestamp, 0);
                this.currentEvent.borrowedMarked = this.processConnectionsForHostDown(bconns, false, hostName, eventTimestamp, 0);
            } else if (actionFlag == 200) {
                boolean isFCFSuccessful;
                this.currentEvent.availConns = aconns == null ? 0 : aconns.length;
                this.currentEvent.borrowedConns = bconns == null ? 0 : bconns.length;
                this.currentEvent.borrowedClosed = this.processConnectionsForHostDown(bconns, false, hostName, eventTimestamp, 1);
                this.currentEvent.availClosed = this.processConnectionsForHostDown(aconns, true, hostName, eventTimestamp, 1);
                assert (this.m_dbInstanceInfoList != null);
                this.m_dbInstanceInfoList.markDownInstanceForHostDownEvent(hostName);
                this.currentEvent.successful = isFCFSuccessful = this.currentEvent.availClosed.failed == 0 && this.currentEvent.borrowedClosed.failed == 0 && this.m_errorInfo.length() == 0;
                this.trace(Level.FINEST, CLASS_NAME, "processConnectionsForDownEvent", "Fast Connection Failover status={0}", null, null, isFCFSuccessful);
            }
        } else {
            this.trace(Level.FINEST, CLASS_NAME, "processConnectionsForDownEvent", "Invalid Event received {0}", null, null, eventType);
        }
    }

    @Override
    public void registerRACCallback(RACCallback cbk) {
        this.poolLock.lock();
        try {
            this.m_cbk = new RACCallbackGuard(cbk);
        }
        finally {
            this.poolLock.unlock();
        }
    }

    @Override
    public void unregisterRACCallback(RACCallback cbk) {
        this.poolLock.lock();
        try {
            if (this.m_cbk == cbk) {
                this.m_cbk = null;
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    public RACCallbackGuard getRACCallback() {
        this.poolLock.lock();
        try {
            RACCallbackGuard rACCallbackGuard = this.m_cbk;
            return rACCallbackGuard;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    @Override
    public void connectionOpened(FailoverablePooledConnection fpc) throws UniversalConnectionPoolException {
        OracleDatabaseInstanceInfo tmpInstance = new OracleDatabaseInstanceInfo(fpc.getDatabase(), fpc.getInstance(), fpc.getHost());
        tmpInstance.setServiceName(fpc.getService());
        tmpInstance.setId(fpc.getInstanceNumber());
        this.updateDatabaseInstanceInfo(tmpInstance, true, true);
        if (this.m_state == 1 && !this.isRuntimeLoadBalancingEnabled()) {
            this.setRuntimeLoadBalancingEnabled(true);
            this.setDatabaseVersion(fpc.getDatabaseVersion());
        }
    }

    @Override
    public void connectionClosed(FailoverablePooledConnection fpc) throws UniversalConnectionPoolException {
        OracleDatabaseInstanceInfo tmpInstance = new OracleDatabaseInstanceInfo(fpc.getDatabase(), fpc.getInstance(), fpc.getHost());
        tmpInstance.setServiceName(fpc.getService());
        this.updateDatabaseInstanceInfo(tmpInstance, true, false);
        if (fpc.isNamedInstanceConnection()) {
            this.decrementNamedInstanceConnCount(tmpInstance);
        }
    }

    @Override
    public String getFCFProcessingInfoProcessedOnly() {
        this.fcfProcessingInfoProcessedOnlyLock.lock();
        try {
            String string = this.m_fcfProcessingInfoProcessedOnly;
            return string;
        }
        finally {
            this.fcfProcessingInfoProcessedOnlyLock.unlock();
        }
    }

    @Override
    public String getFCFProcessingInfo() {
        this.fcfProcessingInfoLock.lock();
        try {
            String string = this.m_fcfProcessingInfo;
            return string;
        }
        finally {
            this.fcfProcessingInfoLock.unlock();
        }
    }

    private void decrementNamedInstanceConnCount(OracleDatabaseInstanceInfo dbInfo) {
        this.poolLock.lock();
        try {
            OracleDatabaseInstanceInfo dbInstance = this.m_dbInstanceInfoList.getOracleDatabaseInstanceInfo(dbInfo.getInstanceName(), dbInfo.getDatabaseName());
            if (dbInstance.getNumNamedInstanceConns() > 0) {
                dbInstance.decrementNumNamedInstanceConns();
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    @Override
    public boolean isRuntimeLoadBalancingEnabled() {
        return this.m_runtimeLoadBalancingEnabled.get();
    }

    public void setRuntimeLoadBalancingEnabled(boolean RLBEnabled) throws UniversalConnectionPoolException {
        this.poolLock.lock();
        try {
            this.m_runtimeLoadBalancingEnabled.set(RLBEnabled);
            if (RLBEnabled) {
                this.initRuntimeLoadBalancing(this.m_serviceName.get());
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    protected void initRuntimeLoadBalancing(String serviceName) throws UniversalConnectionPoolException {
        if (this.getRuntimeLoadBalancingEventHandlerTask() == null) {
            this.setRuntimeLoadBalancingEventHandlerTask(new ONSRuntimeLBEventHandlerTask(this.m_serviceName.get(), this));
        }
        try {
            this.getRuntimeLoadBalancingEventHandlerTask().start();
        }
        catch (RejectedExecutionException e) {
            throw new UniversalConnectionPoolException(e);
        }
        this.generateMixTable();
    }

    protected void terminateRuntimeLoadBalancing() throws UniversalConnectionPoolException {
        this.cleanupRLBTasks();
        this.setRuntimeLoadBalancingEnabled(false);
    }

    protected void setRuntimeLoadBalancingEventHandlerTask(ONSRuntimeLBEventHandlerTask rlbEventHandlerTask) {
        this.rlbEventHandlerTaskLock.lock();
        try {
            this.m_rlbEventHandlerTask = rlbEventHandlerTask;
        }
        finally {
            this.rlbEventHandlerTaskLock.unlock();
        }
    }

    protected ONSRuntimeLBEventHandlerTask getRuntimeLoadBalancingEventHandlerTask() {
        this.rlbEventHandlerTaskLock.lock();
        try {
            ONSRuntimeLBEventHandlerTask oNSRuntimeLBEventHandlerTask = this.m_rlbEventHandlerTask;
            return oNSRuntimeLBEventHandlerTask;
        }
        finally {
            this.rlbEventHandlerTaskLock.unlock();
        }
    }

    protected void processDatabaseInstances() {
        assert (this.m_dbInstanceInfoList != null);
        this.m_dbInstanceInfoList.scheduleInstancesForGravitation(this.m_instancesToGravitateQueue);
        this.setRCLBMetricsPolicyEnabled(true);
        this.gravitatePoolTaskLock.lock();
        try {
            OracleGravitateConnectionPoolTask gravitatePoolTask = this.m_gravitatePoolTask.get();
            if (gravitatePoolTask != null && this.m_gravitateTaskBusy.get()) {
                this.trace(Level.FINEST, CLASS_NAME, "processDatabaseInstances", "about to stop gravitate thread", null, null, new Object[0]);
                gravitatePoolTask.stop();
            }
            this.m_gravitatePoolTask.set(new OracleGravitateConnectionPoolTask(this));
            this.m_gravitatePoolTask.get().start();
        }
        finally {
            this.gravitatePoolTaskLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void gravitatePool() {
        this.m_gravitateTaskBusy.set(true);
        try {
            while (true) {
                this.trace(Level.FINEST, CLASS_NAME, "gravitatePool", "polling instance queue", null, null, new Object[0]);
                OracleDatabaseInstanceInfo instanceToGravitate = this.m_instancesToGravitateQueue.poll(1L, TimeUnit.SECONDS);
                if (null == instanceToGravitate) {
                    this.trace(Level.FINEST, CLASS_NAME, "gravitatePool", "no more instances to retire", null, null, new Object[0]);
                    return;
                }
                try {
                    this.getRACCallback().tearDownConnectionsForInstance(instanceToGravitate, instanceToGravitate.getConnsToTearDown());
                    continue;
                }
                finally {
                    instanceToGravitate.setRebalancingState(OracleDatabaseInstanceInfo.RebalancingState.SHRUNK);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            this.trace(Level.WARNING, CLASS_NAME, "gravitatePool", "", null, e, new Object[0]);
            return;
        }
        finally {
            this.m_gravitateTaskBusy.set(false);
            this.trace(Level.FINEST, CLASS_NAME, "gravitatePool", "gravitation done", null, null, new Object[0]);
        }
    }

    @Override
    public FailoverablePooledConnection selectConnectionPerRCLBAndAffinity(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        ConnectionAffinityCallback cbk = this.getConnectionAffinityCallback();
        this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerRCLBAndAffinity", "affinityPolicy={0}", null, null, new Object[]{cbk.getAffinityPolicy()});
        if (cbk.getAffinityPolicy() == ConnectionAffinityCallback.AffinityPolicy.DATA_BASED_AFFINITY) {
            return this.selectConnectionPerDataBasedAffinity(cri);
        }
        Object appAffinityContext = cbk.getConnectionAffinityContext();
        FailoverablePooledConnection pc = null;
        if (appAffinityContext == null) {
            this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerRCLBAndAffinity", "Application has no affinity context established", null, null, new Object[0]);
            boolean isInstanceAffinityEnabled = cbk.getAffinityPolicy() == ConnectionAffinityCallback.AffinityPolicy.TRANSACTION_BASED_AFFINITY || this.rlbMetricsAccumulator.getReel().size() == 0;
            this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerRCLBAndAffinity", "isInstanceAffinityEnabled={0}", null, null, isInstanceAffinityEnabled);
            pc = this.selectConnectionPerRCLB(cri);
            this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerRCLBAndAffinity", "Connection obtained based on RCLB: {0}", null, null, pc);
            if (pc != null) {
                OracleConnectionAffinityContext affinityContext = this.getUpdatedAffinityContextAfterRCLB(pc, isInstanceAffinityEnabled);
                if (affinityContext != null) {
                    cbk.setConnectionAffinityContext(affinityContext.clone());
                }
                this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerRCLBAndAffinity", "Application affinity context: {0}", null, null, affinityContext);
            }
        } else {
            OracleConnectionAffinityContext updatedAffinityContext;
            this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerRCLBAndAffinity", "Application has affinity context established", null, null, new Object[0]);
            OracleConnectionAffinityContext affinityContext = (OracleConnectionAffinityContext)appAffinityContext;
            boolean isInstanceAffinityEnabled = affinityContext.isForInstanceAffinity();
            String instanceName = affinityContext.getInstanceName();
            String dbUniqName = affinityContext.getDatabaseUniqueName();
            String serviceName = affinityContext.getServiceName();
            boolean affinityValue = false;
            if (!isInstanceAffinityEnabled) {
                String instanceKey = this.generateDatabaseInstanceKey(instanceName, dbUniqName, serviceName);
                affinityValue = this.getConnectionAffinityValue(instanceKey);
            }
            if (isInstanceAffinityEnabled || affinityValue) {
                this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerRCLBAndAffinity", "{0}", null, null, (isInstanceAffinityEnabled ? "Database instance" : "Temporal") + " affinity");
                this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerRCLBAndAffinity", "use application's affinityContext: {0}", null, null, affinityContext.toString());
                pc = this.getRACCallback().getAvailableConnectionToInstance(cri, new RACInstanceImpl(serviceName, instanceName, "", dbUniqName));
                this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerRCLBAndAffinity", "Connection found matching affinity context: {0}", null, null, pc);
                if (pc == null) {
                    this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerRCLBAndAffinity", "Affinity contexts match but no connection available to {0}", null, null, affinityContext.toString());
                    pc = this.getConnectionToNamedInstance(instanceName, dbUniqName, isInstanceAffinityEnabled);
                    this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerRCLBAndAffinity", "Connection obtained to named instance: {0}", null, null, pc);
                    if (pc == null) {
                        if (Util.isAffinityStrict() || cbk.getAffinityPolicy() == ConnectionAffinityCallback.AffinityPolicy.WEBSESSION_BASED_AFFINITY && this.isStrictWSAffinity || cbk.getAffinityPolicy() == ConnectionAffinityCallback.AffinityPolicy.TRANSACTION_BASED_AFFINITY && this.isStrictXAAffinity) {
                            this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerRCLBAndAffinity", "unable to follow affinity strictly, setting affinity context to null", null, null, new Object[0]);
                            cbk.setConnectionAffinityContext(null);
                        } else {
                            pc = this.selectConnectionPerRCLB(cri);
                            this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerRCLBAndAffinity", "Connection obtained based on RCLB: {0}", null, null, pc);
                            if (pc != null) {
                                updatedAffinityContext = this.getUpdatedAffinityContextAfterRCLB(pc, isInstanceAffinityEnabled);
                                if (!isInstanceAffinityEnabled) {
                                    cbk.setConnectionAffinityContext(updatedAffinityContext);
                                    this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerRCLBAndAffinity", "Temporal affinity. Application affinity context is updated: {0}", null, null, updatedAffinityContext);
                                }
                            }
                        }
                        this.incrementFailedAffinityBasedBorrowCount();
                    } else {
                        this.incrementSuccessfulAffinityBasedBorrowCount();
                    }
                } else {
                    this.incrementSuccessfulAffinityBasedBorrowCount();
                }
            } else {
                pc = this.selectConnectionPerRCLB(cri);
                this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerRCLBAndAffinity", "Connection obtained based on RCLB: {0}", null, null, pc);
                if (pc != null) {
                    updatedAffinityContext = this.getUpdatedAffinityContextAfterRCLB(pc, false);
                    cbk.setConnectionAffinityContext(updatedAffinityContext);
                    this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerRCLBAndAffinity", "Temporal affinity miss. Application affinity context is updated: {0}", null, null, updatedAffinityContext);
                }
                this.incrementFailedAffinityBasedBorrowCount();
            }
        }
        return pc;
    }

    private OracleConnectionAffinityContext getUpdatedAffinityContextAfterRCLB(FailoverablePooledConnection fpc, boolean isInstanceAffinityEnabled) {
        boolean needToCreateAffinityContext = true;
        String instanceName = fpc.getInstance();
        String dbName = fpc.getDatabase();
        String serviceName = fpc.getService();
        if (!isInstanceAffinityEnabled) {
            this.trace(Level.FINEST, CLASS_NAME, "getUpdatedAffinityContextAfterRCLB", "Checking affinity hint for this instance", null, null, new Object[0]);
            String instanceKey = this.generateDatabaseInstanceKey(instanceName, dbName, serviceName);
            if (!this.getConnectionAffinityValue(instanceKey)) {
                needToCreateAffinityContext = false;
            }
        }
        if (needToCreateAffinityContext) {
            this.trace(Level.FINEST, CLASS_NAME, "getUpdatedAffinityContextAfterRCLB", "Creating temporary updated affinity context", null, null, new Object[0]);
            OracleConnectionAffinityContext updatedAffinityContext = new OracleConnectionAffinityContext();
            updatedAffinityContext.setConnectionPoolID(this.getRACCallback().getPoolName());
            updatedAffinityContext.setInstanceName(instanceName);
            updatedAffinityContext.setDatabaseUniqueName(dbName);
            updatedAffinityContext.setServiceName(serviceName);
            if (isInstanceAffinityEnabled) {
                this.trace(Level.FINEST, CLASS_NAME, "getUpdatedAffinityContextAfterRCLB", "New context is for instance affinity", null, null, new Object[0]);
                updatedAffinityContext.setForInstanceAffinity(true);
            }
            this.trace(Level.FINEST, CLASS_NAME, "getUpdatedAffinityContextAfterRCLB", "New Affinity context created: {0}", null, null, updatedAffinityContext);
            return updatedAffinityContext;
        }
        this.trace(Level.FINEST, CLASS_NAME, "getUpdatedAffinityContextAfterRCLB", "Temporal Affinity hint is false", null, null, new Object[0]);
        return null;
    }

    private FailoverablePooledConnection getConnectionToNamedInstance(String instanceName, String dbUniqName, boolean isInstanceAffinityEnabled) {
        FailoverablePooledConnection fpc = null;
        if (this.m_dbInstanceInfoList.isNamedInstanceConnectingAllowed(instanceName, dbUniqName, isInstanceAffinityEnabled)) {
            this.trace(Level.FINEST, CLASS_NAME, "getConnectionToNamedInstance", "named instance connecting allowed", null, null, new Object[0]);
            OracleDatabaseInstanceInfo dbInstance = this.m_dbInstanceInfoList.getOracleDatabaseInstanceInfo(instanceName, dbUniqName);
            String namedInstanceUrl = dbInstance.getNamedInstanceUrl();
            try {
                RACInstanceImpl racInstance = new RACInstanceImpl(dbInstance);
                fpc = this.getRACCallback().openNewConnection(namedInstanceUrl, racInstance);
            }
            catch (Exception exc) {
                fpc = null;
                this.trace(Level.WARNING, CLASS_NAME, "getConnectionToNamedInstance", "", null, exc, new Object[0]);
            }
            if (fpc != null) {
                fpc.setAsNamedInstanceConnection();
                dbInstance.incrementNumNamedInstanceConns();
            }
        } else {
            this.trace(Level.FINEST, CLASS_NAME, "getConnectionToNamedInstance", "named instance connecting disallowed", null, null, new Object[0]);
        }
        return fpc;
    }

    protected FailoverablePooledConnection selectConnectionPerDataBasedAffinity(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        DataBasedConnectionAffinityCallback cbk = (DataBasedConnectionAffinityCallback)this.getConnectionAffinityCallback();
        int partitionId = cbk.getPartitionId();
        Object pc = null;
        if (partitionId < 0) {
            this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerDataBasedAffinity", "Callback returns incorrect partition-id.", null, null, new Object[0]);
        } else {
            this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerDataBasedAffinity", "Callback returns partition-id: {0}", null, null, partitionId);
            int configuredInstCardinality = 128;
            int size = this.m_dbInstanceInfoList.size();
            if (size > 128) {
                this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerDataBasedAffinity", String.format("data affinity is disabled, cardinality>128 (%d)", size), null, null, new Object[0]);
            }
            while (true) {
                int instanceId = (partitionId %= 4096) % 128;
                OracleDatabaseInstanceInfo dbInstance = this.m_dbInstanceInfoList.getOracleDatabaseInstanceInfo(instanceId);
                this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerDataBasedAffinity", String.format("Partition-id=%d, dbInstance=%s", partitionId, dbInstance), null, null, new Object[0]);
                if (dbInstance == null) {
                    partitionId = this.m_mixTable[partitionId];
                    this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerDataBasedAffinity", "Bad instance, dbinfo == null in table, remap to partition-id: {0}", null, null, partitionId);
                    continue;
                }
                OracleDatabaseInstanceInfoList.INSTANCE_CATEGORY_FOR_DATA_AFFINITY instanceCategory = this.m_dbInstanceInfoList.getInstanceCategory(dbInstance);
                String instanceName = dbInstance.getInstanceName();
                String dbUniqName = dbInstance.getDatabaseName();
                String serviceName = dbInstance.getServiceName();
                switch (instanceCategory) {
                    case GOOD_INSTANCE: {
                        this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerDataBasedAffinity", "Data-based affinity. Found good instance based on partition-id.", null, null, new Object[0]);
                        this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerDataBasedAffinity", "Partition-id={0}", null, null, partitionId);
                        this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerDataBasedAffinity", String.format("Good instance: instance=%s, service=%s, db=%s", instanceName, serviceName, dbUniqName), null, null, new Object[0]);
                        RACInstanceImpl racInstance = new RACInstanceImpl(serviceName, instanceName, "", dbUniqName);
                        pc = this.getRACCallback().getAvailableConnectionToInstance(cri, racInstance);
                        this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerDataBasedAffinity", "Available connection found in chosen good instance: {0}", null, null, pc);
                        if (pc == null) {
                            this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerDataBasedAffinity", String.format("Found good instance but no connection available to serviceName: %s, instanceName: %s, dbUniqueName: %s", serviceName, instanceName, dbUniqName), null, null, new Object[0]);
                            pc = this.getConnectionToNamedInstance(instanceName, dbUniqName, true);
                            this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerDataBasedAffinity", "Connection obtained to named instance: {0}", null, null, pc);
                            if (pc == null) {
                                pc = this.selectConnectionPerRCLB(cri);
                                this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerDataBasedAffinity", "Connection obtained based on RCLB: {0}", null, null, pc);
                                this.incrementFailedAffinityBasedBorrowCount();
                                break;
                            }
                            this.incrementSuccessfulAffinityBasedBorrowCount();
                            break;
                        }
                        this.incrementSuccessfulAffinityBasedBorrowCount();
                        break;
                    }
                    case VIOLATING_INSTANCE: {
                        this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerDataBasedAffinity", "Violating instance: instance={0}, service={1}, db={2}", null, null, instanceName, serviceName, dbUniqName);
                        pc = this.selectConnectionPerRCLB(cri);
                        this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerDataBasedAffinity", "Connection obtained based on RCLB: {0}", null, null, pc);
                        this.incrementFailedAffinityBasedBorrowCount();
                        break;
                    }
                    case BAD_INSTANCE: {
                        partitionId = this.m_mixTable[partitionId];
                        this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerDataBasedAffinity", "Bad instance, service: {0}, instance: {1}, db: {2}; remap to partition-id: {3}", null, null, serviceName, instanceName, dbUniqName, partitionId);
                    }
                }
                if (pc != null) break;
            }
        }
        this.trace(Level.FINEST, CLASS_NAME, "selectConnectionPerDataBasedAffinity", "method returns connection: {0}", null, null, pc.toString());
        return pc;
    }

    private void generateMixTable() {
        if (this.m_mixTable != null) {
            return;
        }
        int[] alog = new int[4096];
        alog[0] = 1;
        for (int i = 1; i < 4096; ++i) {
            alog[i] = alog[i - 1] << 1 ^ alog[i - 1];
            if ((alog[i] & 0x1000) == 0) continue;
            int n = i;
            alog[n] = alog[n] ^ 0x1009;
        }
        int[] log = new int[4096];
        for (int i = 0; i < 4096; ++i) {
            log[alog[i]] = i;
        }
        log[0] = 4096;
        int[] mix = new int[4096];
        for (int i = 1; i < 4096; ++i) {
            mix[log[i - 1] - 1] = log[i] - 1;
        }
        mix[log[4095] - 1] = log[0] - 1;
        this.m_mixTable = mix;
    }

    private void destroyMixTable() {
        this.m_mixTable = null;
    }

    @Override
    public FailoverablePooledConnection selectConnectionPerRCLB(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        boolean useRLBMetricsPolicy;
        assert (this.m_dbInstanceInfoList != null);
        FailoverablePooledConnection pc = null;
        boolean bl = useRLBMetricsPolicy = this.isRCLBMetricsPolicyEnabled() && this.m_dbInstanceInfoList.size() > 0 && this.m_dbInstanceInfoList.useGoodGroup();
        if (useRLBMetricsPolicy) {
            pc = this.m_dbInstanceInfoList.selectConnectionPerRLBMetrics(cri, this);
        }
        if (!useRLBMetricsPolicy) {
            int i;
            Collection<FailoverablePooledConnection> conns = this.getRACCallback().getAvailableConnections(cri);
            if (conns == null || conns.size() == 0) {
                return null;
            }
            int sz = conns.size();
            int pos = this.m_rand.nextInt(sz);
            Iterator<FailoverablePooledConnection> iter = conns.iterator();
            for (i = 0; i < (pos + sz) % sz; ++i) {
                iter.next();
            }
            for (i = 0; i < sz; ++i) {
                FailoverablePooledConnection tmpPc;
                UniversalPooledConnectionStatus status;
                if (!iter.hasNext()) {
                    iter = conns.iterator();
                }
                if (!(status = (tmpPc = iter.next()).getStatus()).equals(UniversalPooledConnectionStatus.STATUS_NORMAL)) continue;
                pc = tmpPc;
                break;
            }
            this.incrementFailedRCLBBasedBorrowCount();
        }
        return pc;
    }

    protected void cleanupRLBTasks() {
        ProlongedTask gravitatePoolTask;
        ONSRuntimeLBEventHandlerTask rlbEventHandlerTask = this.getRuntimeLoadBalancingEventHandlerTask();
        if (rlbEventHandlerTask != null) {
            rlbEventHandlerTask.setTerminate(true);
        }
        if ((gravitatePoolTask = (ProlongedTask)this.m_gravitatePoolTask.get()) != null) {
            gravitatePoolTask.stop();
            this.m_gravitatePoolTask.set(null);
        }
        this.destroyMixTable();
    }

    @Override
    public long getSuccessfulAffinityBasedBorrowCount() {
        return this.m_successfulAffinityBasedBorrowCount.get();
    }

    @Override
    public long getFailedAffinityBasedBorrowCount() {
        return this.m_failedAffinityBasedBorrowCount.get();
    }

    @Override
    public long getSuccessfulRCLBBasedBorrowCount() {
        return this.m_successfulRCLBBasedBorrowCount.get();
    }

    @Override
    public long getFailedRCLBBasedBorrowCount() {
        return this.m_failedRCLBBasedBorrowCount.get();
    }

    public void incrementSuccessfulAffinityBasedBorrowCount() {
        this.m_successfulAffinityBasedBorrowCount.incrementAndGet();
    }

    protected void incrementFailedAffinityBasedBorrowCount() {
        this.m_failedAffinityBasedBorrowCount.incrementAndGet();
    }

    public void incrementSuccessfulRCLBBasedBorrowCount() {
        this.m_successfulRCLBBasedBorrowCount.incrementAndGet();
    }

    public void incrementFailedRCLBBasedBorrowCount() {
        this.m_failedRCLBBasedBorrowCount.incrementAndGet();
    }

    boolean isRCLBMetricsPolicyEnabled() {
        return this.m_rclbMetricsPolicyEnabled.get();
    }

    void setRCLBMetricsPolicyEnabled(boolean metricsPolicyEnabled) {
        this.m_rclbMetricsPolicyEnabled.set(metricsPolicyEnabled);
    }

    public int getDatabaseVersion() {
        return this.m_dbVersion.get();
    }

    void setDatabaseVersion(int version) {
        this.m_dbVersion.compareAndSet(0, version);
    }

    @Override
    public void registerConnectionAffinityCallback(ConnectionAffinityCallback cbk) throws UniversalConnectionPoolException {
        this.m_connectionAffinityCallback = cbk;
    }

    @Override
    public void unregisterConnectionAffinityCallback(ConnectionAffinityCallback cbk) throws UniversalConnectionPoolException {
        this.m_connectionAffinityCallback = null;
        this.m_affinityMap.clear();
    }

    public ConnectionAffinityCallback getConnectionAffinityCallback() {
        this.poolLock.lock();
        try {
            ConnectionAffinityCallback connectionAffinityCallback = this.m_connectionAffinityCallback;
            return connectionAffinityCallback;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    void setConnectionAffinityValue(String instanceKey, boolean newValue) {
        assert (instanceKey != null);
        this.m_affinityMap.put(instanceKey, newValue);
    }

    public boolean getConnectionAffinityValue(String instanceKey) {
        assert (instanceKey != null);
        Boolean lookupValue = this.m_affinityMap.get(instanceKey);
        if (lookupValue == null) {
            this.trace(Level.FINEST, CLASS_NAME, "getConnectionAffinityValue", "instance/context not in map, lookup returns null", null, null, new Object[0]);
        }
        return lookupValue != null ? lookupValue : false;
    }

    public String generateDatabaseInstanceKey(String instanceName, String dbName, String serviceName) {
        return instanceName + "##" + dbName + "##" + serviceName;
    }

    void handleLoadBalancingEvent(OracleLoadBalancingEvent rlbEvent) throws UniversalConnectionPoolException {
        this.rlbMetricsAccumulator.newEvent(rlbEvent.getServiceName(), rlbEvent.getEventBody(), this.m_dbInstanceInfoList.getRacMetadata());
        for (OracleDatabaseInstanceInfo instanceInfo : this.m_dbInstanceInfoList.getAllInstances()) {
            if (OracleDatabaseInstanceInfo.RebalancingState.SHRINKING == instanceInfo.getRebalancingState()) continue;
            instanceInfo.setRebalancingState(OracleDatabaseInstanceInfo.RebalancingState.QUIESCENT);
        }
        this.trace(Level.FINEST, CLASS_NAME, "handleLoadBalancingEvent", "{0}", null, null, this.rlbMetricsAccumulator.toString(1));
        MetricsAccumulator.Frame frame = this.rlbMetricsAccumulator.getPreviousFrame();
        if (null != frame) {
            int totalConns = 0;
            for (MetricsAccumulator.InstanceStats stats : frame.distribution.values()) {
                totalConns += stats.getConnsTotal();
            }
            this.trace(Level.FINEST, CLASS_NAME, "handleLoadBalancingEvent", "serviceName={0}, eventBody={1}", null, null, rlbEvent.getServiceName(), new String(rlbEvent.getEventBody()));
            for (String inst : frame.distribution.keySet()) {
                MetricsAccumulator.InstanceStats instStats = frame.distribution.get(inst);
                if (null == instStats) continue;
                float percentTotals = (float)instStats.getConnsTotal() / (float)totalConns * 100.0f;
                float percentLoad = (float)instStats.getConnsBorrowed() / (float)frame.totalBorrowed * 100.0f;
                float percentAdvisory = instStats.getAdvisoryPercent();
                String msg = " -- " + inst + " #c=" + instStats.getConnsTotal() + " (" + percentTotals + "%)" + " load=" + percentLoad + "%" + " ONS=" + percentAdvisory + '%' + " (new=" + instStats.getConnsCreated() + ", closed=" + instStats.getConnsClosed() + ')';
                this.trace(Level.FINEST, CLASS_NAME, "handleLoadBalancingEvent", msg, null, null, new Object[0]);
            }
        }
        String instNameKey = null;
        String dbUniqNameKey = null;
        boolean isInstanceAffinityEnabled = false;
        ConnectionAffinityCallback cbk = this.getConnectionAffinityCallback();
        isInstanceAffinityEnabled = cbk != null ? cbk.getAffinityPolicy() == ConnectionAffinityCallback.AffinityPolicy.TRANSACTION_BASED_AFFINITY : false;
        Set<RACInstance> racInstances = rlbEvent.getRACInstances();
        for (RACInstance racInstance : racInstances) {
            instNameKey = racInstance.getInstance();
            dbUniqNameKey = racInstance.getDatabase();
            OracleDatabaseInstanceInfo tmpInstance = new OracleDatabaseInstanceInfo(dbUniqNameKey, instNameKey);
            tmpInstance.setAdvisoryPercent(this.olderWLSCompatible ? (float)racInstance.getPercent() : racInstance.getFloatPercent());
            tmpInstance.flag = racInstance.getInstanceStatus().ordinal() + 1;
            tmpInstance.setServiceName(this.m_serviceName.get());
            this.updateDatabaseInstanceInfo(tmpInstance, false, false);
            if (isInstanceAffinityEnabled) continue;
            String instanceKey = this.generateDatabaseInstanceKey(instNameKey, dbUniqNameKey, this.m_serviceName.get());
            this.setConnectionAffinityValue(instanceKey, ((RACInstanceImpl)racInstance).getAffinityHint());
        }
        if (null != this.rlbMetricsAccumulator.getPreviousFrame()) {
            this.processDatabaseInstances();
        }
        this.getRACCallback().lbaEventOccurred(rlbEvent);
    }

    TaskManager getTaskManager() {
        return this.m_taskManager;
    }

    @Override
    public RACInstance getMostDesirableInstanceToGrow() {
        return this.m_dbInstanceInfoList.getMostDesirableInstanceToGrow();
    }

    @Override
    public RACAffinityContext createRACAffinityContext(String service, String dbUniqName, String instance, String version, RACAffinityContext.AffinityType affinityType) {
        OracleConnectionAffinityContext context = new OracleConnectionAffinityContext();
        context.setServiceName(service);
        context.setDatabaseUniqueName(dbUniqName);
        context.setInstanceName(instance);
        context.setVersionNumber(version);
        context.setForInstanceAffinity(affinityType == RACAffinityContext.AffinityType.TRANSACTION_BASED_AFFINITY);
        return context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getAutoONSConfigurationFromServer() throws UniversalConnectionPoolException {
        FailoverablePooledConnection fpc = null;
        try {
            fpc = this.getRACCallback().openNewConnection(null, null);
            if (fpc != null) {
                this.trace(Level.FINEST, CLASS_NAME, "getAutoONSConfigurationFromServer", "got new physical connection: {0}", null, null, fpc);
                Properties props = fpc.getConnectionInfo();
                String val = props.getProperty("AUTH_ONS_CONFIG");
                if (val != null && !val.equals("")) {
                    this.trace(Level.FINEST, CLASS_NAME, "getAutoONSConfigurationFromServer", "ONS auto-config: {0}", null, null, val);
                    this.setONSConfiguration(val.trim());
                } else {
                    this.trace(Level.FINEST, CLASS_NAME, "getAutoONSConfigurationFromServer", "ONS auto-config: null", null, null, new Object[0]);
                }
            } else {
                this.trace(Level.FINEST, CLASS_NAME, "getAutoONSConfigurationFromServer", "got null physical connection", null, null, new Object[0]);
            }
            if (fpc == null) return;
        }
        catch (Throwable throwable) {
            try {
                this.trace(Level.FINEST, CLASS_NAME, "getAutoONSConfigurationFromServer", "Getting ONS auto-config failed: {0}", null, null, this.getStackTraceString(throwable));
                throw UCPErrorHandler.newUniversalConnectionPoolException(313, throwable);
            }
            catch (Throwable throwable2) {
                if (fpc == null) throw throwable2;
                try {
                    fpc.abort();
                    fpc.close(false);
                    this.trace(Level.FINEST, CLASS_NAME, "getAutoONSConfigurationFromServer", "closed physical connection: {0}", null, null, fpc);
                    throw throwable2;
                }
                catch (UniversalConnectionPoolException exc) {
                    this.trace(Level.WARNING, CLASS_NAME, "getAutoONSConfigurationFromServer", "connection cleanup failed after getting ONS auto-config:", null, exc, new Object[0]);
                }
                throw throwable2;
            }
        }
        try {
            fpc.abort();
            fpc.close(false);
            this.trace(Level.FINEST, CLASS_NAME, "getAutoONSConfigurationFromServer", "closed physical connection: {0}", null, null, fpc);
            return;
        }
        catch (UniversalConnectionPoolException exc) {
            this.trace(Level.WARNING, CLASS_NAME, "getAutoONSConfigurationFromServer", "connection cleanup failed after getting ONS auto-config:", null, exc, new Object[0]);
            return;
        }
    }

    protected ONS getONS() throws UniversalConnectionPoolException {
        if (this.calledStartONS && this.currentONS == null && !"".equals(this.getONSConfiguration())) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(312);
        }
        return this.currentONS;
    }

    @Override
    public ShardManager createShardManager() throws UniversalConnectionPoolException {
        return new ShardManagerImpl(this.getONS(), this.diagnosticsCollector);
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosticsCollector;
    }

    public static interface RACCallbackExtended
    extends RACCallback {
        public void tearDownConnectionsForInstance(OracleDatabaseInstanceInfo var1, int var2);
    }
}

