/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.internal.vectorization;

import jdk.incubator.vector.VectorShape;
import jdk.incubator.vector.VectorSpecies;
import org.apache.lucene.internal.vectorization.VectorizationProvider;
import org.apache.lucene.util.Constants;

final class PanamaVectorConstants {
    static final int PREFERRED_VECTOR_BITSIZE;
    static final boolean HAS_FAST_INTEGER_VECTORS;
    static final VectorSpecies<Long> PRERERRED_LONG_SPECIES;
    static final VectorSpecies<Integer> PRERERRED_INT_SPECIES;
    static final VectorSpecies<Double> PREFERRED_DOUBLE_SPECIES;

    private PanamaVectorConstants() {
    }

    static {
        int vectorBitSize = VectorShape.preferredShape().vectorBitSize();
        PREFERRED_VECTOR_BITSIZE = VectorizationProvider.TESTS_VECTOR_SIZE.orElse(vectorBitSize);
        boolean isAMD64withoutAVX2 = Constants.OS_ARCH.equals("amd64") && PREFERRED_VECTOR_BITSIZE < 256;
        HAS_FAST_INTEGER_VECTORS = VectorizationProvider.TESTS_FORCE_INTEGER_VECTORS || !isAMD64withoutAVX2;
        PRERERRED_LONG_SPECIES = VectorSpecies.of(Long.TYPE, (VectorShape)VectorShape.forBitSize((int)PREFERRED_VECTOR_BITSIZE));
        PRERERRED_INT_SPECIES = VectorSpecies.of(Integer.TYPE, (VectorShape)VectorShape.forBitSize((int)PREFERRED_VECTOR_BITSIZE));
        PREFERRED_DOUBLE_SPECIES = VectorSpecies.of(Double.TYPE, (VectorShape)VectorShape.forBitSize((int)PREFERRED_VECTOR_BITSIZE));
    }
}

