/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.data.type;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.time.DateFormatters;
import org.opensearch.common.time.FormatNames;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;

public class OpenSearchDateType
extends OpenSearchDataType {
    private static final OpenSearchDateType instance = new OpenSearchDateType();
    public static final List<FormatNames> SUPPORTED_NAMED_NUMERIC_FORMATS = List.of(FormatNames.EPOCH_MILLIS, FormatNames.EPOCH_SECOND, FormatNames.EPOCH_MICROS);
    public static final List<FormatNames> SUPPORTED_NAMED_DATETIME_FORMATS = List.of(FormatNames.ISO8601, FormatNames.BASIC_DATE_TIME, FormatNames.BASIC_DATE_TIME_NO_MILLIS, FormatNames.BASIC_ORDINAL_DATE_TIME, FormatNames.BASIC_ORDINAL_DATE_TIME_NO_MILLIS, FormatNames.BASIC_WEEK_DATE_TIME, FormatNames.STRICT_BASIC_WEEK_DATE_TIME, FormatNames.BASIC_WEEK_DATE_TIME_NO_MILLIS, FormatNames.STRICT_BASIC_WEEK_DATE_TIME_NO_MILLIS, FormatNames.BASIC_WEEK_DATE, FormatNames.STRICT_BASIC_WEEK_DATE, FormatNames.DATE_OPTIONAL_TIME, FormatNames.STRICT_DATE_OPTIONAL_TIME, FormatNames.STRICT_DATE_OPTIONAL_TIME_NANOS, FormatNames.DATE_TIME, FormatNames.STRICT_DATE_TIME, FormatNames.DATE_TIME_NO_MILLIS, FormatNames.STRICT_DATE_TIME_NO_MILLIS, FormatNames.DATE_HOUR_MINUTE_SECOND_FRACTION, FormatNames.STRICT_DATE_HOUR_MINUTE_SECOND_FRACTION, FormatNames.DATE_HOUR_MINUTE_SECOND_FRACTION, FormatNames.DATE_HOUR_MINUTE_SECOND_MILLIS, FormatNames.STRICT_DATE_HOUR_MINUTE_SECOND_MILLIS, FormatNames.DATE_HOUR_MINUTE_SECOND, FormatNames.STRICT_DATE_HOUR_MINUTE_SECOND, FormatNames.DATE_HOUR_MINUTE, FormatNames.STRICT_DATE_HOUR_MINUTE, FormatNames.DATE_HOUR, FormatNames.STRICT_DATE_HOUR, FormatNames.ORDINAL_DATE_TIME, FormatNames.STRICT_ORDINAL_DATE_TIME, FormatNames.ORDINAL_DATE_TIME_NO_MILLIS, FormatNames.STRICT_ORDINAL_DATE_TIME_NO_MILLIS, FormatNames.WEEK_DATE_TIME, FormatNames.STRICT_WEEK_DATE_TIME, FormatNames.WEEK_DATE_TIME_NO_MILLIS, FormatNames.STRICT_WEEK_DATE_TIME_NO_MILLIS);
    public static final List<FormatNames> SUPPORTED_NAMED_DATE_FORMATS = List.of(FormatNames.BASIC_DATE, FormatNames.BASIC_ORDINAL_DATE, FormatNames.DATE, FormatNames.STRICT_DATE, FormatNames.YEAR_MONTH_DAY, FormatNames.STRICT_YEAR_MONTH_DAY, FormatNames.ORDINAL_DATE, FormatNames.STRICT_ORDINAL_DATE, FormatNames.WEEK_DATE, FormatNames.STRICT_WEEK_DATE, FormatNames.WEEKYEAR_WEEK_DAY, FormatNames.STRICT_WEEKYEAR_WEEK_DAY);
    public static final List<FormatNames> SUPPORTED_NAMED_INCOMPLETE_DATE_FORMATS = List.of(FormatNames.YEAR_MONTH, FormatNames.STRICT_YEAR_MONTH, FormatNames.YEAR, FormatNames.STRICT_YEAR, FormatNames.WEEK_YEAR, FormatNames.WEEK_YEAR_WEEK, FormatNames.STRICT_WEEKYEAR_WEEK, FormatNames.WEEKYEAR, FormatNames.STRICT_WEEKYEAR);
    public static final List<FormatNames> SUPPORTED_NAMED_TIME_FORMATS = List.of(FormatNames.BASIC_TIME, FormatNames.BASIC_TIME_NO_MILLIS, FormatNames.BASIC_T_TIME, FormatNames.BASIC_T_TIME_NO_MILLIS, FormatNames.TIME, FormatNames.STRICT_TIME, FormatNames.TIME_NO_MILLIS, FormatNames.STRICT_TIME_NO_MILLIS, FormatNames.HOUR_MINUTE_SECOND_FRACTION, FormatNames.STRICT_HOUR_MINUTE_SECOND_FRACTION, FormatNames.HOUR_MINUTE_SECOND_MILLIS, FormatNames.STRICT_HOUR_MINUTE_SECOND_MILLIS, FormatNames.HOUR_MINUTE_SECOND, FormatNames.STRICT_HOUR_MINUTE_SECOND, FormatNames.HOUR_MINUTE, FormatNames.STRICT_HOUR_MINUTE, FormatNames.HOUR, FormatNames.STRICT_HOUR, FormatNames.T_TIME, FormatNames.STRICT_T_TIME, FormatNames.T_TIME_NO_MILLIS, FormatNames.STRICT_T_TIME_NO_MILLIS);
    private static final String CUSTOM_FORMAT_TIME_SYMBOLS = "nNASsmHkKha";
    private static final String CUSTOM_FORMAT_DATE_SYMBOLS = "FecEWwYqQgdMLDyuG";
    private static final List<DateFormatter> OPENSEARCH_DEFAULT_FORMATTERS = Stream.of("strict_date_time_no_millis", "strict_date_optional_time", "epoch_millis").map(DateFormatter::forPattern).toList();
    private final List<String> formats;

    private OpenSearchDateType() {
        super(OpenSearchDataType.MappingType.Date);
        this.formats = List.of();
    }

    private OpenSearchDateType(ExprCoreType exprCoreType) {
        this();
        this.exprCoreType = exprCoreType;
    }

    private OpenSearchDateType(ExprType exprType) {
        this();
        this.exprCoreType = (ExprCoreType)exprType;
    }

    private OpenSearchDateType(String format) {
        super(OpenSearchDataType.MappingType.Date);
        this.formats = this.getFormatList(format);
        this.exprCoreType = this.getExprTypeFromFormatString(format);
    }

    public boolean hasFormats() {
        return !this.formats.isEmpty();
    }

    private List<String> getFormatList(String format) {
        format = DateFormatter.strip8Prefix((String)format);
        return DateFormatter.splitCombinedPatterns((String)format).stream().map(String::trim).collect(Collectors.toList());
    }

    public List<DateFormatter> getAllNamedFormatters() {
        return this.formats.stream().filter(formatString -> FormatNames.forName((String)formatString) != null).map(DateFormatter::forPattern).collect(Collectors.toList());
    }

    public List<DateFormatter> getNumericNamedFormatters() {
        return this.formats.stream().filter(formatString -> {
            FormatNames namedFormat = FormatNames.forName((String)formatString);
            return namedFormat != null && SUPPORTED_NAMED_NUMERIC_FORMATS.contains(namedFormat);
        }).map(DateFormatter::forPattern).collect(Collectors.toList());
    }

    public List<String> getAllCustomFormats() {
        return this.formats.stream().filter(format -> FormatNames.forName((String)format) == null).map(format -> {
            try {
                DateFormatter.forPattern((String)format);
                return format;
            }
            catch (Exception ignored) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<DateFormatter> getAllCustomFormatters() {
        return this.getAllCustomFormats().stream().map(DateFormatter::forPattern).collect(Collectors.toList());
    }

    public ZonedDateTime getParsedDateTime(String dateTime) {
        List<Object> dateFormatters = Stream.concat(this.getAllNamedFormatters().stream(), this.getAllCustomFormatters().stream()).collect(Collectors.toList());
        ZonedDateTime zonedDateTime = null;
        if (dateFormatters.isEmpty()) {
            dateFormatters = OPENSEARCH_DEFAULT_FORMATTERS;
        }
        for (DateFormatter formatter : dateFormatters) {
            try {
                TemporalAccessor accessor = formatter.parse(dateTime);
                zonedDateTime = DateFormatters.from((TemporalAccessor)accessor).withZoneSameLocal(ZoneOffset.UTC);
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return zonedDateTime;
    }

    public String getFormattedDate(TemporalAccessor accessor) {
        if (this.hasNoFormatter()) {
            return OPENSEARCH_DEFAULT_FORMATTERS.get(0).format(accessor);
        }
        return DateFormatter.forPattern((String)this.formats.get(0)).format(accessor);
    }

    public boolean hasNoFormatter() {
        return this.formats.isEmpty();
    }

    public List<DateFormatter> getDateNamedFormatters() {
        return this.formats.stream().filter(formatString -> {
            FormatNames namedFormat = FormatNames.forName((String)formatString);
            return namedFormat != null && SUPPORTED_NAMED_DATE_FORMATS.contains(namedFormat);
        }).map(DateFormatter::forPattern).collect(Collectors.toList());
    }

    public List<DateFormatter> getTimeNamedFormatters() {
        return this.formats.stream().filter(formatString -> {
            FormatNames namedFormat = FormatNames.forName((String)formatString);
            return namedFormat != null && SUPPORTED_NAMED_TIME_FORMATS.contains(namedFormat);
        }).map(DateFormatter::forPattern).collect(Collectors.toList());
    }

    public List<DateFormatter> getDateTimeNamedFormatters() {
        return this.formats.stream().filter(formatString -> {
            FormatNames namedFormat = FormatNames.forName((String)formatString);
            return namedFormat != null && SUPPORTED_NAMED_DATETIME_FORMATS.contains(namedFormat);
        }).map(DateFormatter::forPattern).collect(Collectors.toList());
    }

    private ExprCoreType getExprTypeFromCustomFormats(List<String> formats) {
        boolean isDate = false;
        boolean isTime = false;
        for (String format : formats) {
            if (!isTime) {
                for (char symbol : CUSTOM_FORMAT_TIME_SYMBOLS.toCharArray()) {
                    if (!format.contains(String.valueOf(symbol))) continue;
                    isTime = true;
                    break;
                }
            }
            if (!isDate) {
                for (char symbol : CUSTOM_FORMAT_DATE_SYMBOLS.toCharArray()) {
                    if (!format.contains(String.valueOf(symbol))) continue;
                    isDate = true;
                    break;
                }
            }
            if (!isDate || !isTime) continue;
            return ExprCoreType.TIMESTAMP;
        }
        if (isDate) {
            return ExprCoreType.DATE;
        }
        if (isTime) {
            return ExprCoreType.TIME;
        }
        return ExprCoreType.TIMESTAMP;
    }

    private ExprCoreType getExprTypeFromFormatString(String formatString) {
        List<DateFormatter> datetimeFormatters = this.getDateTimeNamedFormatters();
        List<DateFormatter> numericFormatters = this.getNumericNamedFormatters();
        if (formatString.isEmpty() || !datetimeFormatters.isEmpty() || !numericFormatters.isEmpty()) {
            return ExprCoreType.TIMESTAMP;
        }
        List<DateFormatter> timeFormatters = this.getTimeNamedFormatters();
        List<DateFormatter> dateFormatters = this.getDateNamedFormatters();
        if (!timeFormatters.isEmpty() && !dateFormatters.isEmpty()) {
            return ExprCoreType.TIMESTAMP;
        }
        List<String> customFormatters = this.getAllCustomFormats();
        if (!customFormatters.isEmpty()) {
            ExprCoreType customFormatType;
            ExprCoreType combinedByDefaultFormats = customFormatType = this.getExprTypeFromCustomFormats(customFormatters);
            if (!dateFormatters.isEmpty()) {
                combinedByDefaultFormats = ExprCoreType.DATE;
            }
            if (!timeFormatters.isEmpty()) {
                combinedByDefaultFormats = ExprCoreType.TIME;
            }
            return customFormatType == combinedByDefaultFormats ? customFormatType : ExprCoreType.TIMESTAMP;
        }
        if (!timeFormatters.isEmpty()) {
            return ExprCoreType.TIME;
        }
        if (!dateFormatters.isEmpty()) {
            return ExprCoreType.DATE;
        }
        return ExprCoreType.TIMESTAMP;
    }

    public static boolean isDateTypeCompatible(ExprType exprType) {
        if (!(exprType instanceof ExprCoreType)) {
            return false;
        }
        switch ((ExprCoreType)exprType) {
            case TIMESTAMP: 
            case DATE: 
            case TIME: {
                return true;
            }
        }
        return false;
    }

    public static OpenSearchDateType of(String format) {
        return new OpenSearchDateType(format);
    }

    public static OpenSearchDateType of(ExprCoreType exprCoreType) {
        return new OpenSearchDateType(exprCoreType);
    }

    public static OpenSearchDateType of(ExprType exprType) {
        return new OpenSearchDateType(exprType);
    }

    public static OpenSearchDateType of() {
        return instance;
    }

    @Override
    public List<ExprType> getParent() {
        return List.of(this.exprCoreType);
    }

    @Override
    public boolean shouldCast(ExprType other) {
        return false;
    }

    @Override
    protected OpenSearchDataType cloneEmpty() {
        if (this.formats.isEmpty()) {
            return OpenSearchDateType.of(this.exprCoreType);
        }
        return OpenSearchDateType.of(String.join((CharSequence)" || ", this.formats));
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSearchDateType)) {
            return false;
        }
        OpenSearchDateType other = (OpenSearchDateType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpenSearchDateType;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

