# boolean_switch_row.py
#
# Copyright 2024 Hari Rana (TheEvilSkeleton)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# SPDX-License-Identifier: GPL-3.0-or-later

import logging
from typing import Any

from gi.repository import Gio, Gtk

from refine.widgets.base import BaseInterface
from refine.widgets.toggle_row import ToggleRow


@Gtk.Template.from_resource("/page/tesk/Refine/widgets/boolean-switch-row.ui")
class BooleanSwitchRow(ToggleRow):
    """A `ToggleRow` with on/off switches."""

    __gtype_name__ = "BooleanSwitchRow"

    revert_button = Gtk.Template.Child()
    revealer = Gtk.Template.Child()

    def do_setup(self) -> None:
        super().do_setup()
        self.settings.bind(self.key, self, "active", Gio.SettingsBindFlags.DEFAULT)

        self.connect("notify::active", self._active_set_callback)
        self.revert_button.connect("clicked", self._revert_button_clicked)
        BaseInterface.set_up_separator_revealer(self.revealer, self.revert_button)

    def do_update(self) -> None:
        super().do_update()
        self.is_default = self.settings.get_default_value(
            self.key
        ) != self.settings.get_value(self.key)
        to_float = float(self.is_default)

        self.revert_button.set_opacity(to_float)
        self.revert_button.set_can_focus(self.is_default)
        self.revert_button.set_can_target(self.is_default)

    def _active_set_callback(self, *_args: Any) -> None:
        self.do_update()
        self.value_set(self.settings.get_value(self.key))

    def _revert_button_clicked(self, *_args: Any) -> None:
        logging.debug("Revert button pressed")
        self.settings.reset(self.key)
