/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.spi;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.Bundle;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.BrowserUtils;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.openide.util.RequestProcessor;

public abstract class DetailsProvider {
    public String[] getSupportedClasses() {
        return null;
    }

    public String getDetailsString(String className, Instance instance) {
        return null;
    }

    public View getDetailsView(String className, Instance instance) {
        return null;
    }

    public static abstract class View
    extends JPanel {
        private RequestProcessor.Task workerTask;
        private Instance instance;

        protected View(Instance instance) {
            this(instance, View.initialView());
        }

        private static JComponent initialView() {
            JLabel loading = new JLabel(Bundle.BrowserUtils_Loading(), 0);
            loading.setEnabled(false);
            JPanel loadingContainer = new JPanel(new BorderLayout());
            loadingContainer.setOpaque(true);
            loadingContainer.setBackground(UIUtils.getProfilerResultsBackground());
            loadingContainer.setEnabled(false);
            loadingContainer.add((Component)loading, "Center");
            return loadingContainer;
        }

        protected View(Instance instance, Component initialView) {
            super(new BorderLayout());
            this.add(initialView, "Center");
            this.instance = instance;
        }

        protected abstract void computeView(Instance var1);

        @Override
        public final void addNotify() {
            super.addNotify();
            this.workerTask = BrowserUtils.performTask(new Runnable(){

                @Override
                public void run() {
                    if (!Thread.interrupted()) {
                        this.computeView(instance);
                    }
                }
            });
        }

        protected void removed() {
        }

        @Override
        public final void removeNotify() {
            this.workerTask.cancel();
            super.removeNotify();
            this.removed();
        }
    }

    public static abstract class Basic
    extends DetailsProvider {
        private final String[] supportedClasses;

        public Basic() {
            this(null);
        }

        protected Basic(String ... supportedClasses) {
            this.supportedClasses = supportedClasses;
        }

        @Override
        public final String[] getSupportedClasses() {
            return this.supportedClasses;
        }
    }
}

