/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.openjdk.jmc.common.collection.AbstractIterator;

public class IteratorToolkit {
    public static <T> List<T> toList(Iterator<T> itr, int sizeHint) {
        ArrayList<T> list = new ArrayList<T>(sizeHint);
        while (itr.hasNext()) {
            list.add(itr.next());
        }
        return list;
    }

    public static <T> Iterator<T> skipNulls(Iterator<T> itr) {
        return IteratorToolkit.filter(itr, new Predicate<T>(){

            @Override
            public boolean test(T o) {
                return o != null;
            }
        });
    }

    public static <T> Iterator<T> filter(final Iterator<T> itr, final Predicate<? super T> filter) {
        return new AbstractIterator<T>(){

            @Override
            protected T findNext() {
                while (itr.hasNext()) {
                    Object object = itr.next();
                    if (!filter.test(object)) continue;
                    return object;
                }
                return this.NO_MORE_ELEMENTS;
            }
        };
    }

    public static <T> Iterator<T> of(T[] elements) {
        return IteratorToolkit.of(elements, 0, elements.length);
    }

    static <T> Iterator<T> of(final T[] elements, final int offset, final int len) {
        if (offset < 0 || offset > len || len > elements.length) {
            throw new IllegalArgumentException("Cannnot contruct iterator with offset=" + offset + " and len=" + len + " for an array of length " + elements.length);
        }
        return new Iterator<T>(){
            private int index;
            {
                this.index = offset;
            }

            @Override
            public boolean hasNext() {
                return this.index != len;
            }

            @Override
            public T next() {
                try {
                    return elements[this.index++];
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Iterator doesn't support removal.");
            }
        };
    }
}

