dnl $Id: acsite.m4,v 1.56 2005/10/26 19:00:08 ca Exp $

dnl ##########################################################################
dnl ###  SM_UNSIGNED_SIZE_T - check for unsigned size_t
dnl ##########################################################################

AC_DEFUN([SM_UNSIGNED_SIZE_T], [
  AC_CACHE_CHECK([for unsigned size_t],
    sm_cv_unsigned_size_t,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <sys/types.h>

int main()
{
	size_t v;

	v = 0;
	--v;
	if (v > 0)
		exit(0);
	exit(1);
}
>>changequote([, ]),
      sm_cv_unsigned_size_t=yes,
      sm_cv_unsigned_size_t=no,
      sm_cv_unsigned_size_t=no
    )]
  )
  if test "$sm_cv_unsigned_size_t" = "yes"; then
    AC_DEFINE(HAVE_UNSIGNED_SIZE_T, 1, [Define if your system size_t is unsigned ])
  fi
])

dnl ##########################################################################
dnl ###  SM_UNSIGNED_CHAR - check for unsigned char
dnl ##########################################################################

AC_DEFUN([SM_UNSIGNED_CHAR], [
  AC_CACHE_CHECK([for unsigned char],
    sm_cv_unsigned_char,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <sys/types.h>

int main()
{
	char v;

	v = 0;
	--v;
	if (v > 0)
		exit(0);
	exit(1);
}
>>changequote([, ]),
      sm_cv_unsigned_char=yes,
      sm_cv_unsigned_char=no,
      sm_cv_unsigned_char=no
    )]
  )
  if test "$sm_cv_unsigned_char" = "yes"; then
    AC_DEFINE(HAVE_UNSIGNED_CHAR, 1, [Define if your system char is unsigned ])
  fi
])

dnl ##########################################################################
dnl ###  SM_STATFS_4ARGS - check for four-argument statfs call
dnl ##########################################################################

AC_DEFUN([SM_STATFS_4ARGS], [
  AC_CACHE_CHECK([for four-argument statfs call],
    sm_cv_statfs_4args,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#if HAVE_SYS_STATFS_H
#include <sys/statfs.h>
#endif
#if HAVE_SYS_MOUNT_H
#include <sys/param.h>
#include <sys/mount.h>
#endif

int main()
{
	char *dir;
	struct statfs fs;

	dir = ".";
	if (statfs(dir, &fs, sizeof fs, 0) == 0)
		exit(0);
	exit(1);
}
>>changequote([, ]),
      sm_cv_statfs_4args=yes,
      sm_cv_statfs_4args=no,
      sm_cv_statfs_4args=no
    )]
  )
  if test "$sm_cv_statfs_4args" = "yes"; then
    AC_DEFINE(HAVE_STATFS_4ARGS, 1, [Define if statfs uses four arguments])
  fi
])

dnl ##########################################################################
dnl ###  SM_FUNC_SNPRINTF - check for working snprintf()
dnl ##########################################################################

AC_DEFUN([SM_FUNC_SNPRINTF], [
  AC_CACHE_CHECK([for working snprintf],
    sm_cv_func_snprintf_works,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>

typedef struct {
  int length;
  char *test;
  int retval;
  char *result;
} test_t;

const test_t tests[] = {
  { 10, "12345678901234567890", 20, "123456789" },
#if 0
  { 0, "12345678901234567890", 20, NULL },
  { -1, "12345678901234567890", -1, NULL },
#endif
  { 0, NULL, 0, NULL }
};

int main() {
  char test1[1024];
  int i;

  for (i = 0; tests[i].test; i++) {
    memset(test1, 'X', sizeof(test1));
    if ((snprintf(test1, tests[i].length, "%s", tests[i].test)
         != tests[i].retval) ||
        (tests[i].result && strcmp(tests[i].result, test1)))
      exit(1);
  }

  exit(0);
}
>>changequote([, ]),
      sm_cv_func_snprintf_works=yes,
      sm_cv_func_snprintf_works=no,
      sm_cv_func_snprintf_works=no
    )]
  )
  if test "$sm_cv_func_snprintf_works" = "yes"; then
    AC_DEFINE(HAVE_SNPRINTF, 1, [Define if your system has a working snprintf])
  else
    LIBOBJS="$LIBOBJS snprintf.o"
  fi
])

dnl ##########################################################################
dnl ###  SM_TYPE - check for arbitrary type in arbitrary header file(s)
dnl ##########################################################################

dnl ### Usage: SM_TYPE(type_t, default, [ #include <hdr1.h> ... ])
AC_DEFUN([SM_TYPE], [
  AC_CACHE_CHECK(if $1 is defined, sm_cv_type_$1,
    AC_TRY_LINK($3,
      $1 x;,
      sm_cv_type_$1=yes,
      sm_cv_type_$1=no
    )
  )
  if test "$sm_cv_type_$1" != "yes"; then
    AC_DEFINE($1, $2, Define if your system does not have $1)
  fi
])

dnl ##########################################################################
dnl ###  SM_LIB_WRAP - check for TCP Wrappers library
dnl ##########################################################################

AC_DEFUN([SM_LIB_WRAP], [
  AC_CHECK_HEADERS(tcpd.h)
  if test "$ac_cv_header_tcpd_h" = "yes"; then
    sm_old_libs="$LIBS"
    LIBS="$LIBS -lwrap"
    AC_CACHE_CHECK([for libwrap library], sm_cv_lib_wrap_hosts_ctl,
      AC_TRY_LINK(
        [
          #include <stdio.h>
          #include <tcpd.h>
          int allow_severity;
          int deny_severity;
        ], [
          hosts_ctl("test", STRING_UNKNOWN, "10.0.0.1", STRING_UNKNOWN);
        ],
        sm_cv_lib_wrap_hosts_ctl=yes,
        sm_cv_lib_wrap_hosts_ctl=no
      )
    )
    if test "$sm_cv_lib_wrap_hosts_ctl" = "yes"; then
      AC_DEFINE(HAVE_LIBWRAP, 1, [Define if you have libwrap])
    else
      LIBS="$sm_old_libs"
    fi
  fi
])

dnl ##########################################################################
dnl ###  SM_CHECK_RES_SEARCH - check for broken res_search()
dnl ##########################################################################

AC_DEFUN([SM_CHECK_RES_SEARCH], [
  AC_CACHE_CHECK([for broken res_search],
    sm_cv_func_broken_res_search,
    AC_TRY_RUN(
      [
	#include <sys/types.h>
	#include <netinet/in.h>
	#include <arpa/nameser.h>
	#include <resolv.h>

	int main()
	{
	  unsigned char answer[1024];

	  if (res_search("unknown.sendmail.org", C_IN, T_MX,
		         answer, sizeof(answer)) == -1
	      && h_errno == 0)
	    exit(0);

	  exit(1);
	}
      ],
      sm_cv_func_broken_res_search=yes,
      sm_cv_func_broken_res_search=no
    )
  )
  if test "$sm_cv_func_broken_res_search" = "yes"; then
    AC_DEFINE(BROKEN_RES_SEARCH, 1,
              [Define if res_search sets h_errno to 0 on unknown hosts])
  fi
])

dnl ##########################################################################
dnl ###  SM_TYPE_ACCEPT - check for type of 3rd arg to accept()
dnl ##########################################################################

AC_DEFUN([SM_TYPE_ACCEPT], [
  AC_CHECK_FUNCS(accept)
  if test "$ac_cv_func_accept" = "yes"; then
    AC_CACHE_CHECK([for type of argument 3 of accept],
      sm_cv_type_accept_arg3,
      for sm_type in 'socklen_t' 'size_t' 'unsigned long'  'unsigned int' 'int'; do
	AC_TRY_COMPILE(
	  [
	    #include <sys/types.h>
	    #include <sys/socket.h>
	  ], [
	    extern int accept(int, struct sockaddr *, $sm_type *);
          ],
          [ sm_cv_type_accept_arg3=$sm_type; break ]
        )
      done
      if test "$sm_cv_type_accept_arg3" = ""; then
	sm_cv_type_accept_arg3="int";
      fi
    )
    if test "$sm_cv_type_accept_arg3" != ""; then
      AC_DEFINE_UNQUOTED(socklen_T, $sm_cv_type_accept_arg3,
                         [Define to the type of the 3rd arg to accept()])
    fi
  fi
])

dnl ##########################################################################
dnl ###  SM_TYPE_GETSOCKOPT - check for type of 5th arg to getsockopt()
dnl ##########################################################################

AC_DEFUN([SM_TYPE_GETSOCKOPT], [
  AC_CHECK_FUNCS(getsockopt)
  if test "$ac_cv_func_getsockopt" = "yes"; then
    AC_CACHE_CHECK([for type of argument 5 of getsockopt],
      sm_cv_type_getsockopt_arg5,
      for sm_type in 'socklen_t' 'size_t' 'int'; do
	AC_TRY_COMPILE(
	  [
	    #include <sys/types.h>
	    #include <sys/socket.h>
	  ], [
	    extern int getsockopt(int, int, int, void *, $sm_type *);
          ],
          [ sm_cv_type_getsockopt_arg5=$sm_type; break ]
        )
      done
      if test "$sm_cv_type_getsockopt_arg5" = ""; then
	sm_cv_type_getsockopt_arg5="int";
      fi
    )
    if test "$sm_cv_type_getsockopt_arg5" != ""; then
      AC_DEFINE_UNQUOTED(sockoptlen_T, $sm_cv_type_getsockopt_arg5,
                         [Define to the type of the 5th arg to getsockopt()])
    fi
  fi
])

dnl ##########################################################################
dnl ###  SM_TYPE_GETPWNAME_R - check for POSIX conformance of getpwnam_r()
dnl ##########################################################################

AC_DEFUN([SM_TYPE_GETPWNAME_R], [
  AC_CHECK_FUNCS(getpwnam_r)
    AC_CACHE_CHECK([for POSIX conformance of getpwnam_r],
      sm_cv_posix_getpwnam_r,
	[AC_TRY_LINK(
changequote(<<, >>)<<
#ifndef _POSIX_PTHREAD_SEMANTICS
#define _POSIX_PTHREAD_SEMANTICS 1
#endif
#include <pwd.h>
int r;
struct passwd *pwent;
struct passwd pwentb;
char buf[1024];
	  >>,
	  <<
	    r = getpwnam_r("root", &pwentb, buf, sizeof(buf), &pwent);
>>changequote([, ]),
      sm_cv_posix_getpwnam_r=yes,
      sm_cv_posix_getpwnam_r=no
        )]
    )
  if test "$sm_cv_posix_getpwnam_r" = "yes"; then
	AC_DEFINE_UNQUOTED(POSIX_GETPWNAM_R, 1, [Define if getpwnam_r() conforms to POSIX])
  fi
])


dnl ##########################################################################
dnl ###  SM_SIGWAIT - check for interface to sigwait()
dnl ##########################################################################

AC_DEFUN([SM_SIGWAIT], [
  AC_CHECK_FUNCS(sigwait)
  if test "$ac_cv_func_sigwait" = "yes"; then
    AC_CACHE_CHECK([whether sigwait takes only one argument],
      sm_cv_func_sigwait_one_arg,
      AC_TRY_COMPILE(
	[
	  #include <signal.h>
	], [
	  extern int sigwait(sigset_t *);
	],
	sm_cv_func_sigwait_one_arg=yes,
	sm_cv_func_sigwait_one_arg=no
      )
    )
    if test "$sm_cv_func_sigwait_one_arg" = "yes"; then
      AC_DEFINE(SIGWAIT_ONE_ARG, 1, [Define if sigwait() takes only one arg])
    fi
  fi
])

dnl ##########################################################################
dnl ###  SM_TYPE_CTIME_R - check ctime_r() parameters:
dnl ###  char *ctime_r(const time_t *clock, char *buf);
dnl ###  char *ctime_r(const time_t *clock, char *buf, int buflen);
dnl ##########################################################################

AC_DEFUN([SM_TYPE_CTIME_R], [
  AC_CHECK_FUNCS(ctime_r)
  if test "$ac_cv_func_ctime_r" = "yes"; then
    AC_CACHE_CHECK([ctime_r API], sm_cv_type_ctime_r,
	AC_TRY_COMPILE(
	  [
	    #include <sys/types.h>
	    #include <sys/socket.h>
	  ], [
	    extern char *ctime_r(const time_t *_clock, char *_buf);
	  ],
	  [ sm_cv_type_ctime_r=2 ],
	    AC_TRY_COMPILE(
	      [
	        #include <sys/types.h>
	        #include <sys/socket.h>
	      ], [
	        extern char *ctime_r(const time_t *_clock, char *_buf, int _buflen);
	      ],
	      [ sm_cv_type_ctime_r=3 ],
	   )
	)
      if test "$sm_cv_type_ctime_r" = ""; then
	sm_cv_type_ctime_r=0;
      fi
    )
    if test "$sm_cv_type_ctime_r" != ""; then
      AC_DEFINE_UNQUOTED(SM_CTIME_R_API, $sm_cv_type_ctime_r,
			 [Specify API of ctime_r()])
    fi
  fi
])

dnl ##########################################################################
dnl ###  SM_SAFE_CTYPE ctype.h misbehaves with non-ASCII characters.
dnl ##########################################################################

AC_DEFUN([SM_SAFE_CTYPE], [
  AC_CACHE_CHECK([for safe ctype],
    sm_cv_safe_ctype,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <ctype.h>

int main()
{
	int v;
	char upper[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()_+-=|~,./;'[]<>?:{}  ";
	char lower[] = "abcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+-=|~,./;'[]<>?:{}  ";

	v = EOF;
	if (isalnum(v))
		exit(1);
	if (isprint(v))
		exit(1);
	upper[sizeof(upper) - 2] = '\"';
	lower[sizeof(lower) - 2] = '\"';
	for (v = 128; v < 256; v++)
		if (isalnum(v))
			exit(1);
	for (v = 0; v < sizeof(upper); v++)
	{
		if (tolower(upper[v]) != lower[v])
			exit(1);
		if (toupper(lower[v]) != upper[v])
			exit(1);
	}
	exit(0);
}
>>changequote([, ]),
      sm_cv_safe_ctype=yes,
      sm_cv_safe_ctype=no,
      sm_cv_safe_ctype=no
    )]
  )
  if test "$sm_cv_safe_ctype" = "yes"; then
    AC_DEFINE(HAVE_SAFE_CTYPE, 1, [Define if your system ctype is 8 bit safe ])
  fi
])

dnl ### Check if msghdr{} has msg_control member.
AC_DEFUN([SM_MSGHDR_MSG_CONTROL], [
AC_CACHE_CHECK(if msghdr{} has msg_control member, ac_cv_msghdr_has_msg_control,
	AC_TRY_COMPILE([
#		include <sys/types.h>
#		include <sys/socket.h>],
		[unsigned int i = sizeof(((struct msghdr *)0)->msg_control)],
	ac_cv_msghdr_has_msg_control=yes,
	ac_cv_msghdr_has_msg_control=no))
if test $ac_cv_msghdr_has_msg_control = yes ; then
	AC_DEFINE(HAVE_MSGHDR_MSG_CONTROL, 1, [Define if msghdr{} has msg_control member])
fi
])

dnl ### Check if sockaddr_un has sun_len member.
AC_DEFUN([SM_SOCK_UN_SUN_LEN], [
AC_CACHE_CHECK(if sockaddr_un has sun_len member, ac_cv_sock_un_sun_len,
	AC_TRY_COMPILE([
#		include <sys/types.h>
#		include <sys/socket.h>
#		include <sys/un.h>],
		[unsigned int i = sizeof(((struct sockaddr_un *)0)->sun_len)],
	ac_cv_sock_un_sun_len=yes,
	ac_cv_sock_un_sun_len=no))
if test $ac_cv_sock_un_sun_len = yes ; then
	AC_DEFINE(HAVE_SOCK_UN_SUN_LEN, 1, [Define if sockaddr_un has sun_len member])
fi
])

dnl ### Check if rusage{} has XYZ member.
AC_DEFUN([SM_RUSAGE_MEMBER], [
AC_CACHE_CHECK(if rusage{} has $1 member, ac_cv_rusage_has_$1,
	AC_TRY_COMPILE([
#		include <sys/time.h>
#		include <sys/resource.h>],
		[unsigned int i = sizeof(((struct rusage *)0)->$1)],
	ac_cv_rusage_has_$1=yes,
	ac_cv_rusage_has_$1=no))
if test $ac_cv_rusage_has_$1 = yes ; then
	AC_DEFINE(SM_RUSAGE_$1, 1, [Define if rusage{} has $1 member])
fi
])

dnl ### Check if stat{} has XYZ member.
AC_DEFUN([SM_STAT_MEMBER], [
AC_CACHE_CHECK(if stat{} has $1 member, ac_cv_stat_has_$1,
	AC_TRY_COMPILE([
#		include <sys/types.h>
#		include <sys/stat.h>],
		[unsigned int i = sizeof(((struct stat *)0)->$1)],
	ac_cv_stat_has_$1=yes,
	ac_cv_stat_has_$1=no))
if test $ac_cv_stat_has_$1 = yes ; then
	AC_DEFINE(SM_STAT_$1, 1, [Define if stat{} has $1 member])
fi
])



dnl ##########################################################################
dnl ###  SM_INET_BLKSIZE stat(inet-sock) returns useful value for blksize
dnl ##########################################################################

AC_DEFUN([SM_INET_BLKSIZE], [
  AC_CACHE_CHECK([stat(inet-sock) returns useful value for blksize],
    sm_cv_stblksz_inet,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/stat.h>

int
main(int argc, char **argv)
{
	int fd, r, sockt;
	struct stat st;

	sockt = PF_INET;
	if (argc > 1)
	{
		if (strcasecmp(argv[1], "unix") == 0)
			sockt = PF_UNIX;
		else if (strcasecmp(argv[1], "inet") == 0)
			sockt = PF_INET;
		else return -1;
	}
	fd = socket(sockt, SOCK_STREAM, 0);
	if (fd == -1)
		return -1;
	r = fstat(fd, &st);
	if (r == -1)
		return -1;
	if (st.st_blksize < 256)
		return 1;
	return 0;
}
>>changequote([, ]),
      sm_cv_stblksz_inet=yes,
      sm_cv_stblksz_inet=no,
      sm_cv_stblksz_inet=no
    )]
  )
  if test "$sm_cv_stblksz_inet" = "yes"; then
    AC_DEFINE(HAVE_STBLKSZ_INET, 1, [Define if your system returns useful blksize for inet sockets])
  fi
])


dnl ##########################################################################
dnl ###  SM_FREE_NULL - check whether free(NULL) is ok
dnl ##########################################################################

AC_DEFUN([SM_FREE_NULL], [
  AC_CACHE_CHECK([for free(NULL)],
    sm_cv_free_null,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <stdlib.h>

int main()
{
	free(0);
	exit(0);
}
>>changequote([, ]),
      sm_cv_free_null=yes,
      sm_cv_free_null=no,
      sm_cv_free_null=no
    )]
  )
  if test "$sm_cv_free_null" = "yes"; then
    AC_DEFINE(HAVE_FREE_NULL, 1, [Define if your system allows free(NULL)])
  fi
])

dnl ##########################################################################
dnl ###  SM_STRFTIME_E - check whether strftime() supports %e
dnl ##########################################################################

AC_DEFUN([SM_STRFTIME_E], [
  AC_CACHE_CHECK([strftime() supports %e],
    sm_cv_strftime_e,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <sys/types.h>
#include <time.h>

int main(int argc, char **argv)
{
	size_t r;
	time_t t;
	struct tm *ttm;
	char buf[64];

	t = (time_t) 10000;
	ttm = localtime(&t);
	buf[0] = '\0';
	r = strftime(buf, sizeof(buf), "%e", ttm);
	return strcmp(" 1", buf) == 0;
}
>>changequote([, ]),
      sm_cv_strftime_e=yes,
      sm_cv_strftime_e=no,
      sm_cv_strftime_e=no
    )]
  )
  if test "$sm_cv_strftime_e" = "yes"; then
    AC_DEFINE(HAVE_STRFTIME_E, 1, [Define if strftime() supports %e])
  fi
])


dnl ##########################################################################
dnl ###  Berkeley DB 4.x (x > 0)
dnl ##########################################################################

define(BERKELEY_DB4x_FUNC,
changequote(<<, >>)<<
#include <stdio.h>
#include <db.h>

#if DB_VERSION_MAJOR != 4 || (DB_VERSION_MINOR != 1 && DB_VERSION_MINOR != 2 && DB_VERSION_MINOR != 3)
# error  wrong DB version, need 4.1, 4.2, or 4.3
#endif /* DB_VERSION_MAJOR != 4 */

int
main(int argc, char **argv)
{
	DB *db;
	int ret;

	ret = db_create(&db, 0, 0);
	return 0;
}
>>changequote([, ]))

define(BERKELEY_DB4x_FULL,
changequote(<<, >>)<<
#include <stdio.h>
#include <db.h>
#define BDB_NAME "bdb"
int
bdb_open(void)
{
	int r;
	unsigned int flags;
	int major_v, minor_v, patch_v;
	char *dbfile, *dbh;
	DB *dbp;
	DB_ENV *dbenv;
	DB_TXN *db_txn;

	dbp = NULL;
	dbenv = NULL;
	db_txn = NULL;
	dbfile = NULL;
	(void) db_version(&major_v, &minor_v, &patch_v);
	if (major_v != DB_VERSION_MAJOR || minor_v != DB_VERSION_MINOR)
		return -1;
	r = db_env_create(&dbenv, 0);
	if (r != 0)
	{
		dbenv->err(dbenv, r, "db_env_create");
		goto error;
	}
	flags = DB_CREATE | DB_INIT_MPOOL | DB_INIT_TXN |
			DB_INIT_LOCK | DB_PRIVATE | DB_RECOVER;
	dbh = BDB_NAME;
	r  = dbenv->open(dbenv, dbh, flags, 0600);
	if (r != 0)
	{
		dbenv->err(dbenv, r,
			"where=DB_ENV->open, dbhome=%s", dbh);
		goto error;
	}

	/* Create and initialize database object, open the database. */
	r = db_create(&dbp, dbenv, 0);
	if (r != 0)
		goto error;

	db_txn = NULL;
	r = dbenv->txn_begin(dbenv, NULL, &db_txn, 0);
	if (r != 0)
		goto error;

	dbfile = BDB_NAME;

	flags = DB_CREATE;
	r = dbp->open(dbp, db_txn, dbfile, NULL, DB_BTREE, flags, 0600);
	if (r != 0)
	{
		dbp->err(dbp, r, "where=db->open, db=%s", BDB_NAME);
		if (db_txn != NULL)
		{
			(void) db_txn->abort(db_txn);
			db_txn = NULL;
		}
		goto error;
	}

	if (db_txn != NULL)
	{
		r = db_txn->commit(db_txn, 0);
		db_txn = NULL;
		if (r != 0)
			goto error;
	}

	return 0;

  error:
	if (dbp != NULL)
		(void) dbp->close(dbp, 0);
	if (dbenv != NULL)
		(void) dbenv->close(dbenv, 0);
	return r;
}

int
main(int argc, char **argv)
{
	int r;

	(void) unlink(BDB_NAME "/bdb");
	(void) unlink(BDB_NAME "/log.0000000001");
	(void) unlink(BDB_NAME);
	(void) rmdir(BDB_NAME);
	(void) mkdir(BDB_NAME, 0775);
	r = bdb_open();
	(void) unlink(BDB_NAME "/bdb");
	(void) unlink(BDB_NAME "/log.0000000001");
	(void) rmdir(BDB_NAME);
	return r;
}
>>changequote([, ]))

AC_DEFUN([BERKELEY_DB4x_CHK_LIB],
[
	dnl if lib is specified: try static (lib.a)
	bdb_wo_fdatasync="unknown"
	if test -d "$with_bdb_lib"; then
	    BDB_LIBADD="$with_bdb_lib"
	    for dbname in db-4.3 db4.3 db43 db4-4.3 db-4.2 db4.2 db42 db4-4.2 db-4.1 db4.1 db41 db
	    do
	        BDB2_SAVE_LIBS=$LIBS
	        LIBS="$LIBS $BDB_LIBADD/lib${dbname}.a"
		AC_TRY_RUN(BERKELEY_DB4x_FUNC,
			SMX_DB_LIB="$BDB_LIBADD/lib${dbname}.a";
			dblib="berkeley"; break, dblib="no")

	        if test $dblib = "no" -a $fdatasync_in_lrt; then
	          BDB3_SAVE_LIBS=$LIBS
	          LIBS="$LIBS $SMX_FDATASYNC_LIB"
	          AC_TRY_RUN([BERKELEY_DB4x_FUNC],
			SMX_DB_LIB="$BDB_LIBADD/lib${dbname}.a $SMX_FDATASYNC_LIB";
			dblib="berkeley"; break, dblib="no")
	          LIBS=$BDB3_SAVE_LIBS
	        fi

	        LIBS=$BDB2_SAVE_LIBS
	    done
	else
	    for dbname in db-4.3 db4.3 db43 db4-4.3 db-4.2 db4.2 db42 db4-4.2 db-4.1 db4.1 db41 db
	    do
	        BDB2_SAVE_LDFLAGS=$LDFLAGS
	        LDFLAGS="$LDFLAGS -l${dbname}"
		AC_TRY_RUN(BERKELEY_DB4x_FUNC,
			SMX_DB_LIB="-l${dbname}";
			dblib="berkeley"; break, dblib="no")

	        if test $dblib = "no" -a $fdatasync_in_lrt; then
	          BDB3_SAVE_LDFLAGS=$LDFLAGS
	          LDFLAGS="$LDFLAGS $SMX_FDATASYNC_LIB"
	          AC_TRY_RUN([BERKELEY_DB4x_FUNC],
			SMX_DB_LIB="-l${dbname} $SMX_FDATASYNC_LIB";
			dblib="berkeley"; break, dblib="no")
	          LDFLAGS=$BDB3_SAVE_LDFLAGS
	        fi

	        LDFLAGS=$BDB2_SAVE_LDFLAGS
	    done
	fi

	if test $dblib != "no" -a $fdatasync_in_lrt; then
	  BDB3_SAVE_LDFLAGS=$LDFLAGS
	  LDFLAGS="$LDFLAGS $SMX_DB_LIB"
	  AC_TRY_RUN([BERKELEY_DB4x_FULL],
		bdb_wo_fdatasync="ok", bdb_wo_fdatasync="no")
	  LDFLAGS=$BDB3_SAVE_LDFLAGS
	  if test $bdb_wo_fdatasync = "no"; then
	    BDB3_SAVE_LDFLAGS=$LDFLAGS
	    LDFLAGS="$LDFLAGS $SMX_DB_LIB $SMX_FDATASYNC_LIB"
	    AC_TRY_RUN([BERKELEY_DB4x_FULL],
		SMX_DB_LIB="$SMX_DB_LIBS $SMX_FDATASYNC_LIB";
		dblib="berkeley"; break, dblib="no")
	    LDFLAGS=$BDB3_SAVE_LDFLAGS
	  fi
	fi
])

AC_DEFUN([BERKELEY_DB4x_CHK],
[
	if test -d "$with_bdb_inc"; then
	    CPPFLAGS="$CPPFLAGS -I$with_bdb_inc"
	    BDB_INCADD="-I$with_bdb_inc"
	else
	    BDB_INCADD=""
	fi

	AC_CHECK_HEADER(db.h,
                       	BERKELEY_DB4x_CHK_LIB()
			SMX_DB_INC=$BDB_INCADD,
                        dblib="no")
])

AC_DEFUN([SM_BERKELEYDB4], [
  AC_CACHE_CHECK([for Berkeley DB 4.x],
    sm_cv_berkeleyDB4,
    [
	BDB_SAVE_LIBS=$LIBS
	BDB_SAVE_LDFLAGS=$LDFLAGS
	LIBS="$LIBS $SMX_DB_LIB"
	if test -d "$with_bdb_lib"; then
	    LDFLAGS="$LDFLAGS -L$with_bdb_lib"
	fi
AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <db.h>

/*
**  If you change this, change also include/sm/bdb.h
*/
#if DB_VERSION_MAJOR != 4 || (DB_VERSION_MINOR != 1 && DB_VERSION_MINOR != 2 && DB_VERSION_MINOR != 3)
# error  wrong DB version, need 4.x (x > 0)
#endif
#define DB_CACHE_SIZE	1024

int
main(int argc, char **argv)
{
	char *name;
	DBTYPE dbtype;
	DB *db;
	int flags, ret;

	db = NULL;
	flags = DB_CREATE;
	dbtype = DB_HASH;
	ret = db_create(&db, NULL, 0);
	name = "dbtest.db";
	if (ret == 0 && db != NULL)
	{
		ret = db->set_cachesize(db, 0, DB_CACHE_SIZE, 0);
		if (ret != 0)
		{
			(void) db->close(db, 0);
			exit(1);
		}
	}
	if (ret == 0 && db != NULL)
	{
		ret = db->open(db, NULL, name, NULL, dbtype, flags, 0640);
		if (ret != 0)
		{
			(void) db->close(db, 0);
			exit(1);
		}
		(void) db->close(db, 0);
	}
	unlink(name);
	exit(0);
}
>>changequote([, ]),
      sm_cv_berkeleyDB4=yes,
      sm_cv_berkeleyDB4=no,
      sm_cv_berkeleyDB4=no
    )]
	LIBS=$BDB_SAVE_LIBS
	LDFLAGS=$BDB_SAVE_LDFLAGS
  )
  if test "$sm_cv_berkeleyDB4" = "yes"; then
    AC_DEFINE(HAVE_BERKELEYDB4, 1, [Define if Berkeley DB 4.x (x > 0) is available])
  fi
])


dnl ##########################################################################
dnl ###  SYS_NERR
dnl ##########################################################################

AC_DEFUN([SM_SYS_NERR], [
  AC_CACHE_CHECK([for sys_nerr],
    sm_cv_sys_nerr,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <string.h>

int
main(int argc, char **argv)
{
	return (sys_nerr > 0) ? 0 : 1;
}
>>changequote([, ]),
      sm_cv_sys_nerr=yes,
      sm_cv_sys_nerr=no,
      sm_cv_sys_nerr=no
    )]
  )
  if test "$sm_cv_sys_nerr" = "yes"; then
    AC_DEFINE(HAVE_SYS_NERR, 1, [Define if sys_nerr is available])
  fi
])

dnl ##########################################################################
dnl ###  SYS_ERRLIST
dnl ##########################################################################

AC_DEFUN([SM_SYS_ERRLIST], [
  AC_CACHE_CHECK([for sys_errlist],
    sm_cv_sys_errlist,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <string.h>

int
main(int argc, char **argv)
{
	/* hopefully errno==1 is defined */
	return (sys_errlist[1]) ? 0 : 1;
}
>>changequote([, ]),
      sm_cv_sys_errlist=yes,
      sm_cv_sys_errlist=no,
      sm_cv_sys_errlist=no
    )]
  )
  if test "$sm_cv_sys_errlist" = "yes"; then
    AC_DEFINE(HAVE_SYS_ERRLIST, 1, [Define if sys_errlist is available])
  fi
])


dnl ##########################################################################
dnl ###  PTHREAD_RWLOCK_INIT
dnl ##########################################################################

AC_DEFUN([SM_PTHREAD_RWLOCK_INIT], [
  AC_CACHE_CHECK([for pthread_rwlock_init],
    sm_cv_pthread_rwlock_init,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <pthread.h>

int
main(int argc, char **argv)
{
	pthread_rwlock_t rwl;

	if (pthread_rwlock_init(&rwl, 0) != 0)
		exit(1);
	pthread_rwlock_destroy(&rwl);
	exit(0);
}
>>changequote([, ]),
      sm_cv_pthread_rwlock_init=yes,
      sm_cv_pthread_rwlock_init=no,
      sm_cv_pthread_rwlock_init=no
    )]
  )
  if test "$sm_cv_pthread_rwlock_init" = "yes"; then
    AC_DEFINE(HAVE_PTHREAD_RWLOCK_INIT, 1, [Define if pthread_rwlock_init is available])
  fi
])

dnl ##########################################################################
dnl ###  SM_TLS
dnl ##########################################################################

AC_DEFUN([SM_TLS], [
 AC_ARG_ENABLE(TLS, [  --enable-TLS           enable STARTTLS (check libraries) ],
  smtls=$enableval,
  smtls=yes)
  AC_MSG_CHECKING(TLS support)
  SMX_TLS_LIB=""
  if test "$smtls" != no; then
    AC_CHECK_LIB(crypto, BIO_write,
	SMX_TLS_LIB="$SMX_TLS_LIB -lcrypto"; lcrypto="yes", lcrypto="no")
    TLS_SAVE_LIBS=$LIBS
    LIBS="$LIBS $SMX_TLS_LIB"
    AC_CHECK_LIB(ssl, SSL_CTX_new,
	SMX_TLS_LIB="-lssl $SMX_TLS_LIB"; lssl="yes", lssl="no")
    if test "$lcrypto" != no -a "lssl" != no; then
      AC_CACHE_CHECK([for OpenSSL availability],
        sm_cv_openssl,
        [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <openssl/ssl.h>

int main(int argc, char **argv)
{
	unsigned int linkversion;

	linkversion = (unsigned int) SSLeay();
	fprintf(stderr,
		"OpenSSL versions:\n"
		"compiled against: version=0x%08x\n"
		"linked against:   version=0x%08x\n"
		, (unsigned int) OPENSSL_VERSION_NUMBER, linkversion);
	exit(((unsigned int) OPENSSL_VERSION_NUMBER == linkversion)
		? 0 : 1);
}
>>changequote([, ]),
        sm_cv_openssl=yes,
        sm_cv_openssl=no,
        sm_cv_openssl=no
        )]
      )
      if test "$sm_cv_openssl" != no; then
        AC_DEFINE(SM_USE_TLS, 1, [Define if TLS is available and should be used])
        AC_MSG_RESULT(enabled)
      else
        AC_MSG_RESULT(disabled due to failure in test compilation)
      fi
    else
      AC_MSG_RESULT(disabled due to missing libraries)
    fi
    LIBS=$TLS_SAVE_LIBS
  else
    AC_MSG_RESULT(disabled)
  fi
  AC_SUBST(SMX_TLS_LIB)
])

dnl ##########################################################################
dnl ###  SM_SASL
dnl ##########################################################################

AC_DEFUN([SM_SASL], [
 AC_ARG_ENABLE(SASL, [  --enable-SASL          enable SASL (check libraries) ],
  smsasl=$enableval,
  smsasl=yes)
  AC_MSG_CHECKING(SASL support)
  SMX_SASL_LIB=""
  SMX_SASL_INC=""
  if test "$smsasl" = yes; then
    SASL_SAVE_LDFLAGS=$LDFLAGS
    SASL_SAVE_CFLAGS=$CFLAGS
    SASL_SAVE_CPPFLAGS=$CPPFLAGS
    SASL_SAVE_LIBS=$LIBS
    SASL_ADD_L=""
    if test -d "$with_sasl_lib"; then
      SASL_ADD_L="-L$with_sasl_lib"
      LDFLAGS="$LDFLAGS $SASL_ADD_L"
    fi
    SM_SASL_LIB="-lsasl2"
    AC_CHECK_LIB(sasl, sasl_version_info, [SM_SASL_LIB="-lsasl"])
    AC_CHECK_LIB(sasl2, sasl_version_info, [SM_SASL_LIB="-lsasl2"])
    LIBS="$LIBS $SM_SASL_LIB"
    if test -d "$with_sasl_inc"; then
      CPPFLAGS="$CPPFLAGS -I$with_sasl_inc"
      SASL_INCADD="-I$with_sasl_inc"
    else
      SASL_INCADD=""
    fi
    AC_CHECK_HEADER(sasl/sasl.h,
		[SMX_SASL_INC=$SASL_INCADD; sm_cv_cyrus_saslhdr="yes"],
		[sm_cv_cyrus_saslhdr="no"])
    if test "$sm_cv_cyrus_saslhdr" = yes; then
    AC_CACHE_CHECK([for Cyrus SASL v2 availability],
      sm_cv_cyrus_saslv2,
      [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <sasl/sasl.h>

int main(int argc, char **argv)
{
	const char *implementation, *version_string;
	int r, version_major, version_minor, version_step, version_patch;

	sasl_version_info(&implementation, &version_string,
                          &version_major, &version_minor, &version_step,
                          &version_patch);
	if (version_major != 2)
		exit(1);
	r = sasl_server_init(NULL, "sendmail");
	exit(0);
}
>>changequote([, ]),
      sm_cv_cyrus_saslv2=yes,
      sm_cv_cyrus_saslv2=no,
      sm_cv_cyrus_saslv2=no
      )]
    )
    fi
    if test "$sm_cv_cyrus_saslv2" = yes; then
      SMX_SASL_LIB="$SASL_ADD_L $SM_SASL_LIB"
      AC_DEFINE(SM_USE_SASL, 1, [Define if SASL is available and should be used])
      AC_MSG_RESULT(enabled)
    else
      AC_MSG_RESULT(disabled due to failure in test compilation)
    fi
    LIBS=$SASL_SAVE_LIBS
    CFLAGS=$SASL_SAVE_CFLAGS
    LDFLAGS=$SASL_SAVE_LDFLAGS
    CPPFLAGS=$SASL_SAVE_CPPFLAGS
  else
    AC_MSG_RESULT(disabled)
  fi
  AC_SUBST(SMX_SASL_LIB)
  AC_SUBST(SMX_SASL_INC)
])


dnl ##########################################################################
dnl ###  SM_RES_QUERY_PROTOTYPE - check whether res_query prototype is available
dnl ##########################################################################

AC_DEFUN([SM_RES_QUERY_PROTOTYPE], [
  AC_CACHE_CHECK([check whether res_query prototype is available],
    sm_cv_res_query_prototype,
    AC_TRY_COMPILE([
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/nameser.h>
#include <resolv.h>],
	[
	int (*resfunc)(const char *, int, int, unsigned char *, int);
	resfunc = res_query;
	],
      sm_cv_res_query_prototype=yes,
      sm_cv_res_query_prototype=no
    )
  )
  if test "$sm_cv_res_query_prototype" = "yes"; then
    AC_DEFINE(HAVE_RES_QUERY_PROTOTYPE, 1, [Define if your system has res_query() prototype])
  fi
])


dnl ##########################################################################
dnl ###  SM_NEED_NAMESER_COMPAT_H - check whether nameser_compat.h is needed
dnl ##########################################################################

AC_DEFUN([SM_NEED_NAMESER_COMPAT_H], [
  AC_CHECK_HEADERS(arpa/nameser_compat.h)
  sm_cv_need_nameser_compat_h=no
  if test "$ac_cv_arpa_nameser_compat_h" = "yes"; then
  AC_CACHE_CHECK([check whether nameser_compat.h is needed],
    sm_cv_need_nameser_compat_h,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <arpa/nameser.h>
#include <arpa/nameser_compt.h>

int main()
{
	int i;
	HEADER hp;

	i = T_MX;
	i += hp.qdcount;
	exit(0);
}
>>changequote([, ]),
      sm_cv_need_nameser_compat_h=yes,
      sm_cv_need_nameser_compat_h=no,
      sm_cv_need_nameser_compat_h=no
    )]
  )
  fi
  if test "$sm_cv_need_nameser_compat_h" = "yes"; then
    AC_DEFINE(HAVE_NAMESER_COMPAT, 1, [Define if your system needs arpa/nameser_compat.h])
  fi
])

dnl ##########################################################################
dnl ###  SM_SHA
dnl ##########################################################################

dnl check for SHA1
dnl AC_CHECK_HEADERS(sha1.h)
dnl AC_CHECK_FUNCS(SHA1Init SHA1Update SHA1Final)
dnl AC_CHECK_FUNCS(SHA1_Init SHA1_Update SHA1_Final)
dnl AC_CHECK_LIB(crypto, SHA1)

AC_DEFUN([SM_SHA], [
  SMX_SHA_LIB=""
  AC_CHECK_HEADERS(openssl/sha.h)
  if test "$ac_cv_header_openssl_sha_h" = "yes"; then
    SM_OLD_LIBS="$LIBS"
    LIBS="$LIBS -lcrypto"
    AC_CACHE_CHECK([check whether SHA1 works],
      sm_cv_sha1,
      [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <openssl/sha.h>

int main()
{
	unsigned char md[SHA_DIGEST_LENGTH];
	const char *d = "sha1 test";
	unsigned long n;

	n = strlen(d);
	SHA1(d, n, md);
	exit(0);
}
>>changequote([, ]),
      sm_cv_sha1=yes,
      sm_cv_sha1=no,
      sm_cv_sha1=no
      )]
    )
    if test "$sm_cv_sha1" = "yes"; then
      AC_DEFINE(HAVE_SHA1, 1, [Define if your system has a working SHA1() function])
      AC_CHECK_LIB(crypto, SHA1, SMX_SHA_LIB="-lcrypto", )
    fi
    LIBS="$SM_OLD_LIBS"
  fi
  AC_SUBST(SMX_SHA_LIB)
])

dnl ##########################################################################
dnl ###  SM_NEED_PROTO(includes, function)
dnl ##########################################################################

AC_DEFUN(SM_NEED_PROTO, [
if test "$ac_cv_func_$2" = yes; then
AC_CACHE_CHECK([if $2 needs a prototype], ac_cv_func_$2_noproto,
AC_TRY_COMPILE([$1],
[struct foo { int foo; } xx;
extern int $2 (struct foo*);
$2(&xx);
],
eval "ac_cv_func_$2_noproto=yes",
eval "ac_cv_func_$2_noproto=no"))
define([foo], [NEED_]translit($2, [a-z], [A-Z])[_PROTO])
if test "$ac_cv_func_$2_noproto" = yes; then
	AC_DEFINE(foo, 1, [define if the system is missing a prototype for $2()])
fi
undefine([foo])
fi
])

