/*
 * Copyright (c) 2002, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_IDSTR(id, "@(#)$Id: t-unget.c,v 1.6 2004/12/29 23:47:29 ca Exp $")
#include "sm/io.h"
#include "sm/test.h"
#include <stdio.h>

/* XXX must be smaller than buffer, maybe check bufsize? */
#define SM_N_CHARS	1024

static void
testputc(sm_file_T *fp, int n)
{
	int i;
	uchar c, r;

	for (i = 0; i < n; i++)
	{
		c = (uchar) i;
		r = sm_putc(fp, c);
		SM_TEST(c == r);
	}
}

static void
testgetc(sm_file_T *fp, int n)
{
	int i;
	uchar c, r;

	for (i = 0; i < n; i++)
	{
		c = (uchar) i;
		r = sm_getc(fp);
		SM_TEST(c == r);
	}

	for (i = n - 1; i >= 0 ; i--)
	{
		c = (uchar) i;
		r = sm_io_ungetc(fp, c);
		SM_TEST(c == r);
	}

	for (i = 0; i < n; i++)
	{
		c = (uchar) i;
		r = sm_getc(fp);
		SM_TEST(c == r);
	}
}


int
main(int argc, char *argv[])
{
	sm_ret_T res;
	sm_file_T *fp;

	sm_test_begin(argc, argv, "test sm_io_putc");
	res = sm_io_open(SmStStdio, "foo", SM_IO_WRONLY, &fp, SM_IO_WHAT_END);
	SM_TEST(res == SM_SUCCESS);
	SM_TEST(fp != NULL);
	if (fp != NULL)
	{
		testputc(fp, SM_N_CHARS);
		res = sm_io_close(fp);
		SM_TEST(res == SM_SUCCESS);
		res = sm_io_open(SmStStdio, "foo", SM_IO_RDONLY, &fp, NULL);
		SM_TEST(res == SM_SUCCESS);
		SM_TEST(fp != NULL);
		if (fp != NULL)
		{
			testgetc(fp, SM_N_CHARS);
			res = sm_io_close(fp);
			SM_TEST(res == SM_SUCCESS);
		}
	}
	return sm_test_end();
}
