#!/bin/sh
# $Id: t-alias-0.sh,v 1.5 2005/10/21 18:02:19 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test various alias expansion modes: local_domain
# uses smtpcnf.sh
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""
OUT="t-alias-0.out"
LUM="lu.db"

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to working directory for alias file!
cd ../qmgr || exit 1

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
sender: local:
list0-user1: local:
list0-user2: local:
ownerlist1: local:
ownerlistl: local:
list0:     <list0-user1@local.dom> <list1@local.dom> <list0-user2@some.dom>
owner-list0:     ownerlist0
owner-list1@local.dom:     ownerlist1
list1@local.dom:     <list1-user1@remote.dom> <list1-user2@some.dom>
owner-list2@some.dom:     <ownerlist2somedom@some.dom>
list2@some.dom:     <list0@local.dom> <list1@local.dom> <list2-user0@some.dom>
owner-listl@local.dom:     ownerlistl
listl@local.dom:     <listl-user1@local.dom> <listl-user2@local.dom>
listl-user1@local.dom: local:
listl-user2@local.dom: local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}

## create local user map
#rm -f ${LUM}
#${MM} -F ${LUM} <<EOF
#listl:	ok
#EOF
#if test $? -ne 0
#then
#  echo "$0: ${MM} failed"
#  exit 1
#fi

# create mailertable (save old version?)
${CAT} > ${MT} <<EOF
local.dom	lmtp:
alsolocal.dom	lmtp:
some.dom	[127.0.0.1]
other.dom	[127.0.0.1]
some.dom	[127.0.0.1]
remote.dom	[127.0.0.1]
EOF

# ----------------------------------------
${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4;
}
smar {
 #map lum { type=hash; file=${LUM}; }
 #local_user_map = lum;
aliases { flags = local_domains; }
Log_Level = 12;
nameserver = ${NS};
DNS_timeout = 5;
}
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }
smtps {
Log_Level = 14;
daemon_address = localhost:${SRVPORT};
wait_for_server=4;
}
EOF


# ----------------------------------------
# test: send mail to local address which is not an alias; hence recipient is
# rejected by smtps. note: this doesn't test local_domains much, the recipient
# is also rejected without it.

TEST=1
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

if ${SHELL} ${SD}/smtpcnf.sh -3 lmtpsock -Ssender@local.dom -Rlistl@alsolocal.dom -E 0 -X 0 -A 0
then
  if test -s ${B1}
  then
      ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${B1}
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi

# ----------------------------------------
# test: send mail to local list, check Return-Path:

TEST=2
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

if ${SHELL} ${SD}/smtpcnf.sh -3 lmtpsock -Ssender@local.dom -Rlistl@local.dom -E 0 -X 0 -A 1
then
  if test -s ${B1}
  then
    if ${GREP} '^Return-Path: <owner-listl@local.dom>' ${B1} >/dev/null
    then
      :
    else
      ERR=true
    fi
  else
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${B1}
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi

# ----------------------------------------
# test: send mail to list0
# list0
# <list0-user1@local.dom>
# <list0-user2@some.dom>
# <list1-user1@remote.dom>
# <list1-user2@some.dom>

TEST=3
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

if ${SHELL} ${SD}/smtpcnf.sh -r -3 lmtpsock -Ssender@local.dom -Rlist0@local.dom -E 3 -X 2 -A 1
then
  if test -s ${S1}
  then
    :
  else
    ERR=true
  fi
  if test -s ${B1}
  then
    if ${GREP} '^Return-Path: <owner-list0@local.dom>' ${B1} >/dev/null
    then
      :
    else
      ERR=true
    fi
  else
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${S1}
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi


rm -f ${MTMAP} ${ALIMAP}
# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
