#!/bin/sh
# $Id: t-mts-acc-3.sh,v 1.11 2005/10/21 18:02:19 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test access map restrictions:
# QUICK:{RELAY,OK} to override FROM: rejections.
# uses smtp1.sh.
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

SCRIPTS=`cd ${SD} && pwd`
SRCOK="../qmgr/t-mts-acc-3.ok"

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1

TEST=0
for ALLOW in RELAY OK
do

# create restrictions
# note: this only works if the client address is actually 127.0.0.1
# which is not the case when using FreeBSD jails.
# quick:relay overrides all subsequent restrictions
# (which are tested in t-mts-acc-0.sh)
${CAT} > ${ACC} <<EOF
cltaddr:${SM_LOCALHOST}	quick:${ALLOW}
from:no@such.dom	error:550 5.7.2 no@such.dom
from:@nosuch.dom	error:550 5.7.3 @nosuch.dom
from:@.biz	error:550 5.7.4 @.biz
from:spammer	error:550 5.7.5 spammer
EOF
# create map
rm -f ${ACCMAP}
${MM} -t'	' -F ${ACCMAP} < ${ACC}
rm -f ${MTMAP}

# run some test programs
# ----------------------------------------
TEST=`expr ${TEST} + 1 `
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtp1.sh -Z 'smtpc2' -c '-E' -V '-a' -E 1 -A 1 -X 1 $@ -S"no@such.dom" -R"r${TEST}@y.z"
then
    ${VERBOSE} && echo "$0: test ${TEST} succeeded"
    ERR=false
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# ----------------------------------------
TEST=`expr ${TEST} + 1 `
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtp1.sh -Z 'smtpc2' -c '-E' -V '-a' -E 1 -A 1 -X 1 $@ -S"s${TEST}@nosuch.dom" -R"r${TEST}@y.z"
then
    ERR=false
    ${VERBOSE} && echo "$0: test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# ----------------------------------------
TEST=`expr ${TEST} + 1 `
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtp1.sh -Z 'smtpc2' -c '-E' -V '-a' -E 1 -A 1 -X 1 $@ -S"s${TEST}@some.biz" -R"r${TEST}@y.z"
then
    ERR=false
    ${VERBOSE} && echo "$0: test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# ----------------------------------------
TEST=`expr ${TEST} + 1 `
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtp1.sh -Z 'smtpc2' -c '-E' -V '-a' -E 1 -A 1 -X 1 $@ -S"spammer@some.com" -R"r${TEST}@y.z"
then
    ERR=false
    ${VERBOSE} && echo "$0: test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi


done
rm -f ${ACCMAP}

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
