#!/bin/sh
# $Id: t-owner-1.sh,v 1.12 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test owner- alias expansion, test bounces
# run smtp1.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""
OK="t-owner-1.ok"
OUT="t-owner-1.out"

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to working directory for alias file!
cd ../qmgr || exit 1

# Note: the test programs which rely on failures from SMAR work only if
# SMAR has been compiled with -DSMAR_TEST!
SMAR_TEST=false
../smar/smar -D | ${GREP} "SMAR_TEST" >/dev/null && SMAR_TEST=true

if ${SMAR_TEST}
then
  :
else
  echo $0: SKIPPED -- requires SMAR compile time option SMAR_TEST
  exit 0
fi

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
sender: local:
le1:	<le1-1@p.z>
owner-le1:	<ownerle1@local.dom>
ownerle1:	local:
le2:	<le2-1@t.z>
owner-le2:	<ownerle2@local.dom>
ownerle2:	local:
le3:	<le3-1@p.z> <le3-2@local.dom>
owner-le3:	<ownerle3@local.dom>
ownerle3:	local:
le3-2:	local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}
rm -f ${MTMAP}

# ----------------------------------------
# test: send mail to list with 1 element/error, check bounce

TEST=1
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

if ${SHELL} ${SD}/smtp1.sh -3 lmtpsock -Ssender@local.dom -Rle1@local.dom -E 0 -X 0 -A 1
then
  if test -s ${B1}
  then
     ${EGREP} -v '^Date: ' ${B1} |\
	 ${SED} -e '/^Received:/,$d' \
		-e 's/
$//' -e 's/Mailer-Daemon@.*/Mailer-Daemon@/' > ${OUT}

     ${CAT} > ${OK} <<EOF
Return-Path: <>
From: Mailer-Daemon@
Subject: Undeliverable mail
To: <ownerle1@local.dom>

Hi! This is the sendmail X MTA. I'm sorry to inform you that a mail
from you could not be delivered. See below for details.

Recipient:
<le1-1@p.z>
Expanded from:
<le1@local.dom>
error from address resolver
permanent error


Your original mail follows:
EOF
    if ${DIFF} -w ${OK} ${OUT} >/dev/null
    then
      :
    else
      ERR=true
    fi

  else
     ERR=true
  fi
else
  ERR=true
fi

if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${B1}
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi

# ----------------------------------------
# test: send mail to list with 1 element/error and 1 local recipient,
# check local mail and bounce

TEST=2
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

if ${SHELL} ${SD}/smtp1.sh -3 lmtpsock -Ssender@local.dom -R"le1@local.dom -Ruser@local.dom" -E 0 -X 0 -A 1
then
  ${GREP} '^Return-Path: <sender@local.dom>' ${B1} >/dev/null || ERR=true
  if test -s ${B2}
  then
     ${EGREP} -v '^Date: ' ${B2} |\
	 ${SED} -e '/^Received:/,$d' \
		-e 's/
$//' -e 's/Mailer-Daemon@.*/Mailer-Daemon@/' > ${OUT}

     ${CAT} > ${OK} <<EOF
Return-Path: <>
From: Mailer-Daemon@
Subject: Undeliverable mail
To: <ownerle1@local.dom>

Hi! This is the sendmail X MTA. I'm sorry to inform you that a mail
from you could not be delivered. See below for details.

Recipient:
<le1-1@p.z>
Expanded from:
<le1@local.dom>
error from address resolver
permanent error


Your original mail follows:
EOF
    if ${DIFF} -w ${OK} ${OUT} >/dev/null
    then
      :
    else
      ERR=true
    fi

  else
     ERR=true
  fi
else
  ERR=true
fi

if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${B1}
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi

# ----------------------------------------
# test: send mail to list with 2 rcpts, 1 error
# check bounce

TEST=3
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

if ${SHELL} ${SD}/smtp1.sh -3 lmtpsock -i 2 -s 10 -Ssender@local.dom -Rle3@local.dom -E 0 -X 0 -A 1
then
  ${GREP} '^Return-Path: <owner-le3@local.dom>' ${B1} >/dev/null || ERR=true
  if test -s ${B2}
  then
     ${EGREP} -v '^Date: ' ${B2} |\
	 ${SED} -e '/^Received:/,$d' \
		-e 's/
$//' -e 's/Mailer-Daemon@.*/Mailer-Daemon@/' > ${OUT}

     ${CAT} > ${OK} <<EOF
Return-Path: <>
From: Mailer-Daemon@
Subject: Undeliverable mail
To: <ownerle3@local.dom>

Hi! This is the sendmail X MTA. I'm sorry to inform you that a mail
from you could not be delivered. See below for details.

Recipient:
<le3-1@p.z>
error from address resolver
permanent error


Your original mail follows:
EOF
    if ${DIFF} -w ${OK} ${OUT} >/dev/null
    then
      :
    else
      ERR=true
    fi

  else
     ERR=true
  fi
else
  ERR=true
fi

if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${B1}
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi



rm -f ${MTMAP} ${ALIMAP}
# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
