/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: demo-parseonly.c,v 1.1 2005/01/12 03:22:27 jutta Exp $")

#if SM_LIBCONF_ALONE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netinet/in.h>
#include "sm-conf.h"
#else /* SM_LIBCONF_ALONE */
#include "sm/string.h"
#include "sm/sm-conf.h"
#include "sm/net.h"
#include <stdio.h>
#endif /* SM_LIBCONF_ALONE */

/* DEMO-PARSEONLY.C -- demo the "parse-only" option */

#ifndef offsetof
#define offsetof(type, member)	((char *)&((type *)0)->member - (char *)0)
#endif

typedef struct substructure
{
	unsigned int		sub_number;
	char const		* sub_string;

} substructure_T;


sm_conf_definition_T const subdefinitions[] = {

	{ SM_CONF_DEF_MAGIC, "string", sm_conf_type_string,
		offsetof(struct substructure, sub_string), 0, NULL
	},

	{ SM_CONF_DEF_MAGIC, "number", sm_conf_type_u32,
		offsetof(struct substructure, sub_number),
		sizeof(unsigned int),  NULL
	},

	/* sentinel */
	{ SM_CONF_DEF_MAGIC, NULL }
};


typedef struct
{
	substructure_T	sub;
	substructure_T	sub_parsed_only;

} structure;

sm_conf_definition_T definitions[] = {

	{ SM_CONF_DEF_MAGIC, "sub",
		sm_conf_type_section,
		offsetof(structure, sub),
		sizeof(unsigned long),
		NULL, 0,
		subdefinitions
	},

	{ SM_CONF_DEF_MAGIC, "sub_parsed_only",
		sm_conf_type_section,
		offsetof(structure, sub_parsed_only),
		sizeof(struct substructure),
		NULL,

		/*
		**  This flag is what this demo file is about --
		**  since it's set here, the substructure is
		**  parsed (spurious names are reported, etc.),
		**  but not assigned.
		*/

		SM_CONF_FLAG_PARSE_ONLY,
		subdefinitions
	},

	/* sentinel */
	{ SM_CONF_DEF_MAGIC, NULL }
};

static void
print_structure(structure *s)
{
	printf("sub: number=%d, string=%s\n",
		s->sub.sub_number,
		s->sub.sub_string ? s->sub.sub_string : "*null*");

	printf("sub_parsed_only: number=%d, string=%s\n",
		s->sub_parsed_only.sub_number,
		s->sub_parsed_only.sub_string
			? s->sub_parsed_only.sub_string
			: "*null*");
}

static int
process(char const *name, FILE *fp)
{
	sm_conf_T		*stream;
	int			err;
	structure		s;

	if (((stream = sm_conf_new(name ? name : "*stdin*"))) == NULL)
	{
		fprintf(stderr, "error -- sm_conf_new() returns NULL!\n");
		return 1;
	}
	if ((err = sm_conf_read_FILE(stream, name, fp)) != 0)
	{
		char buf[SM_CONF_ERROR_BUFFER_SIZE];
		char const *e = NULL;

		fprintf(stderr, "%s: %s\n",
			name ? name : "*stdin*",
			sm_conf_strerror(err, buf, sizeof buf));

		while ((e = sm_conf_syntax_error(stream, e)) != NULL)
			fprintf(stderr, "%s\n", e);

		sm_conf_destroy(stream);
		return 2;
	}

	memset(&s, 0, sizeof(s));
	err = sm_conf_scan(stream, definitions, 0, &s);
	if (err != 0)
	{
		char buf[SM_CONF_ERROR_BUFFER_SIZE];
		char const *e = NULL;

		fprintf(stderr, "(while scanning) %s: %s\n",
			name ? name : "*stdin*",
			sm_conf_strerror(err, buf, sizeof buf));

		while ((e = sm_conf_syntax_error(stream, e)) != NULL)
			fprintf(stderr, "%s\n", e);

		sm_conf_destroy(stream);
		return 3;
	}

	print_structure(&s);
	sm_conf_destroy(stream);

	return 0;
}

int
main(int ac, char **av)
{
	int	ai;

	if (ac == 1)
		return process("*stdin*", stdin);

	for (ai = 1; ai < ac; ai++)
	{
		int ret = process(av[ai], NULL);
		if (ret != 0)
			return ret;
	}
	return 0;
}
