/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: demo-scan.c,v 1.4 2004/05/18 02:31:57 jutta Exp $")

#if SM_LIBCONF_ALONE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sm-conf.h"
#else /* SM_LIBCONF_ALONE */
#include "sm/sm-conf.h"
#endif /* SM_LIBCONF_ALONE */

/* SCANNER.C -- demo sm_conf_scan() */

#ifndef offsetof
#define offsetof(type, member)	((char *)&((type *)0)->member - (char *)0)
#endif

typedef struct
{
	short	fl_price;
	char	*fl_color;
} flavor;

sm_conf_definition_T
flavor_def[] =
{
	{ SM_CONF_DEF_MAGIC,
		"price",
		sm_conf_type_u32,
		offsetof(flavor, fl_price),
		sizeof(short),
	},

	{ SM_CONF_DEF_MAGIC,
		"color",
		sm_conf_type_string,
		offsetof(flavor, fl_color),
		0,
		"transparent"
	},

	/* sentinel */
	{ SM_CONF_DEF_MAGIC, NULL }
};

static void
print_flavor(flavor *f, char const *name, size_t name_n)
{
	printf("%.*s:\n",
		(int)name_n, name);
	printf("\tprice: %hu\n", f->fl_price);
	printf("\tcolor: %s\n", f->fl_color);
}

static int
process(char const *name, FILE *fp)
{
	sm_conf_T		*stream;
	int			err;
	flavor			f;
	sm_conf_iterator_T	iterator;
	char const		*flavor_name;
	size_t			flavor_name_n;

	if (((stream = sm_conf_new(name ? name : "*stdin*"))) == NULL)
	{
		fprintf(stderr, "error -- sm_conf_new() returns NULL!\n");
		return 1;
	}
	if ((err = sm_conf_read_FILE(stream, name, fp)) != 0)
	{
		char buf[SM_CONF_ERROR_BUFFER_SIZE];
		char const *e = NULL;

		fprintf(stderr, "%s: %s\n",
			name ? name : "*stdin*",
			sm_conf_strerror(err, buf, sizeof buf));

		while ((e = sm_conf_syntax_error(stream, e)) != NULL)
			fprintf(stderr, "%s\n", e);

		sm_conf_destroy(stream);
		return 2;
	}

	iterator = NULL;
	while (sm_conf_scan_next(stream,
		"materials.flavors{sorbet}.flavor",
		flavor_def, 0, &flavor_name, &flavor_name_n,
		&f, &iterator) == 0)
	{
		print_flavor(&f, flavor_name, flavor_name_n);
	}

	sm_conf_destroy(stream);
	return 0;
}

int
main(int ac, char **av)
{
	int	ret;
	int	ai;

	ret = 0;
	if (ac == 1)
		ret = process("*stdin*", stdin);
	else
	{
		for (ai = 1; ai < ac; ai++)
		{
			ret = process(av[ai], NULL);
			if (ret != 0)
				break;
		}
	}

	return ret;
}
