/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: dadb.h,v 1.15 2005/06/16 00:39:04 ca Exp $
 */

#ifndef DADB_DADB_H
#define DADB_DADB_H 1

#ifndef DADB_DEBUG
# define DADB_DEBUG	0
#endif

#if DADB_DEBUG
# include "sm/io.h"
# define DADB_DPRINTF(x)	sm_io_fprintf x
#else
# define DADB_DPRINTF(x)
#endif

#define FREE_DADB_ENTRIES(dadb_ctx)					\
	do								\
	{								\
		if (dadb_ctx->dadb_entries != NULL)			\
		{							\
			size_t size;					\
									\
			size = dadb_ctx->dadb_entries_max *		\
				sizeof(*dadb_ctx->dadb_entries);	\
			SM_ASSERT(size > dadb_ctx->dadb_entries_max &&	\
				size > sizeof(*dadb_ctx->dadb_entries)); \
			sm_free_size(dadb_ctx->dadb_entries, size);	\
			dadb_ctx->dadb_entries = NULL;			\
		}							\
	} while (0)

sm_ret_T	 dadb_entry_get(dadb_ctx_P _dadb_ctx, dadb_entry_P *_pdadb_entry, uint *_pidx, thr_lock_T _locktype);

#if 0
sm_ret_T dadb_entry_free(dadb_ctx_P _dadb_ctx, dadb_entry_P _dadb_entry, thr_lock_T _locktype);
sm_ret_T dadb_entry_new(dadb_ctx_P _dadb_ctx, dadb_entry_P *_pdadb_entry, thr_lock_T _locktype);
sm_ret_T dadb_entry_update(dadb_ctx_P _dadb_ctx, sessta_id_P _sess_id, sessta_id_P _ta_id, dadb_entry_P _dadb_entry);
#endif /* 0 */

#endif /* DADB_DADB_H */
