/*
 * Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: ibdbc.h,v 1.7 2005/06/16 20:39:01 ca Exp $
 */

#ifndef IBDBC_H
#define IBDBC_H 1

typedef struct ibc_e_S	ibc_e_T, *ibc_e_P;

/*
**  Entry in IBDB Cache which keeps track in which IBDB sequence number
**  a record (TA or RCPT) is stored.
*/

struct ibc_e_S
{
	smtp_id_T	ibc_id;
	uint32_t	ibc_sequence;
	uint		ibc_type;
};

/* Use enum? */
#define IBC_TA		0x01
#define IBC_RCPT	0x02

sm_ret_T sm_ibc_ta_add(bht_P _bht, sessta_id_P _ta_id, uint32_t _seq);
sm_ret_T sm_ibc_rcpt_add(bht_P _bht, sessta_id_P _ta_id, rcpt_idx_T _rcpt_idx, uint32_t _seq);
sm_ret_T sm_ibc_ta_rm(bht_P _bht, sessta_id_P _ta_id);
sm_ret_T sm_ibc_rcpt_rm(bht_P _bht, sessta_id_P _ta_id, rcpt_idx_T _rcpt_idx);

sm_ret_T sm_ibc_low_seq(bht_P _bht, uint32_t *_pseq);

#endif /* IBDBC_H */
