/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: cstrcaseq.c,v 1.2 2004/05/18 05:50:31 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/cstr.h"

#if SM_CSTR_CHECK
/*
**  SM_CSTR_CASEQ -- Compare two cstrings (case insensitive)
**
**	Parameters:
**		s1 -- first cstring
**		s2 -- second cstring
**
**	Returns:
**		whether cstrings are equal
*/

bool
sm_cstr_caseq(const sm_cstr_P s1, const sm_cstr_P s2)
{
	SM_IS_CSTR(s1);
	SM_IS_CSTR(s2);
	if (s1->sm_cstr_len != s2->sm_cstr_len)
		return false;
	return sm_memcaseeq(s1->sm_cstr_base, s2->sm_cstr_base,
			s1->sm_cstr_len);
}
#endif /* SM_CSTR_CHECK */
