/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: cstrdup.c,v 1.1 2005/10/04 06:04:14 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/heap.h"
#include "sm/cstr.h"

#if SM_CSTR_CHECK
/*
**  SM_CSTR_DUP -- Make a copy of a cstring (increase refcount)
**
**	Parameters:
**		src -- cstring to copy
**
**	Returns:
**		pointer to cstr
*/

sm_cstr_P
sm_cstr_dup(sm_cstr_P src)
{
	SM_IS_CSTR(src);
	SM_CSTR_LOCK(src);
	(src)->sm_cstr_refcnt++;
	SM_CSTR_UNLOCK(src);
	return src;
}
#endif /* SM_CSTR_CHECK */
