/*
 * Copyright (c) 2002 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: falign.c,v 1.2 2002/05/09 16:35:30 ca Exp $")
#include <stdlib.h>
#include <string.h>
#include "sm/io.h"
#include "sm/assert.h"
#include "io-int.h"

/*
**  SM_IO_FALIGN -- make sure that file buffer is aligned by n
**
**	This routine can be used to move the file write pointer for
**	fixed size records.
**
**	Parameters:
**		fp -- the file pointer to write to
**		n -- alignment
**
**	Returns:
**		usual sm_error code
*/

#define ALIGN_N(p, n) (((p) + ((n) - 1)) & ~((n) - 1)) - (p)
#define RNDUP_N(x, n)  ((((x) + (n) - 1) / (n)) * (n))

sm_ret_T
sm_io_falign(sm_file_T *fp, size_t n)
{
	size_t len;
	int a;

	a = (int) (f_p(*fp) - f_bfbase(*fp));
	len = ALIGN_N(a, n);
	if (len == 0)
		return SM_SUCCESS;
	if (f_flags(*fp) & SMWR)
		return sm_io_fpad(fp, len);
	else
		return sm_io_fskip(fp, len);
}
