/*
 * Copyright (c) 2002 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: tree-destroy.c,v 1.5 2003/10/30 18:58:52 ca Exp $")

#include "sm/error.h"
#include "sm/assert.h"
#include "sm/tree.h"

/*
**  SM_TREE_DESTROY2 -- destroy (free) a subtree
**
**	Parameters:
**		node -- node in tree
**
**	Returns:
**		result from free if it is an error
*/

static sm_ret_T
sm_tree_destroy2(sm_tree_P tree, sm_tree_node_P node)
{
	sm_ret_T ret;

	if (node == NULL)
		return SM_SUCCESS;
	ret = sm_tree_destroy2(tree, node->sm_tree_left);
	if (ret != SM_SUCCESS)
		return ret;
	ret = sm_tree_destroy2(tree, node->sm_tree_right);
	if (ret != SM_SUCCESS)
		return ret;
	ret = sm_tree_node_free(tree, node);
	return ret;
}

/*
**  SM_TREE_DESTROY -- destroy (free) a tree
**
**	Parameters:
**		tree -- tree
**
**	Returns:
**		result from free if it is an error
*/

sm_ret_T
sm_tree_destroy(sm_tree_P tree)
{
	sm_ret_T ret;

	ret = sm_tree_destroy2(tree, tree->sm_tree_root);
	if (ret != SM_SUCCESS)
		return ret;
	sm_free_size(tree, sizeof(*tree));
	return SM_SUCCESS;
}
