#!/bin/sh
# $Id: t-mcpconf-0.sh,v 1.8 2005/09/01 21:13:18 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#

# ------------------------------------------------------------
# read configuration file and print it
# uses mcpconf
# ------------------------------------------------------------

test -s stop && exit 1

# source directory of this (and other) shell script
SD=`dirname $0`

ERRS=0

CNF=mcp0.conf
OUT=mcp0.out
OK=mcp0.ok

PRG=./mcpconf

cat > ${CNF} <<EOF
qmgr {
  AQ_max_entries = 8192;
  smtpc {
	initial_connections = 19;
	max_connections = 101; }
  smtps {
	max_connections = 5;
	max_connection_rate=160; }
  max_errors_per_DSN=16;
  wait_for_server = 4;
  wait_for_client = 3;
	start_action = wait;
	user = smxq;
	restart_dependencies = { smtps, smtpc, smar };
	path = "/var/spool/smx/libexec/qmgr";
	arguments = "qmgr -f smx.conf";
}

smar {
  Log_Level = 12;
  nameserver = {10.11.12.13, 127.0.0.1};
  dns_timeout = 6;
	start_action = wait;
	user = smxm;
	restart_dependencies = { smtps, qmgr };
	path = "/var/spool/smx/libexec/smar";
	arguments = "smar -f smx.conf";
}

smtps {
  flags = {8bitmime, access, delay_checks, };
  cdb_gid = 1200;
  daemon_address = "localhost:1234";
  IO_timeout = 60;
  wait_for_server = 4;
	listen_socket { type=inet; port = 25; }
	start_action = pass;
	pass_fd_socket = smtps/smtpsfd;
	user = smxs;
	path = "/var/spool/smx/libexec/smtps";
	arguments = "smtps -f smx.conf";
}

smtpc {
	listen_socket { type=inet; port = 25; }
  wait_for_server = 4;
  Log_Level = 12;
  IO_timeout = 66;
	start_action = wait;
	user = smxc;
	path = "/var/spool/smx/libexec/smtpc";
	arguments = "smtpc -f smx.conf";
}
EOF

cat > ${OK} <<EOF
qmgr {
user          = "smxq";
restartdeps   = { smtps, smtpc, smar,};
start_action  = 2;
path          = "/var/spool/smx/libexec/qmgr";
args          = "qmgr -f smx.conf";
}
smar {
user          = "smxm";
restartdeps   = { smtps, qmgr,};
start_action  = 2;
path          = "/var/spool/smx/libexec/smar";
args          = "smar -f smx.conf";
}
smtps {
port          = 25;
pass_fd_socket= "smtps/smtpsfd";
user          = "smxs";
start_action  = 4;
path          = "/var/spool/smx/libexec/smtps";
args          = "smtps -f smx.conf";
}
smtpc {
port          = 25;
user          = "smxc";
start_action  = 2;
path          = "/var/spool/smx/libexec/smtpc";
args          = "smtpc -f smx.conf";
}
EOF

if ${PRG} ${CNF} >${OUT}
then
  if diff -w ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
  fi
else
  ERRS=`expr ${ERRS} + 1 `
  test X"${SM_STOPONERROR}" != X && exit 1
fi

cat > ${CNF} <<EOF
qmgr {
	start_action = wait;
	user = smxq;
	restart_dependencies = { smtps, smtpc, smar };
	path = "/var/spool/smx/libexec/qmgr";
	arguments = "qmgr -f smx.conf";
}

smar {
	start_action = wait;
	user = smxm;
	restart_dependencies = { smtps, qmgr };
	path = "/var/spool/smx/libexec/smar";
	arguments = "smar -f smx.conf";
}

smtps MSA {
	start_action = pass;
	pass_fd_socket = smtps/smtpsmsa;
	user = smxs;
	path = "/var/spool/smx/libexec/smtps";
	arguments = "smtps -N MSA -f smx.conf";
}

smtps MTA {
	start_action = pass;
	pass_fd_socket = smtps/smtpsmta;
	user = smxs;
	path = "/var/spool/smx/libexec/smtps";
	arguments = "smtps -N MTA -f smx.conf";
}

smtpc {
	listen_socket { type=inet; port = 25; }
	start_action = wait;
	user = smxc;
	path = "/var/spool/smx/libexec/smtpc";
	arguments = "smtpc -f smx.conf";
}
EOF

cat > ${OK} <<EOF
qmgr {
user          = "smxq";
restartdeps   = { smtps, smtpc, smar,};
start_action  = 2;
path          = "/var/spool/smx/libexec/qmgr";
args          = "qmgr -f smx.conf";
}
smar {
user          = "smxm";
restartdeps   = { smtps, qmgr,};
start_action  = 2;
path          = "/var/spool/smx/libexec/smar";
args          = "smar -f smx.conf";
}
smtps {
pass_fd_socket= "smtps/smtpsmsa";
user          = "smxs";
start_action  = 4;
path          = "/var/spool/smx/libexec/smtps";
args          = "smtps -N MSA -f smx.conf";
}
smtps {
pass_fd_socket= "smtps/smtpsmta";
user          = "smxs";
start_action  = 4;
path          = "/var/spool/smx/libexec/smtps";
args          = "smtps -N MTA -f smx.conf";
}
smtpc {
port          = 25;
user          = "smxc";
start_action  = 2;
path          = "/var/spool/smx/libexec/smtpc";
args          = "smtpc -f smx.conf";
}
EOF

if ${PRG} ${CNF} >${OUT}
then
  if diff -w ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
  fi
else
  ERRS=`expr ${ERRS} + 1 `
  test X"${SM_STOPONERROR}" != X && exit 1
fi

# ----------------
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
