#!/bin/sh
# $Id: rcvrenvfromlog.sh,v 1.1 2005/04/25 23:18:37 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
#
# This is a very simple script to recover the envelope data for CDB files.
# It must be executed in the CDB base directory.

umask 077
TMPDIR=/tmp/${USER}/recover.$$
O=${TMPDIR}/TAIDS.$$
LOG=/var/log/maillog

while getopts L:T: FLAG
do
  case "${FLAG}" in
    L)
       LOG="${OPTARG}"
       ;;
    T)
       TMPDIR="${OPTARG}"
       ;;
    ?)
       echo "$0: unknown option ${FLAG}"
       echo "$0: options:"
       echo "-T tmpdir  use tmpdir instead of ${TMPDIR}"
       echo "           NOTE: this directory will be removed and recreated!"
       echo "-L log     use log instead of ${LOG}"
       exit 64
       ;;
  esac
done
shift `expr ${OPTIND} - 1`

# remove existing directory
rmdir ${TMPDIR} 2>/dev/null
# create new directory, fail is present
mkdir -p ${TMPDIR} || exit 1
# this should not exist
rm -f $O

# cd to CDB?
if test ! -d 0
then
  echo "$0: cannot find CDB directory"
  exit 1
fi

ls -1 [0-9A-F]/S* | sed -e 's;[0-9A-F]/;;' > $O

if test ! -s $O
then
  echo "$0: no CDB files found"
  exit 0
fi

for taid in `cat $O`
do
  T=${TMPDIR}/${taid}
  rm -f $T
  echo mail: >> $T
  grep "ss_ta=${taid}, mail=" $LOG | sed -e 's;^.*mail=\(<.*>\), .*;\1;' >> $T
  echo rcpts: >> $T
  grep "ss_ta=${taid}, rcpt=" $LOG | sed -e 's;^.*rcpt=\(<.*>\), .*;\1;' >> $T
done

echo "$0: output in ${TMPDIR}/S*"

exit 0
