/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: qm_sc_ctx.c,v 1.28 2005/03/15 19:56:10 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/io.h"
#include "sm/rcb.h"
#include "sm/qmgr.h"
#include "sm/qmgr-int.h"
#include "qmgr.h"
#include "sm/rcbcomm.h"

/*
**  QSC_CTX_NEW -- Allocate a new QMGR - SMTPC context
**
**	Parameters:
**		qmgr_ctx -- QMGR context
**		idx -- internal counter for context
**		pqsc_ctx -- QMGR - SMTPC context (output)
**
**	Returns:
**		usual sm_error code
**
**	Last code review: 2003-10-17 05:08:08
*/

sm_ret_T
qsc_ctx_new(qmgr_ctx_P qmgr_ctx, uint8_t idx, qsc_ctx_P *pqsc_ctx)
{
	sm_ret_T ret;
	qsc_ctx_P qsc_ctx;
#if 0
	int r;
#endif

	SM_IS_QMGR_CTX(qmgr_ctx);
	SM_REQUIRE(pqsc_ctx != NULL);
	qsc_ctx = (qsc_ctx_P) sm_zalloc(sizeof(*qsc_ctx));
	if (qsc_ctx == NULL)
		return sm_error_temp(SM_EM_Q_Q2SC, ENOMEM);
	ret = qsc_id_init(qsc_ctx, 0);
	if (sm_is_err(ret))
		goto error;
	qsc_ctx->qsc_qmgr_ctx = qmgr_ctx;
	ret = sm_rcbcom_open(&(qsc_ctx->qsc_com));
	if (sm_is_err(ret))
		goto error;
#if 0
	r = pthread_mutex_init(&(qsc_ctx->qsc_mutex), NULL);
	if (r != 0)
	{
		ret = sm_error_perm(SM_EM_Q_Q2SC, r);
		goto error;
	}
#endif /* 0 */
	qsc_ctx->qsc_status = QSC_ST_NONE;
	qsc_ctx->qsc_id = QSC_ID_NONE;
	qsc_ctx->qsc_idx = idx;
	qsc_ctx->sm_magic = SM_QSC_CTX_MAGIC;
	*pqsc_ctx = qsc_ctx;
	return SM_SUCCESS;

  error:
	(void) sm_rcbcom_close(&(qsc_ctx->qsc_com));
	SM_FREE_SIZE(qsc_ctx, sizeof(*qsc_ctx));
	return ret;
}

/*
**  QSC_CTX_FREE -- Free a QMGR - SMTPC context
**
**	Parameters:
**		qsc_ctx -- QMGR - SMTPC context
**
**	Returns:
**		usual sm_error code (always SM_SUCCESS)
**
**	Locking: qsc_ctx must be under control of the caller.
**
**	Last code review: 2003-10-17 15:52:26, see below
*/

sm_ret_T
qsc_ctx_free(qsc_ctx_P qsc_ctx)
{
	if (qsc_ctx == NULL)
		return SM_SUCCESS;

	(void) dadb_destroy(qsc_ctx->qsc_dadb_ctx);
	(void) sm_rcbcom_close(&(qsc_ctx->qsc_com));
	(void) qsc_id_end(qsc_ctx);
#if 0
	(void) pthread_mutex_destroy(&(qsc_ctx->qsc_mutex));
#endif
	qsc_ctx->sm_magic = SM_MAGIC_NULL;
	sm_free_size(qsc_ctx, sizeof(*qsc_ctx));
	return SM_SUCCESS;
}

/*
**  QSC_CTX_CLOSE -- Close a QMGR - SMTPC context; clean it up for reuse
**
**	Parameters:
**		qsc_ctx -- QMGR - SMTPC context
**
**	Returns:
**		usual sm_error code (always SM_SUCCESS)
**
**	Locking: qsc_ctx must be under control of the caller.
**
**	Last code review:
*/

sm_ret_T
qsc_ctx_close(qsc_ctx_P qsc_ctx)
{
	if (qsc_ctx == NULL)
		return SM_SUCCESS;

	(void) dadb_close(qsc_ctx->qsc_qmgr_ctx, qsc_ctx->qsc_dadb_ctx,
			THR_LOCK_UNLOCK);
	(void) dadb_destroy(qsc_ctx->qsc_dadb_ctx);
	qsc_ctx->qsc_dadb_ctx = NULL;
	return SM_SUCCESS;
}
