/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: qm_ss_wakeup.c,v 1.7 2005/08/22 18:16:20 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/io.h"
#include "sm/rcb.h"
#include "sm/qmgr.h"
#include "sm/qmgr-int.h"
#include "sm/rcbcomm.h"
#include "qmgr.h"
#include "log.h"

/*
**  QSS_WAKEUP -- wake up all active qss tasks
**
**	Parameters:
**		qmgr_ctx -- QMGR context
**		locktype -- kind of locking
**
**	Returns:
**		usual sm_error code
**
**	Locking: check unlocking! XXX
**
**	Last code review: 2005-04-23 21:52:03
**	Last code change:
*/

sm_ret_T
qss_wakeup(qmgr_ctx_P qmgr_ctx, thr_lock_T locktype)
{
	int i;
	uint32_t j;
	sm_ret_T ret;
	timeval_T slpt;
	qss_ctx_P qss_ctx;
	sm_evthr_task_P tsk;

	ret = evthr_timeval(qmgr_ctx->qmgr_ev_ctx, &slpt);
	if (thr_lock_it(locktype))
	{
		i = pthread_mutex_lock(&(qmgr_ctx->qmgr_mutex));
		SM_LOCK_OK(i);
		if (i != 0)
		{
			sm_log_write(qmgr_ctx->qmgr_lctx,
				QM_LCAT_SMTPS, QM_LMOD_TO_SMTPS,
				SM_LOG_CRIT, 4,
				"sev=CRIT, func=qss_wakeup, lock=%d", i);
			return sm_error_perm(SM_EM_Q_Q2SS, i);
		}
	}
	for (j = 1, i = 0; i < QM_N_SS_GLI(qmgr_ctx); i++, j *= 2)
	{
		if ((qmgr_ctx->qmgr_ss_li.qm_gli_used & j) != 0)
		{
			qss_ctx = qmgr_li_ss(qmgr_ctx, i);
			tsk = qss_ctx->qss_com.rcbcom_tsk;
			SM_IS_EVTHR_TSK(tsk);

			/* old sleep time is 0 hence true as last par */
			ret = evthr_new_sl(tsk, slpt, true);
			if (sm_is_err(ret))
			{
				sm_log_write(qmgr_ctx->qmgr_lctx,
					QM_LCAT_SMTPS, QM_LMOD_TO_SMTPS,
					SM_LOG_ERROR, 4,
					"sev=ERROR, func=qss_wakeup, evthr_new_sl=%m"
					, ret);
			}
			else
				QM_LEV_DPRINTFC(QDC_Q2S, 5, (QM_DEBFP,
					"sev=DBG, func=qss_wakeup, evthr_new_sl=%r\n", ret));
		}
	}
	if (thr_unl_always(locktype))
	{
		i = pthread_mutex_unlock(&(qmgr_ctx->qmgr_mutex));
		SM_ASSERT(i == 0);
	}
	return SM_SUCCESS;
}

/*
**  QM_SS_WAKEUP -- QMGR - SMTPS interface: wakeup task
**
**	Parameters:
**		tsk -- evthr task
**
**	Returns:
**		usual sm_error code (currently only SM_SUCCESS)
**
**	Called by: qmgr_smtps()
**
**	Last code review: 2005-04-23 22:01:57; see comments
**	Last code change:
*/

sm_ret_T
qm_ss_wakeup(sm_evthr_task_P tsk)
{
	sm_ret_T ret;
	qss_ctx_P qss_ctx;

	SM_IS_EVTHR_TSK(tsk);
	qss_ctx = (qss_ctx_P) tsk->evthr_t_actx;
	/* XXX Run qss_control? */

	/*
	**  need a function that figures out what has changed, i.e., which
	**  resources are available again.
	**  that could be a status variable in qmgr_ctx which is set upon
	**  changes in the resource array.
	**  a caller changes the value in the resource array and if all
	**  resources are below their threshold, qss_wakeup() is invoked.
	*/

	ret = qss_unthrottle(qss_ctx);
	/* XXX ret not used... */

	/* turn it off... XXX always? only if system is running again? */
	tsk->evthr_t_sleep.tv_usec = 0;
	tsk->evthr_t_sleep.tv_sec = 0;
	evthr_clr_ev(tsk, EVTHR_EV_SL);
	evthr_set_ev(tsk, EVTHR_EV_WR);

	return SM_SUCCESS;
}
