#!/bin/sh
# $Id: smtp.sh,v 1.5 2003/08/03 03:37:01 ca Exp $
#
# simple test program running SMTP server and client to send and receive
# 1000 messages.
#
# host on which to listen/to which to send
H=localhost
# port number to use
P=1235
ERRS=0
SRVL="smtps.log"
CLTL="smtpc.log"
rm -f $SRVL $CLTL
#

for SRV in smtps smtps2
do
# start SMTP server
./$SRV -i -l . -b $H:$P > $SRVL 2>&1 &
status=$?
SRVPID=$!
if [ "x$status" != "x0" ]
then
  echo "FAIL: cannot start server $status"
  exit $status
fi
sleep 3
if grep "ERROR" $SRVL > /dev/null
then
  echo "found ERROR in $SRVL"
  ERRS=`expr $ERRS + 1 `
fi

# send SMTP server a signal to dump its state
if kill -USR1 $SRVPID
then
  :
else
  echo "kill -USR1 failed: $?"
  exit 1
fi
sleep 2

# check state of SMTP server
if grep "^Address *$H:$P" $SRVL > /dev/null
then
  :
else
  echo "failed to listen on $H:$P"
  ERRS=`expr $ERRS + 1 `
fi
if grep "^Thread.* 8/" $SRVL > /dev/null
then
  :
else
  echo "failed to start threads"
  ERRS=`expr $ERRS + 1 `
fi
if grep "^Waiting threads *8" $SRVL > /dev/null
then
  :
else
  echo "wrong number of waiting threads"
  ERRS=`expr $ERRS + 1 `
fi
if grep "^Busy threads *0" $SRVL > /dev/null
then
  :
else
  echo "wrong number of busy threads"
  ERRS=`expr $ERRS + 1 `
fi
if grep "^Requests served *0" $SRVL > /dev/null
then
  :
else
  echo "wrong number of requests"
  ERRS=`expr $ERRS + 1 `
fi

# send 1000 messages: 100 connections, 10 threads
if ./smtpc -r $H:$P -c 100 -t 10 > $CLTL 2>&1
then
  :
else
  cat $CLTL
  ERRS=`expr $ERRS + 1 `
fi

# ----------------
kill -TERM $SRVPID

# wait a moment to release socket
test $SRV = smtps && sleep 5

done

if [ "$ERRS" = "0" ]
then
  exit 0
else
  echo "$ERRS error(s)"
  exit 1
fi
