/*
 * Decompiled with CFR 0.152.
 */
package org.dvb.ui;

public final class DVBAlphaComposite {
    public static final int CLEAR = 1;
    public static final int SRC = 2;
    public static final int SRC_OVER = 3;
    public static final int DST_OVER = 4;
    public static final int SRC_IN = 5;
    public static final int DST_IN = 6;
    public static final int SRC_OUT = 7;
    public static final int DST_OUT = 8;
    public static final DVBAlphaComposite Clear = new DVBAlphaComposite(1);
    public static final DVBAlphaComposite Src = new DVBAlphaComposite(2);
    public static final DVBAlphaComposite SrcOver = new DVBAlphaComposite(3);
    public static final DVBAlphaComposite DstOver = new DVBAlphaComposite(4);
    public static final DVBAlphaComposite SrcIn = new DVBAlphaComposite(5);
    public static final DVBAlphaComposite DstIn = new DVBAlphaComposite(6);
    public static final DVBAlphaComposite SrcOut = new DVBAlphaComposite(7);
    public static final DVBAlphaComposite DstOut = new DVBAlphaComposite(8);
    float alpha;
    int rule;

    private DVBAlphaComposite(int rule) {
        this.rule = rule;
        this.alpha = 1.0f;
    }

    private DVBAlphaComposite(int rule, float alpha) {
        this.rule = rule;
        this.alpha = alpha;
    }

    public int getRule() {
        return this.rule;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public static DVBAlphaComposite getInstance(int rule) {
        switch (rule) {
            case 1: {
                return Clear;
            }
            case 2: {
                return Src;
            }
            case 3: {
                return SrcOver;
            }
            case 4: {
                return DstOver;
            }
            case 5: {
                return SrcIn;
            }
            case 6: {
                return DstIn;
            }
            case 7: {
                return SrcOut;
            }
            case 8: {
                return DstOut;
            }
        }
        throw new IllegalArgumentException("Unknown rule");
    }

    public static DVBAlphaComposite getInstance(int rule, float alpha) {
        return new DVBAlphaComposite(rule, alpha);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.alpha);
        result = 31 * result + this.rule;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DVBAlphaComposite other = (DVBAlphaComposite)obj;
        if (Float.floatToIntBits(this.alpha) != Float.floatToIntBits(other.alpha)) {
            return false;
        }
        return this.rule == other.rule;
    }
}

