/*
 * Decompiled with CFR 0.152.
 */
package org.dvb.user;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.dvb.user.Facility;
import org.dvb.user.GeneralPreference;
import org.dvb.user.Preference;
import org.dvb.user.UnsupportedPreferenceException;
import org.dvb.user.UserPreferenceChangeEvent;
import org.dvb.user.UserPreferenceChangeListener;
import org.dvb.user.UserPreferencePermission;

public class UserPreferenceManager {
    private static UserPreferenceManager instance;
    private LinkedList preferences = new LinkedList();
    private LinkedList listeners = new LinkedList();

    private UserPreferenceManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserPreferenceManager getInstance() {
        Class clazz = UserPreferenceManager.class;
        synchronized (clazz) {
            if (instance == null) {
                instance = new UserPreferenceManager();
            }
            return instance;
        }
    }

    public void read(Preference p) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new UserPreferencePermission("read"));
        }
        p.removeAll();
        String name = p.getName();
        Iterator it = this.preferences.iterator();
        while (it.hasNext()) {
            Preference preference = (Preference)it.next();
            if (!name.equals(preference.getName())) continue;
            p.add(preference.getFavourites());
            break;
        }
    }

    public void read(Preference p, Facility facility) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new UserPreferencePermission("read"));
        }
        p.removeAll();
        String name = p.getName();
        if (name.equals(facility.getPreference())) {
            Iterator it = this.preferences.iterator();
            while (it.hasNext()) {
                Preference preference = (Preference)it.next();
                if (!name.equals(preference.getName())) continue;
                String[] values = preference.getFavourites();
                String[] valuesFacility = facility.getValues();
                block1: for (int i = 0; i < values.length; ++i) {
                    for (int j = 0; j < valuesFacility.length; ++j) {
                        if (!values[i].equals(valuesFacility[j])) continue;
                        p.add(values[i]);
                        continue block1;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Preference p) throws UnsupportedPreferenceException, IOException {
        String name = p.getName();
        if (!GeneralPreference.isGeneralPreference(name)) {
            throw new UnsupportedPreferenceException();
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new UserPreferencePermission("write"));
        }
        Iterator it = this.preferences.iterator();
        while (it.hasNext()) {
            Preference preference = (Preference)it.next();
            if (!name.equals(preference.getName())) continue;
            it.remove();
            break;
        }
        this.preferences.add(p);
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            int size = this.listeners.size();
            if (size > 0) {
                UserPreferenceChangeEvent event = new UserPreferenceChangeEvent(name);
                for (int i = 0; i < size; ++i) {
                    ((UserPreferenceChangeListener)this.listeners.get(i)).receiveUserPreferenceChangeEvent(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserPreferenceChangeListener(UserPreferenceChangeListener l) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserPreferenceChangeListener(UserPreferenceChangeListener l) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.remove(l);
        }
    }
}

