/*****************************************************************************
 * vlf.c: VideoLAN Forwarder
 *****************************************************************************
 * Copyright (C) 2000 VideoLAN
 *
 * Authors: Samuel Hocevar <sam@via.ecp.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include <strings.h>

#define PACKET_SIZE 1316 // 1316 = 7*188

/* port which receives data */
#define RECV_PORT 1234
/* port which sends data (0 for non-specified) */
#define SRC_PORT 0
/* remote port to which we send data */
#define SEND_PORT 1234
/* remote address */
#define SEND_ADDRESS "127.0.0.1"

int main () {

int infd,outfd,sockopt;
struct sockaddr_in  cli_addr, serv_addr, listen_addr;

int length;
long long int counter=0, bytes=0;
unsigned char c [PACKET_SIZE];
    
fprintf(stderr, "VideoLAN Forwarder - version 0.2.0 Onatopp - (c)1996-2000 VideoLAN\n");

    if ( (infd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
        fprintf(stderr,"bordel de couille, gn'arrive pas  crer la socket qui coute\n");
    
    listen_addr.sin_family      = AF_INET;
    listen_addr.sin_addr.s_addr = htonl(INADDR_ANY);
    listen_addr.sin_port        = htons(RECV_PORT);

    if (bind(infd, (struct sockaddr *) &listen_addr, sizeof(listen_addr)) < 0)
        fprintf(stderr,"sa race maudite, gn'arrive pas  binder la socket qui coute\n");

    bzero((char *) &serv_addr, sizeof(serv_addr));
    serv_addr.sin_family      = AF_INET;
    serv_addr.sin_addr.s_addr = inet_addr(SEND_ADDRESS);
    serv_addr.sin_port        = htons(SEND_PORT);

    if ( (outfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
        fprintf(stderr,"putain va chier, gn'arrive pas  crer la socket qui crit\n");

    if( setsockopt(outfd, SOL_SOCKET, SO_BROADCAST, &sockopt, sizeof(sockopt)) < 0 )
        fprintf(stderr,"SO_BROADCAST setsockopt error\n");
    
    cli_addr.sin_family      = AF_INET;
    cli_addr.sin_addr.s_addr = htonl(INADDR_ANY);
    cli_addr.sin_port        = htons(SRC_PORT);
    if (bind(outfd, (struct sockaddr *) &cli_addr, sizeof(cli_addr)) < 0)
        fprintf(stderr,"et meeeeeeeerde, gn'arrive pas  binder la socket qui crit\n");
    

    for(;;) {
	   length = recv(infd, &c, PACKET_SIZE, 0);
	   counter++; bytes+=length;

           if ( !(counter & 0xf ) ) fprintf(stderr,"
%Li packets received (%Li bytes)", counter, bytes);
	   sendto(outfd, &c, PACKET_SIZE, 0, (struct sockaddr *) &serv_addr, sizeof(serv_addr));
    }

}
