/******************************************************************************/
/* blBoard.h (c)1999 Bozo                                                     */
/******************************************************************************/

#ifndef _BLBOARD_H_
#define _BLBOARD_H_


//------------------------------------------------------------------------------
// C_BlBoard class
//------------------------------------------------------------------------------
class C_BlBoard
{
public:
	static C_BlBoard* Create(handle hLog);
	~C_BlBoard();

	int Init();
	int Run();
	int Destroy();

private:
	// Do NOT create more than one instances of C_BlBoard
	// Sorry, I hate callbacks which have not a pointer argment
	// which I can specify to pass "this" to the callback.
	C_BlBoard(handle hLog);
	static C_BlBoard* s_pInstance;
	
	// Card initialisation
	SE_STATUS InitBoard(void);
	int UpdatePgrmTable();
	int StartStreaming(u16 uiPgrmNumber, C_DataLink* pDataLink);
	int StopStreaming(u16 uiPgrmNumber);

	// Capture callbacks
	static void CaptureCallback0(SE_UINT iBoardNumber, SE_HANDLE seHandle,
																PSE_VOID pvData, SE_UINT uiDataBlockLength);
	static void CaptureCallback1(SE_UINT iBoardNumber, SE_HANDLE seHandle,
																PSE_VOID pvData, SE_UINT uiDataBlockLength);
	static void CaptureCallback2(SE_UINT iBoardNumber, SE_HANDLE seHandle,
																PSE_VOID pvData, SE_UINT uiDataBlockLength);

	// Callbacks
	static void CBMasterStatusGranted (SE_UINT iBoardNumber);
	static void CBTableSectionArrived (SE_UINT iBoardNumber,
		SE_HANDLE seHandle, PVOID pvTableSection, SE_UINT uiDataBlockLength);
	static void CBStreamDataArrived (SE_UINT iBoardNumber, SE_HANDLE seHandle,
		PVOID pvStreamData, SE_UINT uiDataBlockLength);
	static void CBCAMessageReceived (SE_UINT iBoardNumber, PVOID pvMessage,
		SE_INT iMessageLength);
	static void CBAddMulticastAddress (SE_UINT iBoardNumber,
		SE_ULONG ulEthernetAddress);
	static void CBRemoveMulticastAddress (SE_UINT iBoardNumber,
		SE_ULONG ulEthernetAddress);

	handle m_hLog;
	C_CmdLink m_cCmdLink;
	C_HashTable<u16, PMT_TABLE> m_cPmtStructures;
	C_HashTable<u16, C_DataLink> m_cDataLinksByPgrmNumber;
	C_HashTable<u16, C_DataLink> m_cDataLinksByPID;
	C_HashTable<u16, SE_HANDLE> m_cHandles;
	C_HashTable<u16, C_Pat> m_cPats;
	C_HashTable<u16, C_Pmt> m_cPmts;

	int m_iNumBoards;
	bool m_bAppRegistered;
	bool m_bAppMastered;
	bool m_bBoardInitialized;

	SAT_TUNER_SETTINGS m_sSatTunerSettings;
	FE_LOCK_STATUS m_sFeLockStatus;
	PAT_TABLE m_sPatTable;
	bool m_bPatValid;
	C_String m_strDirectoryString;
	int iRnd;
};

#else
#error "Multiple inclusions of blboard.h"
#endif
